C     Last change:  JG   20 Nov 1998    7:41 am
c
c
      subroutine basis_3d
c
c 3-D Hermite and Lagrange basis functions
c program to calculate basis functions and first and second derivatives
c      in local coordinates and creates the products for the
c      time term(b3), velocity terms(bx3,by3,bz3), dispersion terms
c      (bxx3,byy3,bzz3,bxy3,bxz3,byz3)
c       also have linear lagrange basis represented here
c
        include 'include.f'
c
	dimension gp(2)
c

c local gauss points
                       gp(1) = - (1.d0/dsqrt(3.d0))
                       gp(2) =   (1.d0/dsqrt(3.d0))
	     jj=1
c calc. the basis functions in local space
c functions 1,2 are defined on neg side
c functions 3,4 are defined on pos side
c 
c 
	do  5 i = 1, 2
	     z1 = gp(i)
	     z2 = gp(i)*gp(i)
	     z3 = gp(i)*gp(i)*gp(i)
c
	     bbz1  = (z3-3.d0*z1+2.d0)/4.d0
	     bbz2  = (z3-z2-z1+1.d0)/4.d0
	     bbz3  = (2.d0+3.d0*z1-z3)/4.d0
	     bbz4  = (z3+z2-z1-1.d0)/4.d0
	     dbz1  = (3.d0*z2-3.d0)/4.d0
	     dbz2  = (3.d0*z2-2.d0*z1-1.d0)/4.d0
	     dbz3  = (3.d0-3.d0*z2)/4.d0
	     dbz4  = (3.d0*z2+2.d0*z1-1.d0)/4.d0
	     d2bz1 =  3.d0*z1/2.d0
	     d2bz2 = (3.d0*z1-1.d0)/2.d0
	     d2bz3 = -3.d0*z1/2.d0
	     d2bz4 = (3.d0*z1+1.d0)/2.d0
c
             sz1  = (1.d0-z1)/2.d0
             sz2  = (1.d0+z1)/2.d0
             dsz1 = - 0.5d0
             dsz2 =   0.5d0
c
	do 10 j = 1, 2
	     x1 = gp(j)
	     x2 = gp(j)*gp(j)
	     x3 = gp(j)*gp(j)*gp(j)
c
	     bbx1  = (x3-3.d0*x1+2.d0)/4.d0
	     bbx2  = (x3-x2-x1+1.d0)/4.d0
	     bbx3  = (2.d0+3.d0*x1-x3)/4.d0
	     bbx4  = (x3+x2-x1-1.d0)/4.d0
	     dbx1  = (3.d0*x2-3.d0)/4.d0
	     dbx2  = (3.d0*x2-2.d0*x1-1.d0)/4.d0
	     dbx3  = (3.d0-3.d0*x2)/4.d0
	     dbx4  = (3.d0*x2+2.d0*x1-1.d0)/4.d0
	     d2bx1 =  3.d0*x1/2.d0
	     d2bx2 = (3.d0*x1-1.d0)/2.d0
	     d2bx3 = -3.d0*x1/2.d0
	     d2bx4 = (3.d0*x1+1.d0)/2.d0
c
             sx1  = (1.d0-x1)/2.d0
             sx2  = (1.d0+x1)/2.d0
             dsx1 = - 0.5d0
             dsx2 =   0.5d0
c
	do 20 k = 1, 2
	     y1 = gp(k)
	     y2 = gp(k)*gp(k)
	     y3 = gp(k)*gp(k)*gp(k)
c
	     bby1  = (y3-3.d0*y1+2.d0)/4.d0
	     bby2  = (y3-y2-y1+1.d0)/4.d0
	     bby3  = (2.d0+3.d0*y1-y3)/4.d0
	     bby4  = (y3+y2-y1-1.d0)/4.d0
	     dby1  = (3.d0*y2-3.d0)/4.d0
	     dby2  = (3.d0*y2-2.d0*y1-1.d0)/4.d0
	     dby3  = (3.d0-3.d0*y2)/4.d0
	     dby4  = (3.d0*y2+2.d0*y1-1.d0)/4.d0
	     d2by1 =  3.d0*y1/2.d0
	     d2by2 = (3.d0*y1-1.d0)/2.d0
	     d2by3 = -3.d0*y1/2.d0
	     d2by4 = (3.d0*y1+1.d0)/2.d0
c
             sy1  =(1.d0-y1)/2.d0
             sy2  =(1.d0+y1)/2.d0
             dsy1 = - 0.5d0
             dsy2 =   0.5d0
c
c
c hermites
c construct BASIS matricies - one for the function
c           first derivatives and second derivatives
c
c row   = collocation point location (numbered in y-x-z)
c column= node location      (numbered in y-x-z)
c page  = degree of freedom  (U,Ux,Uy,Uz,Uxy,Uxz,Uyz,Uxyz)
c node 1
	b3(jj,1,1) = bbx1 * bby1 * bbz1
	b3(jj,1,2) = bbx2 * bby1 * bbz1
	b3(jj,1,3) = bbx1 * bby2 * bbz1
	b3(jj,1,4) = bbx1 * bby1 * bbz2
	b3(jj,1,5) = bbx2 * bby2 * bbz1
	b3(jj,1,6) = bbx2 * bby1 * bbz2
	b3(jj,1,7) = bbx1 * bby2 * bbz2
	b3(jj,1,8) = bbx2 * bby2 * bbz2
c node 2
	b3(jj,2,1) = bbx1 * bby3 * bbz1
	b3(jj,2,2) = bbx2 * bby3 * bbz1
	b3(jj,2,3) = bbx1 * bby4 * bbz1
	b3(jj,2,4) = bbx1 * bby3 * bbz2
	b3(jj,2,5) = bbx2 * bby4 * bbz1
	b3(jj,2,6) = bbx2 * bby3 * bbz2
	b3(jj,2,7) = bbx1 * bby4 * bbz2
	b3(jj,2,8) = bbx2 * bby4 * bbz2
c node 3
	b3(jj,3,1) = bbx3 * bby1 * bbz1
	b3(jj,3,2) = bbx4 * bby1 * bbz1
	b3(jj,3,3) = bbx3 * bby2 * bbz1
	b3(jj,3,4) = bbx3 * bby1 * bbz2
	b3(jj,3,5) = bbx4 * bby2 * bbz1
	b3(jj,3,6) = bbx4 * bby1 * bbz2
	b3(jj,3,7) = bbx3 * bby2 * bbz2
	b3(jj,3,8) = bbx4 * bby2 * bbz2
c node 4
	b3(jj,4,1) = bbx3 * bby3 * bbz1
	b3(jj,4,2) = bbx4 * bby3 * bbz1
	b3(jj,4,3) = bbx3 * bby4 * bbz1
	b3(jj,4,4) = bbx3 * bby3 * bbz2
	b3(jj,4,5) = bbx4 * bby4 * bbz1
	b3(jj,4,6) = bbx4 * bby3 * bbz2
	b3(jj,4,7) = bbx3 * bby4 * bbz2
	b3(jj,4,8) = bbx4 * bby4 * bbz2
c node 5
	b3(jj,5,1) = bbx1 * bby1 * bbz3
	b3(jj,5,2) = bbx2 * bby1 * bbz3
	b3(jj,5,3) = bbx1 * bby2 * bbz3
	b3(jj,5,4) = bbx1 * bby1 * bbz4
	b3(jj,5,5) = bbx2 * bby2 * bbz3
	b3(jj,5,6) = bbx2 * bby1 * bbz4
	b3(jj,5,7) = bbx1 * bby2 * bbz4
	b3(jj,5,8) = bbx2 * bby2 * bbz4
c node 6
	b3(jj,6,1) = bbx1 * bby3 * bbz3
	b3(jj,6,2) = bbx2 * bby3 * bbz3
	b3(jj,6,3) = bbx1 * bby4 * bbz3
	b3(jj,6,4) = bbx1 * bby3 * bbz4
	b3(jj,6,5) = bbx2 * bby4 * bbz3
	b3(jj,6,6) = bbx2 * bby3 * bbz4
	b3(jj,6,7) = bbx1 * bby4 * bbz4
	b3(jj,6,8) = bbx2 * bby4 * bbz4
c node 7
	b3(jj,7,1) = bbx3 * bby1 * bbz3
	b3(jj,7,2) = bbx4 * bby1 * bbz3
	b3(jj,7,3) = bbx3 * bby2 * bbz3
	b3(jj,7,4) = bbx3 * bby1 * bbz4
	b3(jj,7,5) = bbx4 * bby2 * bbz3
	b3(jj,7,6) = bbx4 * bby1 * bbz4
	b3(jj,7,7) = bbx3 * bby2 * bbz4
	b3(jj,7,8) = bbx4 * bby2 * bbz4
c node 8
	b3(jj,8,1) = bbx3 * bby3 * bbz3
	b3(jj,8,2) = bbx4 * bby3 * bbz3
	b3(jj,8,3) = bbx3 * bby4 * bbz3
	b3(jj,8,4) = bbx3 * bby3 * bbz4
	b3(jj,8,5) = bbx4 * bby4 * bbz3
	b3(jj,8,6) = bbx4 * bby3 * bbz4
	b3(jj,8,7) = bbx3 * bby4 * bbz4
	b3(jj,8,8) = bbx4 * bby4 * bbz4
c node 1
	bx3(jj,1,1) = dbx1 * bby1 * bbz1
	bx3(jj,1,2) = dbx2 * bby1 * bbz1
	bx3(jj,1,3) = dbx1 * bby2 * bbz1
	bx3(jj,1,4) = dbx1 * bby1 * bbz2
	bx3(jj,1,5) = dbx2 * bby2 * bbz1
	bx3(jj,1,6) = dbx2 * bby1 * bbz2
	bx3(jj,1,7) = dbx1 * bby2 * bbz2
	bx3(jj,1,8) = dbx2 * bby2 * bbz2
c node 2
	bx3(jj,2,1) = dbx1 * bby3 * bbz1
	bx3(jj,2,2) = dbx2 * bby3 * bbz1
	bx3(jj,2,3) = dbx1 * bby4 * bbz1
	bx3(jj,2,4) = dbx1 * bby3 * bbz2
	bx3(jj,2,5) = dbx2 * bby4 * bbz1
	bx3(jj,2,6) = dbx2 * bby3 * bbz2
	bx3(jj,2,7) = dbx1 * bby4 * bbz2
	bx3(jj,2,8) = dbx2 * bby4 * bbz2
c node 3
	bx3(jj,3,1) = dbx3 * bby1 * bbz1
	bx3(jj,3,2) = dbx4 * bby1 * bbz1
	bx3(jj,3,3) = dbx3 * bby2 * bbz1
	bx3(jj,3,4) = dbx3 * bby1 * bbz2
	bx3(jj,3,5) = dbx4 * bby2 * bbz1
	bx3(jj,3,6) = dbx4 * bby1 * bbz2
	bx3(jj,3,7) = dbx3 * bby2 * bbz2
	bx3(jj,3,8) = dbx4 * bby2 * bbz2
c node 4
	bx3(jj,4,1) = dbx3 * bby3 * bbz1
	bx3(jj,4,2) = dbx4 * bby3 * bbz1
	bx3(jj,4,3) = dbx3 * bby4 * bbz1
	bx3(jj,4,4) = dbx3 * bby3 * bbz2
	bx3(jj,4,5) = dbx4 * bby4 * bbz1
	bx3(jj,4,6) = dbx4 * bby3 * bbz2
	bx3(jj,4,7) = dbx3 * bby4 * bbz2
	bx3(jj,4,8) = dbx4 * bby4 * bbz2
c node 5
	bx3(jj,5,1) = dbx1 * bby1 * bbz3
	bx3(jj,5,2) = dbx2 * bby1 * bbz3
	bx3(jj,5,3) = dbx1 * bby2 * bbz3
	bx3(jj,5,4) = dbx1 * bby1 * bbz4
	bx3(jj,5,5) = dbx2 * bby2 * bbz3
	bx3(jj,5,6) = dbx2 * bby1 * bbz4
	bx3(jj,5,7) = dbx1 * bby2 * bbz4
	bx3(jj,5,8) = dbx2 * bby2 * bbz4
c node 6
	bx3(jj,6,1) = dbx1 * bby3 * bbz3
	bx3(jj,6,2) = dbx2 * bby3 * bbz3
	bx3(jj,6,3) = dbx1 * bby4 * bbz3
	bx3(jj,6,4) = dbx1 * bby3 * bbz4
	bx3(jj,6,5) = dbx2 * bby4 * bbz3
	bx3(jj,6,6) = dbx2 * bby3 * bbz4
	bx3(jj,6,7) = dbx1 * bby4 * bbz4
	bx3(jj,6,8) = dbx2 * bby4 * bbz4
c node 7
	bx3(jj,7,1) = dbx3 * bby1 * bbz3
	bx3(jj,7,2) = dbx4 * bby1 * bbz3
	bx3(jj,7,3) = dbx3 * bby2 * bbz3
	bx3(jj,7,4) = dbx3 * bby1 * bbz4
	bx3(jj,7,5) = dbx4 * bby2 * bbz3
	bx3(jj,7,6) = dbx4 * bby1 * bbz4
	bx3(jj,7,7) = dbx3 * bby2 * bbz4
	bx3(jj,7,8) = dbx4 * bby2 * bbz4
c node 8
	bx3(jj,8,1) = dbx3 * bby3 * bbz3
	bx3(jj,8,2) = dbx4 * bby3 * bbz3
	bx3(jj,8,3) = dbx3 * bby4 * bbz3
	bx3(jj,8,4) = dbx3 * bby3 * bbz4
	bx3(jj,8,5) = dbx4 * bby4 * bbz3
	bx3(jj,8,6) = dbx4 * bby3 * bbz4
	bx3(jj,8,7) = dbx3 * bby4 * bbz4
	bx3(jj,8,8) = dbx4 * bby4 * bbz4
c node 1
	by3(jj,1,1) = bbx1 * dby1 * bbz1
	by3(jj,1,2) = bbx2 * dby1 * bbz1
	by3(jj,1,3) = bbx1 * dby2 * bbz1
	by3(jj,1,4) = bbx1 * dby1 * bbz2
	by3(jj,1,5) = bbx2 * dby2 * bbz1
	by3(jj,1,6) = bbx2 * dby1 * bbz2
	by3(jj,1,7) = bbx1 * dby2 * bbz2
	by3(jj,1,8) = bbx2 * dby2 * bbz2
c node 2
	by3(jj,2,1) = bbx1 * dby3 * bbz1
	by3(jj,2,2) = bbx2 * dby3 * bbz1
	by3(jj,2,3) = bbx1 * dby4 * bbz1
	by3(jj,2,4) = bbx1 * dby3 * bbz2
	by3(jj,2,5) = bbx2 * dby4 * bbz1
	by3(jj,2,6) = bbx2 * dby3 * bbz2
	by3(jj,2,7) = bbx1 * dby4 * bbz2
	by3(jj,2,8) = bbx2 * dby4 * bbz2
c node 3
	by3(jj,3,1) = bbx3 * dby1 * bbz1
	by3(jj,3,2) = bbx4 * dby1 * bbz1
	by3(jj,3,3) = bbx3 * dby2 * bbz1
	by3(jj,3,4) = bbx3 * dby1 * bbz2
	by3(jj,3,5) = bbx4 * dby2 * bbz1
	by3(jj,3,6) = bbx4 * dby1 * bbz2
	by3(jj,3,7) = bbx3 * dby2 * bbz2
	by3(jj,3,8) = bbx4 * dby2 * bbz2
c node 4
	by3(jj,4,1) = bbx3 * dby3 * bbz1
	by3(jj,4,2) = bbx4 * dby3 * bbz1
	by3(jj,4,3) = bbx3 * dby4 * bbz1
	by3(jj,4,4) = bbx3 * dby3 * bbz2
	by3(jj,4,5) = bbx4 * dby4 * bbz1
	by3(jj,4,6) = bbx4 * dby3 * bbz2
	by3(jj,4,7) = bbx3 * dby4 * bbz2
	by3(jj,4,8) = bbx4 * dby4 * bbz2
c node 5
	by3(jj,5,1) = bbx1 * dby1 * bbz3
	by3(jj,5,2) = bbx2 * dby1 * bbz3
	by3(jj,5,3) = bbx1 * dby2 * bbz3
	by3(jj,5,4) = bbx1 * dby1 * bbz4
	by3(jj,5,5) = bbx2 * dby2 * bbz3
	by3(jj,5,6) = bbx2 * dby1 * bbz4
	by3(jj,5,7) = bbx1 * dby2 * bbz4
	by3(jj,5,8) = bbx2 * dby2 * bbz4
c node 6
	by3(jj,6,1) = bbx1 * dby3 * bbz3
	by3(jj,6,2) = bbx2 * dby3 * bbz3
	by3(jj,6,3) = bbx1 * dby4 * bbz3
	by3(jj,6,4) = bbx1 * dby3 * bbz4
	by3(jj,6,5) = bbx2 * dby4 * bbz3
	by3(jj,6,6) = bbx2 * dby3 * bbz4
	by3(jj,6,7) = bbx1 * dby4 * bbz4
	by3(jj,6,8) = bbx2 * dby4 * bbz4
c node 7
	by3(jj,7,1) = bbx3 * dby1 * bbz3
	by3(jj,7,2) = bbx4 * dby1 * bbz3
	by3(jj,7,3) = bbx3 * dby2 * bbz3
	by3(jj,7,4) = bbx3 * dby1 * bbz4
	by3(jj,7,5) = bbx4 * dby2 * bbz3
	by3(jj,7,6) = bbx4 * dby1 * bbz4
	by3(jj,7,7) = bbx3 * dby2 * bbz4
	by3(jj,7,8) = bbx4 * dby2 * bbz4
c node 8
	by3(jj,8,1) = bbx3 * dby3 * bbz3
	by3(jj,8,2) = bbx4 * dby3 * bbz3
	by3(jj,8,3) = bbx3 * dby4 * bbz3
	by3(jj,8,4) = bbx3 * dby3 * bbz4
	by3(jj,8,5) = bbx4 * dby4 * bbz3
	by3(jj,8,6) = bbx4 * dby3 * bbz4
	by3(jj,8,7) = bbx3 * dby4 * bbz4
	by3(jj,8,8) = bbx4 * dby4 * bbz4
c node 1
	bz3(jj,1,1) = bbx1 * bby1 * dbz1
	bz3(jj,1,2) = bbx2 * bby1 * dbz1
	bz3(jj,1,3) = bbx1 * bby2 * dbz1
	bz3(jj,1,4) = bbx1 * bby1 * dbz2
	bz3(jj,1,5) = bbx2 * bby2 * dbz1
	bz3(jj,1,6) = bbx2 * bby1 * dbz2
	bz3(jj,1,7) = bbx1 * bby2 * dbz2
	bz3(jj,1,8) = bbx2 * bby2 * dbz2
c node 2
	bz3(jj,2,1) = bbx1 * bby3 * dbz1
	bz3(jj,2,2) = bbx2 * bby3 * dbz1
	bz3(jj,2,3) = bbx1 * bby4 * dbz1
	bz3(jj,2,4) = bbx1 * bby3 * dbz2
	bz3(jj,2,5) = bbx2 * bby4 * dbz1
	bz3(jj,2,6) = bbx2 * bby3 * dbz2
	bz3(jj,2,7) = bbx1 * bby4 * dbz2
	bz3(jj,2,8) = bbx2 * bby4 * dbz2
c node 3
	bz3(jj,3,1) = bbx3 * bby1 * dbz1
	bz3(jj,3,2) = bbx4 * bby1 * dbz1
	bz3(jj,3,3) = bbx3 * bby2 * dbz1
	bz3(jj,3,4) = bbx3 * bby1 * dbz2
	bz3(jj,3,5) = bbx4 * bby2 * dbz1
	bz3(jj,3,6) = bbx4 * bby1 * dbz2
	bz3(jj,3,7) = bbx3 * bby2 * dbz2
	bz3(jj,3,8) = bbx4 * bby2 * dbz2
c node 4
	bz3(jj,4,1) = bbx3 * bby3 * dbz1
	bz3(jj,4,2) = bbx4 * bby3 * dbz1
	bz3(jj,4,3) = bbx3 * bby4 * dbz1
	bz3(jj,4,4) = bbx3 * bby3 * dbz2
	bz3(jj,4,5) = bbx4 * bby4 * dbz1
	bz3(jj,4,6) = bbx4 * bby3 * dbz2
	bz3(jj,4,7) = bbx3 * bby4 * dbz2
	bz3(jj,4,8) = bbx4 * bby4 * dbz2
c node 5
	bz3(jj,5,1) = bbx1 * bby1 * dbz3
	bz3(jj,5,2) = bbx2 * bby1 * dbz3
	bz3(jj,5,3) = bbx1 * bby2 * dbz3
	bz3(jj,5,4) = bbx1 * bby1 * dbz4
	bz3(jj,5,5) = bbx2 * bby2 * dbz3
	bz3(jj,5,6) = bbx2 * bby1 * dbz4
	bz3(jj,5,7) = bbx1 * bby2 * dbz4
	bz3(jj,5,8) = bbx2 * bby2 * dbz4
c node 6
	bz3(jj,6,1) = bbx1 * bby3 * dbz3
	bz3(jj,6,2) = bbx2 * bby3 * dbz3
	bz3(jj,6,3) = bbx1 * bby4 * dbz3
	bz3(jj,6,4) = bbx1 * bby3 * dbz4
	bz3(jj,6,5) = bbx2 * bby4 * dbz3
	bz3(jj,6,6) = bbx2 * bby3 * dbz4
	bz3(jj,6,7) = bbx1 * bby4 * dbz4
	bz3(jj,6,8) = bbx2 * bby4 * dbz4
c node 7
	bz3(jj,7,1) = bbx3 * bby1 * dbz3
	bz3(jj,7,2) = bbx4 * bby1 * dbz3
	bz3(jj,7,3) = bbx3 * bby2 * dbz3
	bz3(jj,7,4) = bbx3 * bby1 * dbz4
	bz3(jj,7,5) = bbx4 * bby2 * dbz3
	bz3(jj,7,6) = bbx4 * bby1 * dbz4
	bz3(jj,7,7) = bbx3 * bby2 * dbz4
	bz3(jj,7,8) = bbx4 * bby2 * dbz4
c node 8
	bz3(jj,8,1) = bbx3 * bby3 * dbz3
	bz3(jj,8,2) = bbx4 * bby3 * dbz3
	bz3(jj,8,3) = bbx3 * bby4 * dbz3
	bz3(jj,8,4) = bbx3 * bby3 * dbz4
	bz3(jj,8,5) = bbx4 * bby4 * dbz3
	bz3(jj,8,6) = bbx4 * bby3 * dbz4
	bz3(jj,8,7) = bbx3 * bby4 * dbz4
	bz3(jj,8,8) = bbx4 * bby4 * dbz4
c node 1
	bxx3(jj,1,1) = d2bx1 * bby1 * bbz1
	bxx3(jj,1,2) = d2bx2 * bby1 * bbz1
	bxx3(jj,1,3) = d2bx1 * bby2 * bbz1
	bxx3(jj,1,4) = d2bx1 * bby1 * bbz2
	bxx3(jj,1,5) = d2bx2 * bby2 * bbz1
	bxx3(jj,1,6) = d2bx2 * bby1 * bbz2
	bxx3(jj,1,7) = d2bx1 * bby2 * bbz2
	bxx3(jj,1,8) = d2bx2 * bby2 * bbz2
c node 2
	bxx3(jj,2,1) = d2bx1 * bby3 * bbz1
	bxx3(jj,2,2) = d2bx2 * bby3 * bbz1
	bxx3(jj,2,3) = d2bx1 * bby4 * bbz1
	bxx3(jj,2,4) = d2bx1 * bby3 * bbz2
	bxx3(jj,2,5) = d2bx2 * bby4 * bbz1
	bxx3(jj,2,6) = d2bx2 * bby3 * bbz2
	bxx3(jj,2,7) = d2bx1 * bby4 * bbz2
	bxx3(jj,2,8) = d2bx2 * bby4 * bbz2
c node 3
	bxx3(jj,3,1) = d2bx3 * bby1 * bbz1
	bxx3(jj,3,2) = d2bx4 * bby1 * bbz1
	bxx3(jj,3,3) = d2bx3 * bby2 * bbz1
	bxx3(jj,3,4) = d2bx3 * bby1 * bbz2
	bxx3(jj,3,5) = d2bx4 * bby2 * bbz1
	bxx3(jj,3,6) = d2bx4 * bby1 * bbz2
	bxx3(jj,3,7) = d2bx3 * bby2 * bbz2
	bxx3(jj,3,8) = d2bx4 * bby2 * bbz2
c node 4
	bxx3(jj,4,1) = d2bx3 * bby3 * bbz1
	bxx3(jj,4,2) = d2bx4 * bby3 * bbz1
	bxx3(jj,4,3) = d2bx3 * bby4 * bbz1
	bxx3(jj,4,4) = d2bx3 * bby3 * bbz2
	bxx3(jj,4,5) = d2bx4 * bby4 * bbz1
	bxx3(jj,4,6) = d2bx4 * bby3 * bbz2
	bxx3(jj,4,7) = d2bx3 * bby4 * bbz2
	bxx3(jj,4,8) = d2bx4 * bby4 * bbz2
c node 5
	bxx3(jj,5,1) = d2bx1 * bby1 * bbz3
	bxx3(jj,5,2) = d2bx2 * bby1 * bbz3
	bxx3(jj,5,3) = d2bx1 * bby2 * bbz3
	bxx3(jj,5,4) = d2bx1 * bby1 * bbz4
	bxx3(jj,5,5) = d2bx2 * bby2 * bbz3
	bxx3(jj,5,6) = d2bx2 * bby1 * bbz4
	bxx3(jj,5,7) = d2bx1 * bby2 * bbz4
	bxx3(jj,5,8) = d2bx2 * bby2 * bbz4
c node 6
	bxx3(jj,6,1) = d2bx1 * bby3 * bbz3
	bxx3(jj,6,2) = d2bx2 * bby3 * bbz3
	bxx3(jj,6,3) = d2bx1 * bby4 * bbz3
	bxx3(jj,6,4) = d2bx1 * bby3 * bbz4
	bxx3(jj,6,5) = d2bx2 * bby4 * bbz3
	bxx3(jj,6,6) = d2bx2 * bby3 * bbz4
	bxx3(jj,6,7) = d2bx1 * bby4 * bbz4
	bxx3(jj,6,8) = d2bx2 * bby4 * bbz4
c node 7
	bxx3(jj,7,1) = d2bx3 * bby1 * bbz3
	bxx3(jj,7,2) = d2bx4 * bby1 * bbz3
	bxx3(jj,7,3) = d2bx3 * bby2 * bbz3
	bxx3(jj,7,4) = d2bx3 * bby1 * bbz4
	bxx3(jj,7,5) = d2bx4 * bby2 * bbz3
	bxx3(jj,7,6) = d2bx4 * bby1 * bbz4
	bxx3(jj,7,7) = d2bx3 * bby2 * bbz4
	bxx3(jj,7,8) = d2bx4 * bby2 * bbz4
c node 8
	bxx3(jj,8,1) = d2bx3 * bby3 * bbz3
	bxx3(jj,8,2) = d2bx4 * bby3 * bbz3
	bxx3(jj,8,3) = d2bx3 * bby4 * bbz3
	bxx3(jj,8,4) = d2bx3 * bby3 * bbz4
	bxx3(jj,8,5) = d2bx4 * bby4 * bbz3
	bxx3(jj,8,6) = d2bx4 * bby3 * bbz4
	bxx3(jj,8,7) = d2bx3 * bby4 * bbz4
	bxx3(jj,8,8) = d2bx4 * bby4 * bbz4
c node 1
	byy3(jj,1,1) = bbx1 * d2by1 * bbz1
	byy3(jj,1,2) = bbx2 * d2by1 * bbz1
	byy3(jj,1,3) = bbx1 * d2by2 * bbz1
	byy3(jj,1,4) = bbx1 * d2by1 * bbz2
	byy3(jj,1,5) = bbx2 * d2by2 * bbz1
	byy3(jj,1,6) = bbx2 * d2by1 * bbz2
	byy3(jj,1,7) = bbx1 * d2by2 * bbz2
	byy3(jj,1,8) = bbx2 * d2by2 * bbz2
c node 2
	byy3(jj,2,1) = bbx1 * d2by3 * bbz1
	byy3(jj,2,2) = bbx2 * d2by3 * bbz1
	byy3(jj,2,3) = bbx1 * d2by4 * bbz1
	byy3(jj,2,4) = bbx1 * d2by3 * bbz2
	byy3(jj,2,5) = bbx2 * d2by4 * bbz1
	byy3(jj,2,6) = bbx2 * d2by3 * bbz2
	byy3(jj,2,7) = bbx1 * d2by4 * bbz2
	byy3(jj,2,8) = bbx2 * d2by4 * bbz2
c node 3
	byy3(jj,3,1) = bbx3 * d2by1 * bbz1
	byy3(jj,3,2) = bbx4 * d2by1 * bbz1
	byy3(jj,3,3) = bbx3 * d2by2 * bbz1
	byy3(jj,3,4) = bbx3 * d2by1 * bbz2
	byy3(jj,3,5) = bbx4 * d2by2 * bbz1
	byy3(jj,3,6) = bbx4 * d2by1 * bbz2
	byy3(jj,3,7) = bbx3 * d2by2 * bbz2
	byy3(jj,3,8) = bbx4 * d2by2 * bbz2
c node 4
	byy3(jj,4,1) = bbx3 * d2by3 * bbz1
	byy3(jj,4,2) = bbx4 * d2by3 * bbz1
	byy3(jj,4,3) = bbx3 * d2by4 * bbz1
	byy3(jj,4,4) = bbx3 * d2by3 * bbz2
	byy3(jj,4,5) = bbx4 * d2by4 * bbz1
	byy3(jj,4,6) = bbx4 * d2by3 * bbz2
	byy3(jj,4,7) = bbx3 * d2by4 * bbz2
	byy3(jj,4,8) = bbx4 * d2by4 * bbz2
c node 5
	byy3(jj,5,1) = bbx1 * d2by1 * bbz3
	byy3(jj,5,2) = bbx2 * d2by1 * bbz3
	byy3(jj,5,3) = bbx1 * d2by2 * bbz3
	byy3(jj,5,4) = bbx1 * d2by1 * bbz4
	byy3(jj,5,5) = bbx2 * d2by2 * bbz3
	byy3(jj,5,6) = bbx2 * d2by1 * bbz4
	byy3(jj,5,7) = bbx1 * d2by2 * bbz4
	byy3(jj,5,8) = bbx2 * d2by2 * bbz4
c node 6
	byy3(jj,6,1) = bbx1 * d2by3 * bbz3
	byy3(jj,6,2) = bbx2 * d2by3 * bbz3
	byy3(jj,6,3) = bbx1 * d2by4 * bbz3
	byy3(jj,6,4) = bbx1 * d2by3 * bbz4
	byy3(jj,6,5) = bbx2 * d2by4 * bbz3
	byy3(jj,6,6) = bbx2 * d2by3 * bbz4
	byy3(jj,6,7) = bbx1 * d2by4 * bbz4
	byy3(jj,6,8) = bbx2 * d2by4 * bbz4
c node 7
	byy3(jj,7,1) = bbx3 * d2by1 * bbz3
	byy3(jj,7,2) = bbx4 * d2by1 * bbz3
	byy3(jj,7,3) = bbx3 * d2by2 * bbz3
	byy3(jj,7,4) = bbx3 * d2by1 * bbz4
	byy3(jj,7,5) = bbx4 * d2by2 * bbz3
	byy3(jj,7,6) = bbx4 * d2by1 * bbz4
	byy3(jj,7,7) = bbx3 * d2by2 * bbz4
	byy3(jj,7,8) = bbx4 * d2by2 * bbz4
c node 8
	byy3(jj,8,1) = bbx3 * d2by3 * bbz3
	byy3(jj,8,2) = bbx4 * d2by3 * bbz3
	byy3(jj,8,3) = bbx3 * d2by4 * bbz3
	byy3(jj,8,4) = bbx3 * d2by3 * bbz4
	byy3(jj,8,5) = bbx4 * d2by4 * bbz3
	byy3(jj,8,6) = bbx4 * d2by3 * bbz4
	byy3(jj,8,7) = bbx3 * d2by4 * bbz4
	byy3(jj,8,8) = bbx4 * d2by4 * bbz4
c node 1
	bzz3(jj,1,1) = bbx1 * bby1 * d2bz1
	bzz3(jj,1,2) = bbx2 * bby1 * d2bz1
	bzz3(jj,1,3) = bbx1 * bby2 * d2bz1
	bzz3(jj,1,4) = bbx1 * bby1 * d2bz2
	bzz3(jj,1,5) = bbx2 * bby2 * d2bz1
	bzz3(jj,1,6) = bbx2 * bby1 * d2bz2
	bzz3(jj,1,7) = bbx1 * bby2 * d2bz2
	bzz3(jj,1,8) = bbx2 * bby2 * d2bz2
c node 2
	bzz3(jj,2,1) = bbx1 * bby3 * d2bz1
	bzz3(jj,2,2) = bbx2 * bby3 * d2bz1
	bzz3(jj,2,3) = bbx1 * bby4 * d2bz1
	bzz3(jj,2,4) = bbx1 * bby3 * d2bz2
	bzz3(jj,2,5) = bbx2 * bby4 * d2bz1
	bzz3(jj,2,6) = bbx2 * bby3 * d2bz2
	bzz3(jj,2,7) = bbx1 * bby4 * d2bz2
	bzz3(jj,2,8) = bbx2 * bby4 * d2bz2
c node 3
	bzz3(jj,3,1) = bbx3 * bby1 * d2bz1
	bzz3(jj,3,2) = bbx4 * bby1 * d2bz1
	bzz3(jj,3,3) = bbx3 * bby2 * d2bz1
	bzz3(jj,3,4) = bbx3 * bby1 * d2bz2
	bzz3(jj,3,5) = bbx4 * bby2 * d2bz1
	bzz3(jj,3,6) = bbx4 * bby1 * d2bz2
	bzz3(jj,3,7) = bbx3 * bby2 * d2bz2
	bzz3(jj,3,8) = bbx4 * bby2 * d2bz2
c node 4
	bzz3(jj,4,1) = bbx3 * bby3 * d2bz1
	bzz3(jj,4,2) = bbx4 * bby3 * d2bz1
	bzz3(jj,4,3) = bbx3 * bby4 * d2bz1
	bzz3(jj,4,4) = bbx3 * bby3 * d2bz2
	bzz3(jj,4,5) = bbx4 * bby4 * d2bz1
	bzz3(jj,4,6) = bbx4 * bby3 * d2bz2
	bzz3(jj,4,7) = bbx3 * bby4 * d2bz2
	bzz3(jj,4,8) = bbx4 * bby4 * d2bz2
c node 5
	bzz3(jj,5,1) = bbx1 * bby1 * d2bz3
	bzz3(jj,5,2) = bbx2 * bby1 * d2bz3
	bzz3(jj,5,3) = bbx1 * bby2 * d2bz3
	bzz3(jj,5,4) = bbx1 * bby1 * d2bz4
	bzz3(jj,5,5) = bbx2 * bby2 * d2bz3
	bzz3(jj,5,6) = bbx2 * bby1 * d2bz4
	bzz3(jj,5,7) = bbx1 * bby2 * d2bz4
	bzz3(jj,5,8) = bbx2 * bby2 * d2bz4
c node 6
	bzz3(jj,6,1) = bbx1 * bby3 * d2bz3
	bzz3(jj,6,2) = bbx2 * bby3 * d2bz3
	bzz3(jj,6,3) = bbx1 * bby4 * d2bz3
	bzz3(jj,6,4) = bbx1 * bby3 * d2bz4
	bzz3(jj,6,5) = bbx2 * bby4 * d2bz3
	bzz3(jj,6,6) = bbx2 * bby3 * d2bz4
	bzz3(jj,6,7) = bbx1 * bby4 * d2bz4
	bzz3(jj,6,8) = bbx2 * bby4 * d2bz4
c node 7
	bzz3(jj,7,1) = bbx3 * bby1 * d2bz3
	bzz3(jj,7,2) = bbx4 * bby1 * d2bz3
	bzz3(jj,7,3) = bbx3 * bby2 * d2bz3
	bzz3(jj,7,4) = bbx3 * bby1 * d2bz4
	bzz3(jj,7,5) = bbx4 * bby2 * d2bz3
	bzz3(jj,7,6) = bbx4 * bby1 * d2bz4
	bzz3(jj,7,7) = bbx3 * bby2 * d2bz4
	bzz3(jj,7,8) = bbx4 * bby2 * d2bz4
c node 8
	bzz3(jj,8,1) = bbx3 * bby3 * d2bz3
	bzz3(jj,8,2) = bbx4 * bby3 * d2bz3
	bzz3(jj,8,3) = bbx3 * bby4 * d2bz3
	bzz3(jj,8,4) = bbx3 * bby3 * d2bz4
	bzz3(jj,8,5) = bbx4 * bby4 * d2bz3
	bzz3(jj,8,6) = bbx4 * bby3 * d2bz4
	bzz3(jj,8,7) = bbx3 * bby4 * d2bz4
	bzz3(jj,8,8) = bbx4 * bby4 * d2bz4
c node 1
	bxy3(jj,1,1) = dbx1 * dby1 * bbz1
	bxy3(jj,1,2) = dbx2 * dby1 * bbz1
	bxy3(jj,1,3) = dbx1 * dby2 * bbz1
	bxy3(jj,1,4) = dbx1 * dby1 * bbz2
	bxy3(jj,1,5) = dbx2 * dby2 * bbz1
	bxy3(jj,1,6) = dbx2 * dby1 * bbz2
	bxy3(jj,1,7) = dbx1 * dby2 * bbz2
	bxy3(jj,1,8) = dbx2 * dby2 * bbz2
c node 2
	bxy3(jj,2,1) = dbx1 * dby3 * bbz1
	bxy3(jj,2,2) = dbx2 * dby3 * bbz1
	bxy3(jj,2,3) = dbx1 * dby4 * bbz1
	bxy3(jj,2,4) = dbx1 * dby3 * bbz2
	bxy3(jj,2,5) = dbx2 * dby4 * bbz1
	bxy3(jj,2,6) = dbx2 * dby3 * bbz2
	bxy3(jj,2,7) = dbx1 * dby4 * bbz2
	bxy3(jj,2,8) = dbx2 * dby4 * bbz2
c node 3
	bxy3(jj,3,1) = dbx3 * dby1 * bbz1
	bxy3(jj,3,2) = dbx4 * dby1 * bbz1
	bxy3(jj,3,3) = dbx3 * dby2 * bbz1
	bxy3(jj,3,4) = dbx3 * dby1 * bbz2
	bxy3(jj,3,5) = dbx4 * dby2 * bbz1
	bxy3(jj,3,6) = dbx4 * dby1 * bbz2
	bxy3(jj,3,7) = dbx3 * dby2 * bbz2
	bxy3(jj,3,8) = dbx4 * dby2 * bbz2
c node 4
	bxy3(jj,4,1) = dbx3 * dby3 * bbz1
	bxy3(jj,4,2) = dbx4 * dby3 * bbz1
	bxy3(jj,4,3) = dbx3 * dby4 * bbz1
	bxy3(jj,4,4) = dbx3 * dby3 * bbz2
	bxy3(jj,4,5) = dbx4 * dby4 * bbz1
	bxy3(jj,4,6) = dbx4 * dby3 * bbz2
	bxy3(jj,4,7) = dbx3 * dby4 * bbz2
	bxy3(jj,4,8) = dbx4 * dby4 * bbz2
c node 5
	bxy3(jj,5,1) = dbx1 * dby1 * bbz3
	bxy3(jj,5,2) = dbx2 * dby1 * bbz3
	bxy3(jj,5,3) = dbx1 * dby2 * bbz3
	bxy3(jj,5,4) = dbx1 * dby1 * bbz4
	bxy3(jj,5,5) = dbx2 * dby2 * bbz3
	bxy3(jj,5,6) = dbx2 * dby1 * bbz4
	bxy3(jj,5,7) = dbx1 * dby2 * bbz4
	bxy3(jj,5,8) = dbx2 * dby2 * bbz4
c node 6
	bxy3(jj,6,1) = dbx1 * dby3 * bbz3
	bxy3(jj,6,2) = dbx2 * dby3 * bbz3
	bxy3(jj,6,3) = dbx1 * dby4 * bbz3
	bxy3(jj,6,4) = dbx1 * dby3 * bbz4
	bxy3(jj,6,5) = dbx2 * dby4 * bbz3
	bxy3(jj,6,6) = dbx2 * dby3 * bbz4
	bxy3(jj,6,7) = dbx1 * dby4 * bbz4
	bxy3(jj,6,8) = dbx2 * dby4 * bbz4
c node 7
	bxy3(jj,7,1) = dbx3 * dby1 * bbz3
	bxy3(jj,7,2) = dbx4 * dby1 * bbz3
	bxy3(jj,7,3) = dbx3 * dby2 * bbz3
	bxy3(jj,7,4) = dbx3 * dby1 * bbz4
	bxy3(jj,7,5) = dbx4 * dby2 * bbz3
	bxy3(jj,7,6) = dbx4 * dby1 * bbz4
	bxy3(jj,7,7) = dbx3 * dby2 * bbz4
	bxy3(jj,7,8) = dbx4 * dby2 * bbz4
c node 8
	bxy3(jj,8,1) = dbx3 * dby3 * bbz3
	bxy3(jj,8,2) = dbx4 * dby3 * bbz3
	bxy3(jj,8,3) = dbx3 * dby4 * bbz3
	bxy3(jj,8,4) = dbx3 * dby3 * bbz4
	bxy3(jj,8,5) = dbx4 * dby4 * bbz3
	bxy3(jj,8,6) = dbx4 * dby3 * bbz4
	bxy3(jj,8,7) = dbx3 * dby4 * bbz4
	bxy3(jj,8,8) = dbx4 * dby4 * bbz4
c
c node 1
	bxz3(jj,1,1) = dbx1 * bby1 * dbz1
	bxz3(jj,1,2) = dbx2 * bby1 * dbz1
	bxz3(jj,1,3) = dbx1 * bby2 * dbz1
	bxz3(jj,1,4) = dbx1 * bby1 * dbz2
	bxz3(jj,1,5) = dbx2 * bby2 * dbz1
	bxz3(jj,1,6) = dbx2 * bby1 * dbz2
	bxz3(jj,1,7) = dbx1 * bby2 * dbz2
	bxz3(jj,1,8) = dbx2 * bby2 * dbz2
c node 2
	bxz3(jj,2,1) = dbx1 * bby3 * dbz1
	bxz3(jj,2,2) = dbx2 * bby3 * dbz1
	bxz3(jj,2,3) = dbx1 * bby4 * dbz1
	bxz3(jj,2,4) = dbx1 * bby3 * dbz2
	bxz3(jj,2,5) = dbx2 * bby4 * dbz1
	bxz3(jj,2,6) = dbx2 * bby3 * dbz2
	bxz3(jj,2,7) = dbx1 * bby4 * dbz2
	bxz3(jj,2,8) = dbx2 * bby4 * dbz2
c node 3
	bxz3(jj,3,1) = dbx3 * bby1 * dbz1
	bxz3(jj,3,2) = dbx4 * bby1 * dbz1
	bxz3(jj,3,3) = dbx3 * bby2 * dbz1
	bxz3(jj,3,4) = dbx3 * bby1 * dbz2
	bxz3(jj,3,5) = dbx4 * bby2 * dbz1
	bxz3(jj,3,6) = dbx4 * bby1 * dbz2
	bxz3(jj,3,7) = dbx3 * bby2 * dbz2
	bxz3(jj,3,8) = dbx4 * bby2 * dbz2
c node 4
	bxz3(jj,4,1) = dbx3 * bby3 * dbz1
	bxz3(jj,4,2) = dbx4 * bby3 * dbz1
	bxz3(jj,4,3) = dbx3 * bby4 * dbz1
	bxz3(jj,4,4) = dbx3 * bby3 * dbz2
	bxz3(jj,4,5) = dbx4 * bby4 * dbz1
	bxz3(jj,4,6) = dbx4 * bby3 * dbz2
	bxz3(jj,4,7) = dbx3 * bby4 * dbz2
	bxz3(jj,4,8) = dbx4 * bby4 * dbz2
c node 5
	bxz3(jj,5,1) = dbx1 * bby1 * dbz3
	bxz3(jj,5,2) = dbx2 * bby1 * dbz3
	bxz3(jj,5,3) = dbx1 * bby2 * dbz3
	bxz3(jj,5,4) = dbx1 * bby1 * dbz4
	bxz3(jj,5,5) = dbx2 * bby2 * dbz3
	bxz3(jj,5,6) = dbx2 * bby1 * dbz4
	bxz3(jj,5,7) = dbx1 * bby2 * dbz4
	bxz3(jj,5,8) = dbx2 * bby2 * dbz4
c node 6
	bxz3(jj,6,1) = dbx1 * bby3 * dbz3
	bxz3(jj,6,2) = dbx2 * bby3 * dbz3
	bxz3(jj,6,3) = dbx1 * bby4 * dbz3
	bxz3(jj,6,4) = dbx1 * bby3 * dbz4
	bxz3(jj,6,5) = dbx2 * bby4 * dbz3
	bxz3(jj,6,6) = dbx2 * bby3 * dbz4
	bxz3(jj,6,7) = dbx1 * bby4 * dbz4
	bxz3(jj,6,8) = dbx2 * bby4 * dbz4
c node 7
	bxz3(jj,7,1) = dbx3 * bby1 * dbz3
	bxz3(jj,7,2) = dbx4 * bby1 * dbz3
	bxz3(jj,7,3) = dbx3 * bby2 * dbz3
	bxz3(jj,7,4) = dbx3 * bby1 * dbz4
	bxz3(jj,7,5) = dbx4 * bby2 * dbz3
	bxz3(jj,7,6) = dbx4 * bby1 * dbz4
	bxz3(jj,7,7) = dbx3 * bby2 * dbz4
	bxz3(jj,7,8) = dbx4 * bby2 * dbz4
c node 8
	bxz3(jj,8,1) = dbx3 * bby3 * dbz3
	bxz3(jj,8,2) = dbx4 * bby3 * dbz3
	bxz3(jj,8,3) = dbx3 * bby4 * dbz3
	bxz3(jj,8,4) = dbx3 * bby3 * dbz4
	bxz3(jj,8,5) = dbx4 * bby4 * dbz3
	bxz3(jj,8,6) = dbx4 * bby3 * dbz4
	bxz3(jj,8,7) = dbx3 * bby4 * dbz4
	bxz3(jj,8,8) = dbx4 * bby4 * dbz4
c node 1
	byz3(jj,1,1) = bbx1 * dby1 * dbz1
	byz3(jj,1,2) = bbx2 * dby1 * dbz1
	byz3(jj,1,3) = bbx1 * dby2 * dbz1
	byz3(jj,1,4) = bbx1 * dby1 * dbz2
	byz3(jj,1,5) = bbx2 * dby2 * dbz1
	byz3(jj,1,6) = bbx2 * dby1 * dbz2
	byz3(jj,1,7) = bbx1 * dby2 * dbz2
	byz3(jj,1,8) = bbx2 * dby2 * dbz2
c node 2
	byz3(jj,2,1) = bbx1 * dby3 * dbz1
	byz3(jj,2,2) = bbx2 * dby3 * dbz1
	byz3(jj,2,3) = bbx1 * dby4 * dbz1
	byz3(jj,2,4) = bbx1 * dby3 * dbz2
	byz3(jj,2,5) = bbx2 * dby4 * dbz1
	byz3(jj,2,6) = bbx2 * dby3 * dbz2
	byz3(jj,2,7) = bbx1 * dby4 * dbz2
	byz3(jj,2,8) = bbx2 * dby4 * dbz2
c node 3
	byz3(jj,3,1) = bbx3 * dby1 * dbz1
	byz3(jj,3,2) = bbx4 * dby1 * dbz1
	byz3(jj,3,3) = bbx3 * dby2 * dbz1
	byz3(jj,3,4) = bbx3 * dby1 * dbz2
	byz3(jj,3,5) = bbx4 * dby2 * dbz1
	byz3(jj,3,6) = bbx4 * dby1 * dbz2
	byz3(jj,3,7) = bbx3 * dby2 * dbz2
	byz3(jj,3,8) = bbx4 * dby2 * dbz2
c node 4
	byz3(jj,4,1) = bbx3 * dby3 * dbz1
	byz3(jj,4,2) = bbx4 * dby3 * dbz1
	byz3(jj,4,3) = bbx3 * dby4 * dbz1
	byz3(jj,4,4) = bbx3 * dby3 * dbz2
	byz3(jj,4,5) = bbx4 * dby4 * dbz1
	byz3(jj,4,6) = bbx4 * dby3 * dbz2
	byz3(jj,4,7) = bbx3 * dby4 * dbz2
	byz3(jj,4,8) = bbx4 * dby4 * dbz2
c node 5
	byz3(jj,5,1) = bbx1 * dby1 * dbz3
	byz3(jj,5,2) = bbx2 * dby1 * dbz3
	byz3(jj,5,3) = bbx1 * dby2 * dbz3
	byz3(jj,5,4) = bbx1 * dby1 * dbz4
	byz3(jj,5,5) = bbx2 * dby2 * dbz3
	byz3(jj,5,6) = bbx2 * dby1 * dbz4
	byz3(jj,5,7) = bbx1 * dby2 * dbz4
	byz3(jj,5,8) = bbx2 * dby2 * dbz4
c node 6
	byz3(jj,6,1) = bbx1 * dby3 * dbz3
	byz3(jj,6,2) = bbx2 * dby3 * dbz3
	byz3(jj,6,3) = bbx1 * dby4 * dbz3
	byz3(jj,6,4) = bbx1 * dby3 * dbz4
	byz3(jj,6,5) = bbx2 * dby4 * dbz3
	byz3(jj,6,6) = bbx2 * dby3 * dbz4
	byz3(jj,6,7) = bbx1 * dby4 * dbz4
	byz3(jj,6,8) = bbx2 * dby4 * dbz4
c node 7
	byz3(jj,7,1) = bbx3 * dby1 * dbz3
	byz3(jj,7,2) = bbx4 * dby1 * dbz3
	byz3(jj,7,3) = bbx3 * dby2 * dbz3
	byz3(jj,7,4) = bbx3 * dby1 * dbz4
	byz3(jj,7,5) = bbx4 * dby2 * dbz3
	byz3(jj,7,6) = bbx4 * dby1 * dbz4
	byz3(jj,7,7) = bbx3 * dby2 * dbz4
	byz3(jj,7,8) = bbx4 * dby2 * dbz4
c node 8
	byz3(jj,8,1) = bbx3 * dby3 * dbz3
	byz3(jj,8,2) = bbx4 * dby3 * dbz3
	byz3(jj,8,3) = bbx3 * dby4 * dbz3
	byz3(jj,8,4) = bbx3 * dby3 * dbz4
	byz3(jj,8,5) = bbx4 * dby4 * dbz3
	byz3(jj,8,6) = bbx4 * dby3 * dbz4
	byz3(jj,8,7) = bbx3 * dby4 * dbz4
	byz3(jj,8,8) = bbx4 * dby4 * dbz4
c
c
c linear lagrange (over 4 nodes)
        b1(jj,1) = sx1 * sy1 * sz1
        b1(jj,2) = sx1 * sy2 * sz1
        b1(jj,3) = sx2 * sy1 * sz1
        b1(jj,4) = sx2 * sy2 * sz1
        b1(jj,5) = sx1 * sy1 * sz2
        b1(jj,6) = sx1 * sy2 * sz2
        b1(jj,7) = sx2 * sy1 * sz2
        b1(jj,8) = sx2 * sy2 * sz2

        bx1(jj,1) = dsx1 * sy1 * sz1
        bx1(jj,2) = dsx1 * sy2 * sz1
        bx1(jj,3) = dsx2 * sy1 * sz1
        bx1(jj,4) = dsx2 * sy2 * sz1
        bx1(jj,5) = dsx1 * sy1 * sz2
        bx1(jj,6) = dsx1 * sy2 * sz2
        bx1(jj,7) = dsx2 * sy1 * sz2
        bx1(jj,8) = dsx2 * sy2 * sz2

        by1(jj,1) = sx1 * dsy1 * sz1
        by1(jj,2) = sx1 * dsy2 * sz1
        by1(jj,3) = sx2 * dsy1 * sz1
        by1(jj,4) = sx2 * dsy2 * sz1
        by1(jj,5) = sx1 * dsy1 * sz2
        by1(jj,6) = sx1 * dsy2 * sz2
        by1(jj,7) = sx2 * dsy1 * sz2
        by1(jj,8) = sx2 * dsy2 * sz2

        bz1(jj,1) = sx1 * sy1 * dsz1
        bz1(jj,2) = sx1 * sy2 * dsz1
        bz1(jj,3) = sx2 * sy1 * dsz1
        bz1(jj,4) = sx2 * sy2 * dsz1
        bz1(jj,5) = sx1 * sy1 * dsz2
        bz1(jj,6) = sx1 * sy2 * dsz2
        bz1(jj,7) = sx2 * sy1 * dsz2
        bz1(jj,8) = sx2 * sy2 * dsz2
c
c
	             jj = jj + 1
c
   20   continue
   10   continue
    5   continue
c
	                                        return
	                                        end
c
c###################################################################
c###################################################################
c
      subroutine basis_2d
c
c###################################################################
c###################################################################
c
c 2-D Lagrange and Hermite basis functions used for interface 
c integral calculations.
c
        include 'include.f'
c
	dimension gp(2)
c

c local gauss points
                       gp(1) = - (1.d0/dsqrt(3.d0))
                       gp(2) =   (1.d0/dsqrt(3.d0))
	     jj = 1
c calc. the basis functions in local space
c functions 1,2 are defined on neg side
c functions 3,4 are defined on pos side
c 
	do 10 j = 1, 2
	     x1 = gp(j)
	     x2 = gp(j)*gp(j)
	     x3 = gp(j)*gp(j)*gp(j)
c
	     bbx1 = (x3-3.d0*x1+2.d0)/4.d0
	     bbx2 = (x3-x2-x1+1.d0)/4.d0
	     bbx3 = (2.d0+3.d0*x1-x3)/4.d0
	     bbx4 = (x3+x2-x1-1.d0)/4.d0
c
             sx1 = (1.d0-x1)/2.d0
             sx2 = (1.d0+x1)/2.d0
c
	do 20 k = 1, 2
	     y1 = gp(k)
	     y2 = gp(k)*gp(k)
	     y3 = gp(k)*gp(k)*gp(k)
c
	     bby1 = (y3-3.d0*y1+2.d0)/4.d0
	     bby2 = (y3-y2-y1+1.d0)/4.d0
	     bby3 = (2.d0+3.d0*y1-y3)/4.d0
	     bby4 = (y3+y2-y1-1.d0)/4.d0
c
             sy1 = (1.d0-y1)/2.d0
             sy2 = (1.d0+y1)/2.d0
c
c hermites
c construct BASIS matricies 
c row = collocation point location (numbered y-x)
c column= degree of freedom  (numbered y-x)
c
c
c node 1
	b3_2d(jj,1,1) = bbx1 * bby1
	b3_2d(jj,1,2) = bbx2 * bby1
	b3_2d(jj,1,3) = bbx1 * bby2
	b3_2d(jj,1,4) = bbx2 * bby2
c node 2
	b3_2d(jj,2,1) = bbx1 * bby3
	b3_2d(jj,2,2) = bbx2 * bby3
	b3_2d(jj,2,3) = bbx1 * bby4
	b3_2d(jj,2,4) = bbx2 * bby4
c node 3
	b3_2d(jj,3,1) = bbx3 * bby1
	b3_2d(jj,3,2) = bbx4 * bby1
	b3_2d(jj,3,3) = bbx3 * bby2
	b3_2d(jj,3,4) = bbx4 * bby2
c node 4
	b3_2d(jj,4,1) = bbx3 * bby3
	b3_2d(jj,4,2) = bbx4 * bby3
	b3_2d(jj,4,3) = bbx3 * bby4
	b3_2d(jj,4,4) = bbx4 * bby4
c
c
c linear lagrange (over 4 nodes)
        b1_2d(jj,1) = sx1 * sy1
        b1_2d(jj,2) = sx1 * sy2
        b1_2d(jj,3) = sx2 * sy1
        b1_2d(jj,4) = sx2 * sy2
c
                      jj = jj + 1
   20   continue
   10   continue
c
                                                return
                                                end