C     Last change:  JG   16 Feb 2003    8:29 am
c SUBROUTINES IN THIS BC FILE:
c subroutine  bcset - set default no flow bc's
c subroutine  bc_flow - set Dirichlet data for flow variables : 
c                       Pw,Sw,St
c subroutine  bc_oa- set Dirichlet data for Roa concentration variables
c subroutine  bc_og- set Dirichlet data for Rog concentration variables
c subroutine  bc_up - update nonlinear bc's after each time step
c subroutine pr_bc - use total flow solution to rep. Pg and Pn bc's
c subroutine pr_up  - save the Pg and Pn bc's in Pw at time level 'n'
c subroutine no_flow - For no flow BC's set the dpc slope to a very high
c                     value to mimic a LINEAR no-flow condition
c
c########################################################
           subroutine bcset
c########################################################
c
c Set up global DEFAULT NO FLOW/FLUX bc vectors 
c          for all dependent variables
c
c Save this data in 3 vectors for each variable 
c
c the vectors ending with _yx are for boundaries in the yx-plane
c the vectors ending with _yz are for boundaries in the yz-plane
c the vectors ending with _xz are for boundaries in the xz-plane
c THE BC IS IMPOSED NORMAL TO THAT SIDE 
c
c bc vectors are a matrix with 2 columns representing the nodal df
c and the two planes for each axis pair 
c  with the plane on the (-) side in col 1
c also numbering is in the order y-x, y-z, x-z, 
c  for the respective planes
c
c
        include 'include.f'
c
c initialize the source vectors
c
        do 222 i = 1, nn
         IF(i_ow.eq.1) qiow(i) = 0.d0
         IF(i_og.eq.1) qiog(i) = 0.d0
                       qw(i)   = 0.d0
                       qn(i)   = 0.d0
                       qg(i)   = 0.d0
  222   continue
c
c*********************************************************
c DO THE PLANES 
c*********************************************************
c
c 2 yx-planes
c
          jj = 0
c
      do 1  i = 1, 2
        do 2  j = 0, nny*nex, nny
          do 3  k = 1, nny
c          flow variables
             ib_yx(j+k,i)  = 1       
c          concenrtation
              IF(i_ow.eq.1) iboa_yx(j+k,i)  = 2
              IF(i_og.eq.1) ibog_yx(j+k,i)  = 2
c
c            global node number    
               ii = jj + j + k        
c
                   IF(i_ow.eq.1)then
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   else
                    call water_prop (0.d0,wa,dww,visw)
                   endif
                   IF(i_og.eq.1)then
                    call   gas_prop (rog11(ii,1),gg,dgg,visg)
                   else
                    call   gas_prop (0.d0,gg,dgg,visg)
                   endif
c
               pa11(ii,4)   = dww*grav*dcos(th_z)*dsin(th_y)
c*
             d_pc = -1.d+07
             call lev_sw_p (d_pc,dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
               sw11(ii,4)  = (rn_r-dww)*grav*dcos(th_z)*dsin(th_y)
     &                        /dpcnw(ii)
               st11(ii,4)  = (dgg-rn_r)*grav*dcos(th_z)*dsin(th_y)
     &                        /dpcgn(ii)
c*
    3     continue
    2   continue
                      jj = nnx*nny*nez
    1 continue
c
c 2 xz-planes
c
          jj = 0
      do 11  i = 1, 2
        do 12  j = 0, nnx*nez, nnx
          do 13  k = 1, nnx
c          flow variables
             ib_xz(j+k,i)  = 1       
c          concenrtation
             IF(i_ow.eq.1) iboa_xz(j+k,i)  = 2
             IF(i_og.eq.1) ibog_xz(j+k,i)  = 2
c
c            global node number    
               ii = (k-1)*nny + j*nny + jj + 1
c
                   IF(i_ow.eq.1)then
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   else
                    call water_prop (0.d0,wa,dww,visw)
                   endif
                   IF(i_og.eq.1)then
                    call   gas_prop (rog11(ii,1),gg,dgg,visg)
                   else
                    call   gas_prop (0.d0,gg,dgg,visg)
                   endif
c
                   pa11(ii,3)   = -dww*grav*dsin(th_z)
c*
             d_pc = -1.d+07
             call lev_sw_p (d_pc,dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
               sw11(ii,3)  = -(rn_r-dww)*grav*dsin(th_z)/dpcnw(ii)
               st11(ii,3)  = -(dgg-rn_r)*grav*dsin(th_z)/dpcgn(ii)
c*
   13     continue
   12   continue
                      jj = ney
   11 continue
c
c 2 yz-planes
c
          jj = 0
      do 21  i = 1, 2
        do 22  j = 0, nny*nez, nny
          do 23  k = 1, nny
c          flow variables
             ib_yz(j+k,i)  = 1       
c          concenrtation
             IF(i_ow.eq.1) iboa_yz(j+k,i)  = 2
             IF(i_og.eq.1) ibog_yz(j+k,i)  = 2
c
c            global node number    
               ii = k + j*nnx + jj 
c
                   IF(i_ow.eq.1)then
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   else
                    call water_prop (0.d0,wa,dww,visw)
                   endif
                   IF(i_og.eq.1)then
                    call   gas_prop (rog11(ii,1),gg,dgg,visg)
                   else
                    call   gas_prop (0.d0,gg,dgg,visg)
                   endif
c
               pa11(ii,2)   = dww*grav*dcos(th_z)*dcos(th_y)
c*
             d_pc = -1.d+07
             call lev_sw_p (d_pc,dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
               sw11(ii,2)  = (rn_r-dww)*grav*dcos(th_z)*dcos(th_y)
     &                        /dpcnw(ii)
               st11(ii,2)  = (dgg-rn_r)*grav*dcos(th_z)*dcos(th_y)
     &                        /dpcgn(ii)
c*
   23     continue
   22   continue
                      jj = nny*nex
   21 continue
c
              			return
         			end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine bc_flow (ncond)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c     SPECIFICATION OF DIRICHLET BC'S
c     for the flow equations
c
c NOTE: all other in/out of mass from the system is described by 
c       point source/sink terms
c
        include 'include.f'
c
	do 26 i=1,ncond
c
c nface = domain face on which the bc is to be perscribed
c          =1 - yx-planes
c          =2 - yz-planes
c          =3 - xz-planes
c ii = global node number for non-zero flux condition (numbering y-x-z)
c
c ncode for Dirichlet bc's :    (variable(s) specified)
c        =1 - default no flow condition
c             Neumann (Pw, Sw, St)
c        =2 - open to gas flow (Pg), closed to water and NAPL flow
c             Neumann (Sw, St), Dirichlet (Pw)
c        =3 - open to NAPL flow (Pn), closed to water and gas flow
c             Neumann (Sw, St), Dirichlet (Pw)
c        =4 - open to water flow (Pw), closed to gas and NAPL flow
c             Neumann (Sw, St), Dirichlet (Pw)
c        =5 - open to water, gas and NAPL flow (Pw, Sn, Sg)
c             Dirichlet (Pw,Sw,St)
c NOTE: Sw and St always have the same BC specification
c
c       ****
	read(9,*)nface, ii, ncode 
c       ****
               if(ncode.eq.2.and.iphase.eq.12) then
       write(6,*) 'INPUT ERROR '
       write(6,*) 'APPLYING A GAS HEAD FOR A WATER-NAPL PROBLEM'
                stop
               else if(ncode.eq.3.and.iphase.eq.13) then
       write(6,*) 'INPUT ERROR '
       write(6,*) 'APPLYING A NAPL HEAD FOR A WATER-GAS PROBLEM'
                stop
               endif
c given the node figure out the 
c          row(x-axis);    index in y 
c          column(y-axis); index in x and 
c          page (z-axis);  index in z
c
	    npg = ii/(nny*nnx)
	    if(nnx*nny*npg.lt.ii)  npg = npg + 1
c
	    nco = ( ii - (npg-1)*nnx*nny ) / nny
	    if(nny*nco.lt.(ii-(npg-1)*nnx*nny))  nco = nco + 1
c
	    nro = nny - (nny*nco - ( ii - (npg-1)*nnx*nny ))
c
c?????????????????
c set the ib_ vector for this condition 
c?????????????????
c
      if (nface.eq.1)  then
c
c       check to see if this node is on an yx face
         if(npg.ne.1.and.npg.ne.nnz)then
c           this node is not on either yx-face
            write(6,*) 'INPUT ERROR '
            write(6,*) 'CHECK FLOW BC S ON THE XY-FACES'
                             stop
         else 
c
c          this an yx-face boundary node : consider row and column
c          index for the bc vector ib_yx is 'ntemp', where:
c          numbering is in y first
                        ntemp = nro + (nco-1)*nny
                  if(npg.eq.1)  then
                           iplane = 1
                  else 
                           iplane = 2
                  endif
                           ib_yx(ntemp,iplane)  = ncode
         endif
c
      else if (nface.eq.2)  then
c
c      check to see if this node is on an yz face
         if(nco.ne.1.and.nco.ne.nnx)then
c           this node is not on either yz-face
            write(6,*) 'INPUT ERROR '
            write(6,*) 'CHECK FLOW BC S ON THE YZ-FACES'
                             stop
         else 
c
c          this an yz-face boundary node : consider row and page
c          index for the bc vector ib_yz is 'ntemp', where:
c          numbering is in y first
                        ntemp = nro + (npg-1)*nny
                  if(nco.eq.1)  then
                           iplane = 1
                  else 
                           iplane = 2
                  endif
                     ib_yz(ntemp,iplane)  = ncode
         endif
c
      else if (nface.eq.3)  then
c
c      check to see if this node is on an xz face
         if(nro.ne.1.and.nro.ne.nny)then
c           this node is not on either xz-face
            write(6,*) 'INPUT ERROR '
            write(6,*) 'CHECK FLOW BC S ON THE XZ-FACES'
                             stop
         else 
c
c          this an xz-face boundary node : consider column and page
c          index for the bc vector ib_xz is 'ntemp', where:
c          numbering is in x first
                        ntemp = nco + (npg-1)*nnx
                  if(nro.eq.1)  then
                           iplane = 1
                  else 
                           iplane = 2
                  endif
                     ib_xz(ntemp,iplane)  = ncode
c
         endif
      else
c            there is a problem with face specification
            write(6,*) 'CHECK FLOW BC FACE SPECIFICATION'
                             stop
      endif
c
c?????????????????
c SET THE Proper variables
c?????????????????
c (2)
        if( ncode      .eq.  2 )  then
c (2)
c Pg is known
c Dirichlet condition on Pw = Pg - Pcnw - Pcgn
c Neumann conditions on Sw and St
c set Qg = Vt * area after solving for Pw.
c
c specify the head of the gas phase at the node
c
          read(9,*) head
c
       IF(i_og.eq.1) then
        call   gas_prop (rog11(ii,1),gg,dgg,visg)
       else
        call   gas_prop (0.d0,gg,dgg,visg)
       endif
c          set Pw and its tangential derivatives
c
        IF(i_static.ne.0) then
c compute the effect of grid rotation on head
          head = head  + dcos(th_z)*dcos(th_y)*x(nco)
     &                 - dsin(th_z)*y(nro)
     &                 + dcos(th_z)*dsin(th_y)*z(npg)
        endif
          pa11(ii,1)   = grav*dgg*head + pg_ref
     &                - pcnw1(ii) - pcgn1(ii)
c
       if (nface.eq.1)  then
c      yx-planes (normal is z)
c       tangential derivatives (2, 3, 5)
            if(dabs(st11(ii,2)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,2)
             endif
             if(dabs(sw11(ii,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,2)
             endif
               
            pa11(ii,2) = dgg*grav*dcos(th_z)*dcos(th_y)-(pcnw + pcgn)
c
            if(dabs(st11(ii,3)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,3)
             endif
             if(dabs(sw11(ii,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,3)
             endif
                
            pa11(ii,3) = -dgg*grav*dsin(th_z) -(pcnw + pcgn)
c
            if(dabs(st11(ii,5)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,5)
             endif
             if(dabs(sw11(ii,5)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,5)
             endif
            pa11(ii,5) = -(pcnw + pcgn)
c
c
       else if (nface.eq.2)  then
c      yz-planes (normal is x)
c       tangential derivatives (3, 4, 7)
            if(dabs(st11(ii,4)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,4)
             endif
             if(dabs(sw11(ii,4)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,4)
             endif
         pa11(ii,4) = dgg*grav*dcos(th_z)*dsin(th_y)-(pcnw + pcgn)
c
            if(dabs(st11(ii,3)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,3)
             endif
             if(dabs(sw11(ii,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,3)
             endif
         pa11(ii,3) = -dgg*grav*dsin(th_z) -(pcnw + pcgn)
c
            if(dabs(st11(ii,7)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,7)
             endif
             if(dabs(sw11(ii,7)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,7)
             endif
         pa11(ii,7) = -(pcnw + pcgn)
c
       else 
c      xz-planes (normal is y)
c          tangential derivatives (2, 4, 6)
c
            if(dabs(st11(ii,2)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,2)
             endif
             if(dabs(sw11(ii,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,2)
             endif
         pa11(ii,2) = dgg*grav*dcos(th_z)*dcos(th_y)-(pcnw + pcgn)
c
            if(dabs(st11(ii,4)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,4)
             endif
             if(dabs(sw11(ii,4)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,4)
             endif
         pa11(ii,4) = dgg*grav*dcos(th_z)*dsin(th_y)-(pcnw + pcgn)
c
            if(dabs(st11(ii,6)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,6)
             endif
             if(dabs(sw11(ii,6)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,6)
             endif
         pa11(ii,6) = -(pcnw + pcgn)
c
c
       endif
c
c (3)
        else if( ncode      .eq.  3 )  then
c (3)
c Pn is known
c Dirichlet condition on Pw = Pn - Pcnw
c Neumann conditions on Sw and St
c set Qg = Vt * area after solving for Pw.
c
c specify the head of the NAPL phase at the node
c
          read(9,*) head
c
c          set Pw and its tangential derivatives
c
        IF(i_static.ne.0) then
c compute the effect of grid rotation on head
          head = head  + dcos(th_z)*dcos(th_y)*x(nco)
     &                 - dsin(th_z)*y(nro)
     &                 + dcos(th_z)*dsin(th_y)*z(npg)
        endif
          pa11(ii,1)   = grav*rn_r*head + pg_ref
     &                - pcnw1(ii)
c
       if (nface.eq.1)  then
c      yx-planes (normal is z)
c       tangential derivatives (2, 3, 5)
            if(dabs(st11(ii,2)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,2)
             endif
             if(dabs(sw11(ii,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,2)
             endif
               
            pa11(ii,2) = rn_r*grav*dcos(th_z)*dcos(th_y)- pcnw
c
            if(dabs(st11(ii,3)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,3)
             endif
             if(dabs(sw11(ii,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,3)
             endif
                
            pa11(ii,3) = -rn_r*grav*dsin(th_z) - pcnw 
c
            if(dabs(st11(ii,5)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,5)
             endif
             if(dabs(sw11(ii,5)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,5)
             endif
            pa11(ii,5) = - pcnw
c
       else if (nface.eq.2)  then
c      yz-planes (normal is x)
c       tangential derivatives (3, 4, 7)
            if(dabs(st11(ii,4)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,4)
             endif
             if(dabs(sw11(ii,4)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,4)
             endif
         pa11(ii,4) = rn_r*grav*dcos(th_z)*dsin(th_y)- pcnw 
c
            if(dabs(st11(ii,3)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,3)
             endif
             if(dabs(sw11(ii,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,3)
             endif
         pa11(ii,3) = -rn_r*grav*dsin(th_z) - pcnw
c
            if(dabs(st11(ii,7)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,7)
             endif
             if(dabs(sw11(ii,7)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,7)
             endif
         pa11(ii,7) = - pcnw 
c
       else 
c      xz-planes (normal is y)
c          tangential derivatives (2, 4, 6)
c
            if(dabs(st11(ii,2)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,2)
             endif
             if(dabs(sw11(ii,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,2)
             endif
         pa11(ii,2) = rn_r*grav*dcos(th_z)*dcos(th_y)- pcnw
c
            if(dabs(st11(ii,4)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,4)
             endif
             if(dabs(sw11(ii,4)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,4)
             endif
         pa11(ii,4) = rn_r*grav*dcos(th_z)*dsin(th_y)- pcnw
c
            if(dabs(st11(ii,6)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,6)
             endif
             if(dabs(sw11(ii,6)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,6)
             endif
         pa11(ii,6) = - pcnw
c
       endif
c
c (4)
        else if( ncode      .eq.  4 )  then
c (4)
c Pw is known
c set Dirichlet condition on Pw and
c Neumann conditions on Sw and St
c
c specify the head of the water phase at the node
c
c        read in Pw (in terms of head of water)
          read(9,*) head
c
                   IF(i_ow.eq.1)then
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   else
                    call water_prop (0.d0,wa,dww,visw)
                   endif
c
        IF(i_static.ne.0) then
c compute the effect of grid rotation on head
          head = head  + dcos(th_z)*dcos(th_y)*x(nco)
     &                 - dsin(th_z)*y(nro)
     &                 + dcos(th_z)*dsin(th_y)*z(npg)
        endif
         pa11(ii,1)   = pg_ref + grav*dww*head
c
       if (nface.eq.1)  then
c      yx-planes (normal is z)
c       tangential derivatives (2, 3, 5)
            pa11(ii,2) = dww*grav*dcos(th_z)*dcos(th_y)
            pa11(ii,3) = -dww*grav*dsin(th_z)
            pa11(ii,5) = 0.d0
c
       else if (nface.eq.2)  then
c      yz-planes (normal is x)
c       tangential derivatives (3, 4, 7)
         pa11(ii,4) = dww*grav*dcos(th_z)*dsin(th_y)
         pa11(ii,3) = -dww*grav*dsin(th_z)
         pa11(ii,7) = 0.d0   
c
       else 
c      xz-planes (normal is y)
c          tangential derivatives (2, 4, 6)
         pa11(ii,2) = dww*grav*dcos(th_z)*dcos(th_y)
         pa11(ii,4) = dww*grav*dcos(th_z)*dsin(th_y)
         pa11(ii,6) = 0.d0
c
       endif
c
c (5)
        else if( ncode      .eq. 5 )  then
c (5)
c        Pw(1), Sw(1), St(1)
c
c        read in Pw, Sw, Sg
          read(9,*) n_opt,head, sw, sg
c n_opt = 1 then use the restart values as Dirichlet data
c n_opt = 0 then use the bc_flow.in file values as Dirichlet data
c
          if (n_opt.ne.1)  then
             if ( 1.d0-sw-sg .gt. 0.0001d0 ) then
c             NAPL is present, so set Dirichlet conc. at eq.
              IF(i_ow.eq.1)then
                     roa11(ii,1) = parow
                     roat(ii,1) = parow
                if (nface.eq.1)  then
c                        yx-planes (normal is z)
                         iboa_yx(ntemp,iplane)  = 1
                else if (nface.eq.2)  then
c                        yz-planes (normal is x)
                         iboa_yz(ntemp,iplane)  = 1
                else
c                        xz-planes (normal is y)
                         iboa_xz(ntemp,iplane)  = 1
                endif
              endif
              IF(i_og.eq.1)then
                     rog11(ii,1) = parog
                     rogt(ii,1) = parog
                if (nface.eq.1)  then
c                        yx-planes (normal is z)
                         ibog_yx(ntemp,iplane)  = 1
                else if (nface.eq.2)  then
c                        yz-planes (normal is x)
                         ibog_yz(ntemp,iplane)  = 1
                else 
c                        xz-planes (normal is y)
                         ibog_xz(ntemp,iplane)  = 1
                endif
              endif
             endif
c
                   IF(i_ow.eq.1)then
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   else
                    call water_prop (0.d0,wa,dww,visw)
                   endif
c
        IF(i_static.ne.0) then
c compute the effect of grid rotation on head
          head = head  + dcos(th_z)*dcos(th_y)*x(nco)
     &                 - dsin(th_z)*y(nro)
     &                 + dcos(th_z)*dsin(th_y)*z(npg)
        endif
          pa11(ii,1)   = grav*dww*head  + pg_ref
c
           sw11(ii,1)  =  sw
           st11(ii,1)  =  1.d0 - sg
                 if (nhyst.eq.1)   then
                      swt(ii,1)  =  sw
                      stt(ii,1)  =  1.d0 - sg
c                  hysteresis on
                        call hyst_ic (ii, sw11(ii,1), st11(ii,1))
                 endif
            call pc_nw    (sw11(ii,1), pc, d_pc, ii)
            call lev_sw_p (pc, pcnw1(ii) )
            call pc_gn       (st11(ii,1), pc, d_pc, ii)
            call lev_st_p    (pc, pcgn1(ii) )
c
          else if(nflag.ne.1) then
              write(6,*) 'INPUT ERROR'
           write(6,*)'BC FLOW CASE 5, n_opt = 1 when no IC data to read'
                    stop
          endif
c
        else
              write(6,*) 'INPUT ERROR'
              write(6,*) 'NOT A VALID CODE NUMBER at boundary node:'
              write(6,*) ii
              stop
        endif
   26  continue
                                    return
                                    end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine bc_oa (ncond)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c routine to set up Dirichlet bc's for the Transport equation
c
c NOTE: all other in/out of mass from the system is described by 
c       point source/sink terms
c
        include 'include.f'
c
        if (ntr_ow.eq.1.and. i_ow.eq.1)  then
c
	do 26 i=1,ncond
c
c nface = domain face on which the bc is to be perscribed
c          =1 - yx-planes
c          =2 - yz-planes
c          =3 - xz-planes
c nod = global node number for non-zero flux condition (numbering y-x-z)
c
c       ****
	read(10,*)nface, nod, value 
c       ****
        if ( value .lt. -epsil) then
              write(6,*) 'INPUT ERROR'
              write(6,*) 'Negative value for Roa BC at boundary node:'
              write(6,*) nod
              stop
        endif
c
               roa11(nod,1) =  value  
               roat(nod,1) =  value  
c
c given the node figure out the 
c          row(x-axis);    index in y 
c          column(y-axis); index in x and 
c          page (z-axis);  index in z
c
	    npg = nod/(nny*nnx)
	    if(nnx*nny*npg.lt.nod)  npg = npg + 1
c
	    nco = ( nod - (npg-1)*nnx*nny ) / nny
	    if(nny*nco.lt.(nod-(npg-1)*nnx*nny))  nco = nco + 1
c
	    nro = nny - (nny*nco - ( nod - (npg-1)*nnx*nny ))
c
c
c set the iboa_ vector for this condition 
      if (nface.eq.1)  then
c
c       check to see if this node is on an yx face
         if(npg.ne.1.and.npg.ne.nnz)then
c           this node is not on either yx-face
            write(6,*) 'INPUT ERROR'
            write(6,*) 'CHECK Conc BC S ON THE XY-FACES'
                             stop
         else 
c
c          this an yx-face boundary node : consider row and column
c          index for the bc vector iboa_yx is 'ntemp', where:
c
                        ntemp = nro + (nco-1)*nny
                  if(npg.eq.1)  then
                         iplane = 1
                  else 
                         iplane = 2
                  endif
                               iboa_yx(ntemp,iplane)  = 1
         endif
c
      else if (nface.eq.2)  then
c
c      check to see if this node is on an yz face
         if(nco.ne.1.and.nco.ne.nnx)then
c           this node is not on either yz-face
            write(6,*) 'INPUT ERROR'
            write(6,*) 'CHECK Conc BC S ON THE YZ-FACES'
                             stop
         else 
c
c          this an yz-face boundary node : consider row and page
c          index for the bc vector iboa_yz is 'ntemp', where:
                        ntemp = nro + (npg-1)*nny
                  if(nco.eq.1)  then
                         iplane = 1
                  else 
                         iplane = 2
                  endif
                         iboa_yz(ntemp,iplane)  = 1
         endif
c
      else
c
c      check to see if this node is on an xz face
         if(nro.ne.1.and.nro.ne.nny)then
c           this node is not on either xz-face
            write(6,*) 'INPUT ERROR'
            write(6,*) 'CHECK Conc BC S ON THE XZ-FACES'
                             stop
         else 
c
c          this an xz-face boundary node : consider column and page
c          index for the bc vector iboa_xz is 'ntemp', where:
                        ntemp = nco + (npg-1)*nnx
                  if(nro.eq.1)  then
                         iplane = 1
                  else 
                         iplane = 2
                  endif
                         iboa_xz(ntemp,iplane)  = 1
c
         endif
c
      endif
c
   26  continue
c
       else 
              write(28,*) 'INPUT WARNING'
       write(28,*) 'NAPL-water transport is OFF - NO BCs SET'
       endif
                                    return
                                    end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine bc_og (ncond)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c routine to set up Dirichlet bc's for the O-G Transport equation
c
c NOTE: all other in/out of mass from the system is described by 
c       point source/sink terms
c
        include 'include.f'
c
        if (ntr_og.eq.1.and.i_og.eq.1)  then
c
	do 26 i=1,ncond
c
c nface = domain face on which the bc is to be perscribed
c          =1 - yx-planes
c          =2 - yz-planes
c          =3 - xz-planes
c nod = global node number for non-zero flux condition (numbering y-x-z)
c
c       ****
	read(11,*)nface, nod, value 
c       ****
        if ( value .lt. -epsil) then
              write(6,*) 'INPUT ERROR'
              write(6,*) 'Negative value for Rog BC at boundary node:'
              write(6,*) nod
              stop
        endif
c
               rog11(nod,1) =  value  
               rogt(nod,1) =  value  
c
c given the node figure out the 
c          row(x-axis);    index in y 
c          column(y-axis); index in x and 
c          page (z-axis);  index in z
c
	    npg = nod/(nny*nnx)
	    if(nnx*nny*npg.lt.nod)  npg = npg + 1
c
	    nco = ( nod - (npg-1)*nnx*nny ) / nny
	    if(nny*nco.lt.(nod-(npg-1)*nnx*nny))  nco = nco + 1
c
	    nro = nny - (nny*nco - ( nod - (npg-1)*nnx*nny ))
c
c
c set the ibog_ vector for this condition 
      if (nface.eq.1)  then
c
c       check to see if this node is on an yx face
         if(npg.ne.1.and.npg.ne.nnz)then
c           this node is not on either yx-face
            write(6,*) 'INPUT ERROR'
            write(6,*) 'CHECK Conc BC S ON THE XY-FACES'
                             stop
         else 
c
c          this an yx-face boundary node : consider row and column
c          index for the bc vector ibog_yx is 'ntemp', where:
c
                        ntemp = nro + (nco-1)*nny
                  if(npg.eq.1)  then
                         iplane = 1
                  else 
                         iplane = 2
                  endif
                               ibog_yx(ntemp,iplane)  = 1
         endif
c
      else if (nface.eq.2)  then
c
c      check to see if this node is on an yz face
         if(nco.ne.1.and.nco.ne.nnx)then
c           this node is not on either yz-face
            write(6,*) 'INPUT ERROR'
            write(6,*) 'CHECK Conc BC S ON THE YZ-FACES'
                             stop
         else 
c
c          this an yz-face boundary node : consider row and page
c          index for the bc vector ibog_yz is 'ntemp', where:
                        ntemp = nro + (npg-1)*nny
                  if(nco.eq.1)  then
                         iplane = 1
                  else 
                         iplane = 2
                  endif
                         ibog_yz(ntemp,iplane)  = 1
         endif
c
      else
c
c      check to see if this node is on an xz face
         if(nro.ne.1.and.nro.ne.nny)then
c           this node is not on either xz-face
            write(6,*) 'INPUT ERROR'
            write(6,*) 'CHECK Conc BC S ON THE XZ-FACES'
                             stop
         else 
c
c          this an xz-face boundary node : consider column and page
c          index for the bc vector ibog_xz is 'ntemp', where:
                        ntemp = nco + (npg-1)*nnx
                  if(nro.eq.1)  then
                         iplane = 1
                  else 
                         iplane = 2
                  endif
                         ibog_xz(ntemp,iplane)  = 1
c
         endif
c
      endif
c
   26  continue
c
       else 
              write(28,*) 'INPUT WARNING'
       write(28,*) 'NAPL-gas transport is OFF - NO BCs SET'
       endif
                                    return
                                    end
c
c########################################################
           subroutine bc_up
c########################################################
c
c     update all bc'c which are a function of the solution 
c              pressure, concentration and saturation
c
        include 'include.f'
c
c*********************************************************
c DO THE PLANES 
c*********************************************************
c
c 1 yx-planes
c
          jj = 0
      do 1  i = 1, 2
        do 2  j = 0, nny*nex, nny
          do 3  k = 1, nny
c
c            global node number    
               ii = jj + j + k        
c
                   IF(i_ow.eq.1)then
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   else
                    call water_prop (0.d0,wa,dww,visw)
                   endif
c
       IF(i_og.eq.1) then
        call   gas_prop (rog11(ii,1),gg,dgg,visg)
       else
        call   gas_prop (0.d0,gg,dgg,visg)
       endif
c
c(1)
        if( ib_yx(j+k,i).eq. 1  )   then
c(1)
            pa11(ii,4)   = dww*grav* dcos(th_z)*dsin(th_y)
c
        if( dabs(dcos(th_z)*dsin(th_y)) .gt. epsil) then
             d_pc = -1.d+07
             call lev_sw_p (d_pc, dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,4)  = (rn_r-dww)*grav* dcos(th_z)*dsin(th_y)
     &                        /dpcnw(ii)
            st11(ii,4)  = (dgg-rn_r)*grav* dcos(th_z)*dsin(th_y)
     &                        /dpcgn(ii)
        endif
c
c(2)
        else if( ib_yx(j+k,i).eq. 2  )   then
c(2)
c          Pw = Pg - Pcgw
c          (Pw)x =  - Pcgw)x
c          (Pw)y =  - Pcgw)y
c          (Pw)xy =  - Pcgw)xy
c          update Pw and its tangential derivatives (1, 2, 3, 5)
c
cX**X  Adjust Pg to account for changes in Pc and gas density
              IF(i_og.eq.1) then
                  call   gas_prop (rogt(ii,1),gg,dgg,visg)
                     head = (pat(ii,1) - pg_ref) / (grav*dgg)
                  call   gas_prop (rog11(ii,1),gg,dgg,visg)
                     pa11(ii,1)   = grav*dgg*head + pg_ref
     &                            - pcnw1(ii) - pcgn1(ii)
              else
                  call   gas_prop (0.d0,gg,dgg,visg)
                  pa11(ii,1) = pat(ii,1) - (pcnw1(ii)+pcgn1(ii))
              endif
cX**X
c
            if(dabs(st11(ii,2)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,2)
             endif
             if(dabs(sw11(ii,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,2)
             endif
               
            pa11(ii,2) = dgg*grav*dcos(th_z)*dcos(th_y)-(pcnw + pcgn)
c
            if(dabs(st11(ii,3)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,3)
             endif
             if(dabs(sw11(ii,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,3)
             endif
                
            pa11(ii,3) = -dgg*grav*dsin(th_z) -(pcnw + pcgn)
c
            if(dabs(st11(ii,5)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,5)
             endif
             if(dabs(sw11(ii,5)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,5)
             endif
            pa11(ii,5) = -(pcnw + pcgn)
c
        if( dabs(dcos(th_z)*dsin(th_y)) .gt. epsil) then
             d_pc = -1.d+07
             call lev_sw_p (d_pc, dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,4)  = (rn_r-dww)*grav* dcos(th_z)*dsin(th_y)
     &                        /dpcnw(ii)
            st11(ii,4)  = (dgg-rn_r)*grav* dcos(th_z)*dsin(th_y)
     &                        /dpcgn(ii)
        endif
c
c no flow conditions
         qw(ii) = 0.d0
         qn(ii) = 0.d0
         qg(ii) = 0.d0
         IF(i_og.eq.1) qiog(ii) = 0.d0
         IF(i_ow.eq.1) qiow(ii) = 0.d0
c(3)
        else if( ib_yx(j+k,i).eq. 3  )   then
c(3)
c          Pw = Pn - Pcnw
c          (Pw)x =  - Pcnw)x
c          (Pw)y =  - Pcnw)y
c          (Pw)xy =  - Pcnw)xy
c          update Pw and its tangential derivatives (1, 2, 3, 5)
c
         pa11(ii,1) = pat(ii,1) - pcnw1(ii)
c
             if(dabs(sw11(ii,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,2)
             endif
         pa11(ii,2) = rn_r*grav*dcos(th_z)*dcos(th_y) - pcnw 
c
             if(dabs(sw11(ii,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,3)
             endif
c
         pa11(ii,3) = -rn_r*grav*dsin(th_z) - pcnw
             if(dabs(sw11(ii,5)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,5)
             endif
         pa11(ii,5) = - pcnw
c
        if( dabs(dcos(th_z)*dsin(th_y)) .gt. epsil) then
             d_pc = -1.d+07
             call lev_sw_p (d_pc, dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,4)  = (rn_r-dww)*grav* dcos(th_z)*dsin(th_y)
     &                        /dpcnw(ii)
            st11(ii,4)  = (dgg-rn_r)*grav* dcos(th_z)*dsin(th_y)
     &                        /dpcgn(ii)
        endif
c
c no flow conditions
         qw(ii) = 0.d0
         qn(ii) = 0.d0
         qg(ii) = 0.d0
         IF(i_og.eq.1) qiog(ii) = 0.d0
         IF(i_ow.eq.1) qiow(ii) = 0.d0
c
c(4)
        else if( ib_yx(j+k,i).eq. 4  )   then
c(4)
c Adjust Pw TO account for change IN water density
c
              IF(i_ow.eq.1)then
                    call water_prop (roat(ii,1),wa,dww,visw)
c
                   head = (pat(ii,1) - pg_ref) / (grav*dww)
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   pa11(ii,1)   = pg_ref + grav*dww*head
              else
c                   Pw = Pw
                    call water_prop (0.d0,wa,dww,visw)
              endif
c
        if( dabs(dcos(th_z)*dsin(th_y)) .gt. epsil) then
             d_pc = -1.d+07
             call lev_sw_p (d_pc, dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,4)  = (rn_r-dww)*grav* dcos(th_z)*dsin(th_y)
     &                        /dpcnw(ii)
            st11(ii,4)  = (dgg-rn_r)*grav* dcos(th_z)*dsin(th_y)
     &                        /dpcgn(ii)
        endif
c
c no flow conditions
         qw(ii) = 0.d0
         qn(ii) = 0.d0
         qg(ii) = 0.d0
         IF(i_og.eq.1) qiog(ii) = 0.d0
         IF(i_ow.eq.1) qiow(ii) = 0.d0
c
c(5)
        else if( ib_yx(j+k,i).eq. 5  )   then
c(5)
c Adjust Pw TO account for change IN water density
c
              IF(i_ow.eq.1)then
                    call water_prop (roat(ii,1),wa,dww,visw)
c
                   head = (pat(ii,1) - pg_ref) / (grav*dww)
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   pa11(ii,1)   = pg_ref + grav*dww*head
              endif
c
        endif
c
    3     continue
    2   continue
                      jj = nnx*nny*nez
    1 continue
c
c################################################
c 2 xz-planes
c################################################
          jj = 0
      do 11  i = 1, 2
        do 12  j = 0, nnx*nez, nnx
          do 13  k = 1, nnx
c
c            global node number    
               ii = (k-1)*nny + j*nny + jj + 1
c
                   IF(i_ow.eq.1)then
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   else
                    call water_prop (0.d0,wa,dww,visw)
                   endif
       IF(i_og.eq.1) then
        call   gas_prop (rog11(ii,1),gg,dgg,visg)
       else
        call   gas_prop (0.d0,gg,dgg,visg)
       endif
c
c(1)
        if( ib_xz(j+k,i).eq. 1  )   then
c(1)
c no flow conditions
            pa11(ii,3)  = -dww*grav*dsin(th_z)
        if( dabs(dsin(th_z)           ) .gt. epsil) then
             d_pc = -1.d+07
             call lev_sw_p (d_pc, dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,3)  = -(rn_r-dww)*grav*dsin(th_z)/dpcnw(ii)
            st11(ii,3)  = -(dgg-rn_r)*grav*dsin(th_z)/dpcgn(ii)
        endif
c
c(2)
        else if( ib_xz(j+k,i).eq. 2  )   then
c(2)
c          Pw = Pg - Pcgw
c          (Pw)x =  - Pcgw)x
c          (Pw)z =  - Pcgw)z
c          (Pw)xz =  - Pcgw)xz
c          update Pw and its tangential derivatives (1, 2, 4, 6)
cX**X  Adjust Pg to account for changes in Pc and gas density
              IF(i_og.eq.1) then
                  call   gas_prop (rogt(ii,1),gg,dgg,visg)
                     head = (pat(ii,1) - pg_ref) / (grav*dgg)
                  call   gas_prop (rog11(ii,1),gg,dgg,visg)
                     pa11(ii,1)   = grav*dgg*head + pg_ref
     &                            - pcnw1(ii) - pcgn1(ii)
              else
                  call   gas_prop (0.d0,gg,dgg,visg)
                  pa11(ii,1) = pat(ii,1) - (pcnw1(ii)+pcgn1(ii))
              endif
cX**X
c
            if(dabs(st11(ii,2)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,2)
             endif
             if(dabs(sw11(ii,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,2)
             endif
         pa11(ii,2) = dgg*grav*dcos(th_z)*dcos(th_y)-(pcnw + pcgn)
c
            if(dabs(st11(ii,4)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,4)
             endif
             if(dabs(sw11(ii,4)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,4)
             endif
         pa11(ii,4) = dgg*grav*dcos(th_z)*dsin(th_y)-(pcnw + pcgn)
c
            if(dabs(st11(ii,6)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,6)
             endif
             if(dabs(sw11(ii,6)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,6)
             endif
         pa11(ii,6) = -(pcnw + pcgn)
c
        if( dabs(dsin(th_z)           ) .gt. epsil) then
             d_pc = -1.d+07
             call lev_sw_p (d_pc, dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,3)  = -(rn_r-dww)*grav*dsin(th_z)/dpcnw(ii)
            st11(ii,3)  = -(dgg-rn_r)*grav*dsin(th_z)/dpcgn(ii)
        endif
c no flow conditions
         qw(ii) = 0.d0
         qn(ii) = 0.d0
         qg(ii) = 0.d0
         IF(i_og.eq.1) qiog(ii) = 0.d0
         IF(i_ow.eq.1) qiow(ii) = 0.d0
c
c(3)
        else if( ib_xz(j+k,i).eq. 3  )   then
c(3)
c          Pw = Pn - Pcnw
c          (Pw)x =  - Pcnw)x
c          (Pw)z =  - Pcnw)z
c          (Pw)xz =  - Pcnw)xz
c          update Pw and its tangential derivatives (1, 2, 4, 6)
c     
         pa11(ii,1) = pat(ii,1) - pcnw1(ii)
c
             if(dabs(sw11(ii,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,2)
             endif
         pa11(ii,2) = rn_r*grav*dcos(th_z)*dcos(th_y)- pcnw 
c
             if(dabs(sw11(ii,4)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,4)
             endif
         pa11(ii,4) = rn_r*grav*dcos(th_z)*dsin(th_y)- pcnw
c
             if(dabs(sw11(ii,6)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,6)
             endif
         pa11(ii,6) = - pcnw
c
        if( dabs(dsin(th_z)           ) .gt. epsil) then
             d_pc = -1.d+07
             call lev_sw_p (d_pc, dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,3)  = -(rn_r-dww)*grav*dsin(th_z)/dpcnw(ii)
            st11(ii,3)  = -(dgg-rn_r)*grav*dsin(th_z)/dpcgn(ii)
        endif
c no flow conditions
         qw(ii) = 0.d0
         qn(ii) = 0.d0
         qg(ii) = 0.d0
         IF(i_og.eq.1) qiog(ii) = 0.d0
         IF(i_ow.eq.1) qiow(ii) = 0.d0
c
c(4)
        else if( ib_xz(j+k,i).eq. 4  )   then
c(4)
c Adjust Pw TO account for change IN water density
c
              IF(i_ow.eq.1)then
                    call water_prop (roat(ii,1),wa,dww,visw)
c
                   head = (pat(ii,1) - pg_ref) / (grav*dww)
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   pa11(ii,1)   = pg_ref + grav*dww*head
              else
c                   Pw = Pw
                    call water_prop (0.d0,wa,dww,visw)
              endif
c
        if( dabs(dsin(th_z)           ) .gt. epsil) then
             d_pc = -1.d+07
             call lev_sw_p (d_pc, dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,3)  = -(rn_r-dww)*grav*dsin(th_z)/dpcnw(ii)
            st11(ii,3)  = -(dgg-rn_r)*grav*dsin(th_z)/dpcgn(ii)
        endif
c no flow conditions
         qw(ii) = 0.d0
         qn(ii) = 0.d0
         qg(ii) = 0.d0
         IF(i_og.eq.1) qiog(ii) = 0.d0
         IF(i_ow.eq.1) qiow(ii) = 0.d0
c
c(5)
        else if( ib_xz(j+k,i).eq. 5  )   then
c(5)
c Adjust Pw TO account for change IN water density
c
              IF(i_ow.eq.1)then
                    call water_prop (roat(ii,1),wa,dww,visw)
c
                   head = (pat(ii,1) - pg_ref) / (grav*dww)
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   pa11(ii,1)   = pg_ref + grav*dww*head
              endif
        endif
c
   13     continue
   12   continue
                      jj = ney
   11 continue
c
c################################################
c 3 yz-planes
c################################################
c
          jj = 0
      do 21  i = 1, 2
        do 22  j = 0, nny*nez, nny
          do 23  k = 1, nny
c
c            global node number    
               ii = k + j*nnx + jj 
c
                   IF(i_ow.eq.1)then
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   else
                    call water_prop (0.d0,wa,dww,visw)
                   endif
       IF(i_og.eq.1) then
        call   gas_prop (rog11(ii,1),gg,dgg,visg)
       else
        call   gas_prop (0.d0,gg,dgg,visg)
       endif
c(1)
        if( ib_yz(j+k,i).eq. 1  )   then
c(1)
c no flow conditions
            pa11(ii,2)   = dww*grav* dcos(th_z)*dcos(th_y)
c
       if( dabs(dcos(th_z)*dcos(th_y)) .gt. epsil) then
             d_pc = -1.d+07
             call lev_sw_p (d_pc, dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,2)  = (rn_r-dww)*grav* dcos(th_z)*dcos(th_y)
     &                        /dpcnw(ii)
            st11(ii,2)  = (dgg-rn_r)*grav* dcos(th_z)*dcos(th_y)
     &                        /dpcgn(ii)
       endif
c
c(2)
        else if( ib_yz(j+k,i).eq. 2  )   then
c(2)
c          Pw = Pg - Pcgw
c          (Pw)y =  - Pcgw)y
c          (Pw)z =  - Pcgw)z
c          (Pw)yz =  - Pcgw)yz
c          update Pw and its tangential derivatives (1, 3, 4, 7)
c
cX**X  Adjust Pg to account for changes in Pc and gas density
              IF(i_og.eq.1) then
                  call   gas_prop (rogt(ii,1),gg,dgg,visg)
                     head = (pat(ii,1) - pg_ref) / (grav*dgg)
                  call   gas_prop (rog11(ii,1),gg,dgg,visg)
                     pa11(ii,1)   = grav*dgg*head + pg_ref
     &                            - pcnw1(ii) - pcgn1(ii)
              else
                  call   gas_prop (0.d0,gg,dgg,visg)
                  pa11(ii,1) = pat(ii,1) - (pcnw1(ii)+pcgn1(ii))
              endif
cX**X
c
            if(dabs(st11(ii,4)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,4)
             endif
             if(dabs(sw11(ii,4)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,4)
             endif
         pa11(ii,4) = dgg*grav*dcos(th_z)*dsin(th_y)-(pcnw + pcgn)
c
            if(dabs(st11(ii,3)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,3)
             endif
             if(dabs(sw11(ii,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,3)
             endif
            pa11(ii,3) = -dgg*grav*dsin(th_z) -(pcnw + pcgn)
c
            if(dabs(st11(ii,7)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,7)
             endif
             if(dabs(sw11(ii,7)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,7)
             endif
            pa11(ii,7) = -(pcnw + pcgn)
c
       if( dabs(dcos(th_z)*dcos(th_y)) .gt. epsil) then
             d_pc = -1.d+07
             call lev_sw_p (d_pc, dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,2)  = (rn_r-dww)*grav* dcos(th_z)*dcos(th_y)
     &                        /dpcnw(ii)
            st11(ii,2)  = (dgg-rn_r)*grav* dcos(th_z)*dcos(th_y)
     &                        /dpcgn(ii)
       endif
c no flow conditions
         qw(ii) = 0.d0
         qn(ii) = 0.d0
         qg(ii) = 0.d0
         IF(i_og.eq.1) qiog(ii) = 0.d0
         IF(i_ow.eq.1) qiow(ii) = 0.d0
c(3)
        else if( ib_yz(j+k,i).eq. 3  )   then
c(3)
c          Pw = Pn - Pcnw
c          (Pw)y =  - Pcnw)y
c          (Pw)z =  - Pcnw)z
c          (Pw)yz =  - Pcnw)yz
c          update Pw and its tangential derivatives (1, 3, 4, 7)
c
         pa11(ii,1) = pat(ii,1) - pcnw1(ii)
c
             if(dabs(sw11(ii,4)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,4)
             endif
         pa11(ii,4) = rn_r*grav*dcos(th_z)*dsin(th_y) - pcnw
c
             if(dabs(sw11(ii,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,3)
             endif
            pa11(ii,3) = -rn_r*grav*dsin(th_z) - pcnw
c
             if(dabs(sw11(ii,7)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,7)
             endif
         pa11(ii,7) = - pcnw 
c
       if( dabs(dcos(th_z)*dcos(th_y)) .gt. epsil) then
             d_pc = -1.d+07
             call lev_sw_p (d_pc, dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,2)  = (rn_r-dww)*grav* dcos(th_z)*dcos(th_y)
     &                        /dpcnw(ii)
            st11(ii,2)  = (dgg-rn_r)*grav* dcos(th_z)*dcos(th_y)
     &                        /dpcgn(ii)
       endif
c no flow conditions
         qw(ii) = 0.d0
         qn(ii) = 0.d0
         qg(ii) = 0.d0
         IF(i_og.eq.1) qiog(ii) = 0.d0
         IF(i_ow.eq.1) qiow(ii) = 0.d0
c
c(4)
        else if( ib_yz(j+k,i).eq. 4  )   then
c(4)
cX**X Adjust Pw TO account for change IN water density
c
              IF(i_ow.eq.1)then
                    call water_prop (roat(ii,1),wa,dww,visw)
c
                   head = (pat(ii,1) - pg_ref) / (grav*dww)
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   pa11(ii,1)   = pg_ref + grav*dww*head
              else
c                   Pw = Pw
                    call water_prop (0.d0,wa,dww,visw)
              endif
cX**X
       if( dabs(dcos(th_z)*dcos(th_y)) .gt. epsil) then
             d_pc = -1.d+07
             call lev_sw_p (d_pc, dpcnw(ii) )
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,2)  = (rn_r-dww)*grav* dcos(th_z)*dcos(th_y)
     &                        /dpcnw(ii)
            st11(ii,2)  = (dgg-rn_r)*grav* dcos(th_z)*dcos(th_y)
     &                        /dpcgn(ii)
       endif
c no flow conditions
         qw(ii) = 0.d0
         qn(ii) = 0.d0
         qg(ii) = 0.d0
         IF(i_og.eq.1) qiog(ii) = 0.d0
         IF(i_ow.eq.1) qiow(ii) = 0.d0
c
c(5)
        else if( ib_yz(j+k,i).eq. 5  )   then
c(5)
c Adjust Pw TO account for change IN water density
c
              IF(i_ow.eq.1)then
                    call water_prop (roat(ii,1),wa,dww,visw)
c
                   head = (pat(ii,1) - pg_ref) / (grav*dww)
                    call water_prop (roa11(ii,1),wa,dww,visw)
                   pa11(ii,1)   = pg_ref + grav*dww*head
              endif
        endif
c
   23     continue
   22   continue
                      jj = nny*nex
   21 continue
c
              			return
         			end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
           subroutine pr_bc
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c     For Pg and Pn Dirichlet data 
c
c convert Vt into appropriate Q for flow BC's 2, 3, 4
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c DEFINE BC'S FOR THE SATURATION EQUATIONS AFTER Pw SOLUTION
c     For Pg and Pn Dirichlet data set the following:
c
c Pg:  qg = normal cpt. of Vt * area
c Pn:  qn = normal cpt. of Vt * area
c
        include 'include.f'
c---
cwrite       if (iscr.eq.1) then
cwrite       write(6,*) 'FLUX CONVERSION for BCs 2, 3, 4 (node, qw, qn, qg)'
cwrite       endif
c*********************************************************
c DO THE PLANES 
c*********************************************************
c
c 1 yx-planes
c
          jj = 0
      do 1  i = 1, 2
        do 2  j = 0, nny*nex, nny
          do 3  k = 1, nny
c
c            global node number    
               ii = jj + j + k        
c
c(2)
        if( ib_yx(j+k,i).eq. 2  )   then
c(2)
c Pg condition applied to a yx-plane (z-normal)
           if(i.eq.1)  then
                  qg(ii) = vtz(ii) / dz(1)*2.d0
                  ds = dz(1)/2.d0
           else
                  qg(ii) = -vtz(ii) / dz(nez)*2.d0
                  ds = dz(nez)/2.d0
           endif
              vtz(ii) = 0.d0
              vwz(ii) = 0.d0
              vgz(ii) = 0.d0
c
       if(qg(ii) .lt. -1.d-10)  then
c        outflow condition, 
c        adjust rate based on phase mobilities at node
          qt = qg(ii)
         call qout_adj (qt, ii)
       endif
c
       if (iscr.eq.1) then
             if(k.eq.1) then
                   dss = dy(1)/2.d0
             else if(k.eq.nny) then
                   dss = dy(ney)/2.d0
             else
                   dss = (dy(k-1)+dy(k))/2.d0
             endif
             if(j/nny+1.eq.1) then
                   dsss = dx(1)/2.d0
             else if(j/nny.eq.nex) then
                   dsss = dx(nex)/2.d0
             else
                   dsss = (dx(j/nny)+dx(j/nny+1))/2.d0
             endif
         v_w = qw(ii)*ds*dss*dsss
         v_n = qn(ii)*ds*dss*dsss
         v_g = qg(ii)*ds*dss*dsss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
c(3)
        else if( ib_yx(j+k,i).eq. 3  )   then
c(3)
c Pn condition applied to a yx-plane (z-normal)
           if(i.eq.1)  then
                  qn(ii) = vtz(ii) / dz(1)*2.d0
                  ds = dz(1)/2.d0
           else
                  qn(ii) = -vtz(ii) / dz(nez)*2.d0
                  ds = dz(nez)/2.d0
           endif
              vtz(ii) = 0.d0
              vwz(ii) = 0.d0
              vgz(ii) = 0.d0
c
       if(qn(ii) .lt. -1.d-10)  then
c        outflow condition, 
c        adjust rate based on phase mobilities at node
          qt = qn(ii)
         call qout_adj (qt, ii)
       endif
c
       if (iscr.eq.1) then
             if(k.eq.1) then
                   dss = dy(1)/2.d0
             else if(k.eq.nny) then
                   dss = dy(ney)/2.d0
             else
                   dss = (dy(k-1)+dy(k))/2.d0
             endif
             if(j/nny+1.eq.1) then
                   dsss = dx(1)/2.d0
             else if(j/nny.eq.nex) then
                   dsss = dx(nex)/2.d0
             else
                   dsss = (dx(j/nny)+dx(j/nny+1))/2.d0
             endif
         v_w = qw(ii)*ds*dss*dsss
         v_n = qn(ii)*ds*dss*dsss
         v_g = qg(ii)*ds*dss*dsss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
c(4)
        else if( ib_yx(j+k,i).eq. 4  )   then
c(4)
c Pw condition applied to a yx-plane (z-normal)
           if(i.eq.1)  then
                  qw(ii) = vtz(ii) / dz(1)*2.d0
                  ds = dz(1)/2.d0
           else
                  qw(ii) = -vtz(ii) / dz(nez)*2.d0
                  ds = dz(nez)/2.d0
           endif
              vtz(ii) = 0.d0
              vwz(ii) = 0.d0
              vgz(ii) = 0.d0
c
             if(qw(ii) .lt. -1.d-10)  then
c              outflow condition, 
c              adjust rate based on phase mobilities at node
                   qt = qw(ii)
                  call qout_adj (qt, ii)
             endif
c
       if (iscr.eq.1) then
             if(k.eq.1) then
                   dss = dy(1)/2.d0
             else if(k.eq.nny) then
                   dss = dy(ney)/2.d0
             else
                   dss = (dy(k-1)+dy(k))/2.d0
             endif
             if(j/nny+1.eq.1) then
                   dsss = dx(1)/2.d0
             else if(j/nny.eq.nex) then
                   dsss = dx(nex)/2.d0
             else
                   dsss = (dx(j/nny)+dx(j/nny+1))/2.d0
             endif
         v_w = qw(ii)*ds*dss*dsss
         v_n = qn(ii)*ds*dss*dsss
         v_g = qg(ii)*ds*dss*dsss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
        endif
c
    3     continue
    2   continue
                      jj = nnx*nny*nez
    1 continue
c
c################################################
c 2 xz-planes
c################################################
          jj = 0
      do 11  i = 1, 2
        do 12  j = 0, nnx*nez, nnx
          do 13  k = 1, nnx
c
c            global node number    
               ii = (k-1)*nny + j*nny + jj + 1
c
c(2)
        if( ib_xz(j+k,i).eq. 2  )   then
c(2)
c Pg condition applied to a xz-plane (y-normal)
           if(i.eq.1)  then
                  qg(ii) = vty(ii) / dy(1)*2.d0
                  ds = dy(1)/2.d0
           else
                  qg(ii) = -vty(ii) / dy(ney)*2.d0
                  ds = dy(ney)/2.d0
           endif
              vty(ii) = 0.d0
              vwy(ii) = 0.d0
              vgy(ii) = 0.d0
c
       if(qg(ii) .lt. -1.d-10)  then
c        outflow condition, 
c        adjust rate based on phase mobilities at node
                   qt = qg(ii)
                  call qout_adj (qt, ii)
       endif
       if (iscr.eq.1) then
             if(k.eq.1) then
                   dss = dx(1)/2.d0
             else if(k.eq.nnx) then
                   dss = dx(nex)/2.d0
             else
                   dss = (dx(k-1)+dx(k))/2.d0
             endif
             if(j/nnx+1.eq.1) then
                   dsss = dz(1)/2.d0
             else if(j/nnx.eq.nez) then
                   dsss = dz(nez)/2.d0
             else
                   dsss = (dz(j/nnx)+dz(j/nnx+1))/2.d0
             endif
         v_w = qw(ii)*ds*dss*dsss
         v_n = qn(ii)*ds*dss*dsss
         v_g = qg(ii)*ds*dss*dsss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
c(3)
        else if( ib_xz(j+k,i).eq. 3  )   then
c(3)
c Pn condition applied to a xz-plane (y-normal)
           if(i.eq.1)  then
                  qn(ii) = vty(ii) / dy(1)*2.d0
                  ds = dy(1)/2.d0
           else
                  qn(ii) = -vty(ii) / dy(ney)*2.d0
                  ds = dy(ney)/2.d0
           endif
              vty(ii) = 0.d0
              vwy(ii) = 0.d0
              vgy(ii) = 0.d0
c
       if(qn(ii) .lt. -1.d-10)  then
c        outflow condition, 
c        adjust rate based on phase mobilities at node
                   qt = qn(ii)
                  call qout_adj (qt, ii)
       endif
       if (iscr.eq.1) then
             if(k.eq.1) then
                   dss = dx(1)/2.d0
             else if(k.eq.nnx) then
                   dss = dx(nex)/2.d0
             else
                   dss = (dx(k-1)+dx(k))/2.d0
             endif
             if(j/nnx+1.eq.1) then
                   dsss = dz(1)/2.d0
             else if(j/nnx.eq.nez) then
                   dsss = dz(nez)/2.d0
             else
                   dsss = (dz(j/nnx)+dz(j/nnx+1))/2.d0
             endif
         v_w = qw(ii)*ds*dss*dsss
         v_n = qn(ii)*ds*dss*dsss
         v_g = qg(ii)*ds*dss*dsss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
c(4)
        else if( ib_xz(j+k,i).eq. 4  )   then
c(4)
c Pw condition applied to a xz-plane (y-normal)
           if(i.eq.1)  then
                  qw(ii) = vty(ii) / dy(1)*2.d0
                  ds = dy(1)/2.d0
           else
                  qw(ii) = -vty(ii) / dy(ney)*2.d0
                  ds = dy(ney)/2.d0
           endif
              vty(ii) = 0.d0
              vwy(ii) = 0.d0
              vgy(ii) = 0.d0
c
             if(qw(ii) .lt. -1.d-10)  then
c              outflow condition, 
c              adjust rate based on phase mobilities at node
                   qt = qw(ii)
                  call qout_adj (qt, ii)
             endif
c
       if (iscr.eq.1) then
             if(k.eq.1) then
                   dss = dx(1)/2.d0
             else if(k.eq.nnx) then
                   dss = dx(nex)/2.d0
             else
                   dss = (dx(k-1)+dx(k))/2.d0
             endif
             if(j/nnx+1.eq.1) then
                   dsss = dz(1)/2.d0
             else if(j/nnx.eq.nez) then
                   dsss = dz(nez)/2.d0
             else
                   dsss = (dz(j/nnx)+dz(j/nnx+1))/2.d0
             endif
         v_w = qw(ii)*ds*dss*dsss
         v_n = qn(ii)*ds*dss*dsss
         v_g = qg(ii)*ds*dss*dsss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
        endif
c
   13     continue
   12   continue
                      jj = ney
   11 continue
c
c################################################
c 3 yz-planes
c################################################
c
          jj = 0
      do 21  i = 1, 2
        do 22  j = 0, nny*nez, nny
          do 23  k = 1, nny
c
c            global node number    
               ii = k + j*nnx + jj 
c
c(2)
        if( ib_yz(j+k,i).eq. 2  )   then
c(2)
c Pg condition applied to a yz-plane (x-normal)
           if(i.eq.1)  then
                  qg(ii) = vtx(ii) / dx(1)*2.d0
                  ds = dx(1)/2.d0
           else
                  qg(ii) = -vtx(ii) / dx(nex)*2.d0
                  ds = dx(nex)/2.d0
           endif
              vtx(ii) = 0.d0
              vwx(ii) = 0.d0
              vgx(ii) = 0.d0
c
       if(qg(ii) .lt. -1.d-10)  then
c        outflow condition, 
c        adjust rate based on phase mobilities at node
                   qt = qg(ii)
                  call qout_adj (qt, ii)
       endif
       if (iscr.eq.1) then
             if(k.eq.1) then
                   dss = dy(1)/2.d0
             else if(k.eq.nny) then
                   dss = dy(ney)/2.d0
             else
                   dss = (dy(k-1)+dy(k))/2.d0
             endif
             if(j/nny+1.eq.1) then
                   dsss = dz(1)/2.d0
             else if(j/nny.eq.nez) then
                   dsss = dz(nez)/2.d0
             else
                   dsss = (dz(j/nny)+dz(j/nny+1))/2.d0
             endif
         v_w = qw(ii)*ds*dss*dsss
         v_n = qn(ii)*ds*dss*dsss
         v_g = qg(ii)*ds*dss*dsss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
c(3)
        else if( ib_yz(j+k,i).eq. 3  )   then
c(3)
c Pn condition applied to a yz-plane (x-normal)
           if(i.eq.1)  then
                  qn(ii) = vtx(ii) / dx(1)*2.d0
                  ds = dx(1)/2.d0
           else
                  qn(ii) = -vtx(ii) / dx(nex)*2.d0
                  ds = dx(nex)/2.d0
           endif
              vtx(ii) = 0.d0
              vwx(ii) = 0.d0
              vgx(ii) = 0.d0
c
       if(qn(ii) .lt. -1.d-10)  then
c        outflow condition, 
c        adjust rate based on phase mobilities at node
                   qt = qn(ii)
                  call qout_adj (qt, ii)
       endif
       if (iscr.eq.1) then
             if(k.eq.1) then
                   dss = dy(1)/2.d0
             else if(k.eq.nny) then
                   dss = dy(ney)/2.d0
             else
                   dss = (dy(k-1)+dy(k))/2.d0
             endif
             if(j/nny+1.eq.1) then
                   dsss = dz(1)/2.d0
             else if(j/nny.eq.nez) then
                   dsss = dz(nez)/2.d0
             else
                   dsss = (dz(j/nny)+dz(j/nny+1))/2.d0
             endif
         v_w = qw(ii)*ds*dss*dsss
         v_n = qn(ii)*ds*dss*dsss
         v_g = qg(ii)*ds*dss*dsss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
c(4)
        else if( ib_yz(j+k,i).eq. 4  )   then
c(4)
c Pw condition applied to a yz-plane (x-normal)
           if(i.eq.1)  then
                  qw(ii) = vtx(ii) / dx(1)*2.d0
                  ds = dx(1)/2.d0
           else
                  qw(ii) = -vtx(ii) / dx(nex)*2.d0
                  ds = dx(nex)/2.d0
           endif
              vtx(ii) = 0.d0
              vwx(ii) = 0.d0
              vgx(ii) = 0.d0
c
             if(qw(ii) .lt. -1.d-10)  then
c              outflow condition, 
c              adjust rate based on phase mobilities at node
                   qt = qw(ii)
                  call qout_adj (qt, ii)
             endif
       if (iscr.eq.1) then
             if(k.eq.1) then
                   dss = dy(1)/2.d0
             else if(k.eq.nny) then
                   dss = dy(ney)/2.d0
             else
                   dss = (dy(k-1)+dy(k))/2.d0
             endif
             if(j/nny+1.eq.1) then
                   dsss = dz(1)/2.d0
             else if(j/nny.eq.nez) then
                   dsss = dz(nez)/2.d0
             else
                   dsss = (dz(j/nny)+dz(j/nny+1))/2.d0
             endif
         v_w = qw(ii)*ds*dss*dsss
         v_n = qn(ii)*ds*dss*dsss
         v_g = qg(ii)*ds*dss*dsss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
        endif
c
   23     continue
   22   continue
                      jj = nny*nex
   21 continue
c
  111  format(i5,2x,1pe12.4,2x,1pe12.4,2x,1pe12.4)
              			return
         			end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
           subroutine pr_save
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c at the begining of the time step 
c save pressure conditions for flow bc's 2 and 3
c    ( save the Pg and Pn bc's in Pw at time level 'n')
cX**c save pressure conditions for flow bc's 4 and 5
c to account for change in concentration
c
        include 'include.f'
c---
c*********************************************************
c DO THE PLANES 
c*********************************************************
c
c 1 yx-planes
c
          jj = 0
      do 1  i = 1, 2
        do 2  j = 0, nny*nex, nny
          do 3  k = 1, nny
c
c            global node number    
               ii = jj + j + k        
c
c(2)
        if( ib_yx(j+k,i).eq. 2  )   then
c(2)
c Pg condition
            pat(ii,1) = pa11(ii,1) + pcnw1(ii) + pcgn1(ii)
c
c(3)
        else if( ib_yx(j+k,i).eq. 3  )   then
c(3)
c Pn condition
            pat(ii,1) = pa11(ii,1) + pcnw1(ii)
cX**
c(4)
        else if( ib_yx(j+k,i).eq. 4  )   then
c(4)
c Pn condition
            pat(ii,1) = pa11(ii,1)
c
c(5)
        else if( ib_yx(j+k,i).eq. 5  )   then
c(5)
c Pn condition
            pat(ii,1) = pa11(ii,1)
cX**
        endif
c
    3     continue
    2   continue
                      jj = nnx*nny*nez
    1 continue
c
c################################################
c 2 xz-planes
c################################################
          jj = 0
      do 11  i = 1, 2
        do 12  j = 0, nnx*nez, nnx
          do 13  k = 1, nnx
c
c            global node number    
               ii = (k-1)*nny + j*nny + jj + 1
c
c(2)
        if( ib_xz(j+k,i).eq. 2  )   then
c(2)
c Pg condition
            pat(ii,1) = pa11(ii,1) + pcnw1(ii) + pcgn1(ii)
c
c(3)
        else if( ib_xz(j+k,i).eq. 3  )   then
c(3)
c Pn condition
            pat(ii,1) = pa11(ii,1) + pcnw1(ii)
c
cX**
c(4)
        else if( ib_xz(j+k,i).eq. 4  )   then
c(4)
c Pn condition
            pat(ii,1) = pa11(ii,1)
c
c(5)
        else if( ib_xz(j+k,i).eq. 5  )   then
c(5)
c Pn condition
            pat(ii,1) = pa11(ii,1)
cX**
        endif
c
   13     continue
   12   continue
                      jj = ney
   11 continue
c
c################################################
c 3 yz-planes
c################################################
c
          jj = 0
      do 21  i = 1, 2
        do 22  j = 0, nny*nez, nny
          do 23  k = 1, nny
c
c            global node number    
               ii = k + j*nnx + jj 
c
c(2)
        if( ib_yz(j+k,i).eq. 2  )   then
c(2)
c Pg condition
            pat(ii,1) = pa11(ii,1) + pcnw1(ii) + pcgn1(ii)
c
c(3)
        else if( ib_yz(j+k,i).eq. 3  )   then
c(3)
c Pn condition
            pat(ii,1) = pa11(ii,1) + pcnw1(ii)
c
cX**
c(4)
        else if( ib_yz(j+k,i).eq. 4  )   then
c(4)
c Pn condition
            pat(ii,1) = pa11(ii,1)
c
c(5)
        else if( ib_yz(j+k,i).eq. 5  )   then
c(5)
c Pn condition
            pat(ii,1) = pa11(ii,1)
cX**
        endif
c
   23     continue
   22   continue
                      jj = nny*nex
   21 continue
c
              			return
         			end
c########################################################
           subroutine no_flow
c########################################################
c
c For no flow BC's set the dpc slope to a very high value
c to mimic a LINEAR no-flow condition
c
        include 'include.f'
c
c 2 yx-planes
       if( dabs(dcos(th_z)*dsin(th_y)) .gt. epsil) then
c
          jj = 0
c
           do 1  i = 1, 2
             do 2  j = 0, nny*nex, nny
               do 3  k = 1, nny
c
                 if (ib_yx(j+k,i) .ne. 5)  then
c
c                 global node number    
                    ii = jj + j + k        
c
                     call lev_sw_p (-1.d+07, dpcnw(ii) )
                     call lev_st_p (-1.d+07, dpcgn(ii) )
c
                 endif
c
    3          continue
    2        continue
                      jj = nnx*nny*nez
    1      continue
      endif
c
c 2 xz-planes
       if( dabs(dsin(th_z))            .gt. epsil) then
c
               jj = 0
           do 11  i = 1, 2
             do 12  j = 0, nnx*nez, nnx
               do 13  k = 1, nnx
                 if (ib_xz(j+k,i) .ne. 5)  then
c
c                 global node number    
                    ii = (k-1)*nny + j*nny + jj + 1
c
                     call lev_sw_p (-1.d+07, dpcnw(ii) )
                     call lev_st_p (-1.d+07, dpcgn(ii) )
                 endif
c
   13          continue
   12        continue
                      jj = ney
   11      continue
      endif
c
c 2 yz-planes
       if( dabs(dcos(th_z)*dcos(th_y)) .gt. epsil) then
c
               jj = 0
           do 21  i = 1, 2
             do 22  j = 0, nny*nez, nny
               do 23  k = 1, nny
                 if (ib_yz(j+k,i) .ne. 5)  then
c
c                 global node number    
                    ii = k + j*nnx + jj 
                     call lev_sw_p (-1.d+07, dpcnw(ii) )
                     call lev_st_p (-1.d+07, dpcgn(ii) )
                 endif
c
   23          continue
   22        continue
                      jj = nny*nex
   21      continue
      endif
c
              			return
         			end
