C     Last change:  JG   30 Aug 2000    2:23 pm
c SUBROUTINES IN THIS FILE:
c subroutine df_num_p - Define degree of freedom numbering for Pw
c subroutine df_num_s - Define degree of freedom numbering for Sw/St
c subroutine df_num_oa - Define degree of freedom numbering for Roa  
c subroutine df_num_og - Define degree of freedom numbering for Rog  
c subroutine number - number the degrees of freedom for the system of
c                   equations using tensor product ordering
c subroutine offset_ - Define offset vector for the SLAP column format
c                     vector j_offset - defined by the grid 
c                     geometry and df/eq numbering
c subroutine locat - generate the location vector for GMRES
c                        sweep in the shortest direction
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c       Define degree of freedom numbering for 
c       each dependent variable, for each subdomain
c       based on subdomain dimension and boundary data
c
c here the following vctors are defined:
c  ibc_p     (Pw)
c  ibc_s    (Sw and St)
c  ibc_oa    (Roa)
c
c force Dirichlet conditions on the interface(s) of this subdomain 
c nn_sub_y = number of nodes in the y dimension of the subdomains
c nn_sub_x = number of nodes in the x dimension of the subdomains
c nn_sub_z = number of nodes in the z dimension of the subdomains
c 
c in setting the vector ibc_ :
c a zero indicates that the df is a bc
c all non bc df's are given a number indicating the row
c in the system of equations it belongs
c
c the numbering of ibc is in shortest direction first (as per ixyz)
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c PRESSURE SOLUTION
      subroutine df_num_p (mnode_s,mnd_ixz,mnd_iyz,mnd_iyx,
     &                     npt_s,ibc,ib_yx,ib_yz,ib_xz,
     &                     ixyz,nnx,nny,
     &                     nn_sub_y, nn_sub_x, nn_sub_z, nn_sub)
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
       parameter ( i_df2 = 8)
       parameter ( iside = 2)
       parameter ( ndir = 6)
       integer mnode_s,mnd_ixz,mnd_iyz,mnd_iyx,
     &         ixyz,nnx,nny,nn_sub_y, nn_sub_x, nn_sub_z, nn_sub
       integer npt_s(mnode_s,ndir),ibc(mnode_s,i_df2),
     &              ib_yx(mnd_iyx,iside), ib_yz(mnd_iyz,iside),
     &              ib_xz(mnd_ixz,iside)
c
c
c PROCEDURE 
c construct boundary nodes of ibc by:
c 1. initialize all bdy df's to 9
c 2. look at each face separately and mark the proper condition 
c    normal to that face with a  0
c 3. then loop through and give all 9 df's the proper number
c
c
c initialize ibc = 9
       do 101 j = 1, 8 
         do 100 i = 1, nn_sub
             ibc(i,j) = 9
  100    continue
  101  continue
c
c 1. negative yx face 
c        the boundary plane on the negative-yx side is natural 
c
              j = 0
              m = 0
c
          do 15 i = 1, nn_sub_x
            do 16 k = 1, nn_sub_y
c
                nod = npt_s(k+m,3)
c
                if( ib_yx(j+k,1).ne.1)  then
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,2) = 0
                          ibc(nod,3) = 0
                          ibc(nod,5) = 0
                else
c                  this node is a Neumann node
                          ibc(nod,4) = 0
                          ibc(nod,6) = 0
                          ibc(nod,7) = 0
                          ibc(nod,8) = 0
                endif 
   16      continue
              j = j + nny
              m = m + nn_sub_y
   15    continue
c
c
c 2. positive yx face 
c        the boundary plane on the positive-yx side is natural 
c
              j = 0
              m = nn_sub_y*nn_sub_x*(nn_sub_z-1)
c
          do 25 i = 1, nn_sub_x
            do 26 k = 1, nn_sub_y
c
                nod = npt_s(k+m,3)
                if( ib_yx(j+k,2).ne.1)  then
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,2) = 0
                          ibc(nod,3) = 0
                          ibc(nod,5) = 0
                else
c                  this node is a Neumann node
                          ibc(nod,4) = 0
                          ibc(nod,6) = 0
                          ibc(nod,7) = 0
                          ibc(nod,8) = 0
                endif 
   26      continue
c
              j = j + nny
              m = m + nn_sub_y
c
   25    continue
c
c
c 3. negative yz face 
c        the boundary plane on the negative-yz side is natural 
c
              j = 0
              m = 0
c
          do 35 i = 1, nn_sub_z
            do 36 k = 1, nn_sub_y
c
                nod = npt_s(k+m,4)
                if( ib_yz(j+k,1).ne.1)  then
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,3) = 0
                          ibc(nod,4) = 0
                          ibc(nod,7) = 0
                else
c                  this node is a Neumann node
                          ibc(nod,2) = 0
                          ibc(nod,5) = 0
                          ibc(nod,6) = 0
                          ibc(nod,8) = 0
                endif 
   36      continue
c
              j = j + nny
              m = m + nn_sub_y
c
   35    continue
c
c
c 4. positive yz face 
c        the boundary plane on the positive-yz side is natural 
c
              j = 0
              m = nn_sub_y*nn_sub_z*(nn_sub_x-1)
c
          do 45 i = 1, nn_sub_z
            do 46 k = 1, nn_sub_y
c
                nod = npt_s(k+m,4)
                if( ib_yz(j+k,2).ne.1)  then
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,3) = 0
                          ibc(nod,4) = 0
                          ibc(nod,7) = 0
                else
c                  this node is a Neumann node
                          ibc(nod,2) = 0
                          ibc(nod,5) = 0
                          ibc(nod,6) = 0
                          ibc(nod,8) = 0
                endif 
   46      continue
c
              j = j + nny
              m = m + nn_sub_y
c
   45    continue
c
c 5. negative xz face 
c        the boundary plane on the negative-xz side is natural 
c
              j = 0
              m = 0
c
          do 55 i = 1, nn_sub_z
            do 56 k = 1, nn_sub_x
c
                  nod = npt_s(k+m,2)
                if( ib_xz(j+k,1).ne.1)  then
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,2) = 0
                          ibc(nod,4) = 0
                          ibc(nod,6) = 0
                else
c                  this node is a Neumann node
                          ibc(nod,3) = 0
                          ibc(nod,5) = 0
                          ibc(nod,7) = 0
                          ibc(nod,8) = 0
                endif 
   56      continue
c
              j = j + nnx
              m = m + nn_sub_x 
c
   55    continue
c
c 6. positive xz face 
c        the boundary plane on the positive-xz side is natural 
c
              j = 0
              m = nn_sub_x*nn_sub_z*(nn_sub_y-1)
c
          do 65 i = 1, nn_sub_z
            do 66 k = 1, nn_sub_x
c
                 nod = npt_s(k+m,2)
                if( ib_xz(j+k,2).ne.1)  then
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,2) = 0
                          ibc(nod,4) = 0
                          ibc(nod,6) = 0
                else
c                  this node is a Neumann node
                          ibc(nod,3) = 0
                          ibc(nod,5) = 0
                          ibc(nod,7) = 0
                          ibc(nod,8) = 0
                endif 
   66      continue
c
              j = j + nnx
              m = m + nn_sub_x 
c
   65    continue
c
c number the degrees of freedom for the system of equations
c ordering of unknowns depends on solution strategy:
c  iterative - use tensor product ordering
c-----------------------------------------------------------------
        call number (mnode_s,8,ibc,
     &                     ixyz,nn_sub_y, nn_sub_x, nn_sub_z)
c-----------------------------------------------------------------
c
                        return 
                        end
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c SATURATION SOLUTION
      subroutine df_num_s (mnode_s,mnd_ixz,mnd_iyz,mnd_iyx,
     &                     npt_s,ibc,ib_yx,ib_yz,ib_xz,
     &                     ixyz,nnx,nny,
     &                     nn_sub_y, nn_sub_x, nn_sub_z, nn_sub)
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
       parameter ( i_df2 = 8)
       parameter ( iside = 2)
       parameter ( ndir = 6)
       integer mnode_s,mnd_ixz,mnd_iyz,mnd_iyx,
     &         ixyz,nnx,nny,nn_sub_y, nn_sub_x, nn_sub_z, nn_sub
       integer npt_s(mnode_s,ndir),ibc(mnode_s,i_df2),
     &              ib_yx(mnd_iyx,iside), ib_yz(mnd_iyz,iside),
     &              ib_xz(mnd_ixz,iside)
c
c
c PROCEDURE 
c construct boundary nodes of ibc by:
c 1. initialize all bdy df's to 9
c 2. look at each face separately and mark the proper condition 
c    normal to that face with a  0
c 3. then loop through and give all 9 df's the proper number
c
c
c initialize ibc = 9
       do 101 j = 1, 8 
         do 100 i = 1, nn_sub
             ibc(i,j) = 9
  100    continue
  101  continue
c
c 1. negative yx face 
c        the boundary plane on the negative-yx side is natural 
c
              j = 0
              m = 0
c
          do 15 i = 1, nn_sub_x
            do 16 k = 1, nn_sub_y
c
                nod = npt_s(k+m,3)
c
                if( ib_yx(j+k,1).ne.5)  then
c                  this node is a Neumann node
                          ibc(nod,4) = 0
                          ibc(nod,6) = 0
                          ibc(nod,7) = 0
                          ibc(nod,8) = 0
                else
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,2) = 0
                          ibc(nod,3) = 0
                          ibc(nod,5) = 0
                endif 
   16      continue
              j = j + nny
              m = m + nn_sub_y
   15    continue
c
c 2. positive yx face 
c        the boundary plane on the positive-yx side is natural 
c
              j = 0
              m = nn_sub_y*nn_sub_x*(nn_sub_z-1)
c
          do 25 i = 1, nn_sub_x
            do 26 k = 1, nn_sub_y
c
                nod = npt_s(k+m,3)
                if( ib_yx(j+k,2).ne.5)  then
c                  this node is a Neumann node
                          ibc(nod,4) = 0
                          ibc(nod,6) = 0
                          ibc(nod,7) = 0
                          ibc(nod,8) = 0
                else
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,2) = 0
                          ibc(nod,3) = 0
                          ibc(nod,5) = 0
                endif 
   26      continue
c
              j = j + nny
              m = m + nn_sub_y
c
   25    continue
c
c
c 3. negative yz face 
c        the boundary plane on the negative-yz side is natural 
c
              j = 0
              m = 0
c
          do 35 i = 1, nn_sub_z
            do 36 k = 1, nn_sub_y
c
                nod = npt_s(k+m,4)
                if( ib_yz(j+k,1).ne.5)  then
c                  this node is a Neumann node
                          ibc(nod,2) = 0
                          ibc(nod,5) = 0
                          ibc(nod,6) = 0
                          ibc(nod,8) = 0
                else
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,3) = 0
                          ibc(nod,4) = 0
                          ibc(nod,7) = 0
                endif 
   36      continue
c
              j = j + nny
              m = m + nn_sub_y
c
   35    continue
c
c
c 4. positive yz face 
c        the boundary plane on the positive-yz side is natural 
c
              j = 0
              m = nn_sub_y*nn_sub_z*(nn_sub_x-1)
c
          do 45 i = 1, nn_sub_z
            do 46 k = 1, nn_sub_y
c
                nod = npt_s(k+m,4)
                if( ib_yz(j+k,2).ne.5)  then
c                  this node is a Neumann node
                          ibc(nod,2) = 0
                          ibc(nod,5) = 0
                          ibc(nod,6) = 0
                          ibc(nod,8) = 0
                else
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,3) = 0
                          ibc(nod,4) = 0
                          ibc(nod,7) = 0
                endif 
   46      continue
c
              j = j + nny
              m = m + nn_sub_y
c
   45    continue
c
c
c 5. negative xz face 
c        the boundary plane on the negative-xz side is natural 
c
              j = 0
              m = 0
c
          do 55 i = 1, nn_sub_z
            do 56 k = 1, nn_sub_x
c
                  nod = npt_s(k+m,2)
                if( ib_xz(j+k,1).ne.5)  then
c                  this node is a Neumann node
                          ibc(nod,3) = 0
                          ibc(nod,5) = 0
                          ibc(nod,7) = 0
                          ibc(nod,8) = 0
                else
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,2) = 0
                          ibc(nod,4) = 0
                          ibc(nod,6) = 0
                endif 
   56      continue
c
              j = j + nnx
              m = m + nn_sub_x 
c
   55    continue
c
c
c 6. positive xz face 
c        the boundary plane on the positive-xz side is natural 
c
              j = 0
              m = nn_sub_x*nn_sub_z*(nn_sub_y-1)
c
          do 65 i = 1, nn_sub_z
            do 66 k = 1, nn_sub_x
c
                 nod = npt_s(k+m,2)
                if( ib_xz(j+k,2).ne.5)  then
c                  this node is a Neumann node
                          ibc(nod,3) = 0
                          ibc(nod,5) = 0
                          ibc(nod,7) = 0
                          ibc(nod,8) = 0
                else
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,2) = 0
                          ibc(nod,4) = 0
                          ibc(nod,6) = 0
                endif 
   66      continue
c
              j = j + nnx
              m = m + nn_sub_x 
c
   65    continue
c
c
c number the degrees of freedom for the system of equations
c ordering of unknowns depends on solution strategy:
c  direct - use natural ordering
c  iterative - use tensor product ordering
c-----------------------------------------------------------------
        call number (mnode_s,8,ibc,
     &                     ixyz,nn_sub_y, nn_sub_x, nn_sub_z)
c-----------------------------------------------------------------
c
                        return 
                        end
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c CONCENTRATION SOLUTION
c
      subroutine df_num_t (mnode_s,mnode_t,mnd_ixz,mnd_iyz,mnd_iyx,
     &                     npt_s,ibc,iboa_yx,iboa_yz,iboa_xz,
     &                     ixyz,nnx,nny,
     &                     nn_sub_y, nn_sub_x, nn_sub_z, nn_sub)
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
       parameter ( i_df2 = 8)
       parameter ( iside = 2)
       parameter ( ndir = 6)
       integer mnode_s,mnd_ixz,mnd_iyz,mnd_iyx,
     &         ixyz,nnx,nny,nn_sub_y, nn_sub_x, nn_sub_z, nn_sub
       integer npt_s(mnode_s,ndir),ibc(mnode_t,i_df2),
     &              iboa_yx(mnd_iyx,iside), iboa_yz(mnd_iyz,iside),
     &              iboa_xz(mnd_ixz,iside)
c
c PROCEDURE 
c construct boundary nodes of ibc by:
c 1. initialize all bdy df's to 9
c 2. look at each face separately and mark the proper condition 
c    normal to that face with a  0
c 3. then loop through and give all 9 df's the proper number
c
c
c initialize ibc = 9
       do 101 j = 1, 8 
         do 100 i = 1, nn_sub
             ibc(i,j) = 9
  100    continue
  101  continue
c
c 1. negative yx face 
c        the boundary plane on the negative-yx side is natural 
c
              j = 0
              m = 0
c
          do 15 i = 1, nn_sub_x
            do 16 k = 1, nn_sub_y
c
                nod = npt_s(k+m,3)
c
                if(iboa_yx(j+k,1).eq.1)  then
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,2) = 0
                          ibc(nod,3) = 0
                          ibc(nod,5) = 0
                else
c                  this node is a Neumann node
                          ibc(nod,4) = 0
                          ibc(nod,6) = 0
                          ibc(nod,7) = 0
                          ibc(nod,8) = 0
                endif 
   16      continue
              j = j + nny
              m = m + nn_sub_y
   15    continue
c
c
c 2. positive yx face 
c        the boundary plane on the positive-yx side is natural 
c
              j = 0
              m = nn_sub_y*nn_sub_x*(nn_sub_z-1)
c
          do 25 i = 1, nn_sub_x
            do 26 k = 1, nn_sub_y
c
                nod = npt_s(k+m,3)
                if(iboa_yx(j+k,2).eq.1)  then
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,2) = 0
                          ibc(nod,3) = 0
                          ibc(nod,5) = 0
                else
c                  this node is a Neumann node
                          ibc(nod,4) = 0
                          ibc(nod,6) = 0
                          ibc(nod,7) = 0
                          ibc(nod,8) = 0
                endif 
   26      continue
c
              j = j + nny
              m = m + nn_sub_y
c
   25    continue
c
c
c 3. negative yz face 
c        the boundary plane on the negative-yz side is natural 
c
              j = 0
              m = 0
c
          do 35 i = 1, nn_sub_z
            do 36 k = 1, nn_sub_y
c
                nod = npt_s(k+m,4)
                if(iboa_yz(j+k,1).eq.1)  then
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,3) = 0
                          ibc(nod,4) = 0
                          ibc(nod,7) = 0
                else
c                  this node is a Neumann node
                          ibc(nod,2) = 0
                          ibc(nod,5) = 0
                          ibc(nod,6) = 0
                          ibc(nod,8) = 0
                endif 
   36      continue
c
              j = j + nny
              m = m + nn_sub_y
c
   35    continue
c
c
c 4. positive yz face 
c        the boundary plane on the positive-yz side is natural 
c
              j = 0
              m = nn_sub_y*nn_sub_z*(nn_sub_x-1)
c
          do 45 i = 1, nn_sub_z
            do 46 k = 1, nn_sub_y
c
                nod = npt_s(k+m,4)
                if(iboa_yz(j+k,2).eq.1)  then
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,3) = 0
                          ibc(nod,4) = 0
                          ibc(nod,7) = 0
                else
c                  this node is a Neumann node
                          ibc(nod,2) = 0
                          ibc(nod,5) = 0
                          ibc(nod,6) = 0
                          ibc(nod,8) = 0
                endif 
   46      continue
c
              j = j + nny
              m = m + nn_sub_y
c
   45    continue
c
c
c 5. negative xz face 
c        the boundary plane on the negative-xz side is natural 
c
              j = 0
              m = 0
c
          do 55 i = 1, nn_sub_z
            do 56 k = 1, nn_sub_x
c
                  nod = npt_s(k+m,2)
                if(iboa_xz(j+k,1).eq.1)  then
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,2) = 0
                          ibc(nod,4) = 0
                          ibc(nod,6) = 0
                else
c                  this node is a Neumann node
                          ibc(nod,3) = 0
                          ibc(nod,5) = 0
                          ibc(nod,7) = 0
                          ibc(nod,8) = 0
                endif 
   56      continue
c
              j = j + nnx
              m = m + nn_sub_x 
c
   55    continue
c
c
c 6. positive xz face 
c        the boundary plane on the positive-xz side is natural 
c
              j = 0
              m = nn_sub_x*nn_sub_z*(nn_sub_y-1)
c
          do 65 i = 1, nn_sub_z
            do 66 k = 1, nn_sub_x
c
                 nod = npt_s(k+m,2)
                if(iboa_xz(j+k,2).eq.1)  then
c                  this node is a Dirichlet node
                          ibc(nod,1) = 0
                          ibc(nod,2) = 0
                          ibc(nod,4) = 0
                          ibc(nod,6) = 0
                else
c                  this node is a Neumann node
                          ibc(nod,3) = 0
                          ibc(nod,5) = 0
                          ibc(nod,7) = 0
                          ibc(nod,8) = 0
                endif 
   66      continue
c
              j = j + nnx
              m = m + nn_sub_x 
c
   65    continue
c
c
c number the degrees of freedom for the system of equations
c ordering of unknowns depends on solution strategy:
c  direct - use natural ordering
c  iterative - use tensor product ordering
c-----------------------------------------------------------------
        call number (mnode_t,8,ibc,
     &                     ixyz,nn_sub_y, nn_sub_x, nn_sub_z)
c-----------------------------------------------------------------
                        return 
                        end
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        subroutine number (mnode_s,i_df,ibc,
     &                     ixyz,nn_sub_y, nn_sub_x, nn_sub_z)
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c number the degrees of freedom for the system of equations
c ordering of unknowns depends on solution strategy:
c  iterative - use tensor product ordering
c     ixyz - defines node numbering based on shortest dimension first
c            = 1 is x-y-z numbering
c            = 2 is x-z-y numbering
c            = 3 is y-x-z numbering
c            = 4 is y-z-x numbering
c            = 5 is z-x-y numbering
c            = 6 is z-y-x numbering
c
        integer mnode_s,i_df,ixyz,nn_sub_y, 
     &          nn_sub_x, nn_sub_z
        integer   ibc(mnode_s,i_df)
c
c
c TENSOR PRODUCT ORDERING FOR THE PRESSURE VARIABLES
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c number the degrees of freedom for the system of equations
c numbering is dependent on the grid numbering
       if(ixyz.eq.1)  then
                n1 = nn_sub_x
                n2 = nn_sub_y
                n3 = nn_sub_z
               ndf2 = 2
               ndf3 = 3
               ndf4 = 5
               ndf5 = 4
               ndf6 = 6
               ndf7 = 7
       else if(ixyz.eq.2)  then
                n1 = nn_sub_x
                n2 = nn_sub_z
                n3 = nn_sub_y
               ndf2 = 2
               ndf3 = 4
               ndf4 = 6
               ndf5 = 3
               ndf6 = 5
               ndf7 = 7
       else if(ixyz.eq.3)  then
                n1 = nn_sub_y
                n2 = nn_sub_x
                n3 = nn_sub_z
               ndf2 = 3
               ndf3 = 2
               ndf4 = 5
               ndf5 = 4
               ndf6 = 7
               ndf7 = 6
       else if(ixyz.eq.4)  then
                n1 = nn_sub_y
                n2 = nn_sub_z
                n3 = nn_sub_x
               ndf2 = 3
               ndf3 = 4
               ndf4 = 7
               ndf5 = 2
               ndf6 = 5
               ndf7 = 6
       else if(ixyz.eq.5)  then
                n1 = nn_sub_z
                n2 = nn_sub_x
                n3 = nn_sub_y
               ndf2 = 4
               ndf3 = 2
               ndf4 = 6
               ndf5 = 3
               ndf6 = 7
               ndf7 = 5
       else 
                n1 = nn_sub_z
                n2 = nn_sub_y
                n3 = nn_sub_x
               ndf2 = 4
               ndf3 = 3
               ndf4 = 7
               ndf5 = 2
               ndf6 = 6
               ndf7 = 5
       endif
c
c for each n3 2D planes
c for each n2 lines per plane
c for each node
c
      do 101     i = 1, n3
c         2D plane i
      if(i.eq.1.or.i.eq.n3)  then
c              first or last plane
             if(i.eq.1           )  then
               nstart = 0
             else
               nstart = (n3-1)*(n1-1)*(n2-1)*8 - (n1-1)*(n2-1)*4
             endif
         do 12   j = 1, n2
c           Line j
c           node to start:
              nod = (i-1)*n1*n2 + (j-1)*n1 + 1
c
           if(j.eq.1.or.j.eq.n2)  then
c              first or last line on the first or last plane
               if(j.eq.1)  then
                num = nstart + 1
               else
                num = nstart + (n2-1)*(n1-1)*4-(n1-1)*2+1
               endif
c             tag them all in order
                do 13 k = 1, n1
                    do 14 idf = 1, 8
                          if(ibc(nod,idf).ne.0)  then
                             ibc(nod,idf) = num
                             num = num + 1
                          endif
   14               continue
                               nod = nod + 1
   13           continue
c
           else 
c              interior line on the first or last plane
                numm = nstart + (j-2)*(n1-1)*4 + (n1-1)*2 + 1
                nump = nstart + (j-2)*(n1-1)*4 + (n1-1)*4 + 1
c
             do 16 k = 1, n1
               if(k.eq.1.or.k.eq.n1)  then
c       first or last node on interior line on the first or last plane
c       (edge - 2 df)
                   if(ibc(nod,   1).ne.0 .or.
     &                ibc(nod,ndf2).ne.0 )      then
c                  Dirichlet-type boundary
                          if(ibc(nod,   1).ne.0)  then
                             ibc(nod,   1) = numm
                             numm = numm + 1
                             ibc(nod,ndf3) = nump
                             nump = nump + 1
                          else 
                             ibc(nod,ndf2) = numm
                             numm = numm + 1
                             ibc(nod,ndf4) = nump
                             nump = nump + 1
                          endif
                   else
c                  Neuman-type boundary
                          if(ibc(nod,ndf5).ne.0)  then
                             ibc(nod,ndf5) = numm
                             numm = numm + 1
                             ibc(nod,ndf7) = nump
                             nump = nump + 1
                          else 
                             ibc(nod,ndf6) = numm
                             numm = numm + 1
                             ibc(nod,   8) = nump
                             nump = nump + 1
                          endif
                   endif 
               else
c       interior node on interior line on the first or last plane
c       (midside - 4 df)
                   if(ibc(nod,   1).ne.0 )      then
c                     Dirichlet-type boundary
                             ibc(nod,   1) = numm
                             numm = numm + 1
                             ibc(nod,ndf2) = numm
                             numm = numm + 1
                             ibc(nod,ndf3) = nump
                             nump = nump + 1
                             ibc(nod,ndf4) = nump
                             nump = nump + 1
                   else
c                     Neuman-type boundary
                             ibc(nod,ndf5) = numm
                             numm = numm + 1
                             ibc(nod,ndf6) = numm
                             numm = numm + 1
                             ibc(nod,ndf7) = nump
                             nump = nump + 1
                             ibc(nod,   8) = nump
                             nump = nump + 1
                   endif
               endif
                               nod = nod + 1
   16           continue
           endif
   12       continue
      else 
c     interior plane 
               nstart = (i-2)*(n1-1)*(n2-1)*8 + (n1-1)*(n2-1)*4
         do 112   j = 1, n2
c           Line j
c           node to start:
              nod = (i-1)*n1*n2 + (j-1)*n1 + 1
c
           if(j.eq.1.or.j.eq.n2)  then
c              first or last line on this interior plane
               if(j.eq.1)  then
                numm = nstart + 1
                nump = numm + (n2-1)*(n1-1)*4
               else
                numm = nstart + (n2-1)*(n1-1)*4-(n1-1)*2 + 1
                nump = numm  + (n2-1)*(n1-1)*4
               endif
c
             do 116 k = 1, n1
               if(k.eq.1.or.k.eq.n1)  then
c       first or last node on first or last line on this interior plane
c (edge - 2 df)
                   if(ibc(nod,   1).ne.0 .or.
     &                ibc(nod,ndf2).ne.0 )    then
c                  Dirichlet-type boundary
                          if(ibc(nod,   1).ne.0)  then
                             ibc(nod,   1) = numm
                             numm = numm + 1
                             ibc(nod,ndf5) = nump
                             nump = nump + 1
                          else 
                             ibc(nod,ndf2) = numm
                             numm = numm + 1
                             ibc(nod,ndf6) = nump
                             nump = nump + 1
                          endif
                   else
c                  Neuman-type boundary
                          if(ibc(nod,ndf3).ne.0)  then
                             ibc(nod,ndf3) = numm
                             numm = numm + 1
                             ibc(nod,ndf7) = nump
                             nump = nump + 1
                          else 
                             ibc(nod,ndf4) = numm
                             numm = numm + 1
                             ibc(nod,   8) = nump
                             nump = nump + 1
                          endif
                   endif 
               else
c       interior node on first or last line on this interior plane
c (midside df = 4)
                   if(ibc(nod,   1).ne.0 )    then
c                  Dirichlet-type boundary
                             ibc(nod,   1) = numm
                             numm = numm + 1
                             ibc(nod,ndf2) = numm
                             numm = numm + 1
                             ibc(nod,ndf5) = nump
                             nump = nump + 1
                             ibc(nod,ndf6) = nump
                             nump = nump + 1
                   else
c                  Neuman-type boundary
                             ibc(nod,ndf3) = numm
                             numm = numm + 1
                             ibc(nod,ndf4) = numm
                             numm = numm + 1
                             ibc(nod,ndf7) = nump
                             nump = nump + 1
                             ibc(nod,   8) = nump
                             nump = nump + 1
                   endif
               endif
                               nod = nod + 1
  116           continue
c
           else 
c              interior line on this interior plane     
      nummm = nstart + (j-2)*(n1-1)*4 + (n1-1)*2 + 1
      numpm = nstart + (j-2)*(n1-1)*4 + (n1-1)*4 + 1
      nummp = nstart + (j-2)*(n1-1)*4 + (n1-1)*2 + 1 + (n1-1)*(n2-1)*4
      numpp = nstart + (j-2)*(n1-1)*4 + (n1-1)*4 + 1 + (n1-1)*(n2-1)*4
             do 117 k = 1, n1
               if(k.eq.1.or.k.eq.n1)  then
c       first or last node on interior line on interior plane
c (midside df = 4)
                   if(ibc(nod,   1).ne.0 )    then
c                  Dirichlet-type boundary
                             ibc(nod,   1) = nummm
                             nummm = nummm + 1
                             ibc(nod,ndf3) = numpm
                             numpm = numpm + 1
                             ibc(nod,ndf5) = nummp
                             nummp = nummp + 1
                             ibc(nod,ndf7) = numpp
                             numpp = numpp + 1
                   else
c                  Neuman-type boundary
                             ibc(nod,ndf2) = nummm
                             nummm = nummm + 1
                             ibc(nod,ndf4) = numpm
                             numpm = numpm + 1
                             ibc(nod,ndf6) = nummp
                             nummp = nummp + 1
                             ibc(nod,   8) = numpp
                             numpp = numpp + 1
                   endif
               else
c       interior node on interior line on interior plane
                             ibc(nod,   1) = nummm
                             nummm = nummm + 1
                             ibc(nod,ndf2) = nummm
                             nummm = nummm + 1
                             ibc(nod,ndf3) = numpm
                             numpm = numpm + 1
                             ibc(nod,ndf4) = numpm
                             numpm = numpm + 1
                             ibc(nod,ndf5) = nummp
                             nummp = nummp + 1
                             ibc(nod,ndf6) = nummp
                             nummp = nummp + 1
                             ibc(nod,ndf7) = numpp
                             numpp = numpp + 1
                             ibc(nod,   8) = numpp
                             numpp = numpp + 1
               endif
                               nod = nod + 1
  117           continue
           endif
  112    continue
      endif
c
  101 continue
                        return
                        end
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        subroutine offset_ (mnode_s,ibc,mme_s,ja,
     &                     ixyz,nn_sub_y, nn_sub_x, nn_sub_z)
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c FOR THE GMRES SOLVER
c Define offset vector for the SLAP column format 
c j_offset - defined by the grid geometry and df/eq numbering
c
c   use tensor product ordering
c
c     ixyz - defines node numbering based on shortest dimension first
c            = 1 is x-y-z numbering
c            = 2 is x-z-y numbering
c            = 3 is y-x-z numbering
c            = 4 is y-z-x numbering
c            = 5 is z-x-y numbering
c            = 6 is z-y-x numbering
c
        integer mnode_s,mme_s,ixyz,nn_sub_y, nn_sub_x, nn_sub_z
        integer   ibc(mnode_s,8),ja(mme_s)
c
c TENSOR PRODUCT ORDERING
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c number the degrees of freedom for the system of equations
c numbering is dependent on the grid numbering
       if(ixyz.eq.1)  then
                n1 = nn_sub_x
                n2 = nn_sub_y
                n3 = nn_sub_z
               ndf2 = 2
               ndf3 = 3
               ndf4 = 5
               ndf5 = 4
               ndf6 = 6
               ndf7 = 7
       else if(ixyz.eq.2)  then
                n1 = nn_sub_x
                n2 = nn_sub_z
                n3 = nn_sub_y
               ndf2 = 2
               ndf3 = 4
               ndf4 = 6
               ndf5 = 3
               ndf6 = 5
               ndf7 = 7
       else if(ixyz.eq.3)  then
                n1 = nn_sub_y
                n2 = nn_sub_x
                n3 = nn_sub_z
               ndf2 = 3
               ndf3 = 2
               ndf4 = 5
               ndf5 = 4
               ndf6 = 7
               ndf7 = 6
       else if(ixyz.eq.4)  then
                n1 = nn_sub_y
                n2 = nn_sub_z
                n3 = nn_sub_x
               ndf2 = 3
               ndf3 = 4
               ndf4 = 7
               ndf5 = 2
               ndf6 = 5
               ndf7 = 6
       else if(ixyz.eq.5)  then
                n1 = nn_sub_z
                n2 = nn_sub_x
                n3 = nn_sub_y
               ndf2 = 4
               ndf3 = 2
               ndf4 = 6
               ndf5 = 3
               ndf6 = 7
               ndf7 = 5
       else 
                n1 = nn_sub_z
                n2 = nn_sub_y
                n3 = nn_sub_x
               ndf2 = 4
               ndf3 = 3
               ndf4 = 7
               ndf5 = 2
               ndf6 = 6
               ndf7 = 5
       endif
c
c for each n3 2D planes
c for each n2 lines per plane
c for each node
       nline1 = 16*(1 + (n1-2)*2)
       nline2 = nline1*4            
       nline3 = nline1*16           
       nplane1 = 2*nline1 + 4*nline1*(n2-2)
       nplane2 = 4*nplane1
c
      do 101     i = 1, n3
c         2D plane i
      if(i.eq.1.or.i.eq.n3)  then
c              first or last plane
             if(i.eq.1           )  then
               nstart = 0
               noff_strt   = 0
             else
               nstart = (n3-1)*(n1-1)*(n2-1)*8 - (n1-1)*(n2-1)*4
               noff_strt = nplane1 + (n3-2)*nplane2
             endif
         do 12   j = 1, n2
c           Line j
c           node to start:
              nod = (i-1)*n1*n2 + (j-1)*n1 + 1
c
           if(j.eq.1.or.j.eq.n2)  then
c              first or last line on the first or last plane
               if(j.eq.1)  then
                num  = nstart + 1
                noff = noff_strt + 1
               else
                num  = nstart + (n2-1)*(n1-1)*4-(n1-1)*2 + 1
                noff = noff_strt + nplane1 - nline1 + 1
               endif
c             tag them all in order
                do 13 k = 1, n1
                    do 14 idf = 1, 8
                          if(ibc(nod,idf).ne.0)  then
                             ja(num)      = noff          
                             num = num + 1
                              if(k.eq.1.or.k.eq.n1) then
                                noff = noff + 8
                              else
                                noff = noff + 16
                              endif
                          endif
   14               continue
                               nod = nod + 1
   13           continue
c
           else 
c              interior line on the first or last plane
                numm = nstart + (j-2)*(n1-1)*4 + (n1-1)*2 + 1
                nump = nstart + (j-2)*(n1-1)*4 + (n1-1)*4 + 1
                noffm = noff_strt +   nline1 + (j-2)*nline2 + 1
                noffp = noff_strt + 3*nline1 + (j-2)*nline2 + 1
c
             do 16 k = 1, n1
               if(k.eq.1.or.k.eq.n1)  then
c       first or last node on interior line on the first or last plane
c       (edge - 2 df)
                   if(ibc(nod,   1).ne.0 .or.
     &                ibc(nod,ndf2).ne.0 )      then
c                  Dirichlet-type boundary
                          if(ibc(nod,   1).ne.0)  then
                                ja(numm)   = noffm          
                             numm = numm + 1
                             noffm = noffm + 16
                                ja(nump)   = noffp          
                             nump = nump + 1
                             noffp = noffp + 16
                          else 
                                ja(numm)   = noffm          
                             numm = numm + 1
                             noffm = noffm + 16
                                ja(nump)   = noffp          
                             nump = nump + 1
                             noffp = noffp + 16
                          endif
                   else
c                  Neuman-type boundary
                          if(ibc(nod,ndf5).ne.0)  then
                                ja(numm)   = noffm          
                             numm = numm + 1
                             noffm = noffm + 16
                                ja(nump)   = noffp          
                             nump = nump + 1
                             noffp = noffp + 16
                          else 
                                ja(numm)   = noffm          
                             numm = numm + 1
                             noffm = noffm + 16
                                ja(nump)   = noffp          
                             nump = nump + 1
                             noffp = noffp + 16
                          endif
                   endif 
               else
c       interior node on interior line on the first or last plane
c       (midside - 4 df)
                   if(ibc(nod,   1).ne.0 )      then
c                     Dirichlet-type boundary
                                ja(numm)   = noffm          
                             numm = numm + 1
                             noffm = noffm + 32
                                ja(numm)   = noffm          
                             numm = numm + 1
                             noffm = noffm + 32
                                ja(nump)   = noffp          
                             nump = nump + 1
                             noffp = noffp + 32
                                ja(nump)   = noffp          
                             nump = nump + 1
                             noffp = noffp + 32
                   else
c                     Neuman-type boundary
                                ja(numm)   = noffm          
                             numm = numm + 1
                             noffm = noffm + 32
                                ja(numm)   = noffm          
                             numm = numm + 1
                             noffm = noffm + 32
                                ja(nump)   = noffp          
                             nump = nump + 1
                             noffp = noffp + 32
                                ja(nump)   = noffp          
                             nump = nump + 1
                             noffp = noffp + 32
                   endif
               endif
                               nod = nod + 1
   16           continue
           endif
   12       continue
      else 
c     interior plane 
               nstart = (i-2)*(n1-1)*(n2-1)*8 + (n1-1)*(n2-1)*4
               noff_strt = nplane1 + (i-2)*nplane2
         do 112   j = 1, n2
c           Line j
c           node to start:
              nod = (i-1)*n1*n2 + (j-1)*n1 + 1
c
           if(j.eq.1.or.j.eq.n2)  then
c              first or last line on this interior plane
               if(j.eq.1)  then
                numm = nstart + 1
                nump = numm + (n2-1)*(n1-1)*4
                noffm = noff_strt + 1
                noffp = noff_strt + 2*nplane1 + 1
               else
                numm = nstart + (n2-1)*(n1-1)*4-(n1-1)*2 + 1
                nump = numm  + (n2-1)*(n1-1)*4
                noffm = noff_strt + 2*nplane1 - 2*nline1 + 1
                noffp = noff_strt +   nplane2 -   2*nline1 + 1
               endif
c
             do 116 k = 1, n1
               if(k.eq.1.or.k.eq.n1)  then
c       first or last node on first or last line on this interior plane
c (edge - 2 df)
                   if(ibc(nod,   1).ne.0 .or.
     &                ibc(nod,ndf2).ne.0 )    then
c                  Dirichlet-type boundary
                          if(ibc(nod,   1).ne.0)  then
                                ja(numm)   = noffm          
                             noffm = noffm + 16
                             numm = numm + 1
                                ja(nump)   = noffp          
                             noffp = noffp + 16
                             nump = nump + 1
                          else 
                                ja(numm)   = noffm          
                             noffm = noffm + 16
                             numm = numm + 1
                                ja(nump)   = noffp          
                             noffp = noffp + 16
                             nump = nump + 1
                          endif
                   else
c                  Neuman-type boundary
                          if(ibc(nod,ndf3).ne.0)  then
                                ja(numm)   = noffm          
                             noffm = noffm + 16
                             numm = numm + 1
                                ja(nump)   = noffp          
                             noffp = noffp + 16
                             nump = nump + 1
                          else 
                                ja(numm)   = noffm          
                             noffm = noffm + 16
                             numm = numm + 1
                                ja(nump)   = noffp          
                             noffp = noffp + 16
                             nump = nump + 1
                          endif
                   endif 
               else
c       interior node on first or last line on this interior plane
c (midside df = 4)
                   if(ibc(nod,   1).ne.0 )    then
c                  Dirichlet-type boundary
                                ja(numm)   = noffm          
                             noffm = noffm + 32
                             numm = numm + 1
                                ja(numm)   = noffm          
                             noffm = noffm + 32
                             numm = numm + 1
                                ja(nump)   = noffp          
                             noffp = noffp + 32
                             nump = nump + 1
                                ja(nump)   = noffp          
                             noffp = noffp + 32
                             nump = nump + 1
                   else
c                  Neuman-type boundary
                                ja(numm)   = noffm          
                             noffm = noffm + 32
                             numm = numm + 1
                                ja(numm)   = noffm          
                             noffm = noffm + 32
                             numm = numm + 1
                                ja(nump)   = noffp          
                             noffp = noffp + 32
                             nump = nump + 1
                                ja(nump)   = noffp          
                             noffp = noffp + 32
                             nump = nump + 1
                   endif
               endif
                               nod = nod + 1
  116           continue
c
           else 
c              interior line on this interior plane     
      nummm = nstart + (j-2)*(n1-1)*4 + (n1-1)*2 + 1
      numpm = nstart + (j-2)*(n1-1)*4 + (n1-1)*4 + 1
      nummp = nstart + (j-2)*(n1-1)*4 + (n1-1)*2 + 1 + (n1-1)*(n2-1)*4
      numpp = nstart + (j-2)*(n1-1)*4 + (n1-1)*4 + 1 + (n1-1)*(n2-1)*4
      noffmm = noff_strt + 2*nline1 + (j-2)*2*nline2 + 1
      noffpm =  noffmm   + nline2
      noffmp = noff_strt + 2*nplane1 + 2*nline1 + (j-2)*2*nline2 + 1
      noffpp =  noffmp   + nline2
c
             do 117 k = 1, n1
               if(k.eq.1.or.k.eq.n1)  then
c       first or last node on interior line on interior plane
c (midside df = 4)
                   if(ibc(nod,   1).ne.0 )    then
c                  Dirichlet-type boundary
                                ja(nummm)   = noffmm          
                             noffmm = noffmm + 32
                             nummm = nummm + 1
                                ja(numpm)   = noffpm          
                             noffpm = noffpm + 32
                             numpm = numpm + 1
                                ja(nummp)   = noffmp          
                             noffmp = noffmp + 32
                             nummp = nummp + 1
                                ja(numpp)   = noffpp          
                             noffpp = noffpp + 32
                             numpp = numpp + 1
                   else
c                  Neuman-type boundary
                                ja(nummm)   = noffmm          
                             noffmm = noffmm + 32
                             nummm = nummm + 1
                                ja(numpm)   = noffpm          
                             noffpm = noffpm + 32
                             numpm = numpm + 1
                                ja(nummp)   = noffmp          
                             noffmp = noffmp + 32
                             nummp = nummp + 1
                                ja(numpp)   = noffpp          
                             noffpp = noffpp + 32
                             numpp = numpp + 1
                   endif
               else
c       interior node on interior line on interior plane
                                ja(nummm)   = noffmm          
                             noffmm = noffmm + 64
                             nummm = nummm + 1
                                ja(nummm)   = noffmm          
                             noffmm = noffmm + 64
                             nummm = nummm + 1
                                ja(numpm)   = noffpm          
                             noffpm = noffpm + 64
                             numpm = numpm + 1
                                ja(numpm)   = noffpm          
                             noffpm = noffpm + 64
                             numpm = numpm + 1
                                ja(nummp)   = noffmp          
                             noffmp = noffmp + 64
                             nummp = nummp + 1
                                ja(nummp)   = noffmp          
                             noffmp = noffmp + 64
                             nummp = nummp + 1
                                ja(numpp)   = noffpp          
                             noffpp = noffpp + 64
                             numpp = numpp + 1
                                ja(numpp)   = noffpp          
                             noffpp = noffpp + 64
                             numpp = numpp + 1
               endif
                               nod = nod + 1
  117           continue
           endif
  112    continue
      endif
c
  101 continue
                             ja(num)      = noff          
c
                                return 
                                end
c
c GIVEN ja
c
c generate the ia vector - location vector for GMRES
c sweep in the shortest direction
c
c ***********************************************************
c
        subroutine locat (mnode_s,ibc,mme_s,ja,ia,
     &                     norder,n_short, n_med, n_long, nequ)
c
c ***********************************************************
        integer mnode_s,mme_s,n_short, n_med, n_long
        integer   ibc(mnode_s,8),ia(mme_s),ja(mme_s),
     &            inod(8), n_eq(8), norder(8)
c******
c
c  initialize the ia vector
                nelt =  ja(nequ+1)-1
          do 200 i = 1, nelt
  200          ia(i) = 0
c
c loop through all the elements in this subdomain
c do so in the shortest dimensions first
c
       do 5 n3 = 1, n_long-1
c
         do 10 n2 = 1, n_med-1
c
           do 15 n1 = 1, n_short-1
c
c the subdomain node numbers making up this element
c where the ordering is the same as for the collocation points
c
          inod(norder(1)) = 
     &                (n3-1)*n_short*n_med + n_short*(n2-1) + n1    
          inod(norder(2)) = 
     &                (n3-1)*n_short*n_med + n_short*(n2-1) + n1 + 1
          inod(norder(3)) = 
     &                (n3-1)*n_short*n_med + n_short* n2    + n1    
          inod(norder(4)) = 
     &                (n3-1)*n_short*n_med + n_short* n2    + n1 + 1
          inod(norder(5)) =  
     &                 n3   *n_short*n_med + n_short*(n2-1) + n1    
          inod(norder(6)) =  
     &                 n3   *n_short*n_med + n_short*(n2-1) + n1 + 1
          inod(norder(7)) =  
     &                 n3   *n_short*n_med + n_short* n2    + n1    
          inod(norder(8)) =  
     &                 n3   *n_short*n_med + n_short* n2    + n1 + 1
c
          n_eq(norder(1))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1
          n_eq(norder(2))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1
c
          n_eq(norder(3))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1 +
     &                      2*(n_short-1)
          n_eq(norder(4))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1     +
     &                      2*(n_short-1)
c
          n_eq(norder(5))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1 +
     &                      4*(n_short-1)*(n_med-1)
          n_eq(norder(6))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1     +
     &                      4*(n_short-1)*(n_med-1)
c
          n_eq(norder(7))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1 +
     &                      4*(n_short-1)*(n_med-1) +
     &                      2*(n_short-1)
          n_eq(norder(8))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1     +
     &                      4*(n_short-1)*(n_med-1) +
     &                      2*(n_short-1)
c
c loop through the 8 collocation points in the element
c
c collocation point location index = ii
       do 20 ii = 1, 8
c
c        loop through the nodes in this element
         do 23 i = 1, 8
c
c          loop through the degrees of freedom at each node
            do 24 idf = 1, 8
c
c
c*********************************************************
c
         if(ibc(inod(i),idf) .ne. 0)        then
c          we have an entry into the system matrix
              i_df = ibc(inod(i),idf)
             j_off = ja(i_df)
c
            if(i_df .eq. n_eq(ii)) then
c              diagonal entry
               ia(j_off) = n_eq(ii)
            else
c            off-diagonal entry, put in first available position
c               and in decending order
               do 100 inc = ja(i_df)+1, ja(i_df+1)-1
                 if( n_eq(ii).lt.ia(inc) ) then
c                  all must slide down one
                        ntemp = ia(inc)
                      ia(inc) = n_eq(ii)
                 do 110 inc2 = inc+1, ja(i_df+1)-1
                  if(ia(inc2).ge.1  ) then
                        ntemp2 = ia(inc2)
                      ia(inc2) = ntemp    
                        ntemp = ntemp2 
                  else 
                      ia(inc2) = ntemp    
                     go to 101
                  endif
  110          continue
c
                  else if(ia(inc).lt.1  ) then
                      ia(inc) = n_eq(ii)
                      go to 101
                  endif 
  100          continue
            endif
  101          continue
c
         endif
c
   24     continue
c
   23   continue
c
   20   continue
   15   continue
   10   continue
    5   continue
c
                                return 
                                end
