C     Last change:  JG   26 Sep 2000    4:10 pm
c--------------------------
c--------------------------
c Subroutines in this file
c subroutine exch_w - compute the mass exchange terms for the 
c                     water contaminant transport equation
c subroutine exch_g - compute the mass exchange terms for the 
c                     gas contaminant transport equation
c--------------------------
c--------------------------
c
c        #########################################################
         subroutine exch_w (ii, dsx, dsy, dsz, poro, cow, cowg)
c        #########################################################
c
c compute the mass exchange terms for the water contaminant transport
c equation
c
        include 'include.f'
c
c--------------------------
c compute the exchange coeff at the collocation point
c--------------------------
c
             sa = 0.d0
             st = 0.d0
              vw_x   = 0.d0
              vw_y   = 0.d0
              vw_z   = 0.d0
           so_mn = 1.d0
           so_mx = 0.d0
           sa_mn  = 1.d0
           sa_mx  = 0.d0
c
         do 21 i = 1, 8
c
                 ino    = npt_g_s(inod(i) )
c
           vw_x = vw_x + vwx(ino) *b1(ii,i)
           vw_y = vw_y + vwy(ino) *b1(ii,i)
           vw_z = vw_z + vwz(ino) *b1(ii,i)
c
       st    = st     + stt(ino,1)*b3(ii,i,1)
     &                + stt(ino,2)*b3(ii,i,2)*dsx
     &                + stt(ino,3)*b3(ii,i,3)*dsy
     &                + stt(ino,4)*b3(ii,i,4)*dsz
     &                + stt(ino,5)*b3(ii,i,5)*dsx*dsy
     &                + stt(ino,6)*b3(ii,i,6)*dsx*dsz
     &                + stt(ino,7)*b3(ii,i,7)*dsy*dsz
     &                + stt(ino,8)*b3(ii,i,8)*dsx*dsy*dsz
c
       sa    = sa     + swt(ino,1)*b3(ii,i,1)
     &                + swt(ino,2)*b3(ii,i,2)*dsx
     &                + swt(ino,3)*b3(ii,i,3)*dsy
     &                + swt(ino,4)*b3(ii,i,4)*dsz
     &                + swt(ino,5)*b3(ii,i,5)*dsx*dsy
     &                + swt(ino,6)*b3(ii,i,6)*dsx*dsz
     &                + swt(ino,7)*b3(ii,i,7)*dsy*dsz
     &                + swt(ino,8)*b3(ii,i,8)*dsx*dsy*dsz
c
      if (stt(ino,1)-swt(ino,1).lt.so_mn) so_mn = stt(ino,1)-swt(ino,1)
      if (stt(ino,1)-swt(ino,1).gt.so_mx) so_mx = stt(ino,1)-swt(ino,1)
      if (swt(ino,1).lt.sa_mn)  sa_mn = swt(ino,1)
      if (swt(ino,1).gt.sa_mx)  sa_mx = swt(ino,1)
c
   21   continue
c
         so = st - sa
c
           if (so_mn.lt.0.d0)          so_mn = 0.d0
           if (so_mx.gt.1.d0)          so_mx = 1.d0
           if (so.gt.so_mx)             so = so_mx
           if (so.lt.so_mn)             so = so_mn
c
           if (sa_mn.lt.0.d0)          sa_mn = 0.d0
           if (sa_mx.gt.1.d0)          sa_mx = 1.d0
           if (sa.gt.sa_mx)             sa = sa_mx
           if (sa.lt.sa_mn)             sa = sa_mn
c
c N to W exchange
c 1.)
          vmag = dsqrt(vw_x*vw_x + vw_y*vw_y + vw_z*vw_z)
      cow = bow_1*(vmag)**(bow_3)*(poro*so)**(bow_2)/24.d0
c          ******
c          ex_ow  = cow *(parow - ow)
c          ******
c 2.)
c     cow = bow_1*(poro*so)**(bow_2)
c
c N in W to G exchange
        IF(1.d0-so-sa .GE. 0.01d0)  then
c there is enough gas for exchange to occur
c 1.)
c         vmag = dsqrt(vg_x*vg_x + vg_y*vg_y)
c     cowg = bowg_1*(vmag)**(bowg_3)*(poro*sa)**(bowg_2)/24.d0
c 2.)
      cowg = bowg_1*(poro*sa)**(bowg_2)
c          ******
c          ex_owg = cowg*(e_henry*ow - og)
c          ******
        else
c extinguish the rate as Sg goes to 0
           cowg = bowg_1*(poro*(0.99d0-so))**(bowg_2)
     &           * (1.d0 - 100.d0*(0.01d0-1.d0+so+sa))
        endif
c--------------------------
c
                   return 
                   end 
c
c        #########################################################
         subroutine exch_g (ii,dsx,dsy,dsz,poro,cog,cowg)
c        #########################################################
c
c compute the mass exchange terms for the gas contaminant transport
c equation
c
        include 'include.f'
c
c--------------------------
c compute the exchange coeff at the collocation point
c
             sa = 0.d0
             st = 0.d0
              vg_x   = 0.d0
              vg_y   = 0.d0
              vg_z   = 0.d0
           so_mn = 1.d0
           so_mx = 0.d0
           sa_mn  = 1.d0
           sa_mx  = 0.d0
c
         do 21 i = 1, 8
c
                 ino    = npt_g_s(inod(i) )
c
             vg_x =   vg_x   + vgx(ino)  *b1(ii,i)
             vg_y =   vg_y   + vgy(ino)  *b1(ii,i)
             vg_z =   vg_z   + vgz(ino)  *b1(ii,i)
c
       st    = st     + stt(ino,1)*b3(ii,i,1)
     &                + stt(ino,2)*b3(ii,i,2)*dsx
     &                + stt(ino,3)*b3(ii,i,3)*dsy
     &                + stt(ino,4)*b3(ii,i,4)*dsz
     &                + stt(ino,5)*b3(ii,i,5)*dsx*dsy
     &                + stt(ino,6)*b3(ii,i,6)*dsx*dsz
     &                + stt(ino,7)*b3(ii,i,7)*dsy*dsz
     &                + stt(ino,8)*b3(ii,i,8)*dsx*dsy*dsz
c
       sa    = sa     + swt(ino,1)*b3(ii,i,1)
     &                + swt(ino,2)*b3(ii,i,2)*dsx
     &                + swt(ino,3)*b3(ii,i,3)*dsy
     &                + swt(ino,4)*b3(ii,i,4)*dsz
     &                + swt(ino,5)*b3(ii,i,5)*dsx*dsy
     &                + swt(ino,6)*b3(ii,i,6)*dsx*dsz
     &                + swt(ino,7)*b3(ii,i,7)*dsy*dsz
     &                + swt(ino,8)*b3(ii,i,8)*dsx*dsy*dsz
c
      if (stt(ino,1)-swt(ino,1).lt.so_mn) so_mn = stt(ino,1)-swt(ino,1)
      if (stt(ino,1)-swt(ino,1).gt.so_mx) so_mx = stt(ino,1)-swt(ino,1)
      if (swt(ino,1).lt.sa_mn)  sa_mn = swt(ino,1)
      if (swt(ino,1).gt.sa_mx)  sa_mx = swt(ino,1)
c
   21   continue
c
         so = st - sa
           if (so_mn.lt.0.d0)          so_mn = 0.d0
           if (so_mx.gt.1.d0)          so_mx = 1.d0
           if (so.gt.so_mx)             so = so_mx
           if (so.lt.so_mn)             so = so_mn
c
           if (sa_mn.lt.0.d0)          sa_mn = 0.d0
           if (sa_mx.gt.1.d0)          sa_mx = 1.d0
           if (sa.gt.sa_mx)             sa = sa_mx
           if (sa.lt.sa_mn)             sa = sa_mn
c
c N to G exchange
c 1.)
c          vmag = dsqrt(vg_x*vg_x + vg_y*vg_y)
c          cog = bog_1*(vmag)**(bog_3)*(poro*so)**(bog_2)/24.d0
c 2.)
           cog = bog_1*(poro*so)**(bog_2)
c
c N in W to G exchange
c force exchange = 0 if Sg = 0
        IF(1.d0-so-sa .GE. 0.01d0)  then
c there is enough gas for normal exchange to occur
c 1.)
c     cowg = bowg_1*(vmag)**(bowg_3)*(poro*sa)**(bowg_2)/24.d0
c 2.)
      cowg = bowg_1*(poro*sa)**(bowg_2)
        else
c extinguish the rate as Sg goes to 0
           cowg = bowg_1*(poro*(0.99d0-so))**(bowg_2)
     &           * (1.d0 - 100.d0*(0.01d0-1.d0+so+sa))
        endif
c
c--------------------------
                   return 
                   end