C     Last change:  JG   30 Aug 2000   12:08 pm
c
c
           subroutine icset
c
c
c sets pressures at static equilibrium for either water or oil 
c saturated conditions and dissolved components at zero 
c (% water species = 1, %oil species = 1 )
c
c
        include 'include.f'
c
c
c  swinit : initial global water saturation
c  stinit : initial global total liquid saturation
c  coninit : initial global contaminant concentration
c            cannot be bigger than parow
c
c
             read (1,*) swinit
c
c Initial total liquid saturation: stinit
c
             read (1,*) stinit
c
           if(stinit.lt.swinit-1.d-12) then
              write(6,*) 'INPUT ERROR'
               write(6,*) 'INITIAL CONDITIONS: VIOLATE St >= Sw'
               stop
           endif
           if(iphase.eq.12.and.stinit.lt.1.d0-epsil) then
             write(6,*) 'INPUT ERROR'
       write(6,*)'       IPHASE and INITIAL saturations not compatible'
               stop
           endif
           if(iphase.eq.13.and.dabs(stinit-swinit).gt.epsil) then
             write(6,*) 'INPUT ERROR'
       write(6,*)'       IPHASE and INITIAL SATURATIONS not compatible'
               stop
           endif
c
c
c Initial oil in water concentration : roainit
c
             read (1,*) roainit
               if(ntr_ow.ne.1) then
                 roainit = 0.d0
               endif
c
c Initial oil in gas concentration : roginit
c
             read (1,*) roginit
               if(ntr_og.ne.1) then
                 roginit = 0.d0
               endif
c
        read(1,*)ncont
        if (ncont.ne.1)then
c NOT A RESTART
c set initial conditions to static equalibrium
c
           if (stinit-swinit.gt.0.001d0) then
c NAPL present, set to eq. concentrations
            c_ow = parow
            c_og = parog
           else
c NAPL not present, set to specified IC
            c_ow = roainit
            c_og = roginit
           endif
c WATER
c           if (i_spcies.eq.111.or.i_spices.eq.110) then
           if (i_ow.eq.1) then
            do 35 i = 1, nn
                    roa11(i,1) = c_ow
                    roat(i,1)  = c_ow
   35        continue
             call water_prop (c_ow,wa,dww,visw)
           else
             call water_prop (0.d0,wa,dww,visw)
           end if
c GAS
c           if (i_spcies.eq.111.or.i_spices.eq.101) then
           if (i_og.eq.1) then
            do 36 i = 1, nn
                    rog11(i,1) = c_og
                    rogt(i,1) = c_og
   36        continue
             call   gas_prop (c_og,wg,dgg,visg)
           else
             call   gas_prop (0.d0,wg,dgg,visg)
           end if
c
c______________________________________________________________
c Given global initial Sw and St define initial capillary pressures
c
       if (nhyst.eq.1)   then
c
c hysteresis on
c
c define effective saturation parameters and
c phase trapping parameters
c before computing the capillary pressures
c
          do 333 j = 1, nn
c
                 sw11(j,1)  = swinit
                 swt(j,1)   = swinit
c
                 st11(j,1)  = stinit
                 stt(j,1)   = stinit
c
             call hyst_ic (j, swinit, stinit)
c
c            given Sw what is Pcnw
             call pc_nw    (swinit, pc, d_pc, j)
             call lev_sw_p (pc, pc )
                 pcnw1(j)  = pc
c            given St what is Pcgn
             call pc_gn    (stinit, pc, d_pc, j)
             call lev_st_p (pc, pc )
                 pcgn1(j)  = pc
c
  333     continue
c
       else
c
c no hysteresis
c
            do 334 j = 1, nn
c
                 sw11(j,1)  = swinit
                 swt(j,1)   = swinit
c
                 st11(j,1)  = stinit
                 stt(j,1)   = stinit
c
c            given Sw what is Pcnw
             call pc_nw    (swinit, pc, d_pc, j)
             call lev_sw_p (pc, pc )
                 pcnw1(j)  = pc
c            given St what is Pcgn
             call pc_gn    (stinit, pc, d_pc, j)
             call lev_st_p (pc, pc )
                 pcgn1(j)  = pc
c
              nhc_t(j) = 1
              nhc_w(j) = 1
              ss_w(j,1) = 1.d0
              sr_w(j,1) = swr(j)
              ss_t(j,1) = 1.d0
              sr_t(j,1) = swr(j)
c
  334       continue
c
       endif
c
c  read in deviations to global SATURATION definition
c ndev  = number of nodes at which Sw and St are to be redefined
            read(1,*) ndev
            if (ndev.gt.0)  then
                call ic_sat(ndev)
            endif
c
c
c SET WATER PRESSURE - STATIC DISTRIBUTION 
c
             dww = dww*grav
c
             do 30 i = 1, nn
                do 31 j = 1, 8
       		 pa11(i,j)  = 0.0d0
   31           continue
   30        continue
c
c  set reference pressure ( atmospheric)
c
c  cross section is xy-plane ( x is vertical positive down )
c  set up static pressure distribution in vertical given grid rotation
c
            kk = -nny*nnx 
c
       do 24 k=1,nnz
            kk = kk + nny*nnx
            ii = -nny 
         do 25 i=1,nnx
              ii = ii + nny 
           do 26 j=1,nny
c
               pa11(kk+ii+j,1) = dww*( dcos(th_z)*dcos(th_y)*x(i)
     &                              -  dsin(th_z)*y(j)
     &                              +  dcos(th_z)*dsin(th_y)*z(k) )
c
               pa11(kk+ii+j,2) = dww*  dcos(th_z)*dcos(th_y)   
               pa11(kk+ii+j,3) = - dww*  dsin(th_z)
               pa11(kk+ii+j,4) = dww*  dcos(th_z)*dsin(th_y)
c
   26      continue
   25    continue
   24  continue
c
c@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
c
        else
                 nflag = 1
c
c it's a RESTART
c this is a continuation of a previous run, if so we must read in
c initial data
c
                        call read_rs
c
c  read in deviations to global SATURATION definition
c ndev  = number of nodes at which Sw and St are to be redefined
            read(1,*) ndev
            if (ndev.gt.0)  then
                call ic_sat(ndev)
            endif
        endif
c
c  read in deviations to global ROA definition
c ndev  = number of nodes at which Conc is to be redefined
            read(1,*) ndev
            if (ndev.gt.0.and.i_ow.eq.1.and.ntr_ow.eq.1)  then
                call ic_roa(ndev)
            endif
c  read in deviations to global ROG definition
c ndev_rog  = number of nodes at which Conc is to be redefined
            read(1,*) ndev
            if (ndev.gt.0.and.i_og.eq.1.and.ntr_og.eq.1)  then
                call ic_rog(ndev)
            endif
c
                                                      return 
                                                      end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine ic_sat(ndev)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c opportunity to change IC's/BC's from global/default specification
c
c additional conditions for Sw and St
c
c can be either dirichlet bc's to override default conditions
c or can specify specific IC's at any node in the domain
c changing Sw here can result in either mobile or immobile residual
c NOTE: alter functional conditions only!
c
        include 'include.f'
c
                       open (13,file='sw.in')
	do 26 i=1,ndev
c
		read(13,*)  nod,sw,st
c
           if(st.lt.sw-1.d-12) then
               write(6,*) 'INPUT ERROR'
               write(6,*) '       VIOLATE St >= Sw, AT NODE:'
               write(6,*) nod
               stop
           endif
           if(iphase.eq.12.and.st.lt.1.d0-epsil) then
               write(6,*) 'INPUT ERROR'
       write(6,*)' IPHASE/INITIAL Saturations not compatible @ node'
               write(6,*) nod
               stop
           endif
           if(iphase.eq.13.and.dabs(st-sw).gt.epsil) then
               write(6,*) 'INPUT ERROR'
       write(6,*)' IPHASE/INITIAL Saturations not compatible @ node'
               write(6,*) nod
               stop
           endif
c
           if (sw.gt.1.000d0) sw = 1.d0
           if (st.gt.1.000d0) st = 1.d0
c
               sw11(nod,1)  = sw
               st11(nod,1)  = st
c
                       if (st-sw.gt.0.001d0) then
c NAPL is present
                        IF(i_ow.eq.1) then
                          roa11(nod,1) = parow
                          roat(nod,1) = parow
                        endif
                        IF(i_og.eq.1) then
                          rog11(nod,1) = parog
                          rogt(nod,1) = parog
                        endif
                       endif
c
c Given nodal initial Sw define initial capillary pressure
c and hysteresis vectors
c
         if (nhyst.eq.1)   then
c hysteresis on 
c given sw and st define parameters for hysteretic k-S-P model
c
              call hyst_ic (nod, sw, st)
c
         endif
c
c set capillary pressure
c            given Sw what is Pcnw 
             call pc_nw    (sw, pc, d_pc, nod)
             call lev_sw_p (pc, pc )
                 pcnw1(nod)  = pc
c            given St what is Pcgn 
             call pc_gn    (st, pc, d_pc, nod)
             call lev_st_p (pc, pc )
                 pcgn1(nod)  = pc
c
   26   continue
c
        close (13)
           return 
         end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine ic_roa(ndev)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c opportunity to change IC's from global/default specification
c at any node in the domain
c
        include 'include.f'
        open (13,file='roa.in')
c
       if (ntr_ow.eq.1) then
        do 26 i=1,ndev
c
                read(13,*)  nod,value
c
           if (value.gt.parow  ) value = parow
           if (value.lt.0.d0  ) value = 0.d0
c
              roa11(nod,1)  = value
              roat(nod,1)  = value
c
   26   continue
c
        else
               write(28,*) 'INPUT WARNING'
         write(28,*) 'NAPL-water transport is OFF'
        endif
c
        close (13)
                                               return
                                               end
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine ic_rog(ndev)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c opportunity to change IC's from global/default specification
c at any node in the domain
c
        include 'include.f'
        open (13,file='rog.in')
c
        if (ntr_og.eq.1) then
        do 26 i=1,ndev
c
                read(13,*)  nod,value
c
           if (value.gt.parog  ) value = parog
           if (value.lt.0.d0  ) value = 0.d0
c
              rog11(nod,1)  = value
              rogt(nod,1)  = value
c
   26   continue
c
        else
               write(28,*) 'INPUT WARNING'
         write(28,*) 'NAPL-gas transport is OFF'
        endif
        close (13)
                                               return
                                               end
