C     Last change:  JG   15 Jul 2002   11:44 am
c-----------------------------------------------------------------
c-----------------------------------------------------------------
c BEFORE COMPILING SET THESE PARAMETERS
c
c  Set these parameters to MINIMIZE MEMORY  (RAM reqirements)
c THERE ARE 3 THINGS YOU CAN CHANGE HERE:
C 1.) global mesh dimensions - SET TO YOUR MESH SIZE TO MINIMIZE STORAGE
c
c 2.) DEFINE SPECIES TRANSPORT PROBLEM
c
c 3.) number of hysteresis loops -
c     at this point, set mloop = 1 if not using hysteresis
c                    set mloop = 4 if using hysteresis
c
c TO define how HEAD TYPE flow BCs are specified.
c 4.) specify the total head yourself, or specify the difference from static
c     and let the code compute the correct total head.
c
c-----------------------------------------------------------------
c
        implicit DOUBLE PRECISION (a-h,o-z)
c
c-----------------------------------------------------------------
c
c (1.) global mesh dimensions ---
c
c maximum number of nodes in x dimension
                                         parameter (mgnd_x     = 21 )
c maximum number of nodes in y dimension
                                         parameter (mgnd_y     = 41)
c maximum number of nodes in z dimension
                                         parameter (mgnd_z     = 2)
c
c (2)
c DEFINE SPECIES TRANSPORT PROBLEM
c       OPTIONS:
c               W transport on (i_ow = 1), off (i_ow = 0)
c               G transport on (i_og = 1), off (i_og = 0)
                                         parameter (i_ow   =  1)
                                         parameter (i_og   =  0)
c (3)
c HYSTERESIS ON/OFF
c                       set mloop = 1 with hysteresis off
c                       set mloop = 4 with hysteresis on
c
                                         parameter (mloop   = 4 )
c
c (4) Pressure condition - difference from static (=1)
c                          specify the total head (=0)
                                         parameter (i_static = 1)
c
c
c ---    ---       ---      ---              ---          ---
c ---    ---       ---      ---              ---          --- 
c ---    --- DON'T MAKE CHANGES BELOW THIS LINE   ---          --- 
c ---  THE FOLLOWING PARAMETERS ARE SET AUTOMATICALLY ---      --- 
c ---    ---       ---      ---              ---          --- 
c global dimensions
c ---    ---       ---      ---              ---          --- 
c ---    ---       ---      ---              ---          --- 
        parameter (mnode_g     = mgnd_x*mgnd_y*mgnd_z)
        parameter (melem_g     = (mgnd_x-1)*(mgnd_y-1)*(mgnd_z-1) )
        parameter (mgel_x     = (mgnd_x-1))
        parameter (mgel_y     = (mgnd_y-1))
        parameter (mgel_z     = (mgnd_z-1))
c ---    ---       ---      ---              ---          --- 
c interface mesh dimensions ---
c ---    ---       ---      ---              ---          --- 
c elements/nodes
        parameter (mnode_iyx     = mgnd_x  *  mgnd_y    )
        parameter (mnode_ixz     = mgnd_x  *  mgnd_z    )
        parameter (mnode_iyz     = mgnd_z  *  mgnd_y    )
c       parameter (max_int = max(mnode_ixz, mnode_iyz, mnode_iyx) )
c
c number of equations in the domain
        parameter (meq_s     = 8*melem_g )
c
c iterative solver dimensioning
c
c max number of non-zero matrix elements =
c    8* ( 64*(# interior elements) + 48*(# midside elements) 
c       + 36*(# edge elements) + 27*(# corner elements)  )
c
        parameter (mme_s  = 8 * (
     &           64*(mgel_x-2)*(mgel_y-2)*(mgel_z-2)
     &         + 96*( (mgel_x-2)*(mgel_y-2) 
     &              + (mgel_x-2)*(mgel_z-2) 
     &              + (mgel_y-2)*(mgel_z-2) )
     &         +144*( (mgel_x-2) + (mgel_y-2) + (mgel_z-2) )
     &              + 216 ) )
c Bi-CG
c  LENW >= NL+NU+8*N
       parameter (lenw  = mme_s + 9*meq_s  )
c
c  LENIW >= NL+NU+4*N+12
       parameter (leniw = mme_s + 12 + 5*meq_s )
c
c-----------------------------------------------------------------
c-----------------------------------------------------------------
c-- given these parameters all vectors are defined ---------------
c-----------------------------------------------------------------
c
c mesh definition and node numbering
       dimension y(mgnd_y),x(mgnd_x),z(mgnd_z),
     &           dy(mgnd_y-1),dx(mgnd_x-1),dz(mgnd_z-1),
c
     &           nel(melem_g,8),
c
     &           npt_s(mnode_g,6),norder(8),npt_g_s(mnode_g)
c
c boundary condition information
c natural boundaries, 
c     each vector for a specific variable (Pw, Sw, Sg, Row, Rog)
c     and a speciric boundary plane (yx, yz, xz)
       dimension
     &    ib_yx(mnode_iyx,2),ib_yz(mnode_iyz,2),ib_xz(mnode_ixz,2)
      dimension iboa_yx(1+i_ow*mnode_iyx,2),ibog_yx(1+i_og*mnode_iyx,2),
     &          iboa_yz(1+i_ow*mnode_iyz,2),ibog_yz(1+i_og*mnode_iyz,2),
     &          iboa_xz(1+i_ow*mnode_ixz,2),ibog_xz(1+i_og*mnode_ixz,2)
cc
c the df equation numbering for the domain taking into account 
c the natural boundary conditions 
            dimension ibc_p(mnode_g,8), ibc_s(mnode_g,8)
            dimension ibc_oa(1+i_ow*mnode_g,8), ibc_og(1+i_og*mnode_g,8)
c
c Hermite variables
c PRESSURE
       dimension pa11(mnode_g,8),  pat(mnode_g,8)
c SATURATION
            dimension sw11(mnode_g,8),  swt(mnode_g,8),
     &             st11(mnode_g,8),  stt(mnode_g,8)
c CONCENTRATION
            dimension
     &     roa11(1+i_ow*mnode_g,8), roat(1+i_ow*mnode_g,8),
     &     roa_p(1+i_ow*mnode_g,8),
     &     rog11(1+i_og*mnode_g,8), rogt(1+i_og*mnode_g,8),
     &     rog_p(1+i_og*mnode_g,8)
c
c point source stuff (wells)
c SATURATION
      	  dimension qw(mnode_g),qn(mnode_g),qg(mnode_g)
c CONCENTRATION
      	  dimension qiow(1+i_ow*mnode_g), qiog(1+i_og*mnode_g)
c
c soil properties (permeability and porosity)
       dimension perm (mnode_g), por(mnode_g)
c adsorption
      	  dimension p_ow (1+i_ow*mnode_g)
c
c k-S-P model  definition
       dimension  nhc_w(mnode_g), nhc_t(mnode_g), 
     &            swt_c(mnode_g), sgt_c(mnode_g), snt_c(mnode_g),
     &            asd(mnode_g),    asi(mnode_g), shpe(mnode_g),
     &       swr(mnode_g), sgr(mnode_g), snwr(mnode_g), snnr(mnode_g)
c
c coefficients in the PDE's
c
c flow variables
       dimension  dpcgn(mnode_g), dpcnw(mnode_g), 
     &            pcnw1(mnode_g), pcgn1(mnode_g),
     &            rpn  (mnode_g), rpa  (mnode_g), rpg(mnode_g),
     &            h_gw  (mnode_g), h_nw  (mnode_g), h_gn(mnode_g)
       dimension  vwx(mnode_g), vwy(mnode_g), vwz(mnode_g),
     &            vgx(mnode_g), vgy(mnode_g), vgz(mnode_g),
     &            vtx(mnode_g), vty(mnode_g), vtz(mnode_g)
c
c basis functions
c  3-D Hermites
       dimension b3(8,8,8),bx3(8,8,8),by3(8,8,8),bz3(8,8,8),
     &           bxx3(8,8,8),byy3(8,8,8),bzz3(8,8,8),
     &           bxy3(8,8,8),bxz3(8,8,8),byz3(8,8,8)
c  3-D Lagrange
       dimension b1(8,8),bx1(8,8),by1(8,8),bz1(8,8)
c  2-D Hermites
      dimension b3_2d(4,4,4)
c  2-D Lagrange
       dimension b1_2d(4,4)
c CG pointer vectors
       dimension j_offset(mme_s),i_loctn(mme_s)
c
c basis functions
       common /b_3d/ b3,bx3,by3,bz3,bxx3,byy3,bzz3,bxy3,bxz3,byz3,
     &               b1,bx1,by1,bz1
       common /b_2d/ b3_2d,b1_2d
       common /gmres/ j_offset,    i_loctn     
c
c Hermite vectors
       common/s_w/          sw11,swt
       common/p_w/          pa11,pat
       common/s_t/         st11,stt
       common/conc/       roa11,roat,roa_p,rog11,rogt,rog_p
c
c boundary condition vectors
       common/bv/         ib_yx,ib_yz,ib_xz,iboa_yx,iboa_yz,iboa_xz,
     &                    ibog_yx,ibog_yz,ibog_xz
       common/eq_num/     ibc_p,ibc_s,ibc_oa,ibc_og
c
c dimensions - global domain
       common/space/      x,y,z,dx,dy,dz
       common/dim/        nex,ney,nez,nnx,nny,nnz,nn
       common/ncon/       nel
c
       common/nodnum/    npt_s,npt_g_s,norder
       common/num_dir/  ixyz,nn_sub,nequ,ncd,n_short,
     &                    n_long,n_med,nn_sub_x,nn_sub_y,nn_sub_z
c
c simulation parameters (vectors)
       common/fun_sat/      h_gw,h_gn,h_nw,vtx,vty,vtz
       common/fun_trans/      vwx, vwy, vwz,vgx,vgy,vgz
       common/cap_press/      pcnw1,pcgn1
       common/fun_flow/     rpa,rpn,rpg,dpcnw,dpcgn
       common/peclet_c/     pe_w,pe_g
       common/phase_sol/   iphase

c source / sink vectors
       common/well_rate/  qw,qn,qg,qiow,qiog
c
c
c simulation parameters (scalars)
c time step control
       common /dtlim/  dslim,co,dt_crit
       common /dtctrl/  dt,dt0,tdivh,tsmin,time,tmax,istop,iscr,itrf,
     &                  itrt,itrs,inc,n_opt,
     &                  ithangs,ithangg,ithangc,ihang,itermx
       common /dtctrl2/ tmult,tsmx,tdiv,itw_dt,itg_dt,itoa_dt,itog_dt,
     &                  itreds,itincs,itredc,itincc,itredg,itincg
c iteration data
       common /error/    erip,eris,eros,erit,erot
       common /er_norm/  ernp,erns,ernt,ixp,ixs,ixt
c
       common/exchange/ parow,bow_1, bow_2, bow_3,
     &                  parog,bog_1, bog_2, bog_3,
     &                  e_henry, bowg_1, bowg_2, bowg_3,
     &                  p_ow,decay,theta,ntr_ow,ntr_og
       common /fluid/  vw_r,vn_r,vg_r,rw_r,rn_r,rg_r,denw,
     &                 along,atran,diffw,diffg,pg_ref,d_layer
c
       common/lev_sc/       b_nw, b_gn, b_gw
c
c general
       common/soil/         perm, por
       common /xsect/  grav,th_z, th_y
       common/fdge/    epsil, nflag, mass, iout
c
c hysteresis definition
c
       common /s_p/  swr,snnr,snwr,sgr,shpe,asd,asi
       common /k_s/  alfw,alfn,alfg,
     &               nsew1,nsew2, nseg1,nseg2, nsen1,nsen2,nsen3
       common /k_s_p/  se_sl,se_rl,sfact_kr
       common /hyst_p/ e_r,b_a,sp_min,sr_min,factd,facti,nhyst
       common/ksp/       swt_c,sgt_c,snt_c, nhc_w,nhc_t
c
c
c-----------------------------------------------------------------
       dimension  sb_w(mnode_g,mloop),sb_t(mnode_g,mloop),
     &            ss_w(mnode_g,mloop),ss_t(mnode_g,mloop),
     &            sr_w(mnode_g,mloop),sr_t(mnode_g,mloop),
     &            a_w(mnode_g,mloop), a_t(mnode_g,mloop)
c trapping definition
       dimension  sw_mx(mnode_g), sg_mx(mnode_g), sn_mx(mnode_g),
     &            swt_mx(mnode_g),sgt_mx(mnode_g),snt_mx(mnode_g),
     &            swt_mn(mnode_g),sgt_mn(mnode_g),snt_mn(mnode_g)
c
       common/hyst/       sb_w,sr_w,ss_w,a_w,
     &                    sb_t,sr_t,ss_t,a_t,
     &                    sw_mx,sg_mx,sn_mx,
     &                    swt_mx,sgt_mx,snt_mx,
     &                    swt_mn,sgt_mn,snt_mn
c
c system of equations
       dimension  ri(meq_s), iwork(leniw), rwork(lenw), ai(mme_s)
       dimension sg_tmp(mnode_g,8), sol_g(meq_s)
       dimension sw_tmp(mnode_g,8), sol_w(meq_s)
c indexing vectors
       dimension inod(8), n_eq(8)
c
       common/solve/       ai,ri,rwork,iwork,inod,n_eq
       common/temp/       sol_w, sol_g, sw_tmp, sg_tmp
c
