C     Last change:  JG   20 Nov 1998   10:31 am
c SUBROUTINES IN THIS FILE:
c
c subroutine mbal - compute the mass in the systen by performing
c                   3-D gauss quadrature on solution
c subroutine pore_vol - compute the pore volume in the domain.
c subroutine mbalb - compute the change in mass over the 
c                    boundaries over the time step
c
c##################################################################
      subroutine mbal(tmoa,tmwa,tmon,tmog,tmgg)
c
c program to perform 3-D gauss quadrature 
c      uses 8 points (2 in each dimension)
c intrgrates soln. over domain to find area under curve
c this is the amount of fluid mass in the domain
c
        include 'include.f'
c
        dimension na(8),rog(8)
        dimension roa(8),sw(8),ppor(8),st(8)
c
         tmwa = 0.d0
         tmoa = 0.d0
         tmon = 0.d0
         tmgg = 0.d0
         tmog = 0.d0
c
c----------------------------------------------------------------
c everything is set up for the integration
c loop through the elements, and for each element integrate
c the nodal soln.  this gives the concentration in a given element   
c its a normal mass balance calaulation- find the area under the curve
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
         	     kelem = 1
c
c loop through the elements (y then x then z)
      do 20 l = 1, nez
        do 30 n = 1, nex
          do 40 m = 1, ney
c
c calc the solution at the gauss points
c initialize
	   do 170 kh = 1, 8
c
	      roa(kh)  = 0.d0
	      rog(kh)  = 0.d0
	       sw(kh)  = 0.d0
	       st(kh)  = 0.d0
	      ppor(kh) = 0.d0
c
  170     continue
c
c what are the nodes associated with this element
	      na(1) = nel(kelem,1)
	      na(2) = nel(kelem,2)
	      na(3) = nel(kelem,3)
	      na(4) = nel(kelem,4)
	      na(5) = nel(kelem,5)
	      na(6) = nel(kelem,6)
	      na(7) = nel(kelem,7)
	      na(8) = nel(kelem,8)
c
c loop through 
c       nodes
	do 50 j = 1, 8
c       collocation points
          do 180 ir = 1, 8

	       ppor(ir) = ppor(ir) + por(na(j))*b1(ir,j)
      IF(i_og.eq.1)
     & rog(ir)=rog(ir) +rog11(na(j),1)*b3(ir,j,1)
     &                +rog11(na(j),2)*b3(ir,j,2)*dx(n)/2.d0
     &                +rog11(na(j),3)*b3(ir,j,3)*dy(m)/2.d0
     &                +rog11(na(j),4)*b3(ir,j,4)*dz(l)/2.d0
     &                +rog11(na(j),5)*b3(ir,j,5)*dx(n)*dy(m)/4.d0
     &                +rog11(na(j),6)*b3(ir,j,6)*dx(n)*dz(l)/4.d0
     &                +rog11(na(j),7)*b3(ir,j,7)*dy(m)*dz(l)/4.d0
     &                +rog11(na(j),8)*b3(ir,j,8)*dx(n)*dy(m)*dz(l)/8.d0
c
      IF(i_ow.eq.1)
     & roa(ir)=roa(ir) +roa11(na(j),1)*b3(ir,j,1)
     &                +roa11(na(j),2)*b3(ir,j,2)*dx(n)/2.d0
     &                +roa11(na(j),3)*b3(ir,j,3)*dy(m)/2.d0
     &                +roa11(na(j),4)*b3(ir,j,4)*dz(l)/2.d0
     &                +roa11(na(j),5)*b3(ir,j,5)*dx(n)*dy(m)/4.d0
     &                +roa11(na(j),6)*b3(ir,j,6)*dx(n)*dz(l)/4.d0
     &                +roa11(na(j),7)*b3(ir,j,7)*dy(m)*dz(l)/4.d0
     &                +roa11(na(j),8)*b3(ir,j,8)*dx(n)*dy(m)*dz(l)/8.d0
c
       st(ir)= st(ir) + st11(na(j),1)*b3(ir,j,1)
     &                + st11(na(j),2)*b3(ir,j,2)*dx(n)/2.d0
     &                + st11(na(j),3)*b3(ir,j,3)*dy(m)/2.d0
     &                + st11(na(j),4)*b3(ir,j,4)*dz(l)/2.d0
     &                + st11(na(j),5)*b3(ir,j,5)*dx(n)*dy(m)/4.d0
     &                + st11(na(j),6)*b3(ir,j,6)*dx(n)*dz(l)/4.d0
     &                + st11(na(j),7)*b3(ir,j,7)*dy(m)*dz(l)/4.d0
     &                + st11(na(j),8)*b3(ir,j,8)*dx(n)*dy(m)*dz(l)/8.d0
c
       sw(ir)= sw(ir) + sw11(na(j),1)*b3(ir,j,1)
     &                + sw11(na(j),2)*b3(ir,j,2)*dx(n)/2.d0
     &                + sw11(na(j),3)*b3(ir,j,3)*dy(m)/2.d0
     &                + sw11(na(j),4)*b3(ir,j,4)*dz(l)/2.d0
     &                + sw11(na(j),5)*b3(ir,j,5)*dx(n)*dy(m)/4.d0
     &                + sw11(na(j),6)*b3(ir,j,6)*dx(n)*dz(l)/4.d0
     &                + sw11(na(j),7)*b3(ir,j,7)*dy(m)*dz(l)/4.d0
     &                + sw11(na(j),8)*b3(ir,j,8)*dx(n)*dy(m)*dz(l)/8.d0
c
  180     continue
   50   continue
c
c
c volume of this element
c
         volume = dx(n)*dy(m)*dz(l)/8.d0
c
c mass integrated over the 8 Gauss points in the element
c the summed integration
c
      do 92 k = 1, 8
c
c             mass fraction of water in aqueous phase
                  call water_prop (roa(k),rwa,dww,visw)
                  call   gas_prop (rog(k),rgg,dgg,visg)
c
        tmwa = tmwa + rwa    * sw(k)         * ppor(k) * volume    
c
        tmoa = tmoa + roa(k) * sw(k)         * ppor(k) * volume    
c
        tmon = tmon + rn_r   * (st(k)-sw(k)) * ppor(k) * volume    
c
        tmgg = tmgg + rg_r   * (1.d0 - st(k)) *ppor(k) * volume
c
        tmog = tmog + rog(k) * (1.d0 - st(k))* ppor(k) * volume    
c
   92   continue
c-------------------------------------------------------------------
c
      kelem = kelem + 1
c
   40     continue
   30   continue
   20 continue
c
                                                return
	                                        end
c
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
c
      subroutine pore_vol (pv)
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
c program to perform 3-D gauss quadrature 
c      uses 8 points (2 in each dimension)
c intrgrates soln. over domain to find area under curve
c this is the pore volume in the domain
c
        include 'include.f'
c
	dimension na(8),ppor(8)
c
	pv =  0.d0   
c
c----------------------------------------------------------------
c everything is set up for the integration
c loop through the elements, and for each element integrate
c the nodal soln.  this gives the concentration in a given element   
c its a normal mass balance calaulation- find the area under the curve
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
         	     kelem = 1
c
c loop through the elements (y then x then z)
      do 20 l = 1, nez
        do 30 n = 1, nex
          do 40 m = 1, ney
c
c calc the solution at the gauss points
c initialize
	   do 170 kh = 1, 8
c
	      ppor(kh) = 0.d0
c
  170     continue
c
c what are the nodes associated with this element
	      na(1) = nel(kelem,1)
	      na(2) = nel(kelem,2)
	      na(3) = nel(kelem,3)
	      na(4) = nel(kelem,4)
	      na(5) = nel(kelem,5)
	      na(6) = nel(kelem,6)
	      na(7) = nel(kelem,7)
	      na(8) = nel(kelem,8)
c
	do 51 j = 1, 8
          do 181 ir = 1, 8
c
	       ppor(ir) = ppor(ir) + por(na(j))*b1(ir,j)
c
  181   continue
   51     continue
c
c volume of this element
c
         volume = dx(n)*dy(m)*dz(l)/8.d0
c
c pore volume integrated over the 8 Gauss points in the element
c the summed integration
c
      do 92 k = 1, 8
c
        pv = pv + ppor(k)*volume   
c
   92   continue
c
c
      kelem = kelem + 1
c
   40     continue
   30   continue
   20 continue
c
c
                                                   return
	                                           end
c
c====================================================================
      subroutine mbalb(flxowa,flxiwa,flxoon,flxion,flxooa,flxioa,
     &                 flxoog,flxiog,flxogg,flxigg)
c====================================================================
c
c CALCULATE THE MASS OVER EACH BOUNDARY PLANE
c
c Given the normal component of velocity at each boundary node, 
c multiply it by the mass at that node and the planar area associated 
c  with the node:
c area = the sum of 1/4 the element areas in the plane associated 
c  with the node
c
        include 'include.f'
c
c
c the mass in and out for the different species for this time step
         flxowa=0.d0
         flxiwa=0.d0
           flxoon=0.d0
           flxion=0.d0
         flxooa=0.d0
         flxioa=0.d0
           flxogg=0.d0
           flxigg=0.d0
         flxoog=0.d0
         flxiog=0.d0
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c yx-face, normal is z. find row and column- dx and dy at node
c
          jj = 0
      do 1  i = 1, 2
        do 2  j = 0, nny*nex, nny
          do 3  k = 1, nny
c
        if( ib_yx(j+k,i).eq. 5  )   then
c
c            global node number    
               nod = jj + j + k        
c
c
c clac the 
c                    row (x-axis), 
c                    col (y-axis), 
c                    page (z-axis) 
c of the source node
                  npg = nod/(nny*nnx)
                  if(nnx*nny*npg.lt.nod)  npg = npg + 1
c
                  nco = ( nod - (npg-1)*nnx*nny ) / nny
                  if(nny*nco.lt.(nod-(npg-1)*nnx*nny))  nco = nco + 1
c
                  nro = nny - (nny*nco - ( nod - (npg-1)*nnx*nny ))
c
                 if(nco.eq.1)then
                     ddx = dx(1)/2.d0
                 else if(nco.eq.nnx)then
                     ddx = dx(nex)/2.d0
                 else
                     ddx = dx(nco)/2.d0 + dx(nco-1)/2.d0
                 endif
c
                 if(nro.eq.1)then
                     ddy = dy(1)/2.d0
                 else if(nro.eq.nny)then
                     ddy = dy(ney)/2.d0
                 else
                     ddy = dy(nro)/2.d0 + dy(nro-1)/2.d0
                 endif
c
          IF(i_ow.eq.1) then
            call water_prop (roa11(nod,1),wa,dww,visw)
            call disp_w (nod, dspxw,dspyw,dspzw,dspxyw, dspxzw, dspyzw)
            flxoa =  dt*(roa11(nod,1)*vwz(nod)
     &              - (dspzw + dspxzw + dspyzw)
     &              * roa11(nod,4)) *ddx*ddy
          else
            call water_prop (0.d0,wa,dww,visw)
            flxoa =  0.d0
          endif
          IF(i_og.eq.1) then
            call   gas_prop (rog11(nod,1),gg,dgg,visg)
            call disp_g (nod, dspxg,dspyg,dspzg,dspxyg, dspxzg, dspyzg)
            flxog =  dt*(rog11(nod,1)*vgz(nod)
     &              - (dspzg + dspxzg + dspyzg)
     &              * rog11(nod,4)) *ddx*ddy
          else
            call   gas_prop (0.d0,gg,dgg,visg)
            flxog =  0.d0
          endif
                   vnz = vtz(nod) - vwz(nod) - vgz(nod)
c
                   flxwa =  dt* wa * vwz(nod) * ddx*ddy
                   flxgg =  dt* gg * vgz(nod) * ddx*ddy
                   flxon =  dt*rn_r* vnz      * ddx*ddy
c
               if(i .eq. 1) then
                if(flxwa.lt.0.d0) then
                   flxowa = flxowa + dabs(flxwa)
                 else
                   flxiwa = flxiwa + dabs(flxwa)
                 endif
                    if(flxgg.lt.0.d0) then
                      flxogg = flxogg + dabs(flxgg)
                    else
                      flxigg = flxigg + dabs(flxgg)
                    endif
                       if(flxoa.lt.0.d0) then
                         flxooa = flxooa + dabs(flxoa)
                       else
                         flxioa = flxioa + dabs(flxoa)
                       endif
                          if(flxon.lt.0.d0) then
                            flxoon = flxoon + dabs(flxon)
                          else
                            flxion = flxion + dabs(flxon)
                          endif
                             if(flxog.lt.0.d0) then
                               flxoog = flxoog + dabs(flxog)
                             else
                               flxiog = flxiog + dabs(flxog)
                             endif
               else
                 if(flxwa.gt.0.d0) then
                   flxowa = flxowa + dabs(flxwa)
                 else
                   flxiwa = flxiwa + dabs(flxwa)
                 endif
                    if(flxoa.gt.0.d0) then
                      flxooa = flxooa + dabs(flxoa)
                    else
                      flxioa = flxioa + dabs(flxoa)
                    endif
                       if(flxon.gt.0.d0) then
                         flxoon = flxoon + dabs(flxon)
                       else
                         flxion = flxion + dabs(flxon)
                       endif
                          if(flxgg.gt.0.d0) then
                            flxogg = flxogg + dabs(flxgg)
                          else
                            flxigg = flxigg + dabs(flxgg)
                          endif
                               if(flxog.gt.0.d0) then
                               flxoog = flxoog + dabs(flxog)
                             else
                               flxiog = flxiog + dabs(flxog)
                             endif
               endif
        endif
c
    3     continue
    2   continue
                      jj = nnx*nny*nez
    1 continue
c
c
c yz-face, normal is x. find row and page- dz and dy at node
c
          jj = 0
      do 21  i = 1, 2
        do 22  j = 0, nny*nez, nny
          do 23  k = 1, nny
c
        if( ib_yz(j+k,i).eq. 1  )   then
c
c            global node number
               nod = k + j*nnx + jj
c
c clac the
c                    row (x-axis), 
c                    col (y-axis), 
c                    page (z-axis) 
c of the source node
                  npg = nod/(nny*nnx)
                  if(nnx*nny*npg.lt.nod)  npg = npg + 1
c
                  nco = ( nod - (npg-1)*nnx*nny ) / nny
                  if(nny*nco.lt.(nod-(npg-1)*nnx*nny))  nco = nco + 1
c
                  nro = nny - (nny*nco - ( nod - (npg-1)*nnx*nny ))
c
                 if(nro.eq.1)then
                     ddy = dy(1)/2.d0
                 else if(nro.eq.nny)then
                     ddy = dy(ney)/2.d0
                 else
                     ddy = dy(nro)/2.d0 + dy(nro-1)/2.d0
                 endif
c
                 if(npg.eq.1)then
                     ddz = dz(1)/2.d0
                 else if(npg.eq.nnz)then
                     ddz = dz(nez)/2.d0
                 else
                     ddz = dz(npg)/2.d0 + dz(npg-1)/2.d0
                 endif
c
          IF(i_ow.eq.1) then
            call water_prop (roa11(nod,1),wa,dww,visw)
            call disp_w (nod, dspxw,dspyw,dspzw,dspxyw, dspxzw, dspyzw)
                   flxoa =  dt*(roa11(nod,1)*vwx(nod)
     &                      - (dspxw + dspxyw + dspxzw)
     &                       *roa11(nod,2)) *ddz*ddy
          else
            call water_prop (0.d0,wa,dww,visw)
            flxoa =  0.d0
          endif
          IF(i_og.eq.1) then
            call   gas_prop (rog11(nod,1),gg,dgg,visg)
            call disp_g (nod, dspxg,dspyg,dspzg,dspxyg, dspxzg, dspyzg)
                   flxog =  dt*(rog11(nod,1)*vgx(nod)
     &                      - (dspxg + dspxyg + dspxzg)
     &                       *rog11(nod,2)) *ddz*ddy
          else
            call   gas_prop (0.d0,gg,dgg,visg)
            flxog =  0.d0
          endif
                   vnx = vtx(nod) - vgx(nod) - vwx(nod)
c
                   flxwa =  dt* wa * vwx(nod) *ddz*ddy
                   flxgg =  dt* gg * vgx(nod) *ddz*ddy
                   flxon =  dt*rn_r* vnx      *ddz*ddy
c
               if(i .eq. 1) then
                if(flxwa.lt.0.d0) then
                   flxowa = flxowa + dabs(flxwa)
                 else
                   flxiwa = flxiwa + dabs(flxwa)
                 endif
                    if(flxgg.lt.0.d0) then
                      flxogg = flxogg + dabs(flxgg)
                    else
                      flxigg = flxigg + dabs(flxgg)
                    endif
                       if(flxoa.lt.0.d0) then
                         flxooa = flxooa + dabs(flxoa)
                       else
                         flxioa = flxioa + dabs(flxoa)
                       endif
                          if(flxon.lt.0.d0) then
                            flxoon = flxoon + dabs(flxon)
                          else
                            flxion = flxion + dabs(flxon)
                          endif
                             if(flxog.lt.0.d0) then
                               flxoog = flxoog + dabs(flxog)
                             else
                               flxiog = flxiog + dabs(flxog)
                             endif
               else
                 if(flxwa.gt.0.d0) then
                   flxowa = flxowa + dabs(flxwa)
                 else
                   flxiwa = flxiwa + dabs(flxwa)
                 endif
                    if(flxoa.gt.0.d0) then
                      flxooa = flxooa + dabs(flxoa)
                    else
                      flxioa = flxioa + dabs(flxoa)
                    endif
                       if(flxon.gt.0.d0) then
                         flxoon = flxoon + dabs(flxon)
                       else
                         flxion = flxion + dabs(flxon)
                       endif
                          if(flxgg.gt.0.d0) then
                            flxogg = flxogg + dabs(flxgg)
                          else
                            flxigg = flxigg + dabs(flxgg)
                          endif
                                if(flxog.gt.0.d0) then
                               flxoog = flxoog + dabs(flxog)
                             else
                               flxiog = flxiog + dabs(flxog)
                             endif
               endif
        endif
c
   23     continue
   22   continue
                      jj = nny*nex
   21 continue
c
c xz-face, normal is y. find column and page- dz and dx at node
c
          jj = 0
      do 11  i = 1, 2
        do 12  j = 0, nnx*nez, nnx
          do 13  k = 1, nnx
c
        if( ib_xz(j+k,i).eq. 5  )   then
c
c            global node number
               nod = (k-1)*nny + j*nny + jj + 1
c
c clac the
c                    row (x-axis), 
c                    col (y-axis), 
c                    page (z-axis) 
c of the source node
                  npg = nod/(nny*nnx)
                  if(nnx*nny*npg.lt.nod)  npg = npg + 1
c
                  nco = ( nod - (npg-1)*nnx*nny ) / nny
                  if(nny*nco.lt.(nod-(npg-1)*nnx*nny))  nco = nco + 1
c
                  nro = nny - (nny*nco - ( nod - (npg-1)*nnx*nny ))
                 if(npg.eq.1)then
                     ddz = dz(1)/2.d0
                 else if(npg.eq.nnz)then
                     ddz = dz(nez)/2.d0
                 else
                     ddz = dz(npg)/2.d0 + dz(npg-1)/2.d0
                 endif
c
                 if(nco.eq.1)then
                     ddx = dx(1)/2.d0
                 else if(nco.eq.nnx)then
                     ddx = dx(nex)/2.d0
                 else
                     ddx = dx(nco)/2.d0 + dx(nco-1)/2.d0
                 endif
c
          IF(i_ow.eq.1) then
            call water_prop (roa11(nod,1),wa,dww,visw)
            call disp_w (nod, dspxw,dspyw,dspzw,dspxyw, dspxzw, dspyzw)
                   flxoa =  dt*(roa11(nod,1)*vwy(nod)
     &                      - (dspxyw + dspyw + dspyzw)
     *                      * roa11(nod,3)) *ddz*ddx
          else
            call water_prop (0.d0,wa,dww,visw)
            flxoa =  0.d0
          endif
          IF(i_og.eq.1) then
            call   gas_prop (rog11(nod,1),gg,dgg,visg)
            call disp_g (nod, dspxg,dspyg,dspzg,dspxyg, dspxzg, dspyzg)
                   flxog =  dt*(rog11(nod,1)*vgy(nod)
     &                      - (dspxyg + dspyg + dspyzg)
     *                      * rog11(nod,3)) *ddz*ddx
          else
            call   gas_prop (0.d0,gg,dgg,visg)
            flxog =  0.d0
          endif
                   vny = vty(nod) - vgy(nod) - vwy(nod)

                   flxwa =  dt* wa* vwy(nod)* ddz*ddx
                   flxgg =  dt* gg* vgy(nod)* ddz*ddx
                   flxon =  dt*rn_r*vny     * ddz*ddx
c
               if(i .eq. 1) then
                if(flxwa.lt.0.d0) then
                   flxowa = flxowa + dabs(flxwa)
                 else
                   flxiwa = flxiwa + dabs(flxwa)
                 endif
                    if(flxgg.lt.0.d0) then
                      flxogg = flxogg + dabs(flxgg)
                    else
                      flxigg = flxigg + dabs(flxgg)
                    endif
                       if(flxoa.lt.0.d0) then
                         flxooa = flxooa + dabs(flxoa)
                       else
                         flxioa = flxioa + dabs(flxoa)
                       endif
                          if(flxon.lt.0.d0) then
                            flxoon = flxoon + dabs(flxon)
                          else
                            flxion = flxion + dabs(flxon)
                          endif
                             if(flxog.lt.0.d0) then
                               flxoog = flxoog + dabs(flxog)
                             else
                               flxiog = flxiog + dabs(flxog)
                             endif
               else
                 if(flxwa.gt.0.d0) then
                   flxowa = flxowa + dabs(flxwa)
                 else
                   flxiwa = flxiwa + dabs(flxwa)
                 endif
                    if(flxoa.gt.0.d0) then
                      flxooa = flxooa + dabs(flxoa)
                    else
                      flxioa = flxioa + dabs(flxoa)
                    endif
                       if(flxon.gt.0.d0) then
                         flxoon = flxoon + dabs(flxon)
                       else
                         flxion = flxion + dabs(flxon)
                       endif
                          if(flxgg.gt.0.d0) then
                            flxogg = flxogg + dabs(flxgg)
                          else
                            flxigg = flxigg + dabs(flxgg)
                          endif
                                if(flxog.gt.0.d0) then
                               flxoog = flxoog + dabs(flxog)
                             else
                               flxiog = flxiog + dabs(flxog)
                             endif
               endif
        endif
c
   13     continue
   12   continue
                      jj = ney
   11 continue
c
                                          return
                                          end