C     Last change:  JG   21 Jan 2000    8:19 am
c SUBROUTINES IN THIS FILE:
c
c subroutine mp_diff - routine to calculate the diffusion term 
c subroutine dt_cntrl - time step control
c
c ####################################
        subroutine mp_diff
c ####################################
c
c
c routine to calculate the diffusion term for 
c the St equation, defined as the max of
c the physical value and the Peclet constrained
c value 
c do this at each node 
c
        include 'include.f'
c
c      open (66, file='pe.out')
c
                dt_crit = tsmx
                ecrit = 1.d-15
c
       do 401 i = 1, nn
c
c given the node, i, figure out the row, column, and page
c
                npg = i/(nny*nnx)
           if(nnx*nny*npg.lt.i)  npg = npg + 1
c
                nco = ( i - (npg-1)*nnx*nny ) / nny
           if(nny*nco.lt.(i-(npg-1)*nnx*nny))  nco = nco + 1
c
                nro = nny - (nny*nco - ( i - (npg-1)*nnx*nny ))
c
c         find the max spacing about this node i 
                 if(nco.eq.1)then
                     dxm = dx(1)
                 else if(nco.eq.nnx)then
                     dxm = dx(nex)
                 else if(dx(nco).gt.dx(nco-1) ) then
                     dxm = dx(nco)
                 else
                     dxm = dx(nco-1)
                 endif
c
                 if(nro.eq.1)then
                     dym = dy(1)
                 else if(nro.eq.nny)then
                     dym = dy(ney)
                 else if(dy(nro).gt.dy(nro-1))  then
                     dym = dy(nro)
                 else   
                     dym = dy(nro-1)
                 endif
c
                 if(npg.eq.1)then
                     dzm = dz(1)
                 else if(npg.eq.nnz)then
                     dzm = dz(nez)
                 else if(dz(npg).gt.dz(npg-1))  then
                     dzm = dz(npg)
                 else 
                     dzm = dz(npg-1)
                 endif
c
c compute the actual diffusion terms
       IF(i_ow.eq.1) then
         call  water_prop (roa11(i,1),wa,rw,vw)
       else
         call  water_prop (0.d0,wa,rw,vw)
       endif
       IF(i_og.eq.1) then
         call  gas_prop   (rog11(i,1),gg,rg,vg)
       else
         call  gas_prop   (0.d0,gg,rg,vg)
       endif
c
c compute the actual diffusion terms
        tot_mob =  rpg(i)/vg  + rpa(i)/vw + rpn(i)/vn_r 
             rpw      =  perm(i)* rpa(i)/vw
             rpv      =  perm(i)* rpg(i)/vg 
             rpo      =  perm(i)* rpn(i)/vn_r  
c
         f_w = rpa(i)/vw   / tot_mob
         f_g = rpg(i)/vg   / tot_mob
         f_n = rpn(i)/vn_r / tot_mob
c
         h_gw(i)  =  1.d0
         h_nw(i)  =  1.d0
         h_gn(i)  =  1.d0
         co_c     =  0.d0
c
         vt_x = vtx(i) 
         vt_y = vty(i)
         vt_z = vtz(i)
c
c determine the value of the diffusion term based on Peclet
c
         call dfds3 (dfww,dfwg,dfgg,dfgw,dfnw,dfng,
     &               dfwgw,dfwgg,dfwnw,dfgng,i)
c
c********************************
       if(rpw.gt.ecrit .and. rpv.gt.ecrit .and. rpo.gt.ecrit ) then
c
c 3-phase interactions
c look at total wetting vs total nonwetting:
c
        t_x = dabs(vt_x*dfww + grav*dcos(th_z)*dcos(th_y)*perm(i)*
     &                  ( dfwgw*(rw-rg) + dfwnw*(rw-rn_r) ) )
        t_y = dabs( vt_y*dfww - grav*dsin(th_z) * perm(i) *
     &                  ( dfwgw*(rw-rg) + dfwnw*(rw-rn_r) ) )
        t_z = dabs(vt_z*dfww + grav*dcos(th_z)*dsin(th_y)*perm(i)*
     &                  ( dfwgw*(rw-rg) + dfwnw*(rw-rn_r) ) )
c
        p_w = max(dxm*t_x, dym*t_y, dzm*t_z)
        c_w = dt*max(t_x/dxm, t_y/dym, t_z/dzm)
c
        t_x = dabs(vt_x*dfgg - grav*dcos(th_z)*dcos(th_y)*perm(i)*
     &                  ( dfwgg*(rw-rg) + dfgng*(rn_r-rg) ) )
        t_y = dabs( vt_y*dfgg + grav*dsin(th_z) * perm(i) *
     &                  ( dfwgg*(rw-rg) + dfgng*(rn_r-rg) ) )
        t_z = dabs(vt_z*dfgg - grav*dcos(th_z)*dsin(th_y)*perm(i)*
     &                  ( dfwgg*(rw-rg) + dfgng*(rn_r-rg) ) )
c
        p_g = max(dxm*t_x, dym*t_y, dzm*t_z)
        c_g = dt*max(t_x/dxm, t_y/dym, t_z/dzm)
c
             pe_ww =  - p_w/(dpcnw(i)*f_w*(rpo + rpv*(b_nw/b_gw)))
             pe_gg =  - p_g/(dpcgn(i)*f_g*(rpo + rpw*(b_gn/b_gw)))
c--------------------------
c Pe based of 'f'
        pe_w1 = max( dabs((dfww*sw11(i,2) + dfwg*st11(i,2)))*dxm,
     &               dabs((dfww*sw11(i,3) + dfwg*st11(i,3)))*dym,
     &               dabs((dfww*sw11(i,4) + dfwg*st11(i,4)))*dzm )/f_w
c
        pe_g1 = max( dabs((dfgw*sw11(i,2) + dfgg*st11(i,2)))*dxm,
     &               dabs((dfgw*sw11(i,3) + dfgg*st11(i,3)))*dym,
     &               dabs((dfgw*sw11(i,4) + dfgg*st11(i,4)))*dzm )/f_g
c
        pe_n1 = max( dabs((dfnw*sw11(i,2) + dfng*st11(i,2)))*dxm,
     &               dabs((dfnw*sw11(i,3) + dfng*st11(i,3)))*dym,
     &               dabs((dfnw*sw11(i,4) + dfng*st11(i,4)))*dzm )/f_n
c--------------------------
c
          if( f_g .gt. f_w )             then
              h_nw(i) = max( 1.d0, pe_ww/pe_w , pe_w1/pe_w  )
              h_gn(i) = max( 1.d0, pe_gg/pe_g , pe_g1/pe_g, pe_n1/pe_g )
              h_gw(i) = h_nw(i)
          else
              h_nw(i) = max( 1.d0, pe_ww/pe_w , pe_w1/pe_w, pe_n1/pe_w )
              h_gn(i) = max( 1.d0, pe_gg/pe_g , pe_g1/pe_g  )
              h_gw(i) = h_gn(i)
          endif
c
c Courant
             co_c = max(c_w, c_g)
c--------------------------
       else if(rpw.gt.ecrit .and. rpv.gt.ecrit )      then
c--------------------------
c W-G     interactions
c--------------------------
        g_x = dabs(vt_x*dfgg - grav*dcos(th_z)*dcos(th_y)*perm(i)*
     &                  dfwgg*(rw-rg) )
        g_y = dabs( vt_y*dfgg + grav*dsin(th_z) * perm(i) *
     &                  dfwgg*(rw-rg) )
        g_z = dabs(vt_z*dfgg - grav*dcos(th_z)*dsin(th_y)*perm(i)*
     &                  dfwgg*(rw-rg) )
c
        w_x = dabs(vt_x*dfww + grav*dcos(th_z)*dcos(th_y)*perm(i)*
     &                  dfwgw*(rw-rg) )
        w_y = dabs( vt_y*dfww - grav*dsin(th_z) * perm(i) *
     &                  dfwgw*(rw-rg) )
        w_z = dabs(vt_z*dfww + grav*dcos(th_z)*dsin(th_y)*perm(i)*
     &                  dfwgw*(rw-rg) )
c
            dpcgw = -max(dpcnw(i)*(b_nw/b_gw), dpcgn(i)*(b_gn/b_gw) )
c--------------------------
             pe_ww =  max(dxm*w_x,dym*w_y,dzm*w_z)/( dpcgw*f_w*rpv )
             pe_gg =  max(dxm*g_x,dym*g_y,dzm*g_z)/( dpcgw*f_g*rpw )
c--------------------------
c Pe based of 'f'
        pe_w1 = max( dabs((dfww*sw11(i,2) + dfwg*st11(i,2)))*dxm,
     &               dabs((dfww*sw11(i,3) + dfwg*st11(i,3)))*dym,
     &               dabs((dfww*sw11(i,4) + dfwg*st11(i,4)))*dzm )/f_w
c
        pe_g1 = max( dabs((dfgw*sw11(i,2) + dfgg*st11(i,2)))*dxm,
     &               dabs((dfgw*sw11(i,3) + dfgg*st11(i,3)))*dym,
     &               dabs((dfgw*sw11(i,4) + dfgg*st11(i,4)))*dzm )/f_g
c
        pe_n1 = 0.d0
c--------------------------
              h_gw(i) = max(1.d0,pe_gg/pe_g, pe_ww/pe_w ,
     &                          pe_g1/pe_g, pe_w1/pe_w )
c Courant
             co_c = dt*max(w_x/dxm, w_y/dym, w_z/dzm, 
     &                     g_x/dxm, g_y/dym, g_z/dzm)
c--------------------------
c
       else if(rpw.gt.ecrit .and. rpo.gt.ecrit )      then
c--------------------------
c W-N     interactions
c--------------------------
c
        w_x = dabs(vt_x*dfww + grav*dcos(th_z)*dcos(th_y)*perm(i)*
     &                   dfwnw*(rw-rn_r) )
        w_y = dabs( vt_y*dfww - grav*dsin(th_z) * perm(i) *
     &                   dfwnw*(rw-rn_r) ) 
        w_z = dabs(vt_z*dfww + grav*dcos(th_z)*dsin(th_y)*perm(i)*
     &                   dfwnw*(rw-rn_r) ) 
c
c--------------------------
             pe_ww =  -max(dxm*w_x,dym*w_y,dzm*w_z)/(f_w*rpo*dpcnw(i))
             pe_gg =   0.d0
c--------------------------
c Pe based of 'f'
        pe_w1 = max( dabs((dfww*sw11(i,2) + dfwg*st11(i,2)))*dxm,
     &               dabs((dfww*sw11(i,3) + dfwg*st11(i,3)))*dym,
     &               dabs((dfww*sw11(i,4) + dfwg*st11(i,4)))*dzm )/f_w
c
        pe_n1 = max( dabs((dfnw*sw11(i,2) + dfng*st11(i,2)))*dxm,
     &               dabs((dfnw*sw11(i,3) + dfng*st11(i,3)))*dym,
     &               dabs((dfnw*sw11(i,4) + dfng*st11(i,4)))*dzm )/f_n
c
        pe_g1 = 0.d0
c--------------------------
            h_nw(i) = max( 1.d0, pe_ww/pe_w, pe_w1/pe_w, pe_n1/pe_w  )
c Courant
             co_c = dt*max(w_x/dxm, w_y/dym, w_z/dzm) 
c--------------------------
c
       else if(rpv.gt.ecrit .and. rpo.gt.ecrit )      then
c--------------------------
c G-N     interactions
c--------------------------
c
        g_x = dabs(vt_x*dfgg - grav*dcos(th_z)*dcos(th_y)*perm(i)*
     &                  dfgng*(rn_r-rg) ) 
        g_y = dabs( vt_y*dfgg + grav*dsin(th_z) * perm(i) *
     &                  dfgng*(rn_r-rg) ) 
        g_z = dabs(vt_z*dfgg - grav*dcos(th_z)*dsin(th_y)*perm(i)*
     &                  dfgng*(rn_r-rg) ) 
c
c--------------------------
             pe_gg =  -max(dxm*g_x,dym*g_y,dzm*g_z)/(f_g*rpo*dpcgn(i))
             pe_ww =   0.d0
c--------------------------
c Pe based of 'f'
        pe_g1 = max( dabs((dfgw*sw11(i,2) + dfgg*st11(i,2)))*dxm,
     &               dabs((dfgw*sw11(i,3) + dfgg*st11(i,3)))*dym,
     &               dabs((dfgw*sw11(i,4) + dfgg*st11(i,4)))*dzm )/f_g
c
        pe_n1 = max( dabs((dfnw*sw11(i,2) + dfng*st11(i,2)))*dxm,
     &               dabs((dfnw*sw11(i,3) + dfng*st11(i,3)))*dym,
     &               dabs((dfnw*sw11(i,4) + dfng*st11(i,4)))*dzm )/f_n
c
        pe_w1 = 0.d0
c--------------------------
             h_gn(i) = max( 1.d0, pe_gg/pe_g, pe_g1/pe_g, pe_n1/pe_g  )
c Courant
             co_c = dt*max(g_x/dxm, g_y/dym, g_z/dzm) 
c--------------------------
c
       endif
c
c              sg = 1.d0 - st11(i,1)
c              sn = st11(i,1) - sw11(i,1)
c        write(66,52) i, h_nw(i), h_gn(i), h_gw(i), sw11(i,1),sn,sg,
c    &               co_c
c
c********************************
c COURANT
               if(co_c.gt.co) then
                      dt_crit = min(dt_crit, dt*co/co_c)
               endif
c
c
  401  continue
   52  format(i5, 3(0pe10.3), 3(f8.4), 1x,f8.4 )
c                          close (66)
c
                                  return
                                  end
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        subroutine dt_cntrl 
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c
c
c routine to calculate the next time step based on 
c           1. number if iterations
c           2. Courant Constraint
c
        include 'include.f'
c      open (67, file='co.out')
c
c increase or reduce dt based on number of iterations
c
       if(itg_dt.gt.itreds .or. itoa_dt.gt.itredc
     &  .or. itw_dt.gt.itreds .or. itog_dt.gt.itredc) then
c
c             too many overall iterations so reduce time step
                 dt = dt/tdiv
                   if (dt.lt.tsmin) then
                       write(6,*) '***CRASH due to time step cut'
                       write(6,*) 'time                ',time
                       stop
                   endif
c
        else if(itg_dt.lt.itincs .and. itoa_dt.lt.itincc
     &  .and. itw_dt.lt.itincs .and. itog_dt.lt.itincc) then
c
c             increment time step
                dt = dt*tmult
                if(dt.gt.tsmx) dt = tsmx
        endif
c determine dt based on Courant number
               if(dt_crit.lt.dt ) then
                      dt = dt_crit
                   if (dt.lt.tsmin) then
                       write(6,*) '***CRASH due to time step cut'
                       write(6,*) 'Courant Too Low'
                       write(6,*) 'Solution not written '        
                       write(6,*) 'time                ',time
                       stop
                   endif
               else  if (dt.lt.tsmin) then
                       write(6,*) '***CRASH due to time step cut'
                       write(6,*) 'Due to Iteration Chop'        
                       write(6,*) 'Solution not written '        
                       write(6,*) 'time                ',time
                       stop
               endif
c
                                  return
                                  end