C     Last change:  JG   20 Nov 1998    9:31 am
c##########################################################
	subroutine sub_def (nex, ney, nez,
     &                nn_sub_y, nn_sub_x, nn_sub_z, nn_sub,
     &                nequ ,ixyz, n_short, n_med, n_long ,norder)
c##########################################################
c
cc DOMAIN DEFINITION
c given: nex, ney, nez
c compute:
c     nn_sub_x - number of nodes in the domain in the x-direction
c     nn_sub_y - number of nodes in each subdomain in the y-direction 
c     nn_sub_z - number of nodes in each subdomain in the z-direction 
c     nn_sub   - number of nodes in each subdomain
c     nequ - number of unknowns in each subdomain after bc's removed
c     ixyz - defines node numbering based on shortest dimension first
c            = 1 is x-y-z numbering
c            = 2 is x-z-y numbering
c            = 3 is y-x-z numbering
c            = 4 is y-z-x numbering
c            = 5 is z-x-y numbering
c            = 6 is z-y-x numbering
c     norder() = map from shortest numbering direction first to y-x-z
c                numbering for an element for use in system matrix 
c                assembly
c
        parameter ( ipts = 8)
        integer norder(ipts)
        integer nex, ney, nez,
     &          nn_sub_y, nn_sub_x, nn_sub_z, nn_sub,
     &          nequ ,ixyz, n_short, n_med, n_long
c
          nn_sub_y = ney + 1
          nn_sub_x = nex + 1
          nn_sub_z = nez + 1
          nn_sub   = nn_sub_x*nn_sub_y*nn_sub_z
          nequ     = 8*(nn_sub_x - 1)*(nn_sub_y - 1)*(nn_sub_z - 1)
c
c          given the partition and the size of the subdomains
c          we want to number in the shortest dimension first
                       norder(1) = 1
                       norder(8) = 8
            if(nn_sub_y.le.nn_sub_x)  then
              if(nn_sub_y.le.nn_sub_z)  then
                if(nn_sub_x.le.nn_sub_z)  then
                   ixyz = 3
                   n_short = nn_sub_y
                   n_med   = nn_sub_x
                   n_long  = nn_sub_z
                       norder(2) = 2
                       norder(3) = 3
                       norder(4) = 4
                       norder(5) = 5
                       norder(6) = 6
                       norder(7) = 7
                else
                   ixyz = 4
                   n_short = nn_sub_y
                   n_med   = nn_sub_z
                   n_long  = nn_sub_x
                       norder(2) = 2
                       norder(3) = 5
                       norder(4) = 6
                       norder(5) = 3
                       norder(6) = 4
                       norder(7) = 7
                endif
              else
                   ixyz = 6
                   n_short = nn_sub_z
                   n_med   = nn_sub_y
                   n_long  = nn_sub_x
                       norder(2) = 5
                       norder(3) = 2
                       norder(4) = 6
                       norder(5) = 3
                       norder(6) = 7
                       norder(7) = 4
              endif
            else
              if(nn_sub_x.le.nn_sub_z)  then
                if(nn_sub_y.le.nn_sub_z)  then
                   ixyz = 1
                   n_short = nn_sub_x
                   n_med   = nn_sub_y
                   n_long  = nn_sub_z
                       norder(2) = 3
                       norder(3) = 2
                       norder(4) = 4
                       norder(5) = 5
                       norder(6) = 7
                       norder(7) = 6
                else
                   ixyz = 2
                   n_short = nn_sub_x
                   n_med   = nn_sub_z
                   n_long  = nn_sub_y
                       norder(2) = 3
                       norder(3) = 5
                       norder(4) = 7
                       norder(5) = 2
                       norder(6) = 4
                       norder(7) = 6
                endif
              else
                   ixyz = 5
                   n_short = nn_sub_z
                   n_med   = nn_sub_x
                   n_long  = nn_sub_y
                       norder(2) = 5
                       norder(3) = 3
                       norder(4) = 7
                       norder(5) = 2
                       norder(6) = 6
                       norder(7) = 4
              endif
            endif
c
                                           return 
                                           end
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
	subroutine point (mnode_s,npt_g_s, npt_s,
     &                    nnx,nny,ixyz,n_short,n_med,n_long)
c*********************************************************************
c
c set up pointer to map between x y and z nodal numberings
c for this rectangular mesh
c
c domain node numbering
c npt_s -- is an operator which eliminates domain numbering
c        direction (shortest directions first [SDF]) dependence
c  map any of the 6 general numbering combos into SDF
c       ***    (general numbering) => SDF    ***
c        Dimension (nn_sub,6)
c          column 1 is x-y-z numbering
c          column 2 is x-z-y numbering
c          column 3 is y-x-z numbering (input/output ordering)
c          column 4 is y-z-x numbering
c          column 5 is z-x-y numbering
c          column 6 is z-y-x numbering
c
c npt_g_s -- relates I/O numbering (y-x-z numbering) and
c            domain default numbering (shortest directions first)
c         map SDF to I/O
c         ***    SDF => I/O    ***
c            Dimension (nn_sub)
c
        parameter ( ndir = 6)
      integer nnx,nny,mnode_s,ixyz,n_short,n_med,n_long
      integer npt_s(mnode_s,ndir),  npt_g_s(mnode_s)
c%%%%%%
c generate npt_s and npt_g_s depending on domain default numbering
c%%%%%%
c for local domain vectors the numbering
c is by default first in the shortest dimension 
c
      if(ixyz.eq.1)  then
c            default domain ordering is x-y-z
c
c%%%%%%
c generate npt_s 
c%%%%%%
c 1.   x-y-z  => x-y-z
	             m = 0
	        do 3     i = 0, n_long-1  
	          do 2   j = 0, n_med-1 
	            do 1 k = 1, n_short   
c
                    m = m + 1
		     npt_s(m,1) = k + i*n_med*n_short + j*n_short
c
    1               continue
    2             continue
    3           continue
c
c 2.   x-z-y  => x-y-z
	             m = 0
	        do 13     i = 0, n_med-1  
	          do 12   j = 0, n_long-1 
	            do 11 k = 1, n_short   
c
                    m = m + 1
		     npt_s(m,2) = k + j*n_med*n_short + i*n_short
c
   11               continue
   12             continue
   13           continue
c
c 3. y-x-z => x-y-z
	             m = 0
	        do 23     i = 0, n_long-1  
	          do 22   j = 1, n_short
	            do 21 k = 0, n_med-1   
c
                    m = m + 1
		     npt_s(m,3) = k*n_short + j + i*n_short*n_med
c
   21               continue
   22             continue
   23           continue
c
c 4. y-z-x  => x-y-z
	             m = 0
	        do 33     i = 1, n_short  
	          do 32   j = 0, n_long-1
	            do 31 k = 0, n_med-1   
c
                    m = m + 1
		     npt_s(m,4) = k*n_short + j*n_short*n_med + i
c
   31               continue
   32             continue
   33           continue
c
c 5. z-x-y  => x-y-z
	             m = 0
	        do 43     i = 0, n_med-1
	          do 42   j = 1, n_short
	            do 41 k = 0, n_long-1   
c
                    m = m + 1
		     npt_s(m,5) = k*n_short*n_med + j + i*n_short
c
   41               continue
   42             continue
   43           continue
c
c 6. z-y-x  => x-y-z
	             m = 0
	        do 53     i = 1, n_short
	          do 52   j = 0, n_med-1
	            do 51 k = 0, n_long-1   
c
                    m = m + 1
		     npt_s(m,6) = k*n_short*n_med + j*n_short + i
c
   51               continue
   52             continue
   53           continue
c
c
c
c%%%%%%
c generate npt_g_s 
c%%%%%%
c domain is numbered in x-y-z
c and the I/O numbering : y-x-z
c  x-y-z  => y-x-z
c
             mm = 0
c
	        do 60     i = 0, n_long-1
	          do 59   j = 1, n_med
	            do 58 k = 0, n_short-1
c
                                 mm = mm + 1
c
	              npt_g_s(mm) = k*nny + j + i*nnx*nny
c
   58               continue
   59             continue
   60           continue
c
c%%%%%%
c
      else if(ixyz.eq.2)  then
c            default domain ordering is x-z-y (2)
c
c%%%%%%
c generate npt_s 
c%%%%%%
c 2.  x-z-y  => x-z-y
	             m = 0
	        do 103     i = 0, n_long-1  
	          do 102   j = 0, n_med-1 
	            do 101 k = 1, n_short   
c
                    m = m + 1
		     npt_s(m,2) = k + i*n_med*n_short + j*n_short
c
  101               continue
  102             continue
  103           continue
c
c 1.  x-y-z  => x-z-y
	             m = 0
	        do 113     i = 0, n_med-1  
	          do 112   j = 0, n_long-1 
	            do 111 k = 1, n_short   
c
                    m = m + 1
		     npt_s(m,1) = k + j*n_med*n_short + i*n_short
c
  111               continue
  112             continue
  113           continue
c
c 5. z-x-y  => x-z-y
	             m = 0
	        do 123     i = 0, n_long-1  
	          do 122   j = 1, n_short
	            do 121 k = 0, n_med-1   
c
                    m = m + 1
		     npt_s(m,5) = k*n_short + j + i*n_short*n_med
c
  121               continue
  122             continue
  123           continue
c
c 6.  z-y-x  => x-z-y
	             m = 0
	        do 133     i = 1, n_short  
	          do 132   j = 0, n_long-1
	            do 131 k = 0, n_med-1   
c
                    m = m + 1
		     npt_s(m,6) = k*n_short + j*n_short*n_med + i
c
  131               continue
  132             continue
  133           continue
c
c 3.  y-x-z  => x-z-y
	             m = 0
	        do 143     i = 0, n_med-1
	          do 142   j = 1, n_short
	            do 141 k = 0, n_long-1   
c
                    m = m + 1
		     npt_s(m,3) = k*n_short*n_med + j + i*n_short
c
  141               continue
  142             continue
  143           continue
c
c 4.  y-z-x  => x-z-y
	             m = 0
	        do 153     i = 1, n_short
	          do 152   j = 0, n_med-1
	            do 151 k = 0, n_long-1   
c
                    m = m + 1
		     npt_s(m,4) = k*n_short*n_med + j*n_short + i
c
  151               continue
  152             continue
  153           continue
c
c%%%%%%
c generate npt_g_s 
c%%%%%%
c subdomain is numbered in x-z-y
c and the global domain is default (nodes and subdomains) : y-x-z
c
             mm = 0
c
	        do 160     i = 1, n_long
	          do 159   j = 0, n_med-1
	            do 158 k = 0, n_short-1
c
                                 mm = mm + 1
c
	              npt_g_s(mm) = k*nny + i + j*nnx*nny
c
  158               continue
  159             continue
  160           continue
c
c%%%%%%
c
      else if(ixyz.eq.3)  then
c            default subdomain ordering is y-x-z (3)
c
c%%%%%%
c generate npt_s 
c%%%%%%
c 3.  y-x-z  => y-x-z
	             m = 0
	        do 203     i = 0, n_long-1  
	          do 202   j = 0, n_med-1 
	            do 201 k = 1, n_short   
c
                    m = m + 1
		     npt_s(m,3) = k + i*n_med*n_short + j*n_short
c
  201               continue
  202             continue
  203           continue
c
c 4.  y-z-x  => y-x-z
	             m = 0
	        do 213     i = 0, n_med-1  
	          do 212   j = 0, n_long-1 
	            do 211 k = 1, n_short   
c
                    m = m + 1
		     npt_s(m,4) = k + j*n_med*n_short + i*n_short
c
  211               continue
  212             continue
  213           continue
c
c 1.  x-y-z  => y-x-z
	             m = 0
	        do 223     i = 0, n_long-1  
	          do 222   j = 1, n_short
	            do 221 k = 0, n_med-1   
c
                    m = m + 1
		     npt_s(m,1) = k*n_short + j + i*n_short*n_med
c
  221               continue
  222             continue
  223           continue
c
c 2.  x-z-y  => y-x-z
	             m = 0
	        do 233     i = 1, n_short  
	          do 232   j = 0, n_long-1
	            do 231 k = 0, n_med-1   
c
                    m = m + 1
		     npt_s(m,2) = k*n_short + j*n_short*n_med + i
c
  231               continue
  232             continue
  233           continue
c
c 6.  z-y-x  => y-x-z
	             m = 0
	        do 243     i = 0, n_med-1
	          do 242   j = 1, n_short
	            do 241 k = 0, n_long-1   
c
                    m = m + 1
		     npt_s(m,6) = k*n_short*n_med + j + i*n_short
c
  241               continue
  242             continue
  243           continue
c
c 5.  z-x-y  => y-x-z
	             m = 0
	        do 253     i = 1, n_short
	          do 252   j = 0, n_med-1
	            do 251 k = 0, n_long-1   
c
                    m = m + 1
		     npt_s(m,5) = k*n_short*n_med + j*n_short + i
c
  251               continue
  252             continue
  253           continue
c
c
c
c%%%%%%
c generate npt_g_s 
c%%%%%%
c subdomain is numbered in y-x-z (3)
c and the global domain is default (nodes and subdomains) : y-x-z
c
             mm = 0
c
	        do 260     i = 0, n_long-1
	          do 259   j = 0, n_med-1
	            do 258 k = 1, n_short
c
                                 mm = mm + 1
c
	              npt_g_s(mm) =  j*nny + k + i*nnx*nny
c
  258               continue
  259             continue
  260           continue
c
c%%%%%%
      else if(ixyz.eq.4)  then
c            default subdomain ordering is y-z-x (4)
c
c%%%%%%
c generate npt_s 
c%%%%%%
c 4.  y-z-x  => y-z-x
	             m = 0
	        do 303     i = 0, n_long-1  
	          do 302   j = 0, n_med-1 
	            do 301 k = 1, n_short   
c
                    m = m + 1
		     npt_s(m,4) = k + i*n_med*n_short + j*n_short
c
  301               continue
  302             continue
  303           continue
c
c 3.  y-x-z  => y-z-x
	             m = 0
	        do 313     i = 0, n_med-1  
	          do 312   j = 0, n_long-1 
	            do 311 k = 1, n_short   
c
                    m = m + 1
		     npt_s(m,3) = k + j*n_med*n_short + i*n_short
c
  311               continue
  312             continue
  313           continue
c
c 6.  z-y-x  => y-z-x
	             m = 0
	        do 323     i = 0, n_long-1  
	          do 322   j = 1, n_short
	            do 321 k = 0, n_med-1   
c
                    m = m + 1
		     npt_s(m,6) = k*n_short + j + i*n_short*n_med
c
  321               continue
  322             continue
  323           continue
c
c 5.  z-x-y  => y-z-x
	             m = 0
	        do 333     i = 1, n_short  
	          do 332   j = 0, n_long-1
	            do 331 k = 0, n_med-1   
c
                    m = m + 1
		     npt_s(m,5) = k*n_short + j*n_short*n_med + i
c
  331               continue
  332             continue
  333           continue
c
c 1.  x-y-z  => y-z-x
	             m = 0
	        do 343     i = 0, n_med-1
	          do 342   j = 1, n_short
	            do 341 k = 0, n_long-1   
c
                    m = m + 1
		     npt_s(m,1) = k*n_short*n_med + j + i*n_short
c
  341               continue
  342             continue
  343           continue
c
c 2.  x-z-y  => y-z-x
	             m = 0
	        do 353     i = 1, n_short
	          do 352   j = 0, n_med-1
	            do 351 k = 0, n_long-1   
c
                    m = m + 1
		     npt_s(m,2) = k*n_short*n_med + j*n_short + i
c
  351               continue
  352             continue
  353           continue
c
c
c
c%%%%%%
c generate npt_g_s 
c%%%%%%
c subdomain is numbered in y-z-x (4)
c and the global domain is default (nodes and subdomains) : y-x-z
c
             mm = 0
c
	        do 360     i = 0, n_long-1
	          do 359   j = 0, n_med-1
	            do 358 k = 1, n_short
c
                                 mm = mm + 1
c
	              npt_g_s(mm) =  i*nny + k + j*nnx*nny
c
  358               continue
  359             continue
  360           continue
c
c%%%%%%
      else if(ixyz.eq.5)  then
c            default subdomain ordering is z-x-y (5)
c
c%%%%%%
c generate npt_s 
c%%%%%%
c 5.  z-x-y  => z-x-y
	             m = 0
	        do 403     i = 0, n_long-1  
	          do 402   j = 0, n_med-1 
	            do 401 k = 1, n_short   
c
                    m = m + 1
		     npt_s(m,5) = k + i*n_med*n_short + j*n_short
c
  401               continue
  402             continue
  403           continue
c
c 6.  z-y-x  => z-x-y
	             m = 0
	        do 413     i = 0, n_med-1  
	          do 412   j = 0, n_long-1 
	            do 411 k = 1, n_short   
c
                    m = m + 1
		     npt_s(m,6) = k + j*n_med*n_short + i*n_short
c
  411               continue
  412             continue
  413           continue
c
c 2.  x-z-y  => z-x-y
	             m = 0
	        do 423     i = 0, n_long-1  
	          do 422   j = 1, n_short
	            do 421 k = 0, n_med-1   
c
                    m = m + 1
		     npt_s(m,2) = k*n_short + j + i*n_short*n_med
c
  421               continue
  422             continue
  423           continue
c
c 1.  x-y-z  => z-x-y
	             m = 0
	        do 433     i = 1, n_short  
	          do 432   j = 0, n_long-1
	            do 431 k = 0, n_med-1   
c
                    m = m + 1
		     npt_s(m,1) = k*n_short + j*n_short*n_med + i
c
  431               continue
  432             continue
  433           continue
c
c 4.  y-z-x  => z-x-y
	             m = 0
	        do 443     i = 0, n_med-1
	          do 442   j = 1, n_short
	            do 441 k = 0, n_long-1   
c
                    m = m + 1
		     npt_s(m,4) = k*n_short*n_med + j + i*n_short
c
  441               continue
  442             continue
  443           continue
c
c 3.  y-x-z  => z-x-y
	             m = 0
	        do 453     i = 1, n_short
	          do 452   j = 0, n_med-1
	            do 451 k = 0, n_long-1   
c
                    m = m + 1
		     npt_s(m,3) = k*n_short*n_med + j*n_short + i
c
  451               continue
  452             continue
  453           continue
c
c
c
c%%%%%%
c generate npt_g_s 
c%%%%%%
c subdomain is numbered in z-x-y (5)
c and the global domain is default (nodes and subdomains) : y-x-z
c
             mm = 0
c
	        do 460     i = 1, n_long
	          do 459   j = 0, n_med-1
	            do 458 k = 0, n_short-1
c
                                 mm = mm + 1
c
	              npt_g_s(mm) =  j*nny + i + k*nnx*nny
c
  458               continue
  459             continue
  460           continue
c
c%%%%%%
c
      else
c            default subdomain ordering is z-y-x (6)
c
c%%%%%%
c generate npt_s 
c%%%%%%
c 6.  z-y-x  => z-y-x
	             m = 0
	        do 503     i = 0, n_long-1  
	          do 502   j = 0, n_med-1 
	            do 501 k = 1, n_short   
c
                    m = m + 1
		     npt_s(m,6) = k + i*n_med*n_short + j*n_short
c
  501               continue
  502             continue
  503           continue
c
c 5.  z-x-y  => z-y-x
	             m = 0
	        do 513     i = 0, n_med-1  
	          do 512   j = 0, n_long-1 
	            do 511 k = 1, n_short   
c
                    m = m + 1
		     npt_s(m,5) = k + j*n_med*n_short + i*n_short
c
  511               continue
  512             continue
  513           continue
c
c 4.  y-z-x  => z-y-x
	             m = 0
	        do 523     i = 0, n_long-1  
	          do 522   j = 1, n_short
	            do 521 k = 0, n_med-1   
c
                    m = m + 1
		     npt_s(m,4) = k*n_short + j + i*n_short*n_med
c
  521               continue
  522             continue
  523           continue
c
c 3.  y-x-z  => z-y-x
	             m = 0
	        do 533     i = 1, n_short  
	          do 532   j = 0, n_long-1
	            do 531 k = 0, n_med-1   
c
                    m = m + 1
		     npt_s(m,3) = k*n_short + j*n_short*n_med + i
c
  531               continue
  532             continue
  533           continue
c
c 2.  x-z-y  => z-y-x
	             m = 0
	        do 543     i = 0, n_med-1
	          do 542   j = 1, n_short
	            do 541 k = 0, n_long-1   
c
                    m = m + 1
		     npt_s(m,2) = k*n_short*n_med + j + i*n_short
c
  541               continue
  542             continue
  543           continue
c
c 1.  x-y-z  => z-y-x
	             m = 0
	        do 553     i = 1, n_short
	          do 552   j = 0, n_med-1
	            do 551 k = 0, n_long-1   
c
                    m = m + 1
		     npt_s(m,1) = k*n_short*n_med + j*n_short + i
c
  551               continue
  552             continue
  553           continue
c
c
c
c%%%%%%
c generate npt_g_s 
c%%%%%%
c subdomain is numbered in z-y-x (6)
c and the global domain is default (nodes and subdomains) : y-x-z
c
             mm = 0
c
	        do 560     i = 0, n_long-1
	          do 559   j = 1, n_med
	            do 558 k = 0, n_short-1
c
                                 mm = mm + 1
c
	              npt_g_s(mm) =  i*nny + j + k*nnx*nny
c
  558               continue
  559             continue
  560           continue
c
c%%%%%%
c
      endif 
                                           return 
                                           end
c
c##########################################################
               subroutine relem (nnz,nny,nnx,melem,nel)
c##########################################################
c##########################################################
c
c generates a list of the element indicies
c nodes are numbered in y-x-z order
c to go with collocation point numbering
c
         integer melem,nnz,nny,nnx
         integer nel(melem,8)
c
                  nex = nnx-1
                  ney = nny-1
                  nez = nnz-1
c
	     m = 1
	do 1 i     = 0, nez*nnx*nny-1, nny*nnx
	  do 2 j   = 0, nny*nex-1, nny
	    do 3 k = 1, ney
c
               nel(m,1) = k                 + j     + i
               nel(m,2) = k                 + j + 1 + i
               nel(m,3) = k + nny           + j     + i
               nel(m,4) = k + nny           + j + 1 + i
               nel(m,5) = k       + nny*nnx + j     + i
               nel(m,6) = k       + nny*nnx + j + 1 + i
               nel(m,7) = k + nny + nny*nnx + j     + i
               nel(m,8) = k + nny + nny*nnx + j + 1 + i
	         m = m + 1
    3   continue
    2     continue
    1       continue
c
	return
	end
c