C     Last change:  JG   15 Jul 2002   12:16 pm
c =====================================================================
      subroutine sys_oa_i (n_do,iter)          
c =====================================================================
c
c  stors the system matrix in band store mode (see subroutine dgbsv)
c
c  the product of functions cast in basis are delt with by 
c  summing the function cast in lagrange at the collocation
c  point and obtaining a value.
c
c ***********************************************************
        include 'include.f'
c
c ***********************************************************
c 3 steps:
c    1. generate ai*x = ri
c    2. solve for x using iterative solver
c    3. update the global pressure vector
c
c STEP 1.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c
c  initialize the ia vector
                nelt =  j_offset(nequ+1)-1
c
                  n_do = 0
                 iter = 0
c******
c loop through all the elements in this subdomain
c do so in the shortest dimensions first
c
       do 5 n3 = 1, n_long-1
c
           if(ixyz.eq.1.or.ixyz.eq.3)  then
              dsz = dz(n3)/2.d0
           else if(ixyz.eq.2.or.ixyz.eq.5)  then
              dsy = dy(n3)/2.d0
           else
              dsx = dx(n3)/2.d0
           endif 
c
       do 10 n2 = 1, n_med-1
c
           if(ixyz.eq.2.or.ixyz.eq.4)  then
              dsz = dz(n2)/2.d0
           else if(ixyz.eq.1.or.ixyz.eq.6)  then
              dsy = dy(n2)/2.d0
           else
              dsx = dx(n2)/2.d0
           endif 
c
       do 15 n1 = 1, n_short-1
c
           if(ixyz.eq.5.or.ixyz.eq.6)  then
              dsz = dz(n1)/2.d0
           else if(ixyz.eq.3.or.ixyz.eq.4)  then
              dsy = dy(n1)/2.d0
           else
              dsx = dx(n1)/2.d0
           endif 
c
c the subdomain node numbers making up this element
c where the ordering is the same as for the collocation points
c
      inod(norder(1)) = 
     &                (n3-1)*n_short*n_med + n_short*(n2-1) + n1    
      inod(norder(2)) = 
     &                (n3-1)*n_short*n_med + n_short*(n2-1) + n1 + 1
      inod(norder(3)) = 
     &                (n3-1)*n_short*n_med + n_short* n2    + n1    
      inod(norder(4)) = 
     &                (n3-1)*n_short*n_med + n_short* n2    + n1 + 1
      inod(norder(5)) =  
     &                 n3   *n_short*n_med + n_short*(n2-1) + n1    
      inod(norder(6)) =  
     &                 n3   *n_short*n_med + n_short*(n2-1) + n1 + 1
      inod(norder(7)) =  
     &                 n3   *n_short*n_med + n_short* n2    + n1    
      inod(norder(8)) =  
     &                 n3   *n_short*n_med + n_short* n2    + n1 + 1
c
      n_eq(norder(1))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1
      n_eq(norder(2))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1
c
      n_eq(norder(3))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1 +
     &                      2*(n_short-1)
      n_eq(norder(4))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1     +
     &                      2*(n_short-1)
c
      n_eq(norder(5))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1 +
     &                      4*(n_short-1)*(n_med-1)
      n_eq(norder(6))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1     +
     &                      4*(n_short-1)*(n_med-1)
c
      n_eq(norder(7))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1 +
     &                      4*(n_short-1)*(n_med-1) +
     &                      2*(n_short-1)
      n_eq(norder(8))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1     +
     &                      4*(n_short-1)*(n_med-1) +
     &                      2*(n_short-1)
c
c
c loop through the 8 collocation points in the element
c
c collocation point location index = ii
       do 20 ii = 1, 8
c
          ri(n_eq(ii)) = 0.d0
c
c-------------------------------------------------------------
c    calculate the product functions at this colocation point
c          linear Lagrange representation
c-------------------------------------------------------------
             satt  = 0.d0
             ds   = 0.d0
             dw   = 0.d0
             poro   = 0.d0
             pow   = 0.d0
c
             vx   = 0.d0
             vy   = 0.d0
             vz   = 0.d0
c
              dsp_x  = 0.d0
              dsp_y  = 0.d0
              dsp_z  = 0.d0
c
              dspxx = 0.d0
              dspyy = 0.d0
              dspzz = 0.d0
c
              dsp_xy = 0.d0
              dsp_xz = 0.d0
              dsp_yz = 0.d0
c
              dspxyx = 0.d0
              dspxyy = 0.d0
c
              dspxzx = 0.d0
              dspxzz = 0.d0
c
              dspyzy = 0.d0
              dspyzz = 0.d0
c
             qw_in = 0.d0 
             qi_ow = 0.d0
c
c
c         loop through the 8 nodes in this element to get 
c         the value of the function at collocation point 'ii'
c
          do 19 i = 1, 8
c
             ino = npt_g_s(inod(i))
c
           call  water_prop (roa11(ino,1),wa,rw,vw)
           dw   = dw   + rw    *b1(ii,i)
           ds = ds + (1.d0 - roa11(ino,1)/rn_r) *b1(ii,i)
c
c          sww =  swt(ino,1)
c            if ( sww.gt.1.d0) sww = 1.d0
c            if ( sww.lt.0.d0) sww = 0.d0
c          satt = satt +  sww  *b1(ii,i)
           satt = satt +  swt(ino,1)  *b1(ii,i)
c
           poro  = poro  + por(ino)     *b1(ii,i)
           pow   = pow   + p_ow(ino)    *b1(ii,i)
c
           vx = vx + vwx(ino) *b1(ii,i)
           vy = vy + vwy(ino) *b1(ii,i)
           vz = vz + vwz(ino) *b1(ii,i)
c
         call disp_w (ino, dspx, dspy, dspz, dspxy, dspxz, dspyz)
          dsp_x = dsp_x    + dspx     *b1(ii,i)
          dsp_y = dsp_y    + dspy     *b1(ii,i)
          dsp_z = dsp_z    + dspz     *b1(ii,i)
c
          dsp_xy = dsp_xy  + dspxy    *b1(ii,i)
          dsp_yz = dsp_yz  + dspyz    *b1(ii,i)
          dsp_xz = dsp_xz  + dspxz    *b1(ii,i)
c
          dspxx = dspxx    + dspx     *bx1(ii,i)/dsx
          dspyy = dspyy    + dspy     *by1(ii,i)/dsy
          dspzz = dspzz    + dspz     *bz1(ii,i)/dsz
c
          dspxyx = dspxyx +   dspxy  *bx1(ii,i)/dsx
          dspxyy = dspxyy +   dspxy  *by1(ii,i)/dsy
c
          dspxzx = dspxzx +   dspxz  *bx1(ii,i)/dsx
          dspxzz = dspxzz +   dspxz  *bz1(ii,i)/dsz
c
          dspyzy = dspyzy +   dspyz  *by1(ii,i)/dsy
          dspyzz = dspyzz +   dspyz  *bz1(ii,i)/dsz
c
           if(qiow(ino).gt.1.d-12) then
c            qw_in  = qw_in  +  qw(ino)       *b1(ii,i)
c            qi_ow  = qi_ow  +  qiow(ino)     *b1(ii,i)
             qw_in  = qw_in  +  qw(ino)       *0.125d0
             qi_ow  = qi_ow  +  qiow(ino)     *0.125d0
           endif
c
   19    continue
c
cxxxxxxx
c calc the exchange term if transport is on
       if(bow_1.gt.0.d0 .or. bowg_1.gt.0.d0) then
          call exch_w (ii, dsx, dsy, dsz, poro, cow, cowg)
      else
          cow = 0.d0
         cowg = 0.d0
      endif
c
c==================================================================
c        evaluate the entries in the system matrix
c        there are 16 degrees of freedom per element
c        before bc's reduced out
c
c for this collocation point 
c
c        loop through the nodes in this element
         do 23 i = 1, 8
c
             ino = npt_g_s(inod(i))
c
c        loop through the degrees of freedom at each node
          do 24 idf = 1, 8
c
c
              if(idf.eq.2) then
                              x1  = dsx
         else if(idf.eq.3) then
                                                  x1  = dsy
         else if(idf.eq.4) then
                                                  x1  = dsz
         else if(idf.eq.5) then
                                                  x1  = dsx*dsy
         else if(idf.eq.6) then
                                                  x1  = dsx*dsz
         else if(idf.eq.7) then
                                                  x1  = dsy*dsz
         else if(idf.eq.8) then
                                                  x1  = dsx*dsy*dsz
         else
                                                  x1  = 1.d0
         endif
c
c LHS stuff
c
        abb   = x1*( ( (poro*satt + ds*pow)/dt
     *          + qw_in + ds*cow + ds*cowg*e_henry
     &          + (dw*poro*satt/rw_r + ds*pow)*decay) * b3(ii,i,idf)
     *             + vx*      bx3(ii,i,idf)/dsx
     *             + vy*      by3(ii,i,idf)/dsy 
     *             + vz*      bz3(ii,i,idf)/dsz 
     *             -( (dspxx+dspxyy+dspxzz)*bx3(ii,i,idf)/dsx
     *             +  (dspxyx+dspyy+dspyzz)*by3(ii,i,idf)/dsy
     *             +  (dspxzx+dspyzy+dspzz)*bz3(ii,i,idf)/dsz
     *             + dsp_x*bxx3(ii,i,idf)/(dsx*dsx)
     *             + dsp_y*byy3(ii,i,idf)/(dsy*dsy)
     *             + dsp_z*bzz3(ii,i,idf)/(dsz*dsz)
     *             + 2.d0*dsp_xy*bxy3(ii,i,idf)/(dsx*dsy)
     *             + 2.d0*dsp_xz*bxz3(ii,i,idf)/(dsx*dsz)
     *             + 2.d0*dsp_yz*byz3(ii,i,idf)/(dsy*dsz)))
c
       abb1  = x1*(poro*satt + ds*pow)/dt * b3(ii,i,idf)
       x_owg   =   x1*ds*cowg * b3(ii,i,idf)
c
c*********************************************************
c  system matrix- band stored -
c  is this df a bc, if not enter in the system matrix ai
           if(ibc_oa(inod(i),idf) .ne. 0)        then
c          we have an entry into the system matrix
c
            if(ibc_oa(inod(i),idf) .eq. n_eq(ii)) then
c              diagonal entry
               ai(j_offset(ibc_oa(inod(i),idf))) = abb
            else
c            off-diagonal entry
               do 100 inc = 1, 63
                 if( n_eq(ii).eq.
     &             i_loctn(j_offset(ibc_oa(inod(i),idf))+inc) ) then
c                  put it here
                    ai(j_offset(ibc_oa(inod(i),idf))+inc) = abb
                     go to 101
                  endif
  100          continue
            endif
c
  101          continue
c
         endif
c
c            RHS
       ri(n_eq(ii)) = ri(n_eq(ii))
     &            - abb    * roa11(ino,idf)
     &            + abb1   *  roat(ino,idf)
      IF(i_og.eq.1) ri(n_eq(ii)) = ri(n_eq(ii)) + x_owg*rog_p(ino,idf)
c
   24     continue
c
   23   continue
c
c         add the exchange, gravity and source/sink parts
c
       ri(n_eq(ii)) = ri(n_eq(ii)) +  ds*cow*parow + qi_ow
c
       if ( dabs(ri(n_eq(ii))).gt.1.d-15 ) n_do = 1
c
   20   continue
   15   continue
   10   continue
    5   continue
c
      if ( n_do.eq.1 )  then
c there was forcing so solve the system!
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c STEP 2.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c for all those nodes where Sw < epsilon assume
c that the change in solution over the time step is ZERO
c Do this by
c    1 looping through all the nodes in the mesh
c    2 at each node check for Sw < epsilon
c    3 if yes, then for all the df's associated with the node
c      zero out the row, put a 1 on the main diagonal, and
c      set RHS = 0.
c       -------------------------
        call alt_cw(nelt,ri_max)
c       -------------------------
        if ( ri_max.lt.1.d-15 ) then
             n_do = 0      
             return
        endif
c there was forcing so solve the system!
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c STEP 3.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c
c have Ax = b, now solve for x
c
c      call dslugm(nequ, ri, sol_w, nelt, i_loctn,j_offset,ai,0,nsave,
c     $     0, erit, itermx, iter, err, ierr, 0,
c     $     rwork, lenw, iwork, leniw)
      call DSLUCS (nequ, ri, sol_w, nelt, i_loctn, j_offset, ai, 0,
     +   2, erit, itermx, iter, err, ierr, 6, rwork, lenw, iwork, leniw)
c
                   if(iscr.eq.1) then
                    write(6,111) iter
  111               format(' Row - BiCG',1x,i3)
                   endif
              if (ierr.ne.0) then
                   write(6,*) ' ERROR in   Roa_v     MATRIX SOLVER '
                   write(6,*) ierr
                    write(4,*) ' ERROR in  Roa_v     MATRIX SOLVER '
                   write(4,*) time
                     stop
               endif
c
      endif
                                return 
                                end
c
c
c=====================================================================
      subroutine alt_cw(nelt,ri_max)
c=====================================================================
c FOR GMRES SOLVER
c for all those nodes where Sw < epsilon assume
c that the change in solution over the time step is ZERO
c
c routine to interrogate each node for the saturation
c if no water is present then assume that the solution to the napl
c in water species transport equation is known at that node.
c This is equivalent to
c zeroing out the row of the system matrix associated with that
c degree of freedom and putting a 1 on the diagonal (column 3);
c also the RHS is set to 0 (ie the change in the value is 0).
c n = number of nodes
        include 'include.f'
c*********************************************************************
c loop through the nodes in this sweep
c check the saturation at each node. if it is less than some min
c then assume the soln is known
c
         ri_max = 0.d0
c    loop through the nodes
         do 10 i = 1, nn
c    check for critical water saturation
             if (sw11(npt_g_s(i),1) .lt. 0.0020d0)  then
c
c    loop through the df's at this node
              do 11 idf=1,8
c    each of the active df's at this node are known
c
               if (ibc_oa(i,idf).ne.0) then
c    active df
                    nro = ibc_oa(i,idf)
                    ri(nro) = 0.d0
c
c    find all the nonzero entries in this nro (<=64)
                 do 12 j = 1, nelt
                         if (i_loctn(j).eq.nro)    then
                               ai(j) = 0.d0
                         endif
   12            continue
                    ai(j_offset(nro)) = 1.d0
c
               endif
   11         continue
c
             else
                 do 21 idf=1,8
                  if (ibc_oa(i,idf).ne.0) then
c                 active df
                    nro = ibc_oa(i,idf)
                    if(ri_max.lt.dabs(ri(nro))) ri_max = dabs(ri(nro))
                  endif
   21            continue
             endif
c
   10    continue
c
c
              return
              end