C     Last change:  JG   15 Jul 2002   12:15 pm
c =====================================================================
c  Generate and solve the linear system of equations for the flow
c  solution
c  4 routines here which are called as required:
c
c    system_pi (del)   = iterative (ILU/GMRES) solution of del
c
c =====================================================================
      subroutine  system_pi (n_do, iter)
c =====================================================================
c elliptic water pressure equation setup
c sweep in the shortest direction
c
c  stors the system matrix in band store mode (see subroutine dgbsv)
c
c  the product of functions cast in basis are delt with by 
c  summing the function cast in lagrange at the collocation
c  point and obtaining a value.
c
c ***********************************************************
        include 'include.f'
c
c ***********************************************************
c 3 steps:
c    1. generate ai*x = ri
c    2. solve for x using iterative solver
c    3. update the global pressure vector
c
c STEP 1.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c
                  n_do = 0
c
c******
c loop through all the elements in this subdomain
c do so in the shortest dimensions first
c
c parallel equation solution
c$doacross  share(n_do),
c$&         local(i,ii,idf,x1,inc,ino,n3,n2,n1,dsz,dsx,dsy,inod,n_eq, 
c$&          poro,rp_g, rp_gy,rp_gx,rp_gz, rp_w, 
c$&          rp_wy,rp_wx,rp_wz, rp_n, rp_ny,rp_nx,rp_nz, 
c$&          rp_wng, rp_wngx,rp_wngy,rp_wngz, qt, 
c$&          dw, dwx, dwy, dwz, dg, dgx, dgy, dgz, 
c$&          pcnw,pcgn,pw_t,pc_n,pc_g)
c
       do 5 n3 = 1, n_long-1
c
           if(ixyz.eq.1.or.ixyz.eq.3)  then
              dsz = dz(n3)/2.d0
           else if(ixyz.eq.2.or.ixyz.eq.5)  then
              dsy = dy(n3)/2.d0
           else
              dsx = dx(n3)/2.d0
           endif 
c
       do 10 n2 = 1, n_med-1
c
           if(ixyz.eq.2.or.ixyz.eq.4)  then
              dsz = dz(n2)/2.d0
           else if(ixyz.eq.1.or.ixyz.eq.6)  then
              dsy = dy(n2)/2.d0
           else
              dsx = dx(n2)/2.d0
           endif 
c
       do 15 n1 = 1, n_short-1
c
           if(ixyz.eq.5.or.ixyz.eq.6)  then
              dsz = dz(n1)/2.d0
           else if(ixyz.eq.3.or.ixyz.eq.4)  then
              dsy = dy(n1)/2.d0
           else
              dsx = dx(n1)/2.d0
           endif 
c
c the subdomain node numbers making up this element
c where the ordering is the same as for the collocation points
c
      inod(norder(1)) = 
     &                (n3-1)*n_short*n_med + n_short*(n2-1) + n1    
      inod(norder(2)) = 
     &                (n3-1)*n_short*n_med + n_short*(n2-1) + n1 + 1
      inod(norder(3)) = 
     &                (n3-1)*n_short*n_med + n_short* n2    + n1    
      inod(norder(4)) = 
     &                (n3-1)*n_short*n_med + n_short* n2    + n1 + 1
      inod(norder(5)) =  
     &                 n3   *n_short*n_med + n_short*(n2-1) + n1    
      inod(norder(6)) =  
     &                 n3   *n_short*n_med + n_short*(n2-1) + n1 + 1
      inod(norder(7)) =  
     &                 n3   *n_short*n_med + n_short* n2    + n1    
      inod(norder(8)) =  
     &                 n3   *n_short*n_med + n_short* n2    + n1 + 1
c
      n_eq(norder(1))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1
      n_eq(norder(2))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1
c
      n_eq(norder(3))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1 +
     &                      2*(n_short-1)
      n_eq(norder(4))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1     +
     &                      2*(n_short-1)
c
      n_eq(norder(5))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1 +
     &                      4*(n_short-1)*(n_med-1)
      n_eq(norder(6))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1     +
     &                      4*(n_short-1)*(n_med-1)
c
      n_eq(norder(7))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1 +
     &                      4*(n_short-1)*(n_med-1) +
     &                      2*(n_short-1)
      n_eq(norder(8))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1     +
     &                      4*(n_short-1)*(n_med-1) +
     &                      2*(n_short-1)
c
c loop through the 8 collocation points in the element
c
c collocation point location index = ii
       do 20 ii = 1, 8
c
          ri(n_eq(ii)) = 0.d0
c
c-------------------------------------------------------------
c    calculate the product functions at this colocation point
c          linear Lagrange representation
c-------------------------------------------------------------
c associated with total flow
             poro  = 0.d0
c
             rp_g   = 0.d0
             rp_gy  = 0.d0
             rp_gx  = 0.d0
             rp_gz  = 0.d0
c
             rp_w   = 0.d0
             rp_wy  = 0.d0
             rp_wx  = 0.d0
             rp_wz  = 0.d0
c
             rp_n   = 0.d0
             rp_ny  = 0.d0
             rp_nx  = 0.d0
             rp_nz  = 0.d0
c
             rp_wng   = 0.d0
             rp_wngx  = 0.d0
             rp_wngy  = 0.d0
             rp_wngz  = 0.d0
c
             dg   = 0.d0
             dw   = 0.d0
             dgx  = 0.d0
             dgy  = 0.d0
             dwx  = 0.d0
             dwy  = 0.d0
             dwz  = 0.d0
             dwz  = 0.d0
c
              qt = 0.d0
c
c         loop through the 8 nodes in this element to get 
c         the value of the function at collocation point 'ii'
c
          do 19 i = 1, 8
c
             ino = npt_g_s(inod(i))
           IF(i_ow.eq.1) then
            call  water_prop (roa11(ino,1),wa,rw,vw)
           else
            call  water_prop (0.d0,wa,rw,vw)
           endif
           IF(i_og.eq.1) then
            call gas_prop (rog11(ino,1),gg,rg,vg)
           else
            call gas_prop (0.d0,gg,rg,vg)
           endif
c
           poro = poro +    por(ino)  *b1(ii,i)
c
c NAPL mobility
          rp_n  = rp_n  + perm(ino)*rpn(ino)/vn_r    *b1(ii,i)
          rp_nx = rp_nx + perm(ino)*rpn(ino)/vn_r    *bx1(ii,i) /dsx
          rp_ny = rp_ny + perm(ino)*rpn(ino)/vn_r    *by1(ii,i) /dsy
          rp_nz = rp_nz + perm(ino)*rpn(ino)/vn_r    *bz1(ii,i) /dsz
c water mobility
          rp_w  = rp_w  + perm(ino)*rpa(ino)/vw *b1(ii,i)
          rp_wx = rp_wx + perm(ino)*rpa(ino)/vw *bx1(ii,i) /dsx
          rp_wy = rp_wy + perm(ino)*rpa(ino)/vw *by1(ii,i) /dsy
          rp_wz = rp_wz + perm(ino)*rpa(ino)/vw *bz1(ii,i) /dsz
c
c gas mobility
          rp_g  = rp_g  + perm(ino)*rpg(ino)/vg *b1(ii,i)
          rp_gx = rp_gx + perm(ino)*rpg(ino)/vg *bx1(ii,i) /dsx
          rp_gy = rp_gy + perm(ino)*rpg(ino)/vg *by1(ii,i) /dsy
          rp_gz = rp_gz + perm(ino)*rpg(ino)/vg *bz1(ii,i) /dsz
c
c total mobility = (water mobility + gas mobility + NAPL mobility)
          rp_wng = rp_wng + perm(ino)*
     &               (  rpa(ino)/vw
     &                + rpn(ino)/vn_r
     &                + rpg(ino)/vg )    *b1(ii,i)
          rp_wngx = rp_wngx + perm(ino)*
     &               (  rpa(ino)/vw
     &                + rpn(ino)/vn_r
     &                + rpg(ino)/vg )    *bx1(ii,i) /dsx
          rp_wngy = rp_wngy + perm(ino)*
     &               (  rpa(ino)/vw
     &                + rpn(ino)/vn_r
     &                + rpg(ino)/vg )    *by1(ii,i) /dsy
          rp_wngz = rp_wngz + perm(ino)*
     &               (  rpa(ino)/vw
     &                + rpn(ino)/vn_r
     &                + rpg(ino)/vg )    *bz1(ii,i) /dsz
c
           if(qw(ino)+qn(ino)+qg(ino).gt. 1.d-12) then
c           qt = qt + (qw(ino)+qn(ino)+qg(ino)) *b1(ii,i)
            qt = qt + (qw(ino)+qn(ino)+qg(ino)) *0.125d0
           else
c           qt = qt + (qw(ino)+qn(ino)+qg(ino)) *b1(ii,i)
            qt = qt + (qw(ino)+qn(ino)+qg(ino)) *0.125d0
           endif
c
           dg  = dg  +  rg    *b1(ii,i)
           dgx = dgx +  rg    *bx1(ii,i)/dsx
           dgy = dgy +  rg    *by1(ii,i)/dsy
           dgz = dgz +  rg    *bz1(ii,i)/dsz
           dw  = dw  +  rw    *b1(ii,i)
           dwx = dwx +  rw    *bx1(ii,i)/dsx
           dwy = dwy +  rw    *by1(ii,i)/dsy
           dwz = dwz +  rw    *bz1(ii,i)/dsz
c
   19    continue
c
c==================================================================
c        evaluate the entries in the system matrix
c        there are 16 degrees of freedom per element
c        before bc's reduced out
c
c for this collocation point 
c
c        loop through the nodes in this element
         do 23 i = 1, 8
c
             ino = npt_g_s(inod(i))
c
c        loop through the degrees of freedom at each node
          do 24 idf = 1, 8
c
c
              if(idf.eq.2) then
                              x1  = dsx
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else if(idf.eq.3) then
                                                  x1  = dsy
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else if(idf.eq.4) then
                                                  x1  = dsz
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else if(idf.eq.5) then
                                                  x1  = dsx*dsy
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else if(idf.eq.6) then
                                                  x1  = dsx*dsz
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else if(idf.eq.7) then
                                                  x1  = dsy*dsz
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else if(idf.eq.8) then
                                                  x1  = dsx*dsy*dsz
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else
                                                  x1  = 1.d0
                      pcnw = pcnw1(ino)
                      pcgn = pcgn1(ino)
         endif
c
c picard
c LHS stuff
c
        pw_t     =    x1*(     rp_wng  *(bxx3(ii,i,idf)/(dsx*dsx)
     *                     +             byy3(ii,i,idf)/(dsy*dsy)
     *                     +             bzz3(ii,i,idf)/(dsz*dsz))
     *                     +  rp_wngx  * bx3 (ii,i,idf)/dsx
     *                     +  rp_wngz  * bz3 (ii,i,idf)/dsz
     *                     +  rp_wngy  * by3 (ii,i,idf)/dsy  )
c
        pc_n     =    x1*(     rp_n  *(bxx3(ii,i,idf)/(dsx*dsx)
     *                     +           byy3(ii,i,idf)/(dsy*dsy)
     *                     +           bzz3(ii,i,idf)/(dsz*dsz))
     *                     +  rp_nx  * bx3 (ii,i,idf)/dsx
     *                     +  rp_nz  * bz3 (ii,i,idf)/dsz
     *                     +  rp_ny  * by3 (ii,i,idf)/dsy )
c
        pc_g     =    x1*(     rp_g  *(bxx3(ii,i,idf)/(dsx*dsx)
     *                     +           byy3(ii,i,idf)/(dsy*dsy)
     *                     +           bzz3(ii,i,idf)/(dsz*dsz))
     *                     +  rp_gx  * bx3 (ii,i,idf)/dsx
     *                     +  rp_gz  * bz3 (ii,i,idf)/dsz
     *                     +  rp_gy  * by3 (ii,i,idf)/dsy )
c
c*********************************************************
c  system matrix- band stored -
c  is this df a bc, if not enter in the system matrix ai
c
         if(ibc_p(inod(i),idf) .ne. 0)        then
c          we have an entry into the system matrix
c
            if(ibc_p(inod(i),idf) .eq. n_eq(ii)) then
c              diagonal entry
               ai(j_offset(ibc_p(inod(i),idf))) = - pw_t   
            else
c            off-diagonal entry
               do 100 inc = 1, 63
                 if( n_eq(ii).eq.
     &             i_loctn(j_offset(ibc_p(inod(i),idf))+inc) ) then
c                  put it here
                      ai(j_offset(ibc_p(inod(i),idf))+inc) = - pw_t   
                     go to 101
                  endif
  100          continue
            endif 
c           
  101          continue
c
         endif
c
c            RHS
       ri(n_eq(ii)) = ri(n_eq(ii))
     &                  +  pw_t    * pa11(ino,idf)
     &                  +  pc_n    * pcnw
     &                  +  pc_g    *(pcnw + pcgn)
c
   24     continue
c
   23   continue
c
c         add the exchange, gravity and source/sink parts
c
          ri(n_eq(ii)) = ri(n_eq(ii)) + qt
     &      -  grav*( dcos(th_z)*dcos(th_y)*
     &        (rp_wx*dw + rp_w*dwx + rp_gx*dg + rp_g*dgx + rn_r*rp_nx)
     *      -        dsin(th_z)           *
     &        (rp_wy*dw + rp_w*dwy + rp_gy*dg + rp_g*dgy + rn_r*rp_ny)
     *      +        dcos(th_z)*dsin(th_y)*
     &        (rp_wz*dw + rp_w*dwz + rp_gz*dg + rp_g*dgz + rn_r*rp_nz) )
c
       if ( dabs(ri(n_eq(ii))).gt.1.d-15 ) n_do = 1
c
   20   continue
   15   continue
   10   continue
    5   continue
c
      if ( n_do.eq.1 )  then
c there was forcing so solve the system!
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c STEP 2.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c have Ax = b, now solve for x
        do 301 j = 1, nn
         do 300 k = 1, 8
c
           if(ibc_p(j,k).ne.0)  then
c              sol_w(ibc_p(j,k)) = 0.d0
              sol_w(ibc_p(j,k)) = pat(npt_g_s(j),k)
           endif
c
  300    continue
  301   continue
c
                nelt =  j_offset(nequ+1)-1
c      call dslugm(nequ, ri, sol_w, nelt, i_loctn, j_offset, ai, 0,
c     $     nsave, 0, erip, itermx, iter, err, ierr, 6,
c     $     rwork, lenw, iwork, leniw)
      call DSLUCS (nequ, ri, sol_w, nelt, i_loctn, j_offset, ai, 0,
     +   2, erip, itermx, iter, err, ierr, 6, rwork, lenw, iwork, leniw)
c
                if (iscr.eq.1) then
                  write(6,111) iter
 111              format(' P - BiCG (',i3,')'/)
                endif
              if (ierr.ne.0) then
                   write(6,*) ' ERROR in    Pw_v     MATRIX SOLVER '
                   write(6,*) ierr
                    write(4,*) ' ERROR in    Pw_v     MATRIX SOLVER '
                   write(4,*) time
                     stop
               endif
c
      endif
                                return 
                                end