C     Last change:  JG   15 Jul 2002   12:15 pm
c =====================================================================
      subroutine system_wi (n_do,iter)          
c =====================================================================
c
c  stors the system matrix in band store mode (see subroutine dgbsv)
c
c  the product of functions cast in basis are delt with by 
c  summing the function cast in lagrange at the collocation
c  point and obtaining a value.
c
c ***********************************************************
        include 'include.f'
c
c ***********************************************************
c 3 steps:
c    1. generate ai*x = ri
c    2. solve for x using iterative solver
c    3. update the global pressure vector
c
c STEP 1.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c
                nelt = 0
                n_do = 0
                iter = 0
c******
c loop through all the elements in this subdomain
c do so in the shortest dimensions first
c
c parallel equation solution
c$doacross  share(n_do),
c$&  local(i,ii,idf,x1,inc,ino,n3,n2,n1,dsz,dsx,dsy,inod,n_eq, 
c$&      d_pgn, d_pgnx, d_pgny, d_pgnz, d_pnw, d_pnwx, d_pnwy, d_pnwz,
c$&      ffw,  ffwx, ffwy, ffwz, vtotx,  vtoty,  vtotz, hnw,  hnwx, 
c$&      hnwy, hnwz, hgw,  hgwx, hgwy, hgwz, f_rn, f_rnx, f_rny, f_rnz,
c$&      f_rg,  f_rgx, f_rgy, f_rgz, dw, dwx, dwy, dwz, qw_in, qt,
c$&      dg, dgx, dgy, dgz, vw_x, vw_y, vw_z, poro, cow, cowg,
c$&      pcnw,pcgn, sw_time,sw_n,sw_g,pc_n,pc_g)
cc
       do 5 n3 = 1, n_long-1
c
           if(ixyz.eq.1.or.ixyz.eq.3)  then
              dsz = dz(n3)/2.d0
           else if(ixyz.eq.2.or.ixyz.eq.5)  then
              dsy = dy(n3)/2.d0
           else
              dsx = dx(n3)/2.d0
           endif 
c
       do 10 n2 = 1, n_med-1
c
           if(ixyz.eq.2.or.ixyz.eq.4)  then
              dsz = dz(n2)/2.d0
           else if(ixyz.eq.1.or.ixyz.eq.6)  then
              dsy = dy(n2)/2.d0
           else
              dsx = dx(n2)/2.d0
           endif 
c
       do 15 n1 = 1, n_short-1
c
           if(ixyz.eq.5.or.ixyz.eq.6)  then
              dsz = dz(n1)/2.d0
           else if(ixyz.eq.3.or.ixyz.eq.4)  then
              dsy = dy(n1)/2.d0
           else
              dsx = dx(n1)/2.d0
           endif 
c
c the subdomain node numbers making up this element
c where the ordering is the same as for the collocation points
c
      inod(norder(1)) = 
     &                (n3-1)*n_short*n_med + n_short*(n2-1) + n1    
      inod(norder(2)) = 
     &                (n3-1)*n_short*n_med + n_short*(n2-1) + n1 + 1
      inod(norder(3)) = 
     &                (n3-1)*n_short*n_med + n_short* n2    + n1    
      inod(norder(4)) = 
     &                (n3-1)*n_short*n_med + n_short* n2    + n1 + 1
      inod(norder(5)) =  
     &                 n3   *n_short*n_med + n_short*(n2-1) + n1    
      inod(norder(6)) =  
     &                 n3   *n_short*n_med + n_short*(n2-1) + n1 + 1
      inod(norder(7)) =  
     &                 n3   *n_short*n_med + n_short* n2    + n1    
      inod(norder(8)) =  
     &                 n3   *n_short*n_med + n_short* n2    + n1 + 1
c
      n_eq(norder(1))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1
      n_eq(norder(2))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1
c
      n_eq(norder(3))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1 +
     &                      2*(n_short-1)
      n_eq(norder(4))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1     +
     &                      2*(n_short-1)
c
      n_eq(norder(5))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1 +
     &                      4*(n_short-1)*(n_med-1)
      n_eq(norder(6))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1     +
     &                      4*(n_short-1)*(n_med-1)
c
      n_eq(norder(7))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1 - 1 +
     &                      4*(n_short-1)*(n_med-1) +
     &                      2*(n_short-1)
      n_eq(norder(8))= (n3-1)*(n_short-1)*(n_med-1)*8 +
     &                      (n2-1)*(n_short-1)*4 + 2*n1     +
     &                      4*(n_short-1)*(n_med-1) +
     &                      2*(n_short-1)
c
c
c loop through the 8 collocation points in the element
c
c collocation point location index = ii
       do 20 ii = 1, 8
c
          ri(n_eq(ii)) = 0.d0
c
c-------------------------------------------------------------
c    calculate the product functions at this colocation point
c          linear Lagrange representation
c-------------------------------------------------------------
             poro  = 0.d0
c
             d_pgn   = 0.d0
             d_pgnx  = 0.d0
             d_pgny  = 0.d0
             d_pgnz  = 0.d0
c
             d_pnw   = 0.d0
             d_pnwx  = 0.d0
             d_pnwy  = 0.d0
             d_pnwz  = 0.d0
c
              ffw  = 0.d0
              ffwx = 0.d0
              ffwy = 0.d0
              ffwz = 0.d0
c
            vtotx  = 0.d0
            vtoty  = 0.d0
            vtotz  = 0.d0
c
              hnw  = 0.d0
              hnwx = 0.d0
              hnwy = 0.d0
              hnwz = 0.d0
              hgw  = 0.d0
              hgwx = 0.d0
              hgwy = 0.d0
              hgwz = 0.d0
c
             f_rn  = 0.d0
             f_rnx = 0.d0
             f_rny = 0.d0
             f_rnz = 0.d0
c
             f_rg  = 0.d0
             f_rgx = 0.d0
             f_rgy = 0.d0
             f_rgz = 0.d0
c
             dg   = 0.d0
             dw   = 0.d0
c associated with density variation
             dwx  = 0.d0
             dwy  = 0.d0
             dwz  = 0.d0
             dgx  = 0.d0
             dgy  = 0.d0
             dgz  = 0.d0
c
             qw_in = 0.d0
             qt    = 0.d0
c
c         loop through the 8 nodes in this element to get 
c         the value of the function at collocation point 'ii'
c
          do 19 i = 1, 8
c
             ino = npt_g_s(inod(i))        
c
           IF(i_ow.eq.1) then
            call  water_prop (roa11(ino,1),wa,rw,vw)
           else
            call  water_prop (0.d0,wa,rw,vw)
           endif
           IF(i_og.eq.1) then
            call gas_prop (rog11(ino,1),gg,rg,vg)
           else
            call gas_prop (0.d0,gg,rg,vg)
           endif
c
           poro = poro +    por(ino)  *b1(ii,i)
c
           if(qw(ino)+qn(ino)+qg(ino).gt. 1.d-12) then
c            qt     = qt     + (qw(ino)+qn(ino)+qg(ino))  *b1(ii,i)
c            qw_in  = qw_in  +  qw(ino)                   *b1(ii,i)
             qt     = qt     + (qw(ino)+qn(ino)+qg(ino))  *0.125d0
             qw_in  = qw_in  +  qw(ino)                   *0.125d0
           endif
c
           d_pnw   = d_pnw   + dpcnw(ino) *b1(ii,i)
           d_pnwx  = d_pnwx  + dpcnw(ino) *bx1(ii,i)/dsx
           d_pnwy  = d_pnwy  + dpcnw(ino) *by1(ii,i)/dsy
           d_pnwz  = d_pnwz  + dpcnw(ino) *bz1(ii,i)/dsz
c
           d_pgn   = d_pgn   + dpcgn(ino) *b1(ii,i)
           d_pgnx  = d_pgnx  + dpcgn(ino) *bx1(ii,i)/dsx
           d_pgny  = d_pgny  + dpcgn(ino) *by1(ii,i)/dsy
           d_pgnz  = d_pgnz  + dpcgn(ino) *bz1(ii,i)/dsz
c
c       ####################################################
c fractional flow of water
        ffw  = ffw  + b1(ii,i) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
         ffwx  = ffwx  + bx1(ii,i)/dsx * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
         ffwy  = ffwy  + by1(ii,i)/dsy * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
         ffwz  = ffwz  + bz1(ii,i)/dsz * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
c
c          applied to gravity term 
c FFw *  mob_n 
         f_rn  = f_rn  + b1(ii,i) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
         f_rnx  = f_rnx  + bx1(ii,i)/dsx * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
         f_rny  = f_rny  + by1(ii,i)/dsy * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
         f_rnz  = f_rnz  + bz1(ii,i)/dsz * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
c
c          applied to diffusion term (from routine mp_diff)
c FFw *  mob_n * h_nw
         hnw  = hnw  + b1(ii,i) * h_nw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
          hnwx  =  hnwx  + bx1(ii,i)/dsx * h_nw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
          hnwy  =  hnwy  + by1(ii,i)/dsy * h_nw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
          hnwz  =  hnwz  + bz1(ii,i)/dsz * h_nw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
c
c
c          applied to gravity term
c FFw * mob_g
         f_rg  = f_rg  + b1(ii,i) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg
         f_rgx  = f_rgx  + bx1(ii,i)/dsx * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg
         f_rgy  = f_rgy  + by1(ii,i)/dsy * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg
         f_rgz  = f_rgz  + bz1(ii,i)/dsz * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg
c
c          applied to diffusion term (from routine mp_diff)
c FFw * mob_g * h_gw
          hgw  =  hgw  + b1(ii,i) * h_gw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg
          hgwx  =  hgwx  + bx1(ii,i)/dsx * h_gw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg
          hgwy  =  hgwy  + by1(ii,i)/dsy * h_gw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg
          hgwz  =  hgwz  + bz1(ii,i)/dsz * h_gw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg
c
         vtotx = vtotx + vtx(ino) *b1(ii,i)
         vtoty = vtoty + vty(ino) *b1(ii,i)
         vtotz = vtotz + vtz(ino) *b1(ii,i)
c
c density variation
           dw  = dw  + rw  *b1(ii,i)
           dg  = dg  + rg  *b1(ii,i)
           dgx = dgx + rg  *bx1(ii,i)/dsx
           dgy = dgy + rg  *by1(ii,i)/dsy
           dgz = dgz + rg  *bz1(ii,i)/dsz
           dwx = dwx + rw  *bx1(ii,i)/dsx
           dwy = dwy + rw  *by1(ii,i)/dsy
           dwz = dwz + rw  *bz1(ii,i)/dsz
c
   19    continue
c
cxxxxxxx
c calc the exchange term if transport is on
      if(ntr_ow.gt.0.and.i_ow.eq.1) then
        call exch_w (ii,dsx,dsy,dsz,poro, cow, cowg)
      else
          cow    = 0.d0
          cowg   = 0.d0
      endif
c
c==================================================================
c        evaluate the entries in the system matrix
c        there are 16 degrees of freedom per element
c        before bc's reduced out
c
c for this collocation point 
c
c        loop through the nodes in this element
         do 23 i = 1, 8
c
             ino = npt_g_s(inod(i))        
c
c        loop through the degrees of freedom at each node
          do 24 idf = 1, 8
c
c
              if(idf.eq.2) then
                              x1  = dsx
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else if(idf.eq.3) then
                                                  x1  = dsy
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else if(idf.eq.4) then
                                                  x1  = dsz
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else if(idf.eq.5) then
                                                  x1  = dsx*dsy
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else if(idf.eq.6) then
                                                  x1  = dsx*dsz
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else if(idf.eq.7) then
                                                  x1  = dsy*dsz
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else if(idf.eq.8) then
                                                  x1  = dsx*dsy*dsz
                      if(dabs(sw11(ino,idf)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,idf)
                      endif
                      if(dabs(st11(ino,idf)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,idf)
                      endif
         else
                                                  x1  = 1.d0
                      pcnw = pcnw1(ino)
                      pcgn = pcgn1(ino)
         endif
c
c picard
c LHS stuff
c time/time-like
c
        sw_time =   x1*poro*b3(ii,i,idf)/dt
c
c space
cXXXXXXXXXXXXXXXXXXXXX
c
        sw_n     =      x1*( 
     *                 d_pnw*hnw  * (bxx3(ii,i,idf)/(dsx*dsx) 
     *               +              byy3(ii,i,idf)/(dsy*dsy)  
     *               +              bzz3(ii,i,idf)/(dsz*dsz) )
     *                     +  ( d_pnw* hnwx + d_pnwx* hnw )
     *                                   *bx3(ii,i,idf)/dsx
     *                     +  ( d_pnw* hnwz + d_pnwz* hnw )
     *                                   *bz3(ii,i,idf)/dsz
     *                     +  ( d_pnw* hnwy + d_pnwy* hnw )
     *                                   *by3(ii,i,idf)/dsy )
c
        sw_g     =  x1*(  
     *           (d_pnw+d_pgn)* hgw * (bxx3(ii,i,idf)/(dsx*dsx) 
     *               +              byy3(ii,i,idf)/(dsy*dsy)  
     *               +              bzz3(ii,i,idf)/(dsz*dsz) )
     *         + ( (d_pnw+d_pgn)* hgwx + (d_pnwx+d_pgnx)* hgw )
     *                                       *bx3(ii,i,idf)/dsx
     *         + ( (d_pnw+d_pgn)* hgwz + (d_pnwz+d_pgnz)* hgw )
     *                                       *bz3(ii,i,idf)/dsz
     *         + ( (d_pnw+d_pgn)* hgwy + (d_pnwy+d_pgny)* hgw )
     *                                       *by3(ii,i,idf)/dsy )
c
        pc_n   =   x1   *(    hnw * (bxx3(ii,i,idf)/(dsx*dsx)
     *               +              byy3(ii,i,idf)/(dsy*dsy)  
     *               +              bzz3(ii,i,idf)/(dsz*dsz) )
     *                     +  hnwx*  bx3(ii,i,idf)/dsx
     *                     +  hnwz*  bz3(ii,i,idf)/dsz
     *                     +  hnwy*  by3(ii,i,idf)/dsy )
c
        pc_g   =   x1   *(    hgw * (bxx3(ii,i,idf)/(dsx*dsx)
     *               +              byy3(ii,i,idf)/(dsy*dsy)  
     *               +              bzz3(ii,i,idf)/(dsz*dsz) )
     *                     +  hgwx*  bx3(ii,i,idf)/dsx
     *                     +  hgwz*  bz3(ii,i,idf)/dsz
     *                     +  hgwy*  by3(ii,i,idf)/dsy )
c
       ab_ex   = x1* (cow + cowg*e_henry)/rn_r * b3(ii,i,idf)
        x_owg   =   x1*cowg/rn_r * b3(ii,i,idf)
c*********************************************************
c  system matrix- band stored -
c  is this df a bc, if not enter in the system matrix ai
c
           if(ibc_s(inod(i),idf) .ne. 0)        then
c          we have an entry into the system matrix
c
            if(ibc_s(inod(i),idf) .eq. n_eq(ii)) then
c              diagonal entry
               ai(j_offset(ibc_s(inod(i),idf))) = sw_time + sw_n + sw_g
            else
c            off-diagonal entry
               do 100 inc = 1, 63
                 if( n_eq(ii).eq.
     &             i_loctn(j_offset(ibc_s(inod(i),idf))+inc) ) then
c                  put it here
                    ai(j_offset(ibc_s(inod(i),idf))+inc) 
     &                    = sw_time + sw_n + sw_g
                     go to 101
                  endif
  100          continue
            endif
c
  101          continue
c
         endif
c
c            RHS
       ri(n_eq(ii)) = ri(n_eq(ii))
     &            - sw_time  * (sw11(ino,idf) - swt(ino,idf))
     &            - pc_n   * pcnw
     &            - pc_g   * (pcgn + pcnw)
c
      IF(i_ow.eq.1) ri(n_eq(ii)) = ri(n_eq(ii)) - ab_ex*roa_p(ino,idf)
      IF(i_og.eq.1) ri(n_eq(ii)) = ri(n_eq(ii)) + x_owg*rog_p(ino,idf)
c
   24     continue
c
   23   continue
c
c         add the exchange, gravity and source/sink parts
c
       ri(n_eq(ii)) = ri(n_eq(ii))      + parow*cow/rn_r 
     &          - (ffw*qt - qw_in
     &               + vtotx*ffwx + vtoty*ffwy + vtotz*ffwz)
     &      -  grav*(
     &               dcos(th_z)*dcos(th_y)*
     &                    ( f_rnx*(dw-rn_r) + f_rn*dwx
     &                    + f_rgx*(dw-dg)   + f_rg*(dwx-dgx) )
     *      -        dsin(th_z)           *
     &                    ( f_rny*(dw-rn_r) + f_rn*dwy
     &                    + f_rgy*(dw-dg)   + f_rg*(dwy-dgy) )  
     *      +        dcos(th_z)*dsin(th_y)*
     &                    ( f_rnz*(dw-rn_r) + f_rn*dwz
     &                    + f_rgz*(dw-dg)   + f_rg*(dwz-dgz) ) )
c
       if ( dabs(ri(n_eq(ii))).gt.1.d-15 ) n_do = 1
c
   20   continue
   15   continue
   10   continue
    5   continue
c
      if ( n_do.eq.1 )  then
c there was forcing so solve the system!
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c STEP 2.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c
                nelt =  j_offset(nequ+1)-1
c      call dslugm(nequ, ri, sol_w, nelt, i_loctn, j_offset, ai, 0,
c     $     nsave, 0, eris, itermx, iter, err, ierr, 0,
c     $     rwork, lenw, iwork, leniw)
      call DSLUCS (nequ, ri, sol_w, nelt, i_loctn, j_offset, ai, 0,
     +   2, eris, itermx, iter, err, ierr, 6, rwork, lenw, iwork, leniw)
c
                 if (iscr.eq.1) then
                   write(6,111) iter
  111              format(' Sw  - BiCG (',i3,')')
                 endif
              if (ierr.ne.0) then
                   write(6,*) ' ERROR in    Sw     MATRIX SOLVER '
                   write(6,*) ierr
                    write(4,*) ' ERROR in   Sw     MATRIX SOLVER '
                   write(4,*) time
                     stop
               endif
      endif
                                return 
                                end
