/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FlowPanel
extends JPanel
implements Observer {
    private JLabel blockP;
    private String[] units;
    private JPanel FillPanel;
    private FlowComboPanel Fcp;
    private JCheckBox editCheckBox;
    private JLabel h1L;
    private JLabel h2L;
    private JLabel aL;
    private JLabel theta_rL;
    private JLabel theta_mL;
    private JLabel theta_sL;
    private JLabel zL;
    private JLabel alphazL;
    private JLabel nL;
    private JLabel tL;
    private JLabel rhoL;
    private JLabel rpL;
    private JLabel K0L;
    private NormalF aF;
    private NormalF theta_rF;
    private NormalF theta_mF;
    private NormalF theta_sF;
    private NormalF zF;
    private NormalF alphazF;
    private NormalF nF;
    private NormalF tF;
    private NormalF rhoF;
    private NormalF rpF;
    private NormalF K0F;

    public FlowPanel(Gossiper gossiper) {
        JarLoadable jarLoadable = new JarLoadable();
        gossiper.addObserver(this);
        JLabel jLabel = new JLabel("Parameter");
        JLabel jLabel2 = new JLabel("Mean");
        JLabel jLabel3 = new JLabel("Std. Deviation");
        this.aL = new JLabel(new ImageIcon(jarLoadable.loadImage("a.gif")));
        this.aL.setToolTipText("Log van Genuchten's alpha");
        this.theta_rL = new JLabel(new ImageIcon(jarLoadable.loadImage("thetar.gif")));
        this.theta_rL.setToolTipText("Residual water content");
        this.theta_mL = new JLabel(new ImageIcon(jarLoadable.loadImage("thetam.gif")));
        this.theta_mL.setToolTipText("Water content");
        this.theta_sL = new JLabel(new ImageIcon(jarLoadable.loadImage("thetas.gif")));
        this.theta_sL.setToolTipText("Saturated water content");
        this.zL = new JLabel(new ImageIcon(jarLoadable.loadImage("l.gif")));
        this.zL.setToolTipText("Thickness of proposed barrier");
        this.alphazL = new JLabel(new ImageIcon(jarLoadable.loadImage("alphaz.gif")));
        this.alphazL.setToolTipText("Hydrodynamic dispersivity");
        this.nL = new JLabel(new ImageIcon(jarLoadable.loadImage("n.gif")));
        this.nL.setToolTipText("Log van Genuchten's n");
        this.tL = new JLabel(new ImageIcon(jarLoadable.loadImage("t.gif")));
        this.tL.setToolTipText("Temperature of soil (for computing molecular diffusivity)");
        this.rhoL = new JLabel(new ImageIcon(jarLoadable.loadImage("rho.gif")));
        this.rhoL.setToolTipText("Soil bulk density");
        this.rpL = new JLabel(new ImageIcon(jarLoadable.loadImage("rp.gif")));
        this.rpL.setToolTipText("Mean soil particle radius");
        this.K0L = new JLabel(new ImageIcon(jarLoadable.loadImage("k0.gif")));
        this.K0L.setToolTipText("Log Saturated hydraulic conductivity");
        String string = "Modifying this mean value is not recommended.See model documentation.";
        this.aF = new NormalF();
        this.aF.m.setToolTipText(string);
        this.aF.m.setForeground(Color.red);
        this.aF.s.setEditable(false);
        this.theta_sF = new NormalF();
        this.theta_sF.m.setToolTipText(string);
        this.theta_sF.m.setForeground(Color.red);
        this.theta_sF.s.setEditable(false);
        this.theta_rF = new NormalF();
        this.theta_rF.m.setToolTipText(string);
        this.theta_rF.m.setForeground(Color.red);
        this.theta_rF.s.setEditable(false);
        this.theta_mF = new NormalF();
        this.theta_mF.m.setEditable(false);
        this.theta_mF.s.setEditable(false);
        this.zF = new NormalF();
        this.alphazF = new NormalF();
        this.nF = new NormalF();
        this.nF.m.setToolTipText(string);
        this.nF.m.setForeground(Color.red);
        this.nF.s.setEditable(false);
        this.tF = new NormalF();
        this.rhoF = new NormalF();
        this.rpF = new NormalF();
        this.K0F = new NormalF();
        this.K0F.m.setToolTipText(string);
        this.K0F.m.setForeground(Color.red);
        this.K0F.s.setEditable(false);
        this.units = new String[13];
        this.units[2] = "  m\u00b3 m-\u00b3";
        this.units[1] = "  m\u00b3 m-\u00b3";
        this.units[0] = "  m\u00b3 m-\u00b3";
        this.units[3] = " log10( m h -\u00b9 )";
        this.units[4] = " log10( m -\u00b9 )";
        this.units[5] = " log10( . )";
        this.units[6] = " g m -\u00b3 ";
        this.units[8] = " m";
        this.units[7] = " m";
        this.units[9] = " Celsius";
        this.units[11] = " m";
        this.units[10] = " m";
        GridLayout gridLayout = new GridLayout(14, 4);
        this.FillPanel = new JPanel();
        this.editCheckBox = new JCheckBox("Uniformly Random", true);
        this.editCheckBox.setForeground(Color.blue);
        this.editCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((FlowPanel)FlowPanel.this).theta_mF.m.setEditable(!FlowPanel.this.editCheckBox.isSelected());
                ((FlowPanel)FlowPanel.this).theta_mF.s.setEditable(!FlowPanel.this.editCheckBox.isSelected());
                if (FlowPanel.this.editCheckBox.isSelected()) {
                    FlowPanel.this.editCheckBox.setForeground(Color.blue);
                } else {
                    FlowPanel.this.editCheckBox.setForeground(Color.gray);
                }
            }
        });
        this.setLayout(gridLayout);
        this.Fcp = new FlowComboPanel(gossiper);
        this.add(jLabel);
        this.add(jLabel2);
        this.add(jLabel3);
        this.add(new JLabel("Units"));
        this.add(this.theta_rL);
        this.add(this.theta_rF.m);
        this.add(this.theta_rF.s);
        this.add(new JLabel(this.units[0]));
        this.add(this.theta_mL);
        this.add(this.theta_mF.m);
        this.add(this.theta_mF.s);
        this.add(this.editCheckBox);
        this.add(this.theta_sL);
        this.add(this.theta_sF.m);
        this.add(this.theta_sF.s);
        this.add(new JLabel(this.units[2]));
        this.add(this.K0L);
        this.add(this.K0F.m);
        this.add(this.K0F.s);
        this.add(new JLabel(this.units[3]));
        this.add(this.aL);
        this.add(this.aF.m);
        this.add(this.aF.s);
        this.add(new JLabel(this.units[4]));
        this.add(this.nL);
        this.add(this.nF.m);
        this.add(this.nF.s);
        this.add(new JLabel(this.units[5]));
        this.add(this.rhoL);
        this.add(this.rhoF.m);
        this.add(this.rhoF.s);
        this.add(new JLabel(this.units[6]));
        this.add(this.rpL);
        this.add(this.rpF.m);
        this.add(this.rpF.s);
        this.add(new JLabel(this.units[7]));
        this.add(this.alphazL);
        this.add(this.alphazF.m);
        this.add(this.alphazF.s);
        this.add(new JLabel(this.units[8]));
        this.add(this.tL);
        this.add(this.tF.m);
        this.add(this.tF.s);
        this.add(new JLabel(this.units[9]));
        this.add(this.zL);
        this.add(this.zF.m);
        this.add(this.zF.s);
        this.add(new JLabel(this.units[10]));
        this.add(this.FillPanel);
        this.add(this.Fcp);
        this.add(this.FillPanel);
        this.add(this.FillPanel);
        this.add(this.FillPanel);
        this.add(this.FillPanel);
        this.add(this.FillPanel);
        this.add(this.FillPanel);
    }

    public void update(Observable observable, Object object) {
        String string = object.getClass().getName();
        if (string.equals("Medium")) {
            Medium medium = (Medium)object;
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMaximumFractionDigits(2);
            this.aF.m.setText(numberFormat.format(medium.a.mean));
            this.aF.s.setText(numberFormat.format(medium.a.sdev));
            this.theta_rF.m.setText(numberFormat.format(medium.theta_r.mean));
            this.theta_rF.s.setText(numberFormat.format(medium.theta_r.sdev));
            this.theta_mF.m.setText(numberFormat.format(medium.theta_m.mean));
            this.theta_mF.s.setText(numberFormat.format(medium.theta_m.sdev));
            this.theta_sF.m.setText(numberFormat.format(medium.theta_s.mean));
            this.theta_sF.s.setText(numberFormat.format(medium.theta_s.sdev));
            this.zF.m.setText(numberFormat.format(medium.z.mean));
            this.zF.s.setText(numberFormat.format(medium.z.sdev));
            this.alphazF.m.setText(Double.toString(medium.alphaz.mean));
            this.alphazF.s.setText(Double.toString(medium.alphaz.sdev));
            this.nF.m.setText(numberFormat.format(medium.n.mean));
            this.nF.s.setText(numberFormat.format(medium.n.sdev));
            this.tF.m.setText(numberFormat.format(medium.t.mean));
            this.tF.s.setText(numberFormat.format(medium.t.sdev));
            this.rpF.m.setText(Double.toString(medium.rp.mean));
            this.rpF.s.setText(Double.toString(medium.rp.sdev));
            this.K0F.m.setText(numberFormat.format(medium.K0.mean));
            this.K0F.s.setText(numberFormat.format(medium.K0.sdev));
            this.rhoF.m.setText(Double.toString(medium.rho.mean));
            this.rhoF.s.setText(Double.toString(medium.rho.sdev));
            this.repaint();
        }
    }

    public Medium getData() {
        Medium medium = new Medium();
        String string = this.Fcp.getSelection();
        string = string.toLowerCase();
        medium.name.is = string.toCharArray();
        Double d = new Double(this.aF.m.getText());
        medium.a.mean = d;
        d = new Double(this.aF.s.getText());
        medium.a.sdev = d;
        d = new Double(this.theta_rF.m.getText());
        medium.theta_r.mean = d;
        d = new Double(this.theta_rF.s.getText());
        medium.theta_r.sdev = d;
        d = new Double(this.theta_mF.m.getText());
        medium.theta_m.mean = d;
        d = new Double(this.theta_mF.s.getText());
        medium.theta_m.sdev = d;
        d = new Double(this.theta_sF.m.getText());
        medium.theta_s.mean = d;
        d = new Double(this.theta_sF.s.getText());
        medium.theta_s.sdev = d;
        d = new Double(this.zF.m.getText());
        medium.z.mean = d;
        d = new Double(this.zF.s.getText());
        medium.z.sdev = d;
        d = new Double(this.alphazF.m.getText());
        medium.alphaz.mean = d;
        d = new Double(this.alphazF.s.getText());
        medium.alphaz.sdev = d;
        d = new Double(this.nF.m.getText());
        medium.n.mean = d;
        d = new Double(this.nF.s.getText());
        medium.n.sdev = d;
        d = new Double(this.tF.m.getText());
        medium.t.mean = d;
        d = new Double(this.tF.s.getText());
        medium.t.sdev = d;
        d = new Double(this.rhoF.m.getText());
        medium.rho.mean = d;
        d = new Double(this.rhoF.s.getText());
        medium.rho.sdev = d;
        d = new Double(this.rpF.m.getText());
        medium.rp.mean = d;
        d = new Double(this.rpF.s.getText());
        medium.rp.sdev = d;
        d = new Double(this.K0F.m.getText());
        medium.K0.mean = d;
        d = new Double(this.K0F.s.getText());
        medium.K0.sdev = d;
        return medium;
    }

    public void putData(Medium medium) {
        this.Fcp.addSoil(medium, new String(medium.name.is));
    }

    public String[] getLabels() {
        String[] stringArray = new String[]{this.theta_rL.getToolTipText(), this.theta_mL.getToolTipText(), this.theta_sL.getToolTipText(), this.K0L.getToolTipText(), this.aL.getToolTipText(), this.nL.getToolTipText(), this.rhoL.getToolTipText(), this.rpL.getToolTipText(), this.alphazL.getToolTipText(), this.tL.getToolTipText(), this.zL.getToolTipText()};
        return stringArray;
    }

    public boolean theta_mIsUniform() {
        return this.editCheckBox.isSelected();
    }

    public String[] getUnits() {
        return this.units;
    }

    public void requestAttention(String string) {
        if (string.equalsIgnoreCase("theta_r.m")) {
            this.theta_rF.m.requestFocus();
        }
        if (string.equalsIgnoreCase("theta_m.m")) {
            this.theta_mF.m.requestFocus();
        }
        if (string.equalsIgnoreCase("theta_m.s")) {
            this.theta_mF.s.requestFocus();
        }
        if (string.equalsIgnoreCase("theta_s.m")) {
            this.theta_sF.m.requestFocus();
        }
        if (string.equalsIgnoreCase("rho.m")) {
            this.rhoF.m.requestFocus();
        }
        if (string.equalsIgnoreCase("rho.s")) {
            this.rhoF.s.requestFocus();
        }
        if (string.equalsIgnoreCase("rp.m")) {
            this.rpF.m.requestFocus();
        }
        if (string.equalsIgnoreCase("rp.s")) {
            this.rpF.s.requestFocus();
        }
        if (string.equalsIgnoreCase("alphaz.m")) {
            this.alphazF.m.requestFocus();
        }
        if (string.equalsIgnoreCase("alphaz.s")) {
            this.alphazF.s.requestFocus();
        }
        if (string.equalsIgnoreCase("z.m")) {
            this.zF.m.requestFocus();
        }
        if (string.equalsIgnoreCase("z.s")) {
            this.zF.s.requestFocus();
        }
    }
}

