/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class HistoPanel
extends JPanel {
    private String sb;
    private JarLoadable jar;
    private int[] bin;
    private String Hits = "0";
    private String Runs = "0";
    private String is;
    private int h;
    private int w;
    private int i;
    private int margin = 60;
    private double bp = 4.0;

    public HistoPanel(int[] nArray, int n, int n2) {
        this.w = n;
        this.h = n2;
        this.bin = nArray;
        JarLoadable jarLoadable = new JarLoadable();
        String string = new String();
    }

    public void redraw(int[] nArray) {
        this.bin = nArray;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(Color.red);
        graphics.drawString("Exceedances", this.margin, this.h - 15);
        graphics.drawString(this.Hits, this.margin, this.h);
        graphics.drawRect(this.margin + (int)this.bp, this.margin + 20, 0, 320);
        if (this.bp < 1.0) {
            graphics.drawString("Note: resolution will not allow display of vertical marker bar.", this.margin + this.bin.length / 2, this.margin - 20);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(this.margin, this.margin + 20, 0, 320);
        graphics.drawString("Right Truncated Histogram", this.margin + this.bin.length / 2, this.margin);
        graphics.drawString("-log A", this.margin + 4 * this.bin.length / 2 - 8, this.h - 30);
        graphics.drawString("0", 58, this.h - 45);
        graphics.drawString("150", 64 + 4 * this.bin.length / 2, this.h - 45);
        graphics.drawString("300", 50 + 4 * this.bin.length, this.h - 45);
        graphics.drawString(":   " + this.Runs, this.margin + 85, this.h);
        graphics.drawString(":   Runs", this.margin + 85, this.h - 15);
        this.i = 0;
        while (this.i < this.bin.length) {
            graphics.drawRect(this.margin + this.i * 4, this.h - this.bin[this.i] - this.margin, 2, this.bin[this.i]);
            ++this.i;
        }
        this.i = 0;
        while (this.i < 320) {
            graphics.drawRect(this.margin - 5, this.h - this.margin - this.i, 4, 0);
            graphics.drawString(String.valueOf(this.i), this.margin - 30, this.h - this.margin - this.i + 5);
            this.i += 20;
        }
        graphics.drawString("C", 15, this.h - this.margin - 210);
        graphics.drawString("O", 15, this.h - this.margin - 190);
        graphics.drawString("U", 15, this.h - this.margin - 170);
        graphics.drawString("N", 15, this.h - this.margin - 150);
        graphics.drawString("T", 15, this.h - this.margin - 130);
    }

    public void setBreak(double d) {
        this.bp = d;
    }

    public void setHits(int n) {
        this.Hits = Integer.toString(n);
    }

    public void setRuns(int n) {
        this.Runs = Integer.toString(n);
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = new BufferedImage(this.w, this.h, 1);
        return bufferedImage;
    }
}

