/*
 * Decompiled with CFR 0.152.
 */
import Jama.Matrix;

public class HspMonteCarlo {
    private Random gen;
    private GasDev gasdev;
    private Mvn mvn;
    private double[][] bb;
    private VarCov varcov;
    private Attenuator att;
    private double mr;
    private double ave;
    private double std;
    private double unv;
    private int maxit;
    private int i;
    private double gset;
    private double ret;
    private boolean iset = false;
    private boolean theta_mIsUniform = true;
    private Medium sd;
    private Medium sdp;
    private Operandum vd;
    private Operandum vdp;
    private static final double TINY = 1.0E-15;

    public HspMonteCarlo(Medium medium, Operandum operandum) {
        this.sd = medium;
        this.vd = operandum;
        this.sdp = (Medium)this.sd.clone();
        this.vdp = (Operandum)this.vd.clone();
        this.att = new UnsatVirusAttenuator(this.sd, this.vd);
        this.maxit = 100000;
        this.gen = new Random(0.0, 1.0);
        this.gasdev = new GasDev();
        this.varcov = new VarCov();
        Matrix matrix = this.varcov.getVarCov(String.valueOf(this.sd.name.is));
        double[] dArray = new double[]{this.sd.theta_r.mean, this.sd.theta_s.mean, this.sd.a.mean, this.sd.n.mean, this.sd.K0.mean};
        this.mvn = new Mvn(matrix, dArray);
        this.getMvn();
    }

    private double[][] getMvn() {
        this.bb = this.mvn.perturb();
        return this.bb;
    }

    public double getNext() {
        if (++this.i >= this.maxit) {
            this.getMvn();
            this.i = 0;
        }
        this.sdp.a.mean = this.bb[this.i][2];
        this.sdp.theta_s.mean = this.bb[this.i][1];
        this.sdp.theta_r.mean = this.bb[this.i][0];
        if (this.theta_mIsUniform) {
            this.unv = (this.sdp.theta_s.mean - this.sdp.theta_r.mean) * this.gen.nextDouble();
            this.sdp.theta_m.mean = this.sdp.theta_r.mean + this.unv;
        } else {
            this.sdp.theta_m.mean = this.perturb(this.sd.theta_m.mean, this.sd.theta_m.sdev);
        }
        this.sdp.z.mean = this.perturb(this.sd.z.mean, this.sd.z.sdev);
        this.sdp.alphaz.mean = this.perturb(this.sd.alphaz.mean, this.sd.alphaz.sdev);
        this.sdp.n.mean = this.bb[this.i][3];
        this.sdp.t.mean = this.perturb(this.sd.t.mean, this.sd.t.sdev);
        this.sdp.rho.mean = this.perturb(this.sd.rho.mean, this.sd.rho.sdev);
        this.sdp.rp.mean = this.perturb(this.sd.rp.mean, this.sd.rp.sdev);
        this.sdp.K0.mean = this.bb[this.i][4];
        this.vdp.lambda0.mean = this.perturb(this.vd.lambda0.mean, this.vd.lambda0.sdev);
        this.vdp.lambda1.mean = this.perturb(this.vd.lambda1.mean, this.vd.lambda1.sdev);
        this.vdp.kappa0.mean = this.perturb(this.vd.kappa0.mean, this.vd.kappa0.sdev);
        this.vdp.kappa1.mean = this.perturb(this.vd.kappa1.mean, this.vd.kappa1.sdev);
        this.vdp.rv.mean = this.perturb(this.vd.rv.mean, this.vd.rv.sdev);
        this.vdp.Kd.mean = this.perturb(this.vd.Kd.mean, this.vd.Kd.sdev);
        this.att.replace(this.sdp, this.vdp);
        this.mr = this.att.getAttenuation();
        return this.mr;
    }

    private double perturb(double d, double d2) {
        double d3 = d + d2 * this.gasdev.nextDeviate();
        return d3;
    }

    public void setTheta_mUniform(boolean bl) {
        this.theta_mIsUniform = bl;
    }
}

