/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import Jama.util.Maths;
import java.io.Serializable;

public class QRDecomposition
implements Serializable {
    private double[][] QR;
    private int m;
    private int n;
    private double[] Rdiag;

    public QRDecomposition(Matrix matrix) {
        this.QR = matrix.getArrayCopy();
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        this.Rdiag = new double[this.n];
        int n = 0;
        while (n < this.n) {
            double d = 0.0;
            int n2 = n;
            while (n2 < this.m) {
                d = Maths.hypot((double)d, (double)this.QR[n2][n]);
                ++n2;
            }
            if (d != 0.0) {
                if (this.QR[n][n] < 0.0) {
                    d = -d;
                }
                int n3 = n;
                while (n3 < this.m) {
                    double[] dArray = this.QR[n3];
                    int n4 = n;
                    dArray[n4] = dArray[n4] / d;
                    ++n3;
                }
                double[] dArray = this.QR[n];
                int n5 = n;
                dArray[n5] = dArray[n5] + 1.0;
                int n6 = n + 1;
                while (n6 < this.n) {
                    double d2 = 0.0;
                    int n7 = n;
                    while (n7 < this.m) {
                        d2 += this.QR[n7][n] * this.QR[n7][n6];
                        ++n7;
                    }
                    d2 = -d2 / this.QR[n][n];
                    int n8 = n;
                    while (n8 < this.m) {
                        double[] dArray2 = this.QR[n8];
                        int n9 = n6;
                        dArray2[n9] = dArray2[n9] + d2 * this.QR[n8][n];
                        ++n8;
                    }
                    ++n6;
                }
            }
            this.Rdiag[n] = -d;
            ++n;
        }
    }

    public Matrix getH() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = n >= n2 ? this.QR[n][n2] : 0.0;
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public Matrix getQ() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        int n = this.n - 1;
        while (n >= 0) {
            int n2 = 0;
            while (n2 < this.m) {
                dArray[n2][n] = 0.0;
                ++n2;
            }
            dArray[n][n] = 1.0;
            int n3 = n;
            while (n3 < this.n) {
                if (this.QR[n][n] != 0.0) {
                    double d = 0.0;
                    int n4 = n;
                    while (n4 < this.m) {
                        d += this.QR[n4][n] * dArray[n4][n3];
                        ++n4;
                    }
                    d = -d / this.QR[n][n];
                    int n5 = n;
                    while (n5 < this.m) {
                        double[] dArray2 = dArray[n5];
                        int n6 = n3;
                        dArray2[n6] = dArray2[n6] + d * this.QR[n5][n];
                        ++n5;
                    }
                }
                ++n3;
            }
            --n;
        }
        return matrix;
    }

    public Matrix getR() {
        Matrix matrix = new Matrix(this.n, this.n);
        double[][] dArray = matrix.getArray();
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = n < n2 ? this.QR[n][n2] : (n == n2 ? this.Rdiag[n] : 0.0);
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public boolean isFullRank() {
        int n = 0;
        while (n < this.n) {
            if (this.Rdiag[n] == 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Matrix solve(Matrix matrix) {
        int n;
        int n2;
        if (matrix.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int n3 = matrix.getColumnDimension();
        double[][] dArray = matrix.getArrayCopy();
        int n4 = 0;
        while (n4 < this.n) {
            n2 = 0;
            while (n2 < n3) {
                double d = 0.0;
                n = n4;
                while (n < this.m) {
                    d += this.QR[n][n4] * dArray[n][n2];
                    ++n;
                }
                d = -d / this.QR[n4][n4];
                int n5 = n4;
                while (n5 < this.m) {
                    double[] dArray2 = dArray[n5];
                    int n6 = n2;
                    dArray2[n6] = dArray2[n6] + d * this.QR[n5][n4];
                    ++n5;
                }
                ++n2;
            }
            ++n4;
        }
        n2 = this.n - 1;
        while (n2 >= 0) {
            int n7 = 0;
            while (n7 < n3) {
                double[] dArray3 = dArray[n2];
                int n8 = n7++;
                dArray3[n8] = dArray3[n8] / this.Rdiag[n2];
            }
            int n9 = 0;
            while (n9 < n2) {
                n = 0;
                while (n < n3) {
                    double[] dArray4 = dArray[n9];
                    int n10 = n;
                    dArray4[n10] = dArray4[n10] - dArray[n2][n] * this.QR[n9][n2];
                    ++n;
                }
                ++n9;
            }
            --n2;
        }
        return new Matrix(dArray, this.n, n3).getMatrix(0, this.n - 1, 0, n3 - 1);
    }
}

