/*
 * Decompiled with CFR 0.152.
 */
public class UnsatVirusAttenuator
implements Attenuator {
    private Random random;
    private Medium sd;
    private Operandum vd;
    private double alog_a;
    private double alog_n;
    private double alog_K0;
    private double alog_lambda0;
    private double alog_lambda1;
    private double q;
    private double innermost;
    private double qf;
    private double T;
    private double at;
    private double k;
    private double atdia;
    private double arg;
    private double kdia;
    private double gamma;
    private double V;
    private double tau;
    private double D;
    private double De;
    private double Se;
    private double Dz;
    private double Gamma;
    private double A;
    private double pA;
    private static final double ALPHA = 1.0;
    private static final double SIGMA = 9.620208E8;
    private static final double RHOW = 1000000.0;
    private static final double GRAVITY = 1.27008E8;
    private static final double BOLTZMANN = 1.789332768E-13;
    private static final double VISCOSITY = 4.705200006E15;
    private static final double INFINITESIMAL = 1.0E-300;
    private static final double TINY = 1.0E-15;
    private static final double LESSTINY = 1.0E-6;

    public UnsatVirusAttenuator(Medium medium, Operandum operandum) {
        this.sd = medium;
        this.vd = operandum;
        this.random = new Random(300.0, 1000.0);
    }

    public double getAdvection() {
        this.qf = this.getKh(this.sd.theta_m.mean) * (0.1 - this.geth(this.sd.theta_m.mean)) / this.sd.z.mean + this.getKh(this.sd.theta_m.mean) * this.sd.z.mean;
        return this.qf;
    }

    public double getKh(double d) {
        this.Se = (d - this.sd.theta_r.mean) / (this.sd.theta_s.mean - this.sd.theta_r.mean);
        this.innermost = Math.pow(this.Se, this.alog_n / (this.alog_n - 1.0));
        double d2 = this.alog_K0 * Math.sqrt(this.Se) * Math.pow(1.0 - Math.pow(1.0 - this.innermost, 1.0 - 1.0 / this.alog_n), 2.0);
        return d2;
    }

    public double geth(double d) {
        this.Se = (d - this.sd.theta_r.mean) / (this.sd.theta_s.mean - this.sd.theta_r.mean);
        this.innermost = Math.pow(this.Se, this.alog_n / (1.0 - this.alog_n));
        return -1.0 * Math.pow(this.innermost - 1.0, 1.0 / this.alog_n);
    }

    public double getAttenuation() {
        this.alog_a = Math.pow(10.0, this.sd.a.mean);
        this.alog_n = Math.pow(10.0, this.sd.n.mean);
        this.alog_K0 = Math.pow(10.0, this.sd.K0.mean);
        this.alog_lambda0 = Math.pow(10.0, this.vd.lambda0.mean);
        this.alog_lambda1 = Math.pow(10.0, this.vd.lambda1.mean);
        this.T = this.sd.t.mean + 273.16;
        this.q = this.getAdvection();
        this.at = 3.0 * (1.0 - this.sd.theta_s.mean) / this.sd.rp.mean;
        this.k = this.vd.kappa0.mean * this.at;
        this.arg = Math.pow(this.Se, this.alog_n / (1.0 - this.alog_n));
        this.atdia = 1.27008E14 * this.sd.theta_m.mean * Math.pow(this.arg - 1.0, 1.0 / this.alog_n) / (9.620208E8 * this.alog_a);
        this.kdia = this.vd.kappa1.mean * this.atdia;
        this.gamma = this.alog_lambda0 + this.alog_lambda1 * this.sd.rho.mean * this.k / (this.k * this.sd.theta_m.mean / this.vd.Kd.mean + this.alog_lambda1 * this.sd.rho.mean) + this.kdia;
        this.V = this.q / this.sd.theta_m.mean;
        this.tau = this.sd.theta_m.mean <= 0.2 ? Math.pow(this.sd.theta_s.mean, 2.0) / Math.pow(this.sd.theta_m.mean, 2.0) : Math.pow(this.sd.theta_s.mean, 2.0) / Math.pow(this.sd.theta_m.mean, 2.0);
        this.D = 1.789332768E-13 * this.T / (8.86909306351215E16 * this.vd.rv.mean);
        this.De = this.D * this.tau;
        this.Dz = this.sd.alphaz.mean * this.V + this.De;
        this.Gamma = (this.V - Math.sqrt(this.V * this.V + 4.0 * this.Dz * this.gamma)) / (2.0 * this.Dz);
        this.A = Math.exp(this.Gamma * this.sd.z.mean);
        if (this.A > 1.0) {
            this.A = 1.0;
        }
        this.pA = this.A <= 1.0E-300 ? -this.random.nextDouble() : HspBasicMath.log10(this.A);
        return this.pA;
    }

    public Medium getMedium() {
        return this.sd;
    }

    public Operandum getOperandum() {
        return this.vd;
    }

    public void replace(Medium medium, Operandum operandum) {
        this.sd = medium;
        this.vd = operandum;
        if (this.sd.theta_s.mean <= 0.0) {
            this.sd.theta_s.mean = 1.0E-300;
        }
        if (this.sd.theta_r.mean <= 0.0) {
            this.sd.theta_r.mean = 1.0E-300;
        }
        if (this.sd.theta_m.mean <= 0.0) {
            this.sd.theta_m.mean = 1.0E-300;
        }
        if (this.sd.z.mean <= 0.0) {
            this.sd.z.mean = 1.0E-300;
        }
        if (this.sd.n.mean > 1.0) {
            this.sd.n.mean = 1.0;
        }
        if (this.sd.rho.mean <= 0.0) {
            this.sd.rho.mean = 1.0E-300;
        }
        if (this.sd.rp.mean <= 0.0) {
            this.sd.rp.mean = 1.0E-300;
        }
        if (this.vd.kappa0.mean < 0.0) {
            this.vd.kappa0.mean = 1.0E-300;
        }
        if (this.vd.kappa1.mean <= 0.0) {
            this.vd.kappa1.mean = 1.0E-300;
        }
        if (this.vd.Kd.mean <= 0.0) {
            this.vd.Kd.mean = 1.0E-300;
        }
        if (this.sd.theta_s.mean >= 1.0) {
            this.sd.theta_s.mean = 1.0;
        }
        if (this.sd.theta_r.mean >= 1.0) {
            this.sd.theta_r.mean = 1.0;
        }
        if (this.sd.theta_m.mean >= 1.0) {
            this.sd.theta_m.mean = 1.0;
        }
        if (this.sd.theta_r.mean >= this.sd.theta_m.mean) {
            this.sd.theta_r.mean = this.sd.theta_m.mean - 1.0E-6;
        }
        if (this.sd.theta_s.mean <= this.sd.theta_m.mean) {
            this.sd.theta_s.mean = this.sd.theta_m.mean + 1.0E-6;
        }
    }
}

