/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VirusPanel
extends JPanel
implements Observer {
    private VirusComboPanel Vcp;
    private JPanel fP;
    private JLabel[] lambdaL;
    private JLabel[] kappaL;
    private JLabel rvL;
    private JLabel kdL;
    private String[] units;
    private NormalF[] lambdaF;
    private NormalF[] kappaF;
    private NormalF rvF;
    private NormalF kdF;

    public VirusPanel(Gossiper gossiper) {
        JarLoadable jarLoadable = new JarLoadable();
        gossiper.addObserver(this);
        JLabel jLabel = new JLabel("Parameter");
        JLabel jLabel2 = new JLabel("Mean");
        JLabel jLabel3 = new JLabel("Std. Deviation");
        JLabel jLabel4 = new JLabel("Units");
        JLabel[] jLabelArray = new JLabel[]{new JLabel(new ImageIcon(jarLoadable.loadImage("lambda.gif"))), new JLabel(new ImageIcon(jarLoadable.loadImage("lambdastar.gif")))};
        jLabelArray[0].setToolTipText("Log Mobile Virus Inactivation Rate");
        jLabelArray[1].setToolTipText("Log Solid-sorbed Virus Inactivation Rate");
        this.lambdaL = jLabelArray;
        JLabel[] jLabelArray2 = new JLabel[]{new JLabel(new ImageIcon(jarLoadable.loadImage("kappa.gif"))), new JLabel(new ImageIcon(jarLoadable.loadImage("kappadia.gif")))};
        jLabelArray2[0].setToolTipText("Mobile to solid-sorbed mass transfer coeff.");
        jLabelArray2[1].setToolTipText("Mobile to air-sorbed mass transfer coeff.");
        this.kappaL = jLabelArray2;
        this.rvL = new JLabel(new ImageIcon(jarLoadable.loadImage("rv.gif")));
        this.rvL.setToolTipText("Radius of virus");
        this.kdL = new JLabel(new ImageIcon(jarLoadable.loadImage("kd.gif")));
        this.kdL.setToolTipText("Mobile to solid-sorbed equilibrium partition coeff.");
        this.lambdaF = new NormalF[3];
        this.lambdaF[0] = new NormalF();
        this.lambdaF[1] = new NormalF();
        this.kappaF = new NormalF[2];
        this.kappaF[0] = new NormalF();
        this.kappaF[1] = new NormalF();
        this.rvF = new NormalF();
        this.kdF = new NormalF();
        this.units = new String[8];
        this.units[0] = "  h-\u00b9";
        this.units[2] = " log10( h-\u00b9 )";
        this.units[1] = " log10( h-\u00b9 )";
        this.units[4] = " m h -\u00b9 ";
        this.units[3] = " m h -\u00b9 ";
        this.units[5] = " m";
        this.units[6] = " any";
        this.units[7] = " m\u00b3 g -\u00b9";
        this.fP = new JPanel();
        GridLayout gridLayout = new GridLayout(8, 4);
        this.setLayout(gridLayout);
        this.Vcp = new VirusComboPanel(gossiper);
        this.add(jLabel);
        this.add(jLabel2);
        this.add(jLabel3);
        this.add(jLabel4);
        this.add(this.lambdaL[0]);
        this.add(this.lambdaF[0].m);
        this.add(this.lambdaF[0].s);
        this.add(new JLabel(this.units[1]));
        this.add(this.lambdaL[1]);
        this.add(this.lambdaF[1].m);
        this.add(this.lambdaF[1].s);
        this.add(new JLabel(this.units[2]));
        this.add(this.kappaL[0]);
        this.add(this.kappaF[0].m);
        this.add(this.kappaF[0].s);
        this.add(new JLabel(this.units[3]));
        this.add(this.kappaL[1]);
        this.add(this.kappaF[1].m);
        this.add(this.kappaF[1].s);
        this.add(new JLabel(this.units[4]));
        this.add(this.rvL);
        this.add(this.rvF.m);
        this.add(this.rvF.s);
        this.add(new JLabel(this.units[5]));
        this.add(this.kdL);
        this.add(this.kdF.m);
        this.add(this.kdF.s);
        this.add(new JLabel(this.units[7]));
        this.add(this.fP);
        this.add(this.Vcp);
        this.add(this.fP);
        this.add(this.fP);
    }

    public void update(Observable observable, Object object) {
        String string = object.getClass().getName();
        if (string.equals("Operandum")) {
            Operandum operandum = (Operandum)object;
            this.lambdaF[0].m.setText(Double.toString(operandum.lambda0.mean));
            this.lambdaF[0].s.setText(Double.toString(operandum.lambda0.sdev));
            this.lambdaF[1].m.setText(Double.toString(operandum.lambda1.mean));
            this.lambdaF[1].s.setText(Double.toString(operandum.lambda1.sdev));
            this.kappaF[0].m.setText(Double.toString(operandum.kappa0.mean));
            this.kappaF[0].s.setText(Double.toString(operandum.kappa0.sdev));
            this.kappaF[1].m.setText(Double.toString(operandum.kappa1.mean));
            this.kappaF[1].s.setText(Double.toString(operandum.kappa1.sdev));
            this.rvF.m.setText(Double.toString(operandum.rv.mean));
            this.rvF.s.setText(Double.toString(operandum.rv.sdev));
            this.kdF.m.setText(Double.toString(operandum.Kd.mean));
            this.kdF.s.setText(Double.toString(operandum.Kd.sdev));
            this.repaint();
        }
    }

    public Operandum getData() {
        Operandum operandum = new Operandum();
        Double d = new Double(this.lambdaF[0].m.getText());
        operandum.lambda0.mean = d;
        d = new Double(this.lambdaF[0].s.getText());
        operandum.lambda0.sdev = d;
        d = new Double(this.lambdaF[1].m.getText());
        operandum.lambda1.mean = d;
        d = new Double(this.lambdaF[1].s.getText());
        operandum.lambda1.sdev = d;
        d = new Double(this.kappaF[0].m.getText());
        operandum.kappa0.mean = d;
        d = new Double(this.kappaF[0].s.getText());
        operandum.kappa0.sdev = d;
        d = new Double(this.kappaF[1].m.getText());
        operandum.kappa1.mean = d;
        d = new Double(this.kappaF[1].s.getText());
        operandum.kappa1.sdev = d;
        d = new Double(this.rvF.m.getText());
        operandum.rv.mean = d;
        d = new Double(this.rvF.s.getText());
        operandum.rv.sdev = d;
        d = new Double(this.kdF.m.getText());
        operandum.Kd.mean = d;
        d = new Double(this.kdF.s.getText());
        operandum.Kd.sdev = d;
        return operandum;
    }

    public void putData(Operandum operandum) {
        this.Vcp.addVirus(operandum, new String(operandum.name.is));
    }

    public String[] getLabels() {
        String[] stringArray = new String[]{this.lambdaL[0].getToolTipText(), this.lambdaL[1].getToolTipText(), this.kappaL[0].getToolTipText(), this.kappaL[1].getToolTipText(), this.rvL.getToolTipText(), this.kdL.getToolTipText()};
        return stringArray;
    }

    public String[] getUnits() {
        return this.units;
    }

    public void requestAttention(String string) {
        if (string.equalsIgnoreCase("rv.m")) {
            this.rvF.m.requestFocus();
        }
        if (string.equalsIgnoreCase("rv.s")) {
            this.rvF.s.requestFocus();
        }
        if (string.equalsIgnoreCase("kappa0.s")) {
            this.kappaF[0].s.requestFocus();
        }
        if (string.equalsIgnoreCase("kappa1.s")) {
            this.kappaF[1].s.requestFocus();
        }
        if (string.equalsIgnoreCase("Kd.s")) {
            this.kdF.s.requestFocus();
        }
    }
}

