import java.util.*;
import java.io.*;

/** This class is a surrogate for a forthcoming <i>bona fide</i> XML
parser which I have not yet written. It simply takes an entire
<b>RandomAccessFile</b> and tokenizes it to build either new
<b>Operandum</b> or new <b>Medium</b> data sets created by the user.
In the future, <i>Virulo</i> should also be able to employ a <i>bona
fide</i> persistence model so user's won't have to keep opening up
their XML files every time.
<P>
@author Barton R. Faulkner<br>
U.S. EPA Office of Research and Development<br>
National Risk Management Research Laboratory<br>
Ada, Oklahoma, USA<br>
@version 31 October 2002
*/

public class DataBuilder {
	public DataBuilder() {
		me=new Medium();
		op=new Operandum();
		obj=new Object();
		element=new String();
	}
	public Object getData(RandomAccessFile xmlfile) {
		fstring="";
		// Try to read the whole xml file in to one long String
		// for tokenizing:
		try {
			while((xmlline=xmlfile.readLine()) != null) {
				fstring+=xmlline;
			}
			xmlfile.close();
		} catch (Exception e) {
			System.out.println(e);
		}
		return parse(fstring);
	}
	private Object parse(String str) {
		Obviously=null;
		Name=null;
		c=str.toCharArray();
		for (i=0; i<c.length; i++) {
			// There are 4 possible places I can be,
			// 1. at the start of an element:
			if (c[i]=='<') {
				offset=i;
				element="";
				ImInAnElement=true;
			// 2. at the end of an element's tag, in which case
			// I'm entering the place where I can find data:
			} else if (c[i]=='>') {
				element=new String(c,offset+1,count);
				element=element.trim();
				if (element.equalsIgnoreCase("operandum"))
					Obviously="operandum";
				if (element.equalsIgnoreCase("medium"))
					Obviously="medium";
				if (element.equalsIgnoreCase("name")) {
					j=0;
					while (c[i+j]!='<') j++;
					Name=new String(c,i+1,j-1);
				}
				ImInAnElement=false;
				if (gotMean && gotSdev) {
					element=element.substring(1);
					element=element.trim();
					buildUp(Obviously, Name, element, Mean, Sdev);
					gotMean=false;
					gotSdev=false;
				} else if (element.equalsIgnoreCase("mean")) {
					j=0;
					while (c[i+j]!='<') j++;
					Mean=new String(c,i+1,j-1);
					gotMean=true;
					k=0;
					while (c[i+j+k]!='>') k++;
					i=i+j+k;
				} else if (element.equalsIgnoreCase("sdev")) {
					j=0;
					while (c[i+j]!='<') j++;
					Sdev=new String(c,i+1,j-1);
					gotSdev=true;
					k=0;
					while (c[i+j+k]!='>') k++;
					i=i+j+k;
				}
				count=0;
			// 3. inside, traversing the element:
			} else {
				if (ImInAnElement) count++;
			}
			// 4. waiting until I find something I care about...
		}
		if (Obviously.equalsIgnoreCase("medium")) {
			obj=(Object)me;
		} else if (Obviously.equalsIgnoreCase("operandum")) {
			obj=(Object)op;
		}
		return obj;
	}
	private void buildUp(String object, String name, String key, String m, String s) {
		if (object.equalsIgnoreCase("operandum")) {
			n=new Normal(Double.parseDouble(m), Double.parseDouble(s));
			StringAsChars sac=new StringAsChars();
			sac.is=name.toCharArray();
			op.name=sac;
			if (key.equals("lam0")) op.lambda0=n;
			if (key.equals("lam1")) op.lambda1=n;
			if (key.equals("kap0")) op.kappa0=n;
			if (key.equals("kap1")) op.kappa1=n;
			if (key.equals("radv"))	 op.rv=n;
			if (key.equals("kd"))	 op.Kd=n;
		} else if (object.equalsIgnoreCase("medium")) {
			n=new Normal(Double.parseDouble(m), Double.parseDouble(s));
			StringAsChars sac=new StringAsChars();
			sac.is=name.toCharArray();
			me.name=sac;
			if (key.equals("th_r")) me.theta_r=n;
			if (key.equals("th_m")) me.theta_m=n;
			if (key.equals("th_s")) me.theta_s=n;
			if (key.equals("len"))  me.z=n;
			if (key.equals("alpz")) me.alphaz=n;
			if (key.equals("logn")) me.n=n;
			if (key.equals("temp")) me.t=n;
			if (key.equals("rho"))  me.rho=n;
			if (key.equals("rp"))   me.rp=n;
			if (key.equals("logks")) me.K0=n;
			if (key.equals("logal")) me.a=n;
		}
	}
	private Operandum op;
	private Medium me;
	private Object obj;
	private char[] c;
	private String xmlline, fstring, element, Mean, Sdev, Name, Obviously, name;
	private Normal n;
	private int i, j, k, offset, count;
	private boolean ImInAnElement, gotMean, gotSdev;
}
