import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
   <b>FlowComboPanel</b> class.
<P>
This is a combo panel that the user uses to select a soil type.
It has a listener that retrieves the appropriate data indexed by
the <b>String</b> which is the title of the soil type.

@author Barton R. Faulkner,
        U.S. EPA Office of Research and Development
        National Risk Management Research Laboratory
        Ada, Oklahoma, USA.
@version 11 November 2002
*/

public class FlowComboPanel extends JPanel {

/* ------------------------
   Constructor
 * ------------------------ */

	/** Construct a <b>FlowComboPanel</b> instance.
	@param gossiper A <b>Gossiper</b> for this object.
	@see Gossiper
	@see Medium
	@see SoilStack
	*/

	public FlowComboPanel(Gossiper gossiper) {
		gpr=gossiper;
		soilStack=new SoilStack();
		newdata=new Medium();
		comboBox=new JComboBox();
		comboBox.addItem("clay");
		comboBox.addItem("clayloam");
		comboBox.addItem("loam");
		comboBox.addItem("loamysand");
		comboBox.addItem("sand");
		comboBox.addItem("sandyclayloam");
		comboBox.addItem("sandyloam");
		comboBox.addItem("silt");
		comboBox.addItem("siltloam");
		comboBox.addItem("siltyclay");
		comboBox.addItem("siltyclayloam");
		comboBox.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				newdata=soilStack.getData(
					(String)(comboBox.getSelectedItem())
				);
				tell(newdata);
			}
		});

		GridLayout gl=new GridLayout(1,2);
		setLayout(gl);
		add(comboBox);
		newdata=soilStack.getData(
			(String)(comboBox.getSelectedItem())
		);
		tell(newdata);
	}
	public String getSelection() {
		return (String)(comboBox.getSelectedItem());
	}
	public void addSoil(Medium soil, String name) {
		comboBox.addItem(name);
		soilStack.addSoil(soil);
	}
	private void tell(Medium nd) {
		gpr.tell(nd);
	}
	private Gossiper gpr;
	private SoilStack soilStack;
	private Medium newdata;
	private JComboBox comboBox;
	private int i;
}
