/**
Merely a Java translation of the popular C program <tt>gasdev.c</tt>
(Press et al. 1988) for generating normally distributed deviates.
<hr>
<b>Reference</b>:
<p>
Press, WH, Teukolsky, SA, Vetterling, WT, Flannery, BP, 1992, <i>Numerical
        Recipes in C</i>, Cambridge University Press, Cambridge, UK, 994 p.

@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
@version 18 July 2001
*/

public class GasDev {
	/** Create one.
	*/
	public GasDev() {
		gen=new Random(ll,ul);
	}
	/** Obtain the next random deviate ~ N(ll,ul), where by default
		ll=0, ul=1000.
	@return the deviate
	*/
	public double nextDeviate() {
                // From Numerical Recipes in C, pp.289-290.
                // This is the Box-Muller method. It returns
                // Gaussian distributed deviates with zero
                // mean and variance of 1.
                if (!iset) {
                        do {
                                v1=2.*gen.nextDouble()/(ul-ll)-1.;
                                v2=2.*gen.nextDouble()/(ul-ll)-1.;
                                rsq=v1*v1+v2*v2;
                        } while (rsq>=1. || rsq==0.);
                        fac=Math.sqrt(-2.*Math.log(rsq)/rsq);
                        gset=v1*fac;
                        iset=true;
                        ret=v2*fac;
                } else {
                        ret=gset;
                        iset=false;
                }
                return ret;
	}
	/** Change the range for the deviates from the default of
		[0., 10000].
	@param lower Lower limit of the range;
	@param upper Upper limit of the range;
	*/
	public void changeRange(double lower, double upper) {
		ll=lower;
		ul=upper;
	}
	private Random gen;
	private double v1, v2, rsq, gset, ret, fac;
	private double ll=0.;
	private double ul=10000.;
	private boolean iset=false;
}
