import java.util.Observable;

/**
<P>
Subclass of <tt>java.util.Observable</tt> that acts as the
"subject" of the <i>Observer</i> design pattern (Gamma et al. 1995)
by using the java class written for this purpose.
<hr>
<b>Reference:</b>
<p>
Gamma, E., Helm, R., Johnson, R., Vlissides, J. 1995. <i>Design Patterns,
Elements of Reusable Object-Oriented Software</i>. Addision-Wesley.

@see Observable
@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
@version 6 February 2001
*/

public class Gossiper extends Observable {
	/** Creat a new <b>Gossiper</b> object.
	*/
	public Gossiper() {
	}
	/** Inform <b>Gossiper</b> object of a change in the
	    concrete subjects so that it will notify the
	    designated observers.
	*/
	public void tell(Object o) {
		setChanged();
		notifyObservers(o);
	}
}
