import java.net.*;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import javax.swing.*;
/** Allows images files to be loaded from a Java Archive (jar) file.
Adapted from examples posted in the UC Berkeley Advanced Java Archives<br>
<code>https://lists.xcf.berkeley.edu/lists/advanced-java/</code><br>
lists.
@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
@version 17 October 2002
*/

public class JarLoadable {
	protected Image loadImage(String name){
		Image image=null;
		byte[] bite=null;
		Toolkit toolkit=Toolkit.getDefaultToolkit();
		InputStream in=getClass().getResourceAsStream(name);
		try {
			int length=in.available();
			bite=new byte[length];
			in.read(bite);
			image=toolkit.createImage(bite);
		} catch(Exception exc) {
			return null;
		}
		return image;
	}
}
