/**
   <b>Medium</b> class.
<P>
Data structure for transport medium. Notice its instance is a
composed object that is cloneable.

@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
@version 5 March 2001
*/

public class Medium implements Cloneable {

	/** USDA name of the soil stored as a char[].
	*/
	public StringAsChars name=new StringAsChars();

	/** Empirical constant van Genucten's alpha (dimensionless).
	*/
	public Normal a=new Normal();

	/** Soil water content parameters:
		{Residual water content,
		Water content,
		Saturated water content}
		(dimensionless).
	*/
	public Normal theta_s=new Normal();
	public Normal theta_r=new Normal();
	public Normal theta_m=new Normal();

	/** Thickness of the proposed hydrogeologic barrier (meters).
	*/
	public Normal z=new Normal();

	/** Vertical dispersivity (meters).
	*/
	public Normal alphaz=new Normal();

	/** van Genuchten parameter (dimensionless).
	*/
	public Normal n=new Normal();

	/** Temperature for computing molecular diffusivity (degrees Celsius).
	*/
	public Normal t=new Normal();

	/** Soil bulk density (g/m^3).
	*/
	public Normal rho=new Normal();

	/** Average radius of soil particles (meter).
	*/
	public Normal rp=new Normal();

	/** Saturated hydraulic conductivity (meter/hr).
	*/
	public Normal K0=new Normal();

	/** Clone method redefinition
	*/
	public Object clone() {
		// Method described by Bruce Eckel p. 555-556.
		Medium sd=null;
		try {
			sd=(Medium)super.clone();
		} catch (CloneNotSupportedException e) {
		}
		// Clone the Normals too:
		Normal tmp=null;
		sd.name=(StringAsChars)sd.name.clone();
		sd.a=(Normal)sd.a.clone();
		sd.theta_s=(Normal)sd.theta_s.clone();
		sd.theta_r=(Normal)sd.theta_r.clone();
		sd.theta_m=(Normal)sd.theta_m.clone();
		sd.z=(Normal)sd.z.clone();
		sd.alphaz=(Normal)sd.alphaz.clone();
		sd.n=(Normal)sd.n.clone();
		sd.t=(Normal)sd.t.clone();
		sd.rho=(Normal)sd.rho.clone();
		sd.rp=(Normal)sd.rp.clone();
		sd.K0=(Normal)sd.K0.clone();
		return sd;
	}
}
