import java.io.IOException;
import java.util.StringTokenizer;

// This class is a surrogate for a forthcoming bona fide XMLWriter.
// It'll do for now

public class MediumXMLWriter {
	public MediumXMLWriter(Medium medium, String name) {
		m=medium;
		tokens=new StringTokenizer(name,System.getProperty("file.separator"));
		writeXML();
	}
	private void writeXML() {
		for (i=0; i<=tokens.countTokens(); i++) {
			lastpart=tokens.nextToken();
		}
		lastpart=tokens.nextToken();
		if (System.getProperty("os.name").startsWith("Win"))
			lastpart=tokens.nextToken();
		xS="<?xml version=\"1.0\"?>\n\n";
		xS+="<media>\n";
		xS+=" <medium>\n";
		xS+="  <name>"+lastpart+"_xml</name>\n";
		xS+="   <th_r>\n    <mean>"+Double.toString(m.theta_r.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.theta_r.sdev)+"</sdev>\n   </th_r>\n";
		xS+="   <th_m>\n    <mean>"+Double.toString(m.theta_m.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.theta_m.sdev)+"</sdev>\n   </th_m>\n";
		xS+="   <th_s>\n    <mean>"+Double.toString(m.theta_s.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.theta_s.sdev)+"</sdev>\n   </th_s>\n";
		xS+="   <logks>\n    <mean>"+Double.toString(m.K0.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.K0.sdev)+"</sdev>\n   </logks>\n";
		xS+="   <logal>\n    <mean>"+Double.toString(m.a.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.a.sdev)+"</sdev>\n   </logal>\n";
		xS+="   <logn>\n    <mean>"+Double.toString(m.n.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.n.sdev)+"</sdev>\n   </logn>\n";
		xS+="   <rho>\n    <mean>"+Double.toString(m.rho.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.rho.sdev)+"</sdev>\n   </rho>\n";
		xS+="   <rp>\n    <mean>"+Double.toString(m.rp.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.rp.sdev)+"</sdev>\n   </rp>\n";
		xS+="   <alpz>\n    <mean>"+Double.toString(m.alphaz.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.alphaz.sdev)+"</sdev>\n   </alpz>\n";
		xS+="   <temp>\n    <mean>"+Double.toString(m.t.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.t.sdev)+"</sdev>\n   </temp>\n";
		xS+="   <len>\n    <mean>"+Double.toString(m.z.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.z.sdev)+"</sdev>\n   </len>\n";
		xS+=" </medium>\n";
		xS+="</media>\n";
	}
	public String getXML() {
		return xS;
	}
	private StringTokenizer tokens;
	private String xS, lastpart;
	private Medium m;
	private int i;
}
