import java.io.IOException;
import java.util.StringTokenizer;

// This class is a surrogate for a forthcoming bona fide XMLWriter.
// It'll do for now.

public class OperandumXMLWriter {
	public OperandumXMLWriter(Operandum operandum, String name) {
		m=operandum;
		tokens=new StringTokenizer(name,System.getProperty("file.separator"));
	}
	public String writeXML() {
		for (i=0; i<=tokens.countTokens(); i++) {
			lastpart=tokens.nextToken();
		}
		lastpart=tokens.nextToken();
		if (System.getProperty("os.name").startsWith("Win")) 
			lastpart=tokens.nextToken();
		xS="<?xml version=\"1.0\"?>\n\n";
		xS+="<operandi>\n";
		xS+=" <operandum>\n";
		xS+="  <name>"+lastpart+"_xml</name>\n";
		xS+="   <lam0>\n    <mean>"+Double.toString(m.lambda0.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.lambda0.sdev)+"</sdev>\n   </lam0>\n";
		xS+="   <lam1>\n    <mean>"+Double.toString(m.lambda1.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.lambda1.sdev)+"</sdev>\n   </lam1>\n";
		xS+="   <kap0>\n    <mean>"+Double.toString(m.kappa0.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.kappa0.sdev)+"</sdev>\n   </kap0>\n";
		xS+="   <kap1>\n    <mean>"+Double.toString(m.kappa1.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.kappa1.sdev)+"</sdev>\n   </kap1>\n";
		xS+="   <radv>\n    <mean>"+Double.toString(m.rv.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.rv.sdev)+"</sdev>\n   </radv>\n";
		xS+="   <kd>\n    <mean>"+Double.toString(m.Kd.mean)+"</mean>\n";
		xS+= "    <sdev>"+Double.toString(m.Kd.sdev)+"</sdev>\n   </kd>\n";
		xS+=" </operandum>\n";
		xS+="</operandi>\n";
		return xS;
	}
	private StringTokenizer tokens;
	private String xS, lastpart;
	private Operandum m;
	private int i;
}
