import com.sun.image.codec.jpeg.*;
import java.io.*;
import java.util.StringTokenizer;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.image.BufferedImage;
import java.text.*;

/**
   <b>ViruloFrame</b> class.
<P>

@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
@version 18 November 2002
@see JFrame
*/

public class ViruloFrame extends JFrame {
	Toolkit tk=Toolkit.getDefaultToolkit();
	Dimension d=tk.getScreenSize();
	int screenHeight=d.height;
	int screenWidth =d.width;
	/** Construct a <b>ViruloFrame</b>.
	*/
	public ViruloFrame() {
		jar=new JarLoadable();
		gossiper=new Gossiper();
		panelFlow=new FlowPanel(gossiper);
		panelVirus=new VirusPanel(gossiper);
                setTitle("Virulo");
		setSize(650,620);
		setLocation( (int)(screenWidth/30), (int)(screenHeight/30) );
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});

		Container contentPane=getContentPane();
		bin=new int[numbins];
		panelGout=new HistoPanel(bin,hpanelwd,hpanelht);
		retainCheckBox=new JCheckBox("Retain and Accumulate");
		panelGout.add(retainCheckBox);
		panelTout=new OutputPanel();
		JScrollPane tsp=new JScrollPane(panelTout);

		tp=new JTabbedPane();
		tp.addTab("Flow Parameters",new ImageIcon(
			jar.loadImage("flow.gif")),
			panelFlow,"flow parameters");
		tp.addTab("Virus Parameters",new ImageIcon(
			jar.loadImage("virus.gif")),
			panelVirus,"virus parameters");
		tp.addTab("Histogram",new ImageIcon(
			jar.loadImage("histogram.gif")),
			panelGout,"histogram");
		tp.addTab("Probability",new ImageIcon(
			jar.loadImage("tout.gif")),
			tsp,"text");
		contentPane.add(tp,"Center");

		fileMenu=new JMenu("File");
		openItem=new JMenuItem("Open xml ..");
		saveItem=new JMenuItem("Save as ..");
		chooser=new JFileChooser();
		chooser.setFileFilter(new JpgFilter());
		saveItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent se) {
			   chooser.showSaveDialog(null);
			   File file=chooser.getSelectedFile();
			   String fileString=file.getPath();
			   if (tp.getSelectedIndex()==3) {
				try {
					if (!fileString.endsWith(".txt"))
						fileString+=".txt";
					rof=new RandomAccessFile(fileString,"rw");
					rof.writeBytes(outString);
					rof.close();
				} catch (IOException ie) {}
			   } else if (tp.getSelectedIndex()==2) {
				try {
					out=new FileOutputStream(file);
					JPEGImageEncoder encoder=
						JPEGCodec.createJPEGEncoder(out);
					encoder.encode(panelGout.getImage());
				} catch (IOException ie) {}
			   } else if (tp.getSelectedIndex()==0) {
				if (fileString.endsWith(".xml")) {
					fileString=fileString.substring(
						0,fileString.lastIndexOf("."));
				}
				sd=panelFlow.getData();
				sdwriter=new MediumXMLWriter(sd,fileString);
				try {
					if (!fileString.endsWith(".xml"))
						fileString+=".xml";
					rof=new RandomAccessFile(fileString,"rw");
					rof.setLength(0);
					rof.writeBytes(sdwriter.getXML());
					rof.close();
				} catch(IOException ie) {}
			   } else if (tp.getSelectedIndex()==1) {
				if (fileString.endsWith(".xml")) {
					fileString=fileString.substring(
						0,fileString.lastIndexOf("."));
				}
				vd=panelVirus.getData();
				vdwriter=
					new OperandumXMLWriter(vd,fileString);
				outString=vdwriter.writeXML();
				try {
					if (!fileString.endsWith(".xml"))
						fileString+=".xml";
					rof=new RandomAccessFile(fileString,"rw");
					rof.setLength(0);
					rof.writeBytes(outString);
					rof.close();
				} catch(IOException ie) {}
			   }
			}
		});
		saveItem.setMnemonic('S');
		fileMenu.add(saveItem);
		exitItem=new JMenuItem("Exit");
		exitItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ee) {
				System.exit(0);
			}
		});
		openItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent oe) {
			   chooser.showOpenDialog(null);
			   File file=chooser.getSelectedFile();
			   fileString=file.getPath();
			   obj=new Object();
			   try {
				if (!fileString.endsWith(".xml")) fileString+=".xml";
				rof=new RandomAccessFile(fileString,"rw");
				DataBuilder builder=new DataBuilder();
				obj=builder.getData(rof);
				if (obj.toString().startsWith("Me"))
					panelFlow.putData((Medium)obj);
				if (obj.toString().startsWith("Op"))
					panelVirus.putData((Operandum)obj);
				rof.close();
			   } catch (IOException ie) {
			   }
			}
		});
		openItem.setMnemonic('O');
		fileMenu.add(openItem);
		fileMenu.add(exitItem);
		exitItem.setMnemonic('x');
		editMenu=new JMenu("Edit");
		editMenu.setMnemonic('E');
		copyItem=new JMenuItem("Copy to clipboard");
		copyItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ce) {
			   if (tp.getSelectedIndex()==3) panelTout.copy();
			}
		});
		copyItem.setMnemonic('C');
		editMenu.add(copyItem);
		selectItem=new JMenuItem("Select all");
		selectItem.setMnemonic('a');
		selectItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
			   if (tp.getSelectedIndex()==3) panelTout.selectAll();
			}
		});
		editMenu.add(selectItem);
		runMenu=new JMenu("Run");
		runMenu.setMnemonic('R');
		goItem=new JMenuItem("Start Simulation",new ImageIcon(
                        jar.loadImage("run.gif")));
		goItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ge) {
				stop=false;
				tp.setSelectedIndex(2);
				MloThread=new UpdateThread();
				MloThread.start();
			}
		});
		stopItem=new JMenuItem("Stop Simulation",new ImageIcon(
                        jar.loadImage("stop.gif")));
		stopItem.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent se) {
				stop=true;
                        }
                });
		runMenu.add(goItem);
		runMenu.add(stopItem);
		goItem.setMnemonic('S');
                helpMenu=new JMenu("About");
		aboutItem=new JMenuItem("About Virulo..");
		aboutItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent afe) {
				aframe=new AboutFrame();
				aframe.show();
			}
		});
		aboutItem.setMnemonic('A');
                helpMenu.add(aboutItem);
                helpMenu.setMnemonic('H');
                runButton=new JButton("Start Simulation",
			new ImageIcon(
			jar.loadImage("run.gif")));
		sLabel=new JLabel(" Threshold Attenuation (\u03b5): ");
		inLabel=new JLabel(" ( -log10 )  ");
		breakPointTextField=new JTextField("4",3);
		breakPointTextField.setHorizontalAlignment(JTextField.CENTER);
		breakPointTextField.setToolTipText("The logarithm, base 10, of "+
			"the target attenuation factor");
		runButton.setToolTipText("Start new simulation with current parameters");
		runButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				stop=false;
				tp.setSelectedIndex(2);
				MloThread=new UpdateThread();
				MloThread.start();
			}
		});
		stopButton=new JButton("Stop",
                        new ImageIcon(
                        jar.loadImage("stop.gif")));
                stopButton.setToolTipText("Stop current simulation");
                stopButton.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
				stop=true;
                        }
                });
		mb=new JMenuBar();
		mb.add(fileMenu);
		fileMenu.setMnemonic('F');
		mb.add(editMenu);
		mb.add(runMenu);
		mb.add(helpMenu);
                mb.add(runButton);
		mb.add(stopButton);
		mb.add(sLabel);
		mb.add(breakPointTextField);
		mb.add(inLabel);
                setJMenuBar(mb);

		sd=panelFlow.getData();
		vd=panelVirus.getData();
		soilData=(Medium)(sd.clone());
		virusData=(Operandum)(vd.clone());
		Mlo=new HspMonteCarlo(soilData,virusData);
	}
	/** Run the model with the current parameters to be sent to the
	<b>Attenuator</b> object.
	*/
	class UpdateThread extends Thread {
		Runnable update, finish;
		public UpdateThread() {
			if (!retainCheckBox.isSelected()) runcount=0;
			update=new Runnable() {
				public void run() {
					panelGout.setBreak(bp);
					panelGout.setHits(hits);
					panelGout.setRuns(runcount);
					panelGout.redraw(bin);
				}
			};
			finish=new Runnable() {
				public void run() {
					panelGout.setRuns(runcount-1);
					panelGout.setHits(hits);
					panelGout.redraw(bin);
                			String[] sLabels=panelFlow.getLabels();
                			String[] vLabels=panelVirus.getLabels();
                			String[] sUnits=panelFlow.getUnits();
                			String[] vUnits=panelVirus.getUnits();
					if (panelFlow.theta_mIsUniform()) {
						theString=": random between "+
							sLabels[1]+" and "+sLabels[3];
					} else {
						theString=": "+
							soilData.theta_m.mean+
							"("+soilData.theta_m.sdev+") ";
					}
                			outString="Output from Virulo "+
                        			"model:\n\n"+
                        			"Input parameters used:\n"+
                        			"Parameter: Mean Value"+
						"(Standard Deviation) units:\n"+
                        			"Soil Parameters:\n   "+sLabels[0]+
                        			": "+soilData.theta_r.mean+
                        			"("+soilData.theta_r.sdev+") "+
						sUnits[0]+"\n   "+sLabels[1]+
                        			theString+
                        			".\n   "+sLabels[2]+
                        			": "+soilData.theta_s.mean+
                        			"("+soilData.theta_s.sdev+") "+
						sUnits[2]+"\n   "+sLabels[3]+
                        			": "+soilData.K0.mean+
                        			"("+soilData.K0.sdev+") "+
						sUnits[3]+"\n   "+sLabels[4]+
                        			": "+soilData.a.mean+
                        			"("+soilData.a.sdev+") "+
						sUnits[4]+"\n   "+sLabels[5]+
                        			": "+soilData.n.mean+
                        			"("+soilData.n.sdev+") "+
						sUnits[5]+"\n   "+sLabels[6]+
                        			": "+soilData.rho.mean+
                        			"("+soilData.rho.sdev+") "+
						sUnits[6]+"\n   "+sLabels[7]+
                        			": "+soilData.rp.mean+
                        			"("+soilData.rp.sdev+") "+
						sUnits[7]+"\n   "+sLabels[8]+
                        			": "+soilData.alphaz.mean+
                        			"("+soilData.alphaz.sdev+") "+
						sUnits[8]+"\n   "+sLabels[9]+
						": "+soilData.t.mean+
						"("+soilData.t.sdev+") "+
						sUnits[9]+"\n   "+sLabels[10]+
                        			": "+soilData.z.mean+
                        			"("+soilData.z.sdev+") "+	
						sUnits[10]+"\n\n"+
                        			"Virus Parameters:\n   "+
                        			vLabels[0]+": "+
                        			virusData.lambda0.mean+"("+
                        			virusData.lambda0.sdev+") "+
						vUnits[0]+"\n   "+
                        			vLabels[1]+": "+
                        			virusData.lambda1.mean+"("+
                        			virusData.lambda1.sdev+") "+
						vUnits[1]+"\n   "+
                        			vLabels[2]+": "+
                        			virusData.kappa0.mean+"("+
                        			virusData.kappa0.sdev+") "+
						vUnits[2]+"\n   "+
                        			vLabels[3]+": "+
                        			virusData.kappa1.mean+"("+
                        			virusData.kappa1.sdev+") "+
						vUnits[3]+"\n   "+
                        			vLabels[4]+": "+
                        			virusData.rv.mean+"("+
                        			virusData.rv.sdev+") "+
						vUnits[4]+"\n   "+
                        			vLabels[5]+": "+
                        			virusData.Kd.mean+"("+
                        			virusData.Kd.sdev+") "+
						vUnits[5]+"\n\n"+
                        			"The probability of failure to achieve "+
                                			bp+"-log attenuation from "+
                                			runcount+
                                			" Monte\n"+"Carlo runs was "+
							hits+":"+runcount+".";
                			panelTout.printOutput(outString);
				}
			};
		}
		public void run() {
			continuing=true;
			bpString=breakPointTextField.getText();
			bp=Double.parseDouble(bpString);
			sd=panelFlow.getData();
			vd=panelVirus.getData();
			soilData=(Medium)(sd.clone());
			virusData=(Operandum)(vd.clone());

			// Now trap invalid user inputs

			if (!(bp>0.)) {
				Message="The threshold value you have chosen, \u03b5="+
				  bpString+",\n"+
				  "imples you expect that the total mass leaching\n"+
				  "could be greater than the total mass put in the\n"+
				  "soil. Please choose a value greater than zero.";
				JOptionPane.showMessageDialog(null,Message,
				  "Illogical choice",JOptionPane.QUESTION_MESSAGE);
				continuing=false;
			}
			if (continuing && sd.theta_r.mean<Double.MIN_VALUE ||
		 	    sd.theta_r.mean>=1.) {
				tp.setSelectedIndex(0);
				Message="Error, the mean value for this parameter must\n"+
					"be between zero and one. You entered "+
					String.valueOf(sd.theta_r.mean);
				JOptionPane.showMessageDialog(null,Message,
				  "Virulo error",JOptionPane.PLAIN_MESSAGE,
					new ImageIcon(jar.loadImage("thetar.gif")));
				panelFlow.requestAttention("theta_r.m");
				continuing=false;
			}
			if (continuing && !panelFlow.theta_mIsUniform() &&
			    (sd.theta_m.mean >=sd.theta_s.mean ||
			     sd.theta_m.mean<=sd.theta_r.mean)) {
				tp.setSelectedIndex(0);
				Message="Error, the mean value for this parameter must\n"+
				   "be between the means of the residual water content\n"+
				   "and the saturated water content. You entered "+
				   String.valueOf(sd.theta_m.mean);
				JOptionPane.showMessageDialog(null,Message,
				   "Virulo error",JOptionPane.PLAIN_MESSAGE,
					new ImageIcon(jar.loadImage("thetam.gif")));
				panelFlow.requestAttention("theta_m.m");
				continuing=false;
			}
			if (continuing && sd.theta_s.mean<Double.MIN_VALUE ||
			    sd.theta_s.mean>=1.) {
				tp.setSelectedIndex(0);
				Message="Error, the mean value for this parameter must\n"+
					"be between zero and one. You entered "+
					String.valueOf(sd.theta_s.mean);
				JOptionPane.showMessageDialog(null,Message, 
					"Virulo error",JOptionPane.PLAIN_MESSAGE,
					new ImageIcon(jar.loadImage("thetas.gif")));
				panelFlow.requestAttention("theta_s.m");
				continuing=false;
			}
			if (continuing && sd.rho.mean<0.)
				defaultNegativeNumberError(
					sd.rho.mean,"rho.gif","rho.m",0);
			if (continuing && sd.rp.mean<0.)
				defaultNegativeNumberError(sd.rp.mean,"rp.gif","rp.m",0);
			if (continuing && sd.alphaz.mean<0.)
				defaultNegativeNumberError(
					sd.alphaz.mean,"alphaz.gif","alphaz.m",0);
			if (continuing && sd.z.mean<0.)
				defaultNegativeNumberError(
					sd.z.mean,"l.gif","L.m",0);
			if (continuing && vd.rv.mean<0.)
				defaultNegativeNumberError(
					vd.rv.mean,"rv.gif","rv.m",1);
			if (continuing && sd.rho.sdev<0.)
				defaultSdevNegativeNumberError(
					sd.rho.sdev,"rho.gif","rho.s",0);
			if (continuing && sd.rp.sdev<0.)
				defaultSdevNegativeNumberError(
					sd.rp.sdev,"rp.gif","rp.s",0);
			if (continuing && sd.alphaz.sdev<0.)	
				defaultSdevNegativeNumberError(
					sd.alphaz.sdev,"alphaz.gif","alphaz.s",0);
			if (continuing && sd.t.sdev<0.)
				defaultSdevNegativeNumberError(
					sd.t.sdev,"t.gif","t.s",0);
			if (continuing && sd.z.sdev<0.)
				defaultSdevNegativeNumberError(
					sd.z.sdev,"l.gif","z.s",0);
			if (continuing && vd.kappa0.sdev<0.)
				defaultSdevNegativeNumberError(
					vd.kappa0.sdev,"kappa.gif","kappa0.s",1);
			if (continuing && vd.kappa1.sdev<0.)
				defaultSdevNegativeNumberError(
					vd.kappa1.sdev,"kappadia.gif","kappa1.s",1);
			if (continuing && vd.rv.sdev<0.)
				defaultSdevNegativeNumberError(
					vd.rv.sdev,"rv.gif","rv.s",1);
			if (continuing && vd.Kd.sdev<0.)
				defaultSdevNegativeNumberError(
					vd.Kd.sdev,"kd.gif","Kd.s",1);

			if (continuing) {
				ccount++;
				if (!retainCheckBox.isSelected()) {
					ccount=1;
					hits=0;
					Mlo=new HspMonteCarlo(soilData,virusData);
					for (i=0; i<numbins; i++) {
						bin[i]=0;
					}
				}
				runButton.setEnabled(false);
				Mlo.setTheta_mUniform(panelFlow.theta_mIsUniform());
				while (!stop && runcount++<ccount*1000000) {
					// Note, Mlo.getNext returns simply
					// the log10(A), thus
					mf=-Mlo.getNext();
					if (mf<=300) {
						bin[(int)(mf/4)]++;
						if (mf<bp) hits++;
					}
					SwingUtilities.invokeLater(update);
				}
				SwingUtilities.invokeLater(finish);
				runButton.setEnabled(true);
			}
		}
	}
	private void defaultNegativeNumberError(
	    double bad, String gifString, String attentor, int idx) {
		tp.setSelectedIndex(idx);
		Message="Error, the mean value for this parameter must\n"+
			"be greater than zero. You entered "+
			String.valueOf(bad);
		 JOptionPane.showMessageDialog(
			null,Message,"Virulo error",JOptionPane.PLAIN_MESSAGE,
			new ImageIcon(jar.loadImage(gifString)));
		if (idx==0) {
			panelFlow.requestAttention(attentor);
		} else {
			panelVirus.requestAttention(attentor);
		}
		continuing=false;
	}
	private void defaultSdevNegativeNumberError( 
	    double bad, String gifString, String attentor, int idx) {
		tp.setSelectedIndex(idx);
		Message="Error, the Std. Deviation value for this parameter must\n"+
			"be greater than zero. You entered "+
			String.valueOf(bad);
		 JOptionPane.showMessageDialog(
			null,Message,"Virulo error",JOptionPane.PLAIN_MESSAGE,
			new ImageIcon(jar.loadImage(gifString)));
		if (idx==0) {
			panelFlow.requestAttention(attentor);
		} else {
			panelVirus.requestAttention(attentor);
		}
		continuing=false;
	}
	private MediumXMLWriter sdwriter;
	private OperandumXMLWriter vdwriter;
	private Object obj;
	private String Message, bpString;
	private boolean stop=true, continuing;
	private UpdateThread MloThread;
	private Medium soilData,sd;
	private Operandum virusData,vd;
	private HspMonteCarlo Mlo;
	private int hpanelwd=400, hpanelht=460;
	private int ccount;
	private int[] bin;
	private AboutFrame aframe;
	private RandomAccessFile rof;
	private OutputStream out;
	private double mf;
	private int i,it,hits,nancount,runcount,numbins=75;
	private double bp=4.;
	private JarLoadable jar;
	private String theString="";
	private String outString="";
	private String fileString="";
	private JFileChooser chooser;
	private JLabel sLabel, inLabel;
	private JMenuBar mb;
	private JMenu fileMenu;
	private JMenu editMenu;
	private JMenu runMenu;
	private JMenu helpMenu;
	private JMenuItem saveItem;
	private JMenuItem openItem;
	private JMenuItem exitItem;
	private JMenuItem copyItem;
	private JMenuItem selectItem;
	private JMenuItem goItem;
	private JMenuItem stopItem;
	private JMenuItem aboutItem;
	private JButton runButton;
	private JButton stopButton;
	private JCheckBox retainCheckBox;
	private JTextField breakPointTextField;
	private JTabbedPane tp;
	private Gossiper gossiper;
	private BufferedImage image;
	private FlowPanel panelFlow;
	private VirusPanel panelVirus;
	private OutputPanel panelTout;
	private HistoPanel panelGout;
}
