import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
   <b>VirusComboPanel</b> class.
<P>
Combo panel of viruses.

@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
@version 18 July 2000
@see Operandum
@see VirusStack
*/

public class VirusComboPanel extends JPanel {
	/** Construct a VirusComboPanel.
	@param gossiper A <b>Gossiper</b> object to make this object
	a concrete subject.
	*/
	public VirusComboPanel(Gossiper gossiper) {
		gpr=gossiper;
		virusStack=new VirusStack();
		newdata=new Operandum();

		comboBox=new JComboBox();
		comboBox.addItem("polio-clay");
		comboBox.addItem("polio-silt");
		comboBox.addItem("polio-sand");
		comboBox.addItem("hepatitis A-clay");
		comboBox.addItem("hepatitis A-sand");
		comboBox.addItem("reovirus 3-clay");
		comboBox.addItem("reovirus 3-silt");
		comboBox.addItem("reovirus 3-sand");
		comboBox.addItem("coxsackievirus-clay");
		comboBox.addItem("coxsackievirus-sand");
		comboBox.addItem("echovirus-clay");
		comboBox.addItem("echovirus-silt");
		comboBox.addItem("echovirus-sand");
		comboBox.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				newdata=virusStack.getData(
					(String)(comboBox.getSelectedItem())
				);
				tell(newdata);
			}
		});

		GridLayout gl=new GridLayout(1,2);
		setLayout(gl);

		add(comboBox);
		newdata=virusStack.getData(
			(String)(comboBox.getSelectedItem())
		);
		tell(newdata);
	}
	public void addVirus(Operandum virus, String name) {
		comboBox.addItem(name);
		virusStack.addVirus(virus);
	}
	private void tell(Operandum nd) {
		gpr.tell(nd);
	}
	private Gossiper gpr;
	private VirusStack virusStack;
	private Operandum newdata;
	private JComboBox comboBox;
}
