import java.util.Observable;
import java.util.Observer;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
   <b>VirusPanel</b> class.
<P>
Panel to display the virus parameter fields to the user.

@author Barton R. Faulkner, US EPA National Risk Management Laboratory,
        Ada, Oklahoma, USA.
@version 18 October 2002
@see Operandum
*/


public class VirusPanel extends JPanel implements Observer {
	/** Construct a <b>VirusPanel</b>.
	@param gossiper A <b>Gossiper</b> object that makes this
	object aware of changes.
	*/
	public VirusPanel(Gossiper gossiper) {
		JarLoadable jar=new JarLoadable();
		gossiper.addObserver(this);
		JLabel h1L=new JLabel("Parameter");
		JLabel h2L=new JLabel("Mean"); //mean
		JLabel h3L=new JLabel("Std. Deviation"); //standard deviation
		JLabel h4L=new JLabel("Units");
		JLabel[] lamL={	new JLabel(new ImageIcon(
			jar.loadImage("lambda.gif"))),
				new JLabel(new ImageIcon(
			jar.loadImage("lambdastar.gif")))};
		lamL[0].setToolTipText("Log Mobile Virus Inactivation Rate");
		lamL[1].setToolTipText(
		"Log Solid-sorbed Virus Inactivation Rate");
		lambdaL=lamL;
		JLabel[] kapL={new JLabel(new ImageIcon(
			jar.loadImage("kappa.gif"))),
			new JLabel(new ImageIcon(
			jar.loadImage("kappadia.gif")))};
		kapL[0].setToolTipText(
		"Mobile to solid-sorbed mass transfer coeff.");
		kapL[1].setToolTipText(
		"Mobile to air-sorbed mass transfer coeff.");
		kappaL=kapL;
		rvL=new JLabel(new ImageIcon(jar.loadImage("rv.gif")));
		rvL.setToolTipText("Radius of virus");
		kdL=new JLabel(new ImageIcon(jar.loadImage("kd.gif")));
		kdL.setToolTipText(
		"Mobile to solid-sorbed equilibrium partition coeff.");

		lambdaF=new NormalF[3];
		lambdaF[0]=new NormalF();
		lambdaF[1]=new NormalF();
		kappaF=new NormalF[2];
		kappaF[0]=new NormalF();
		kappaF[1]=new NormalF();
		rvF=new NormalF();
		kdF=new NormalF();
		units=new String[8];
		units[0]="  h-\u00b9";
		units[1]=units[2]=" log10( h-\u00b9 )";
		units[3]=units[4]=" m h -\u00b9 ";
		units[5]=" m";
		units[6]=" any";
		units[7]=" m\u00b3 g -\u00b9";

		// I'm mystified what makes this layout work versus what
		// causes it to fail. My duct-tape and bailing wire fix
		// is to use this blank JPanel to fill in gaps.
		fP=new JPanel();
		GridLayout gl=new GridLayout(8,4);
		setLayout(gl);
		Vcp=new VirusComboPanel(gossiper);

		add(h1L);
		 add(h2L);
		  add(h3L);
		   add(h4L);
		add(lambdaL[0]);
		 add(lambdaF[0].m);
		  add(lambdaF[0].s);
		   add(new JLabel(units[1]));
                add(lambdaL[1]);
                 add(lambdaF[1].m);
		  add(lambdaF[1].s);
		   add(new JLabel(units[2]));
		add(kappaL[0]);
		 add(kappaF[0].m);
		  add(kappaF[0].s);
		   add(new JLabel(units[3]));
                add(kappaL[1]);
                 add(kappaF[1].m);
		  add(kappaF[1].s);
		   add(new JLabel(units[4]));
                add(rvL);
                 add(rvF.m);
                  add(rvF.s);
                   add(new JLabel(units[5]));
		add(kdL);
		 add(kdF.m);
		  add(kdF.s);
		   add(new JLabel(units[7]));
		add(fP);
                 add(Vcp);
                  add(fP);
                   add(fP);
	}
	/** This method is called by the <b>Gossiper</b> (or other subclass
            of <b>Observable</b>) and updates the <b>Operandum</b> instance.
        @see Gossiper
	*/
	public void update(Observable oble, Object o) {
		String name=o.getClass().getName();
		if (name.equals("Operandum")) {
			Operandum d=(Operandum)(o);

                	lambdaF[0].m.setText(Double.toString(d.lambda0.mean));
			lambdaF[0].s.setText(Double.toString(d.lambda0.sdev));

                        lambdaF[1].m.setText(Double.toString(d.lambda1.mean));
                        lambdaF[1].s.setText(Double.toString(d.lambda1.sdev));

                	kappaF[0].m.setText(Double.toString(d.kappa0.mean));
			kappaF[0].s.setText(Double.toString(d.kappa0.sdev));

                        kappaF[1].m.setText(Double.toString(d.kappa1.mean));
                        kappaF[1].s.setText(Double.toString(d.kappa1.sdev));

			rvF.m.setText(Double.toString(d.rv.mean));
			rvF.s.setText(Double.toString(d.rv.sdev));

                	kdF.m.setText(Double.toString(d.Kd.mean));
			kdF.s.setText(Double.toString(d.Kd.sdev));

                	repaint();
		}
	}
	/** Retrieve the virus data the user has selected.
	@return The virus data.
	*/
	public Operandum getData() {
		Operandum vd=new Operandum();
                Double D;

                D=new Double(lambdaF[0].m.getText());
                vd.lambda0.mean=D.doubleValue();
		D=new Double(lambdaF[0].s.getText());
		vd.lambda0.sdev=D.doubleValue();

                D=new Double(lambdaF[1].m.getText());
                vd.lambda1.mean=D.doubleValue();
                D=new Double(lambdaF[1].s.getText());
                vd.lambda1.sdev=D.doubleValue();

                D=new Double(kappaF[0].m.getText());
                vd.kappa0.mean=D.doubleValue();
                D=new Double(kappaF[0].s.getText());
                vd.kappa0.sdev=D.doubleValue();

                D=new Double(kappaF[1].m.getText());
                vd.kappa1.mean=D.doubleValue();
                D=new Double(kappaF[1].s.getText());
                vd.kappa1.sdev=D.doubleValue();

		D=new Double(rvF.m.getText());
		vd.rv.mean=D.doubleValue();
		D=new Double(rvF.s.getText());
		vd.rv.sdev=D.doubleValue();

                D=new Double(kdF.m.getText());
                vd.Kd.mean=D.doubleValue();
		D=new Double(kdF.s.getText());
		vd.Kd.sdev=D.doubleValue();

		return vd;
	}
	public void putData(Operandum newdata) {
		Vcp.addVirus(newdata, new String(newdata.name.is));
	}
	/** Retrieve the virus labels as a array of Strings.
	@return The labels.
	*/
	public String[] getLabels() {
		String[] labels={
			lambdaL[0].getToolTipText(),
			lambdaL[1].getToolTipText(),
			kappaL[0].getToolTipText(),
			kappaL[1].getToolTipText(),
			rvL.getToolTipText(),
			kdL.getToolTipText()
		};
		return labels;
	}
	public String[] getUnits() {
		return units;
	}
        public void requestAttention(String sF) {
                if (sF.equalsIgnoreCase("rv.m")) rvF.m.requestFocus();
		if (sF.equalsIgnoreCase("rv.s")) rvF.s.requestFocus();
		if (sF.equalsIgnoreCase("kappa0.s")) kappaF[0].s.requestFocus();
		if (sF.equalsIgnoreCase("kappa1.s")) kappaF[1].s.requestFocus();
		if (sF.equalsIgnoreCase("Kd.s")) kdF.s.requestFocus();
        }
	private VirusComboPanel Vcp;
	private JPanel fP;
	private JLabel[] lambdaL;
	private JLabel[] kappaL;
	private JLabel rvL;
	private JLabel kdL;
	private String[] units;
	private NormalF[] lambdaF;
	private NormalF[] kappaF;
	private NormalF rvF;
	private NormalF kdF;
}
