/** This is the interface that generalizes attenuation of an <i>Operandum</i>
    (e.g., a solute, colloid, heat) in a <i>Medium</i> (e.g., a lake, stream,
    porous medium, soil).

@author B.R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
@version 18 July 2000
@see Medium
@see Operandum
*/

public interface Attenuator {
	Medium getMedium();
	Operandum getOperandum();

	/** A replace is used to replace the data for purposes of a
	    time-series or a Monte Carlo implementation.
	*/
	void replace(Medium medium,Operandum operandum);

	/** This method returns the mean advection rate supplied
	    by the Medium.
	*/
	double getAdvection();

	/** This method returns the attenuation factor which is by
	    definition the quantity of Operandum remaining
	    divided by the initial input quantity of Operandum.
	*/
	double getAttenuation();
}
