import java.util.Observable;
import java.util.Observer;
import java.awt.*;
import java.awt.event.*;
import java.text.NumberFormat;
import javax.swing.*;
import javax.swing.event.*;

/**
   <b>FlowPanel</b> class.
<P>
Displays the text fields and labels for the parameters of the Virus
transport model that are specific to the soil data. Instances of this
class are concrete observers that respond to updates of the <b>Medium</b>
data structure.

@author Barton R. Faulkner,
        U.S. EPA Office of Research and Development
        National Risk Management Research Laboratory
        Ada, Oklahoma, USA.
@version 18 October 2002

@see Medium
@see Gossiper
*/

public class FlowPanel extends JPanel implements Observer {

/* ------------------------
   Constructor
 * ------------------------ */
	/** Construct an instance of FlowPanel.
	@param gossiper A <b>Gossiper</b> object that makes this
		<b>FlowPanel</b> aware of changes.
	@see Gossiper
	*/
	public FlowPanel(Gossiper gossiper) {
		JarLoadable jar=new JarLoadable();
		gossiper.addObserver(this);
		JLabel h1L=new JLabel("Parameter");
		JLabel h2L=new JLabel("Mean"); //mean
		JLabel h3L=new JLabel("Std. Deviation"); //standard deviation
		aL=new JLabel(new ImageIcon(
                        jar.loadImage("a.gif")));
		aL.setToolTipText("Log van Genuchten's alpha");
		theta_rL=new JLabel(new ImageIcon(
                        jar.loadImage("thetar.gif")));
		theta_rL.setToolTipText("Residual water content");
		theta_mL=new JLabel(new ImageIcon(
                        jar.loadImage("thetam.gif")));
		theta_mL.setToolTipText("Water content");
		theta_sL=new JLabel(new ImageIcon(
                        jar.loadImage("thetas.gif")));
		theta_sL.setToolTipText("Saturated water content");
                zL=new JLabel(new ImageIcon(
                        jar.loadImage("l.gif")));
		zL.setToolTipText("Thickness of proposed barrier");
                alphazL=new JLabel(new ImageIcon(
                        jar.loadImage("alphaz.gif")));
		alphazL.setToolTipText("Hydrodynamic dispersivity");
		nL=new JLabel(new ImageIcon(
                        jar.loadImage("n.gif")));
		nL.setToolTipText("Log van Genuchten's n");
                tL=new JLabel(new ImageIcon(
                        jar.loadImage("t.gif")));
		tL.setToolTipText(
			"Temperature of soil (for computing molecular diffusivity)");
		rhoL=new JLabel(new ImageIcon(
                        jar.loadImage("rho.gif")));
		rhoL.setToolTipText("Soil bulk density");
		rpL=new JLabel(new ImageIcon(
                        jar.loadImage("rp.gif")));
		rpL.setToolTipText("Mean soil particle radius");
		K0L=new JLabel(new ImageIcon(
                        jar.loadImage("k0.gif")));
		K0L.setToolTipText("Log Saturated hydraulic conductivity");
		String noNo="Modifying this mean value is not recommended."+
			"See model documentation.";
		aF=new NormalF();
		aF.m.setToolTipText(noNo);
		aF.m.setForeground(Color.red);
		aF.s.setEditable(false);

		theta_sF=new NormalF();
		theta_sF.m.setToolTipText(noNo);
		theta_sF.m.setForeground(Color.red);
		theta_sF.s.setEditable(false);

		theta_rF=new NormalF();
		theta_rF.m.setToolTipText(noNo);
		theta_rF.m.setForeground(Color.red);
		theta_rF.s.setEditable(false);

		theta_mF=new NormalF();
		theta_mF.m.setEditable(false);
		theta_mF.s.setEditable(false);
		zF=new NormalF();

		alphazF=new NormalF();

		nF=new NormalF();
		nF.m.setToolTipText(noNo);
		nF.m.setForeground(Color.red);
		nF.s.setEditable(false);
		tF=new NormalF();
		rhoF=new NormalF();
		rpF=new NormalF();

		K0F=new NormalF();
		K0F.m.setToolTipText(noNo);
		K0F.m.setForeground(Color.red);
		K0F.s.setEditable(false);

		units=new String[13];
		units[0]=units[1]=units[2]="  m\u00b3 m-\u00b3";
		units[3]=" log10( m h -\u00b9 )";
		units[4]=" log10( m -\u00b9 )";
		units[5]=" log10( . )";
		units[6]=" g m -\u00b3 ";
		units[7]=units[8]=" m";
		units[9]=" Celsius";
		units[10]=units[11]=" m";

		GridLayout gl=new GridLayout(14,4);
		FillPanel=new JPanel();
		editCheckBox=new JCheckBox("Uniformly Random",true);
		editCheckBox.setForeground(Color.blue);
		editCheckBox.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				theta_mF.m.setEditable(!editCheckBox.isSelected());
				theta_mF.s.setEditable(!editCheckBox.isSelected());
				if (editCheckBox.isSelected()) {
					editCheckBox.setForeground(Color.blue);
				} else {
					editCheckBox.setForeground(Color.gray);
				}
			}
		});
		setLayout(gl);
		Fcp=new FlowComboPanel(gossiper);

		 add(h1L);
		  add(h2L);
		   add(h3L);
		    add(new JLabel("Units"));
                 add(theta_rL);
                  add(theta_rF.m);
                   add(theta_rF.s);
                    add(new JLabel(units[0]));
		 add(theta_mL);
		  add(theta_mF.m);
		   add(theta_mF.s);
		    add(editCheckBox);
                 add(theta_sL);
                  add(theta_sF.m);
                   add(theta_sF.s);
                    add(new JLabel(units[2]));
                 add(K0L);
                  add(K0F.m);
                   add(K0F.s);
                    add(new JLabel(units[3]));
                 add(aL);
                  add(aF.m);
                   add(aF.s);
                    add(new JLabel(units[4]));
                 add(nL);
                  add(nF.m);
                   add(nF.s);
                    add(new JLabel(units[5]));
                 add(rhoL);
                  add(rhoF.m);
                   add(rhoF.s);
                    add(new JLabel(units[6]));
                 add(rpL);
                  add(rpF.m);
                   add(rpF.s);
                    add(new JLabel(units[7]));
                 add(alphazL);
                  add(alphazF.m);
                   add(alphazF.s);
                    add(new JLabel(units[8]));
                 add(tL);
                  add(tF.m);
                   add(tF.s);
                    add(new JLabel(units[9]));
		 add(zL);
		  add(zF.m);
		   add(zF.s);
		    add(new JLabel(units[10]));
                 add(FillPanel);
                  add(Fcp);
                   add(FillPanel);
                    add(FillPanel);
		 add(FillPanel);
		  add(FillPanel);
		   add(FillPanel);
		    add(FillPanel);
	}
	/** This method is called by the <b>Gossiper</b> (or other subclass
	    of <b>Observable</b>) and updates the <b>Medium</b> instance.
	@see Gossiper
	*/
	public void update(Observable oble, Object o) {
		String name=o.getClass().getName();
		if (name.equals("Medium")) {
			Medium d=(Medium)(o);
			NumberFormat nf=NumberFormat.getNumberInstance();

			nf.setMaximumFractionDigits(2);

			aF.m.setText(nf.format(d.a.mean));
			aF.s.setText(nf.format(d.a.sdev));

			theta_rF.m.setText(nf.format(d.theta_r.mean));
			theta_rF.s.setText(nf.format(d.theta_r.sdev));

			theta_mF.m.setText(nf.format(d.theta_m.mean));
			theta_mF.s.setText(nf.format(d.theta_m.sdev));

			theta_sF.m.setText(nf.format(d.theta_s.mean));
			theta_sF.s.setText(nf.format(d.theta_s.sdev));

			zF.m.setText(nf.format(d.z.mean));
			zF.s.setText(nf.format(d.z.sdev));

			alphazF.m.setText(Double.toString(d.alphaz.mean));
			alphazF.s.setText(Double.toString(d.alphaz.sdev));

			nF.m.setText(nf.format(d.n.mean));
			nF.s.setText(nf.format(d.n.sdev));

			tF.m.setText(nf.format(d.t.mean));
			tF.s.setText(nf.format(d.t.sdev));

			rpF.m.setText(Double.toString(d.rp.mean));
			rpF.s.setText(Double.toString(d.rp.sdev));

			K0F.m.setText(nf.format(d.K0.mean));
			K0F.s.setText(nf.format(d.K0.sdev));

			rhoF.m.setText(Double.toString(d.rho.mean));
			rhoF.s.setText(Double.toString(d.rho.sdev));

			repaint();
		}
	}
	/** Obtain the current data.
	@return Medium
	*/
        public Medium getData() {
                Medium sd=new Medium();
		//get the name from the FlowComboPanel:
		String Name=Fcp.getSelection();
		Name=Name.toLowerCase();
		sd.name.is=Name.toCharArray();

		Double D;
		D=new Double(aF.m.getText());
		sd.a.mean=D.doubleValue();
		D=new Double(aF.s.getText());
		sd.a.sdev=D.doubleValue();

                D=new Double(theta_rF.m.getText());
		sd.theta_r.mean=D.doubleValue();
		D=new Double(theta_rF.s.getText());
		sd.theta_r.sdev=D.doubleValue();

                D=new Double(theta_mF.m.getText());
		sd.theta_m.mean=D.doubleValue();
		D=new Double(theta_mF.s.getText());
		sd.theta_m.sdev=D.doubleValue();

                D=new Double(theta_sF.m.getText());
		sd.theta_s.mean=D.doubleValue();
		D=new Double(theta_sF.s.getText());
		sd.theta_s.sdev=D.doubleValue();

                D=new Double(zF.m.getText());
		sd.z.mean=D.doubleValue();
		D=new Double(zF.s.getText());
		sd.z.sdev=D.doubleValue();

		D=new Double(alphazF.m.getText());
		sd.alphaz.mean=D.doubleValue();
		D=new Double(alphazF.s.getText());
		sd.alphaz.sdev=D.doubleValue();

		D=new Double(nF.m.getText());
		sd.n.mean=D.doubleValue();
		D=new Double(nF.s.getText());
		sd.n.sdev=D.doubleValue();

		D=new Double(tF.m.getText());
		sd.t.mean=D.doubleValue();
		D=new Double(tF.s.getText());
		sd.t.sdev=D.doubleValue();

		D=new Double(rhoF.m.getText());
		sd.rho.mean=D.doubleValue();
		D=new Double(rhoF.s.getText());
		sd.rho.sdev=D.doubleValue();

		D=new Double(rpF.m.getText());
		sd.rp.mean=D.doubleValue();
		D=new Double(rpF.s.getText());
		sd.rp.sdev=D.doubleValue();

		D=new Double(K0F.m.getText());
		sd.K0.mean=D.doubleValue();
		D=new Double(K0F.s.getText());
		sd.K0.sdev=D.doubleValue();

                return sd;
        }
	public void putData(Medium newdata) {
		Fcp.addSoil(newdata, new String(newdata.name.is));
	}
	/** Obtain the labels for the parameter fields as a
	<b>String</b> array.
	*/
	public String[] getLabels() {
		String[] labels={
			theta_rL.getToolTipText(),
			theta_mL.getToolTipText(),
			theta_sL.getToolTipText(),
			K0L.getToolTipText(),
			aL.getToolTipText(),
			nL.getToolTipText(),
			rhoL.getToolTipText(),
			rpL.getToolTipText(),
			alphazL.getToolTipText(),
			tL.getToolTipText(),
			zL.getToolTipText()
		};
		return labels;
	}
	public boolean theta_mIsUniform() {
		return editCheckBox.isSelected();
	}
	public String[] getUnits() {
		return units;
	}
	public void requestAttention(String sF) {
		if (sF.equalsIgnoreCase("theta_r.m")) theta_rF.m.requestFocus();
		if (sF.equalsIgnoreCase("theta_m.m")) theta_mF.m.requestFocus();
		if (sF.equalsIgnoreCase("theta_m.s")) theta_mF.s.requestFocus();
		if (sF.equalsIgnoreCase("theta_s.m")) theta_sF.m.requestFocus();
		if (sF.equalsIgnoreCase("rho.m")) rhoF.m.requestFocus();
		if (sF.equalsIgnoreCase("rho.s")) rhoF.s.requestFocus();
		if (sF.equalsIgnoreCase("rp.m")) rpF.m.requestFocus();
		if (sF.equalsIgnoreCase("rp.s")) rpF.s.requestFocus();
		if (sF.equalsIgnoreCase("alphaz.m")) alphazF.m.requestFocus();
		if (sF.equalsIgnoreCase("alphaz.s")) alphazF.s.requestFocus();
		if (sF.equalsIgnoreCase("z.m")) zF.m.requestFocus();
		if (sF.equalsIgnoreCase("z.s")) zF.s.requestFocus();
	}
	private JLabel blockP;
	private String[] units;
	private JPanel FillPanel;
	private FlowComboPanel Fcp;
	private JCheckBox editCheckBox;
	private JLabel h1L;
	private JLabel h2L;
	private JLabel aL;
	private JLabel theta_rL;
	private JLabel theta_mL;
	private JLabel theta_sL;
	private JLabel zL;
	private JLabel alphazL;
	private JLabel nL;
	private JLabel tL;
	private JLabel rhoL;
	private JLabel rpL;
	private JLabel K0L;
//	private JLabel h0L;
//	private JLabel bL;
	private NormalF aF;
	private NormalF theta_rF;
	private NormalF theta_mF;
	private NormalF theta_sF;
	private NormalF zF;
	private NormalF alphazF;
	private NormalF nF;
	private NormalF tF;
	private NormalF rhoF;
	private NormalF rpF;
	private NormalF K0F;
//	private NormalF h0F;
//	private NormalF bF;
}
