import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import javax.swing.*;

public class HistoPanel extends JPanel {
	public HistoPanel(int[] bins, int wd, int ht) {
		w=wd;
		h=ht;
		bin=bins;
		JarLoadable jar=new JarLoadable();
		String sb=new String();
	}
	public void redraw(int[] bins) {
		bin=bins;
		repaint();
	}
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		g.setColor(Color.red);
		g.drawString("Exceedances",margin,h-15);
		g.drawString(Hits,margin,h);
		g.drawRect(margin+(int)(bp),margin+20,0,320);
		if (bp<1.) {
			g.drawString("Note: resolution will not allow "+
				"display of vertical marker bar.",
				margin+bin.length/2,margin-20);
		}
		g.setColor(Color.black);
		g.drawRect(margin,margin+20,0,320);
		g.drawString("Right Truncated Histogram",
				margin+bin.length/2,margin);
		g.drawString("-log A",margin+4*bin.length/2-8,h-30);
		g.drawString("0",58,h-45);
		g.drawString("150",64+4*bin.length/2,h-45);
		g.drawString("300",50+4*bin.length,h-45);
		g.drawString(":   "+Runs,margin+85,h);
		g.drawString(":   Runs",margin+85,h-15);
		for (i=0; i<bin.length; i++) {
			g.drawRect(margin+i*4, h-bin[i]-margin ,2, bin[i] );
		}
		for (i=0; i<320; i+=20) {
			g.drawRect(margin-5,h-margin-i,4,0);
			g.drawString(sb.valueOf(i),margin-30,h-margin-i+5);
		}
		g.drawString("C",15,h-margin-210);
		g.drawString("O",15,h-margin-190);
		g.drawString("U",15,h-margin-170);
		g.drawString("N",15,h-margin-150);
		g.drawString("T",15,h-margin-130);
	}
	public void setBreak(double brk) {
		bp=brk;
	}
	public void setHits(int hits) {
		Hits=Integer.toString(hits);
	}
	public void setRuns(int runs) {
		Runs=Integer.toString(runs);
	}
	public BufferedImage getImage() {
		BufferedImage image=new BufferedImage(w,h,BufferedImage.TYPE_INT_RGB);
		return image;
	}
	private String sb;
	private JarLoadable jar;
	private int[] bin;
	private String Hits="0";
	private String Runs="0";
	private String is;
	private int h, w, i, margin=60;
	private double bp=4;
}
