import java.lang.reflect.*;
/**
   <b>HspBasicMath</b> class.
<P>
Repository for static methods useful to the Hsp program.

@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
@version March 2000
*/

public class HspBasicMath {

/* ------------------------
   Public Methods 
 * ------------------------ */
	/** Grow any type of native vector by one element. Based on
	    Horstmann & Cornell, "Core Java 2, Vol. 1"
	@param a The <b>Object</b> which is an array underneath.
	@return newVector The <b>Object</b> which is the input array
	grown by one element.
	*/ static Object vectorGrow(Object a) {
		// grows any type of vector by one element.
		// based on Horstmann & Cornell, "Core Java2, Vol. 1"
		Class cl=a.getClass();
		if (!cl.isArray()) return null;
		Class componentType=a.getClass().getComponentType();
		int length=Array.getLength(a);
		int newLength=length+1;
		Object newVector=Array.newInstance(componentType,newLength);
		System.arraycopy(a,0,newVector,0,length);
		return newVector;
	}
	/** A log-base-10 function.
	*/
	static double log10(double x) {
		return Math.log(x)/Math.log(10.0);
	}
}
