import javax.swing.*;
import java.awt.*;
import java.util.*;
import Jama.*;

/**
Class for generating Monte Carlo simulations.

@see Mvn
@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
*/

public class HspMonteCarlo {
	public HspMonteCarlo(Medium soildata,Operandum virusdata) {
		sd=soildata;
		vd=virusdata;
		// and make extra copies that can be perturbed:

		sdp=(Medium)sd.clone();
		vdp=(Operandum)vd.clone();
		att=new UnsatVirusAttenuator(sd,vd);
		maxit=100000;
		gen=new Random(0.,1.);
		gasdev=new GasDev();
		varcov=new VarCov();
		Matrix Cov=varcov.getVarCov(String.valueOf(sd.name.is));
		double[] means={sd.theta_r.mean,
				sd.theta_s.mean,
				sd.a.mean,
				sd.n.mean,
				sd.K0.mean
			};
		mvn=new Mvn(Cov,means);
		getMvn();
	}
	private double[][] getMvn() {
		bb=mvn.perturb();
		return bb;
	}
	public double getNext() {
		if (++i>=maxit) {
			getMvn();
			i=0;
		}
//		varcov=new VarCov();
		sdp.a.mean=bb[i][2];
		sdp.theta_s.mean=bb[i][1];
		sdp.theta_r.mean=bb[i][0];
		if (theta_mIsUniform) {
			unv=(sdp.theta_s.mean-sdp.theta_r.mean)*gen.nextDouble();
			sdp.theta_m.mean=sdp.theta_r.mean+unv;
		} else {
			sdp.theta_m.mean=perturb(sd.theta_m.mean,sd.theta_m.sdev);
		}
		sdp.z.mean=perturb(sd.z.mean,sd.z.sdev);
		sdp.alphaz.mean=perturb(sd.alphaz.mean,
			sd.alphaz.sdev);
		sdp.n.mean=bb[i][3];
		sdp.t.mean=perturb(sd.t.mean,sd.t.sdev);
		sdp.rho.mean=perturb(sd.rho.mean,sd.rho.sdev);
		sdp.rp.mean=perturb(sd.rp.mean,sd.rp.sdev);
		sdp.K0.mean=bb[i][4];
		vdp.lambda0.mean=perturb(vd.lambda0.mean,
			vd.lambda0.sdev);
		vdp.lambda1.mean=perturb(vd.lambda1.mean,
			vd.lambda1.sdev);
		vdp.kappa0.mean=perturb(vd.kappa0.mean,
			vd.kappa0.sdev);
		vdp.kappa1.mean=perturb(vd.kappa1.mean,
			vd.kappa1.sdev);
		vdp.rv.mean=perturb(vd.rv.mean,vd.rv.sdev);
		vdp.Kd.mean=perturb(vd.Kd.mean,vd.Kd.sdev);

		att.replace(sdp,vdp);
		mr=att.getAttenuation();
		return mr;
	}
	private double perturb(double avg,double std) {
		double pnum;
		pnum=avg+std*gasdev.nextDeviate();
		return pnum;
	}
	public void setTheta_mUniform(boolean bu) {
		theta_mIsUniform=bu;
	}
	private Random gen;
	private GasDev gasdev;
	private Mvn mvn;
	private double[][] bb;
	private VarCov varcov;
	private Attenuator att;
	private double mr;
	private double ave, std, unv;
	private int maxit,i;
	private double gset, ret;
	private boolean iset=false, theta_mIsUniform=true;
	private Medium sd, sdp;
	private Operandum vd, vdp;
	private static final double TINY=1.0e-15;
}
