import java.awt.*;
import java.awt.image.BufferedImage;

/**
This code is
by Geary, Mastering the JFC, 3rd Ed. pp. 139-140<p>
Reference:<br>
David M. Geary. 1999. <i>Graphic Java 2, Mastering the JFC, 3rd Edition,
Volume II, Swing.</i> Sun Microsystems Press, Palo Alto. 1622 p.
*/
public class ImageCanvas extends Canvas {
	public ImageCanvas(String imageName) {
		image=Toolkit.getDefaultToolkit().getImage(imageName);
		MediaTracker mt=new MediaTracker(this);
		try {
			mt.addImage(image,0);
			mt.waitForID(0);
		} catch(InterruptedException ex) {
			ex.printStackTrace();
		}
	}
        public ImageCanvas(BufferedImage bImage) {
                MediaTracker mt=new MediaTracker(this);
		image=(Image)(bImage);
                try {
                        mt.addImage(bImage,0);
                        mt.waitForID(0);
                } catch(InterruptedException ex) {
                        ex.printStackTrace();
                }
        }
	public void paint(Graphics g) {
		g.drawImage(image,0,0,null);
	}
	public Dimension getPreferredSize() {
		return new Dimension(image.getWidth(null),
			image.getHeight(null));
	}
	private Image image;
	private BufferedImage bImage;
}
