import java.io.File;
import javax.swing.*;
import javax.swing.filechooser.*;

public class JpgFilter extends FileFilter {
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = Utils.getExtension(f);
        if (extension != null) {
            if (extension.equals(Utils.jpg) ||
		extension.equals(Utils.txt) ||
		extension.equals(Utils.xml)) {
                return true;
            } else {
                return false;
            }
        }
        return false;
    }
    // The description of this filter
    public String getDescription() {
        return "*.jpg, *.txt, *.xml";
    }
}
