import Jama.*;

/**
This class is for generating multvariate normal deviates.
<hr>
References:
<p>
Kitanidis, P.K. 1997. <i>Introduction to Geostatistics,
Applications in Hydrogeology.</i> Cambridge University Press,
Cambridge, UK. Appendix C.3.
<p>
Knuth, D.E. 1998. <i>The Art of Computer Programming,
Volume 2. Seminumerical Algorithms, Third Edition.</i>
Addision-Wesley, Reading Mass. p. 586.
<p>
The <a href="http://math.nist.gov/javanumerics/jama/">
<i>Jama</i> matrix package</a> for Java.<br>

@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
*/

public class Mvn {
	/** Create one.
	@param V Variance-Covariance Matrix of the random variables
	@param means Vector of means of the random variables
	*/
	public Mvn(Matrix V, double[] means) {
		m=means;
		S=V;
		gasdev=new GasDev();
		q=100000; // Must use chunks of arrays no bigger than this else out-of-mem.
		aa=new double[q][m.length];
		cholesky=S.chol();
		L=cholesky.getL();
		L_=L.transpose();
	}
	/** Generate the Matrix of Multivariate Normal Deviates where each row
		corresponds to an event for each random variable.
	*/
	public double[][] perturb() {
		for (i=0; i<q; i++) {
			for (j=0; j<m.length; j++) {
				aa[i][j]=gasdev.nextDeviate();
			}
		}
		A=Matrix.constructWithCopy(aa);
		B=A.times(L_);
		bb=B.getArrayCopy();
                for (i=0; i<q; i++) {
                        for (j=0; j<m.length; j++) {
                                bb[i][j]+=m[j];
                        }
                }
		return bb;
	}
	private double[] m;
	private double[][] aa, bb;
	private Matrix S, B, A, L, L_;
	private GasDev gasdev;
	private CholeskyDecomposition cholesky;
	private int i, j, q;
}
