/**
   <b>Operandum</b> class.
<P>
Data structure for passive participants in transport.

@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
@version 5 March 2001
*/

public class Operandum implements Cloneable {

	/** The name of this operandum.
	*/
	public StringAsChars name=new StringAsChars();

	/** Inactivation rate coefficients {liquid, solid-sorbed, air-sorbed}
		(log[per hour]).
	*/
	public Normal lambda0=new Normal();
	public Normal lambda1=new Normal();

	/** Mass transfer coefficients {liquid-liq/solid, liquid-liq/air}
		(per hour).
	*/
	public Normal kappa0=new Normal();
	public Normal kappa1=new Normal();

	/** Radius (m)
	*/
	public Normal rv=new Normal();
	/** Initial concentration or mass (any units).
	*/
	public Normal Kd=new Normal();
        /** Clone method redefinition
        */
        public Object clone() {
		Operandum op=null;
                try {
                        op=(Operandum)super.clone();
                } catch (CloneNotSupportedException e) { 
                }
		// clone the handles too.
		op.name=(StringAsChars)op.name.clone();
		op.lambda0=(Normal)op.lambda0.clone();
		op.lambda1=(Normal)op.lambda1.clone();
		op.kappa0=(Normal)op.kappa0.clone();
		op.kappa1=(Normal)op.kappa1.clone();
		op.rv=(Normal)op.rv.clone();
		op.Kd=(Normal)op.Kd.clone();
		return op;
        }
}
