import java.util.*;

/**
   <b>SoilStack</b> class.
<P>
Stack for Medium.

@author Barton R Faulkner, US EPA National Risk Management Laboratory,
        Ada, Oklahoma, USA.
@version 11 November 2002
@see Medium
*/

public class SoilStack {
        /** Retrieve data by soil type descriptor.
        @param soil Soil type descriptor (e.g., "sand").
        @return The Medium object requested.
        */
        public Medium getData(String soil){
                Medium sd=new Medium();
                if (soil=="clay") {
			String Name=new String("clay");
			sd.name.is=Name.toCharArray();

			sd.a.mean=0.276202682;
			sd.a.sdev=0.129474299;

			sd.theta_r.mean=0.100993333;
			sd.theta_r.sdev=0.010708176;

			sd.theta_m.mean=0;
			sd.theta_m.sdev=0;

			sd.theta_s.mean=0.515332222;
			sd.theta_s.sdev=0.085260028;

			sd.z.mean=0.5;
			sd.z.sdev=0.1;

			sd.alphaz.mean=8.75e-5;
			sd.alphaz.sdev=0.0001;

			sd.n.mean=0.113751456;
			sd.n.sdev=0.015201357;

			sd.t.mean=11.7;
			sd.t.sdev=7.38;

			sd.rho.mean=1.29E+06;
			sd.rho.sdev=1.68E+05;

			sd.rp.mean=9.95E-05;
			sd.rp.sdev=6.15E-05;

			sd.K0.mean=-2.085670553;
			sd.K0.sdev=0.475140674;

//			sd.h0.mean=0.3730;
//			sd.h0.sdev=0.89855;

//			sd.b.mean=0.165;
//			sd.b.sdev=0.128;
		} else if (soil=="clayloam") {
			String Name=new String("clayloam");
			sd.name.is=Name.toCharArray();

			sd.a.mean=0.131688015;
			sd.a.sdev=0.107803701;

			sd.theta_r.mean=0.083457308;
			sd.theta_r.sdev=0.010645087;

			sd.theta_m.mean=0;
			sd.theta_m.sdev=0;

			sd.theta_s.mean=0.455308077;
			sd.theta_s.sdev=0.088337801;

			sd.z.mean=0.5;
			sd.z.sdev=0.1;

			sd.alphaz.mean=8.75e-5;
			sd.alphaz.sdev=0.0001;

			sd.n.mean=0.140818958;
			sd.n.sdev=0.027875485;

			sd.t.mean=11.7;
			sd.t.sdev=7.38;

			sd.rho.mean=1.41E+06;
			sd.rho.sdev=2.39E+05;

			sd.rp.mean=1.68E-04;
			sd.rp.sdev=3.72E-05;

			sd.K0.mean=-2.273130814;
			sd.K0.sdev=0.650853279;

//			sd.h0.mean=0.2589;
//			sd.h0.sdev=0.5495;

//			sd.b.mean=0.242;
//			sd.b.sdev=0.172;
		} else if (soil=="loam") {
			String Name=new String("loam");
			sd.name.is=Name.toCharArray();

			sd.a.mean=0.041061472;
			sd.a.sdev=0.163832209;

			sd.theta_r.mean=0.061114828;
			sd.theta_r.sdev=0.013951437;

			sd.theta_m.mean=0;
			sd.theta_m.sdev=0;

			sd.theta_s.mean=0.421203103;
			sd.theta_s.sdev=0.070526324;

			sd.z.mean=0.5;
			sd.z.sdev=0.1;

			sd.alphaz.mean=8.75e-5;
			sd.alphaz.sdev=0.0001;

			sd.n.mean=0.171560556;
			sd.n.sdev=0.027060968;

			sd.t.mean=11.7;
			sd.t.sdev=7.38;

			sd.rho.mean=1.34E+06;
			sd.rho.sdev=2.75E+05;

			sd.rp.mean=2.15E-04;
			sd.rp.sdev=3.38E-05;

			sd.K0.mean=-1.988473636;
			sd.K0.sdev=0.44938413;

//			sd.h0.mean=0.1115;
//			sd.h0.sdev=0.37385;

//			sd.b.mean=0.252;
//			sd.b.sdev=0.166;
		} else if (soil=="loamysand") {
			String Name=new String("loamysand");
			sd.name.is=Name.toCharArray();

			sd.a.mean=0.574047568;
			sd.a.sdev=0.060216706;

			sd.theta_r.mean=0.047099;
			sd.theta_r.sdev=0.006817318;

			sd.theta_m.mean=0;
			sd.theta_m.sdev=0;

			sd.theta_s.mean=0.3885762;
			sd.theta_s.sdev=0.042800282;

			sd.z.mean=0.5;
			sd.z.sdev=0.1;

			sd.alphaz.mean=5.59e-3;
			sd.alphaz.sdev=0.0001;

			sd.n.mean=0.280855311;
			sd.n.sdev=0.04412957;

			sd.t.mean=11.7;
			sd.t.sdev=7.38;

			sd.rho.mean=1.50E+06;
			sd.rho.sdev=1.67E+05;

			sd.rp.mean=4.20E-04;
			sd.rp.sdev=2.20E-05;

			sd.K0.mean=-1.198044153;
			sd.K0.sdev=0.223334581;

//			sd.h0.mean=0.0869;
//			sd.h0.sdev=0.20025;

//			sd.b.mean=0.553;
//			sd.b.sdev=0.319;
		} else if (soil=="sand") {
			String Name=new String("sand");
			sd.name.is=Name.toCharArray();

			sd.a.mean=0.53060969;
			sd.a.sdev=0.033677377;

			sd.theta_r.mean=0.049638516;
			sd.theta_r.sdev=0.003065946;

			sd.theta_m.mean=0;
			sd.theta_m.sdev=0;

			sd.theta_s.mean=0.366745391;
			sd.theta_s.sdev=0.032116508;

			sd.z.mean=0.5;
			sd.z.sdev=0.1;

			sd.alphaz.mean=5.59e-3;
			sd.alphaz.sdev=0.0001;

			sd.n.mean=0.482299856;
			sd.n.sdev=0.076996491;

			sd.t.mean=11.7;
			sd.t.sdev=7.38;

			sd.rho.mean=1.58E+06;
			sd.rho.sdev=1.42E+05;

			sd.rp.mean=4.71E-04;
			sd.rp.sdev=1.60E-05;

			sd.K0.mean=-0.691792728;
			sd.K0.sdev=0.033615473;

			//sd.h0.mean=0.0726;
			//sd.h0.sdev=0.1872;

			//sd.b.mean=0.694;
			//sd.b.sdev=0.296;
		} else if (soil=="sandyclayloam") {
			String Name=new String("sandyclayloam");
			sd.name.is=Name.toCharArray();

			sd.a.mean=0.344005176;
			sd.a.sdev=0.094847636;

			sd.theta_r.mean=0.064246923;
			sd.theta_r.sdev=0.00780009;

			sd.theta_m.mean=0;
			sd.theta_m.sdev=0;

			sd.theta_s.mean=0.39204;
			sd.theta_s.sdev=0.043790548;

			sd.z.mean=0.5;
			sd.z.sdev=0.1;

			sd.alphaz.mean=8.75e-5;
			sd.alphaz.sdev=0.0001;

			sd.n.mean=0.120380137;
			sd.n.sdev=0.025840507;

			sd.t.mean=11.7;
			sd.t.sdev=7.38;

			sd.rho.mean=1.50E+06;
			sd.rho.sdev=2.24E+05;

			sd.rp.mean=3.08E-04;
			sd.rp.sdev=4.20E-05;

			sd.K0.mean=-2.271251064;
			sd.K0.sdev=0.329351751;

			//sd.h0.mean=0.2808;
			//sd.h0.sdev=0.67965;

			//sd.b.mean=0.319;
			//sd.b.sdev=0.24;
		} else if (soil=="sandyloam") {
			String Name=new String("sandyloam");
			sd.name.is=Name.toCharArray();

			sd.a.mean=0.485840457;
			sd.a.sdev=0.126181322;

			sd.theta_r.mean=0.044244026;
			sd.theta_r.sdev=0.007948225;

			sd.theta_m.mean=0;
			sd.theta_m.sdev=0;

			sd.theta_s.mean=0.369563636;
			sd.theta_s.sdev=0.041579061;

			sd.z.mean=0.5;
			sd.z.sdev=0.1;

			sd.alphaz.mean=8.75e-5;
			sd.alphaz.sdev=0.0001;

			sd.n.mean=0.154301527;
			sd.n.sdev=0.029721521;

			sd.t.mean=11.7;
			sd.t.sdev=7.38;

			sd.rho.mean=1.53E+06;
			sd.rho.sdev=1.69E+05;

			sd.rp.mean=3.35E-04;
			sd.rp.sdev=4.59E-05;

			sd.K0.mean=-1.867049932;
			sd.K0.sdev=0.338895528;

			//sd.h0.mean=0.1466;
			//sd.h0.sdev=0.29395;

			//sd.b.mean=0.378;
			//sd.b.sdev=0.238;
		} else if (soil=="silt") {
			String Name=new String("silt");
			sd.name.is=Name.toCharArray();

			sd.a.mean=-0.244777645;
			sd.a.sdev=0.022860344;

			sd.theta_r.mean=0.059473333;
			sd.theta_r.sdev=0.00743377;

			sd.theta_m.mean=0;
			sd.theta_m.sdev=0;

			sd.theta_s.mean=0.433063333;
			sd.theta_s.sdev=0.026375595;

			sd.z.mean=0.5;
			sd.z.sdev=0.1;

			sd.alphaz.mean=8.75e-5;
			sd.alphaz.sdev=0.0001;

			sd.n.mean=0.221016764;
			sd.n.sdev=0.003976454;

			sd.t.mean=11.7;
			sd.t.sdev=7.38;

			sd.rho.mean=1.39E+06;
			sd.rho.sdev=2.90E+04;

			sd.rp.mean=4.53E-05;
			sd.rp.sdev=2.36E-05;

			sd.K0.mean=-1.838232525;
			sd.K0.sdev=0.114733717;

			//sd.h0.mean=0;
			//sd.h0.sdev=9999;

			//sd.b.mean=0;
			//sd.b.sdev=9999;
		} else if (soil=="siltloam") {
			String Name=new String("siltloam");
			sd.name.is=Name.toCharArray();

			sd.a.mean=-0.207340275;
			sd.a.sdev=0.07486548;

			sd.theta_r.mean=0.063289709;
			sd.theta_r.sdev=0.012632368;

			sd.theta_m.mean=0;
			sd.theta_m.sdev=0;

			sd.theta_s.mean=0.406203592;
			sd.theta_s.sdev=0.050099953;

			sd.z.mean=0.5;
			sd.z.sdev=0.1;

			sd.alphaz.mean=8.75e-5;
			sd.alphaz.sdev=0.0001;

			sd.n.mean=0.206442995;
			sd.n.sdev=0.016064068;

			sd.t.mean=11.7;
			sd.t.sdev=7.38;

			sd.rho.mean=1.43E+06;
			sd.rho.sdev=1.48E+05;

			sd.rp.mean=1.18E-04;
			sd.rp.sdev=5.50E-05;

			sd.K0.mean=-2.160084702;
			sd.K0.sdev=0.383975863;

			//sd.h0.mean=0.2076;
			//sd.h0.sdev=0.5841;

			//sd.b.mean=0.234;
			//sd.b.sdev=0.129;
		} else if (soil=="siltyclay") {
			String Name=new String("siltyclay");
			sd.name.is=Name.toCharArray();

			sd.a.mean=0.090811457;
			sd.a.sdev=0.055141199;

			sd.theta_r.mean=0.094913636;
			sd.theta_r.sdev=0.006446264;

			sd.theta_m.mean=0;
			sd.theta_m.sdev=0;

			sd.theta_s.mean=0.47609;
			sd.theta_s.sdev=0.051411467;

			sd.z.mean=0.5;
			sd.z.sdev=0.1;

			sd.alphaz.mean=8.75e-5;
			sd.alphaz.sdev=0.0001;

			sd.n.mean=0.139975077;
			sd.n.sdev=0.013237462;

			sd.t.mean=11.7;
			sd.t.sdev=7.38;

			sd.rho.mean=1.20E+06;
			sd.rho.sdev=2.57E+05;

			sd.rp.mean=4.07E-05;
			sd.rp.sdev=2.45E-05;

			sd.K0.mean=-2.434048919;
			sd.K0.sdev=0.453360678;

			//sd.h0.mean=0.3419;
			//sd.h0.sdev=0.7958;

			//sd.b.mean=0.150;
			//sd.b.sdev=0.11;
		} else if (soil=="siltyclayloam") {
			String Name=new String("siltyclayloam");
			sd.name.is=Name.toCharArray();

			sd.a.mean=0.027733578;
			sd.a.sdev=0.108638178;

			sd.theta_r.mean=0.092101429;
			sd.theta_r.sdev=0.012059445;

			sd.theta_m.mean=0;
			sd.theta_m.sdev=0;

			sd.theta_s.mean=0.499877619;
			sd.theta_s.sdev=0.102427379;

			sd.z.mean=0.5;
			sd.z.sdev=0.1;

			sd.alphaz.mean=8.75e-5;
			sd.alphaz.sdev=0.0001;

			sd.n.mean=0.157510945;
			sd.n.sdev=0.01544867;

			sd.t.mean=11.7;
			sd.t.sdev=7.38;

			sd.rho.mean=1.29E+06;
			sd.rho.sdev=2.22E+05;

			sd.rp.mean=5.78E-05;
			sd.rp.sdev=2.95E-05;

			sd.K0.mean=-2.20762404;
			sd.K0.sdev=0.634080609;

			//sd.h0.mean=0.3256;
			//sd.h0.sdev=0.7601;

			//sd.b.mean=0.177;
			//sd.b.sdev=0.138;
		} else {
			for (i=0; i<xmlsoils.size(); i++) {
				if (String.copyValueOf(
				   ((Medium)xmlsoils.get(i)).name.is).equalsIgnoreCase(
					soil)
				) sd=(Medium)xmlsoils.get(i);
			}
		}
		return sd;
	}
	public void addSoil(Medium soil) {
		xmlsoils.add(soil);
	}
	private int i;
	private Vector xmlsoils=new Vector();
}
