import java.util.*;
import java.awt.*;
/**
   <b>VectorParser</b> class.
<P>
The VectorParser class contains static convenience methods for converting Java
<i>Vectors</i> to Java native arrays, which is syntactically awkward,
but straight forward. It also provides methods for splitting <i>Vectors</i>
of <i>Points</i> into component integer arrays.

@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
@version 22 November 2000
*/

public class VectorParser {

/* ------------------------
   Constructor
	(there is no specified constructor)
 * ------------------------ */

/* ------------------------
   Public Methods
 * ------------------------ */

	/** Convert Vector to native array.
	@param Vect <i>Vector</i> containing potential doubles.
	@return native array of down-casted doubles.
	*/
	public static double[] toDoubleArray(Vector Vect) {
		double[] v=new double[Vect.size()];
		for (i=0; i<Vect.size(); i++) {
			v[i]=Double.parseDouble((Vect.get(i).toString()));
		}
		return v;
	}

	/** Convert Vector to native array.
	@param Vect <i>Vector</i> containing potential ints.
	@return native array of down-casted ints.
	*/
	public static int[] toIntArray(Vector Vect) {
		int[] v=new int[Vect.size()];
		for (i=0; i<Vect.size(); i++) {
			v[i]=Integer.parseInt((Vect.get(i).toString()));
		}
		return v;
	}

        /** Convert Vector of Points to array of Points.
        @param Vect <i>Vector</i> of Points.
        @return array of Points.
        */
        public static Point[] toPointArray(Vector Vect) {
                Point[] pts=new Point[Vect.size()];
                for (i=0; i<Vect.size(); i++) {
                        pts[i].x=(int)(((Point)(Vect.get(i))).getX());
			pts[i].y=(int)(((Point)(Vect.get(i))).getY());
                }
                return pts;
        }

	/** Convert Vector of Points to native array of the X "coordinates."
	@param Vect <i>Vector</i> of Points.
	@return native array of X "coordinates" of the original Points.
	*/
	public static int[] xSplitPoint(Vector Vect) {
		int[] xpts=new int[Vect.size()];
		for (i=0; i<Vect.size(); i++) {
			xpts[i]=(int)(((Point)(Vect.get(i))).getX());
		}
		return xpts;
	}

	/** Convert Vector of Points to native array of the Y "coordinates."
	@param Vect <i>Vector</i> of Points.
	@return native array of Y "coordinates" of the original Points.
	*/
	public static int[] ySplitPoint(Vector Vect) {
		int[] ypts=new int[Vect.size()];
		for (i=0; i<Vect.size(); i++) {
			ypts[i]=(int)(((Point)(Vect.get(i))).getY());
		}
		return ypts;
	}

        /** Convert Vector to native array.
        @param Vect <i>Vector</i> containing potential floats.
        @return native array of down-casted floats.
        */
        public static float[] toFloatArray(Vector Vect) {
                float[] v=new float[Vect.size()];
                for (i=0; i<Vect.size(); i++) {
                        v[i]=Float.parseFloat((Vect.get(i).toString()));
                }
                return v;
        }

	/** Supply a permutation of a native array of doubles of a given
		Vector of indices
	@param Iv The Vector object containing the desired indices of the
	permutation as Integer objects.
	@param d  The double array which is to be permuted.
	*/
	public static double[] permuteDouble(Vector Iv, double[] d) {
		double[] r=new double[d.length];
		for (i=0; i<d.length; i++) {
			Integer I=new Integer(i);
			k=Iv.indexOf(I);
			if (!(k==-1)) {
				r[i]=d[k];
			} else {
			}
		}
		return r;
	}

	private static int i,k;
}
