import java.util.*;

/**
   <b>VirusStack</b> class.
<P>
Stack for the virus data.

@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
@version 18 July 2000
@see Operandum
*/

public class VirusStack {
	/** Retrieve the data entered by the user.
	@return the virus data.
	*/
	public Operandum getData(String virus){
		Operandum vd=new Operandum();
		if (virus.equalsIgnoreCase("polio-sand")) {
			String Name=new String("polio");
			vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=0.605; // log10(per hr)
                        vd.lambda0.sdev=0.608;

                        vd.lambda1.mean=0.304; // log10(per hr)
                        vd.lambda1.sdev=0.608;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180;

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180;

			vd.rv.mean=1.375e-8;
			vd.rv.sdev=1.250e-9;

                        vd.Kd.mean=2.43e-4; // m^3/g
                        vd.Kd.sdev=5.66e-4;
		} else if (virus.equalsIgnoreCase("polio-silt")) {
                        String Name=new String("polio");
                        vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=0.605; // log10(per hr)
                        vd.lambda0.sdev=0.608;

                        vd.lambda1.mean=0.304; // log10(per hr)
                        vd.lambda1.sdev=0.608;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180;

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180;

                        vd.rv.mean=1.375e-8;
                        vd.rv.sdev=1.250e-9;

                        vd.Kd.mean=3.77e-4; // m^3/g
                        vd.Kd.sdev=7.16e-4;
                } else if (virus.equalsIgnoreCase("polio-clay")) {
                        String Name=new String("polio");
                        vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=0.605; // log10(per hr)
                        vd.lambda0.sdev=0.608;

                        vd.lambda1.mean=0.304; // log10(per hr)
                        vd.lambda1.sdev=0.608;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180;

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180;

                        vd.rv.mean=1.375e-8;
                        vd.rv.sdev=1.250e-9;

                        vd.Kd.mean=7.20e-4; // m^3/g
                        vd.Kd.sdev=9.74e-4;
                } else if (virus.equalsIgnoreCase("hepatitis A-clay")) {
                        String Name=new String("hepatitis");
                        vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=-3.941; // log10(per hr)
                        vd.lambda0.sdev= 0.782;

                        vd.lambda1.mean=-3.446; // log10(per hr)
                        vd.lambda1.sdev= .782;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180;

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180;

                        vd.rv.mean=1.4e-8;
                        vd.rv.sdev=1.250e-9;

                        vd.Kd.mean=1.900e-3; // m^3/g
                        vd.Kd.sdev=4.059e-6;
                } else if (virus.equalsIgnoreCase("hepatitis A-sand")) {
                        String Name=new String("hepatitis");
                        vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=-3.941; // log10(per hr)
                        vd.lambda0.sdev= 0.782;

                        vd.lambda1.mean=-3.446; // log10(per hr)
                        vd.lambda1.sdev= .782;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180;

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180;

                        vd.rv.mean=1.4e-8;
                        vd.rv.sdev=1.250e-9;

                        vd.Kd.mean=4.68e-6; // m^3/g
                        vd.Kd.sdev=4.06e-6;
                } else if (virus.equalsIgnoreCase("reovirus 3-clay")) {
                        String Name=new String("reovirus");
                        vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=-3.941; // log10(per hr)
                        vd.lambda0.sdev= 0.782;

                        vd.lambda1.mean=-3.446; // log10(per hr)
                        vd.lambda1.sdev= .782;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180;

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180;

                        vd.rv.mean=3.5e-8;
                        vd.rv.sdev=5.0e-9;

                        vd.Kd.mean=1.203e-3; // m^3/g
                        vd.Kd.sdev=3.188e-3;
                } else if (virus.equalsIgnoreCase("reovirus 3-silt")) {
                        String Name=new String("reovirus");
                        vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=-3.941; // log10(per hr)
                        vd.lambda0.sdev= 0.782;

                        vd.lambda1.mean=-3.446; // log10(per hr)
                        vd.lambda1.sdev= .782;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180;

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180;

                        vd.rv.mean=3.5e-8;
                        vd.rv.sdev=5.0e-9;

                        vd.Kd.mean=2.113e-3; // m^3/g
                        vd.Kd.sdev=1.648e-3;
                } else if (virus.equalsIgnoreCase("reovirus 3-sand")) {
                        String Name=new String("reovirus");
                        vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=-3.941; // log10(per hr)
                        vd.lambda0.sdev= 0.782;

                        vd.lambda1.mean=-3.446; // log10(per hr)
                        vd.lambda1.sdev= .782;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180;

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180;

                        vd.rv.mean=3.5e-8;
                        vd.rv.sdev=5.0e-9;

                        vd.Kd.mean=3.000e-3; // m^3/g
                        vd.Kd.sdev=9.068e-3;
                } else if (virus.equalsIgnoreCase("coxsackievirus-clay")) {
                        String Name=new String("coxsackievirus");
                        vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=-3.941; // log10(per hr)
                        vd.lambda0.sdev= 0.782;

                        vd.lambda1.mean=-3.446; // log10(per hr)
                        vd.lambda1.sdev= .782;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180;

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180;

                        vd.rv.mean=1.375e-10;
                        vd.rv.sdev=1.e-11;

                        vd.Kd.mean=8.657e-5; // m^3/g
                        vd.Kd.sdev=1.956e-4;
                } else if (virus.equalsIgnoreCase("coxsackievirus-sand")) {
                        String Name=new String("coxsackievirus");
                        vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=-2.515; // log10(per hr)
                        vd.lambda0.sdev= 0.212; 

                        vd.lambda1.mean=-2.774; // log10(per hr)
                        vd.lambda1.sdev=  .212;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180; 

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180; 

                        vd.rv.mean=1.375e-10;
                        vd.rv.sdev=1.e-11;

                        vd.Kd.mean=6.150e-4; // m^3/g
                        vd.Kd.sdev=2.350e-3;
                } else if (virus.equalsIgnoreCase("echovirus-clay")) {
                        String Name=new String("echovirus");
                        vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=-2.406; // log10(per hr)
                        vd.lambda0.sdev= 0.162;

                        vd.lambda1.mean=-2.684; // log10(per hr)
                        vd.lambda1.sdev=  .162;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180;

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180;

                        vd.rv.mean=1.375e-10;
                        vd.rv.sdev=1.e-11;

                        vd.Kd.mean=4.535e-4; // m^3/g
                        vd.Kd.sdev=7.655e-4;
                } else if (virus.equalsIgnoreCase("echovirus-silt")) {
                        String Name=new String("echovirus");
                        vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=-2.406; // log10(per hr)
                        vd.lambda0.sdev= 0.162;

                        vd.lambda1.mean=-2.684; // log10(per hr)
                        vd.lambda1.sdev=  .162;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180;

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180;

                        vd.rv.mean=1.375e-10;
                        vd.rv.sdev=1.e-11;

                        vd.Kd.mean=4.42e-4; // m^3/g
                        vd.Kd.sdev=2.76e-3;
                } else if (virus.equalsIgnoreCase("echovirus-sand")) {
                        String Name=new String("echovirus");
                        vd.name.is=Name.toCharArray();

                        vd.lambda0.mean=-2.406; // log10(per hr)
                        vd.lambda0.sdev= 0.162;

                        vd.lambda1.mean=-2.684; // log10(per hr)
                        vd.lambda1.sdev=  .162;

                        vd.kappa0.mean=0.00134; // m/hr
                        vd.kappa0.sdev=0.00180;

                        vd.kappa1.mean=0.00927; // m/hr
                        vd.kappa1.sdev=0.00180;

                        vd.rv.mean=1.375e-10;
                        vd.rv.sdev=1.e-11;

                        vd.Kd.mean=7.44e-4; // m^3/g
                        vd.Kd.sdev=2.525e-3;
		} else {
			for (i=0; i<xmlviruses.size(); i++) {
				if (String.copyValueOf(
					((Operandum)xmlviruses.get(
					  i)).name.is).equalsIgnoreCase(virus)
				) vd=(Operandum)xmlviruses.get(i);
			}
		}
		return vd;
	}
	public void addVirus(Operandum virus) {
		xmlviruses.add(virus);
	}
	private int i;
	private Vector xmlviruses=new Vector();
}
