import com.sun.image.codec.jpeg.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.image.BufferedImage;
import java.text.*;

/**
   <b>pbViruloFrame</b> class to do Plackett-Burman sensitivity analysis of
   Virulo as described by Beres and Hawkins.
<P>

@author Barton R. Faulkner<br>
        U.S. EPA Office of Research and Development<br>
        National Risk Management Research Laboratory<br>
        Ada, Oklahoma, USA<br>
@version 17 October 2002
@see JFrame
*/

public class pbViruloFrame extends JFrame {
	Toolkit tk=Toolkit.getDefaultToolkit();
	Dimension d=tk.getScreenSize();
	int screenHeight=d.height;
	int screenWidth =d.width;
	/** Construct a <b>ViruloFrame</b>.
	*/
	public pbViruloFrame() {
		jar=new JarLoadable();
		gossiper=new Gossiper();
                setTitle("Virulo !!!PLACKETT-BURMAN SENSITIVITY ANALYSIS!!!");
		// make it extra big so I'll know if I've implemented this
		// class instead of ViruloFrame, by mistake:
		setSize(690,690);
		setLocation( (int)(screenWidth/20), (int)(screenHeight/20) );
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		fileMenu=new JMenu("File");
		openItem=new JMenuItem("Open xml ..");
		saveItem=new JMenuItem("Save as ..");
		chooser=new JFileChooser();
		chooser.setFileFilter(new JpgFilter());
		saveItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent se) {
			   chooser.showSaveDialog(null);
			   File file=chooser.getSelectedFile();
			   String fileString=file.getPath();
			   if (tp.getSelectedIndex()==3) {
				try {
					fileString+=".txt";
					rof=new RandomAccessFile(
						fileString,"rw");
					rof.writeBytes(outString);
					rof.close();
				} catch (IOException ie) {
				}
			   } else if (tp.getSelectedIndex()==2) {
				try {
					out=new FileOutputStream(file);
					JPEGImageEncoder encoder=
						JPEGCodec.createJPEGEncoder(out);
					encoder.encode(panelGout.getImage());
				} catch (IOException ie) {
				}
			   } else if (tp.getSelectedIndex()==0) {
				sd=panelFlow.getData();
				sdwriter=new MediumXMLWriter(sd,fileString);
				fileString+=".xml";
				sdwriter.writeXML(fileString);
			   } else if (tp.getSelectedIndex()==1) {
				vd=panelVirus.getData();
				vdwriter=new OperandumXMLWriter(vd,fileString);
				fileString+=".xml";
				vdwriter.writeXML(fileString);
			   }
			}
		});
		saveItem.setMnemonic('S');
		fileMenu.add(saveItem);
		exitItem=new JMenuItem("Exit");
		exitItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ee) {
				System.exit(0);
			}
		});
		openItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent oe) {
			   chooser.showOpenDialog(null);
			   File file=chooser.getSelectedFile();
			   String fileString=file.getPath();
			   if (tp.getSelectedIndex()==0) {
				try {
					rof=new RandomAccessFile(fileString,"r");
					DataBuilder builder=new DataBuilder();
					builder.getData(rof);
				} catch (IOException ie) {
				}
			   } else if (tp.getSelectedIndex()==1) {
				// TODO: read a virus xml file
			   }
			}
		});
		openItem.setMnemonic('O');
		fileMenu.add(openItem);
		fileMenu.add(exitItem);
		exitItem.setMnemonic('x');
		editMenu=new JMenu("Edit");
		editMenu.setMnemonic('E');
		copyItem=new JMenuItem("Copy to clipboard");
		copyItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ce) {
			   if (tp.getSelectedIndex()==3) panelTout.copy();
			}
		});
		copyItem.setMnemonic('C');
		editMenu.add(copyItem);
		selectItem=new JMenuItem("Select all");
		selectItem.setMnemonic('a');
		selectItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
			   if (tp.getSelectedIndex()==3) panelTout.selectAll();
			}
		});
		editMenu.add(selectItem);
		runMenu=new JMenu("Run");
		runMenu.setMnemonic('R');
		goItem=new JMenuItem("Start Simulation",new ImageIcon(
                        jar.loadImage("run.gif")));
		goItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ge) {
				stop=false;
System.out.println("\nThis is Virulo sensitivity analysis");
double[] l=new double[17];
double[] u=new double[17];
l[0]=0.0647;
u[0]=0.0753;
l[1]=0.15;
u[1]=0.40;
l[2]=0.376;
u[2]=0.433;
l[3]=-2.12;
u[3]=0.42;
l[4]=0.12;
u[4]=0.28;
l[5]=0.23;
u[5]=0.31;
l[6]=975333;
u[6]=1891333;
l[7]=6.233e-5;
u[7]=1.997e-4;
l[8]=8.75e-5;
u[8]=5.59e-3;
l[9]=4.32;
u[9]=19.08;
l[10]=0.5;
u[10]=20;
l[11]=0.0;
u[11]=1.213;
l[12]=0.0;
u[12]=0.912;
l[13]=0.0;
u[13]=3.14e-3;
l[14]=0.0;
u[14]=0.023;
l[15]=1.25e-8;
u[15]=1.5e-8;
l[16]=-3.05e-4;
u[16]=1.2e-3;
System.out.println("Parameter headers:");
System.out.println(" theta_r theta_m theta_s Ks alpha n rho rp alphaz temp L lambda0 lambda1 kappa0 kappa1 rv Kd");
// ++--++++-+-+----++-
//1
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       u[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       u[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("1  + + - - + + + + - + - + - - - - + + - "+mfd);
// -++--++++-+-+----++
//2
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       l[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       l[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("2  - + + - - + + + + - + - + - - - - + + "+mfd);
// +-++--++++-+-+----+
//3
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       l[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       u[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("3  + - + + - - + + + + - + - + - - - - + "+mfd);
// ++-++--++++-+-+----
//4
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       u[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       u[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("4  + + - + + - - + + + + - + - + - - - - "+mfd);
// -++-++--++++-+-+---
//5
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       u[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       u[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("5  - + + - + + - - + + + + - + - + - - - "+mfd);
// --++-++--++++-+-+--
//6
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       l[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       u[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("6  - - + + - + + - - + + + + - + - + - - "+mfd);
// ---++-++--++++-+-+-
//7
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       u[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       l[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("7  - - - + + - + + - - + + + + - + - + - "+mfd);
// ----++-++--++++-+-+
//8
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       u[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       l[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("8  - - - - + + - + + - - + + + + - + - + "+mfd);
// +----++-++--++++-+-
//9
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       l[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       u[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("9  + - - - - + + - + + - - + + + + - + - "+mfd);
// -+----++-++--++++-+
//10
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       l[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       u[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("10 - + - - - - + + - + + - - + + + + - + "+mfd);
// +-+----++-++--++++-
//11
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       l[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       l[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("11 + - + - - - - + + - + + - - + + + + - "+mfd);
// -+-+----++-++--++++
//12
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       l[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       u[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("12 - + - + - - - - + + - + + - - + + + + "+mfd);
// +-+-+----++-++--+++
//13
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       u[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       u[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("13 + - + - + - - - - + + - + + - - + + + "+mfd);
// ++-+-+----++-++--++
//14
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       l[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       l[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("14 + + - + - + - - - - + + - + + - - + + "+mfd);
// +++-+-+----++-++--+
//15
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       u[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       l[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("15 + + + - + - + - - - - + + - + + - - + "+mfd);
// ++++-+-+----++-++--
//16
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       l[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       l[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("16 + + + + - + - + - - - - + + - + + - - "+mfd);
// -++++-+-+----++-++-
//17
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       u[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       l[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("17 - + + + + - + - + - - - - + + - + + - "+mfd);
// --++++-+-+----++-++
//18
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       u[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       u[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("18 - - + + + + - + - + - - - - + + - + + "+mfd);
// +--++++-+-+----++-+
//19
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       u[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       l[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("19 + - - + + + + - + - + - - - - + + - + "+mfd);
// -------------------
//20
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       l[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       l[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("20 - - - - - - - - - - - - - - - - - - - "+mfd);
// --++----+-+-++++--+
//21
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       l[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       l[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("21 - - + + - - - - + - + - + + + + - - + "+mfd);
// +--++----+-+-++++--
//22
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       u[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       u[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("22 + - - + + - - - - + - + - + + + + - - "+mfd);
// -+--++----+-+-++++-
//23
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       u[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       l[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("23 - + - - + + - - - - + - + - + + + + - "+mfd);
// --+--++----+-+-++++
//24
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       l[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       l[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("24 - - + - - + + - - - - + - + - + + + + "+mfd);
// +--+--++----+-+-+++
//25
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       l[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       l[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("25 + - - + - - + + - - - - + - + - + + + "+mfd);
// ++--+--++----+-+-++
//26
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       u[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       l[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("26 + + - - + - - + + - - - - + - + - + + "+mfd);
// +++--+--++----+-+-+
//27
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       l[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       u[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("27 + + + - - + - - + + - - - - + - + - + "+mfd);
// ++++--+--++----+-+-
//28
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       l[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       u[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("28 + + + + - - + - - + + - - - - + - + - "+mfd);
// -++++--+--++----+-+
//29
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       u[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       l[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("29 - + + + + - - + - - + + - - - - + - + "+mfd);
// +-++++--+--++----+-
//30
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       u[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       l[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("30 + - + + + + - - + - - + + - - - - + - "+mfd);
// -+-++++--+--++----+
//31
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       u[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       u[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("31 - + - + + + + - - + - - + + - - - - + "+mfd);
// +-+-++++--+--++----
//32
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       u[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       l[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("32 + - + - + + + + - - + - - + + - - - - "+mfd);
// -+-+-++++--+--++---
//33
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       l[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       l[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("33 - + - + - + + + + - - + - - + + - - - "+mfd);
// --+-+-++++--+--++--
//34
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       u[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       u[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("34 - - + - + - + + + + - - + - - + + - - "+mfd);
// ---+-+-++++--+--++-
//35
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       l[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       u[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=l[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("35 - - - + - + - + + + + - - + - - + + - "+mfd);
// ----+-+-++++--+--++
//36
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       u[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       u[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=l[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("36 - - - - + - + - + + + + - - + - - + + "+mfd);
// +----+-+-++++--+--+
//37
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= l[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       l[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       u[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= l[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("37 + - - - - + - + - + + + + - - + - - + "+mfd);
// ++----+-+-++++--+--
//38
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= l[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       l[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      l[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       l[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= l[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("38 + + - - - - + - + - + + + + - - + - - "+mfd);
// -++----+-+-++++--+-
//39
soilData.theta_r.mean= l[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      l[3];
soilData.a.mean=       l[4];
soilData.n.mean=       l[5];
soilData.rho.mean=     l[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  l[8];
soilData.t.mean=       u[9];
soilData.z.mean=       l[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     l[15];
virusData.Kd.mean=     l[16];
mfd=getMfd();
System.out.println("39 - + + - - - - + - + - + + + + - - + - "+mfd);
// +++++++++++++++++++
//40
soilData.theta_r.mean= u[0];
soilData.theta_m.mean= u[1];
soilData.theta_s.mean= u[2];
soilData.K0.mean=      u[3];
soilData.a.mean=       u[4];
soilData.n.mean=       u[5];
soilData.rho.mean=     u[6];
soilData.rp.mean=      u[7];
soilData.alphaz.mean=  u[8];
soilData.t.mean=       u[9];
soilData.z.mean=       u[10];
virusData.lambda0.mean=u[11];
virusData.lambda1.mean=u[12];
virusData.kappa0.mean= u[13];
virusData.kappa1.mean= u[14];
virusData.rv.mean=     u[15];
virusData.Kd.mean=     u[16];
mfd=getMfd();
System.out.println("40 + + + + + + + + + + + + + + + + + + + "+mfd);
			}
		});
		stopItem=new JMenuItem("Stop Simulation",new ImageIcon(
                        jar.loadImage("stop.gif")));
		stopItem.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent se) {
				stop=true;
                        }
                });
		runMenu.add(goItem);
		runMenu.add(stopItem);
		goItem.setMnemonic('S');
                helpMenu=new JMenu("Help");
		aboutItem=new JMenuItem("About Virulo..");
		aboutItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent afe) {
				aframe=new AboutFrame();
				aframe.show();
			}
		});
		aboutItem.setMnemonic('A');
                helpMenu.add(aboutItem);
                helpMenu.setMnemonic('H');
                runButton=new JButton("Start Simulation",
			new ImageIcon(
			jar.loadImage("run.gif")));
		sLabel=new JLabel(" Threshold Attenuation (\u03b5): ");
		inLabel=new JLabel(" ( -log10 )  ");
		breakPointTextField=new JTextField("4",3);
		breakPointTextField.setHorizontalAlignment(JTextField.CENTER);
		breakPointTextField.setToolTipText("The logarithm, base 10, of the target "+
			"attenuation factor");
		runButton.setToolTipText("Start new simulation with current parameters");
		runButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			}
		});
		stopButton=new JButton("Stop",
                        new ImageIcon(
                        jar.loadImage("stop.gif")));
                stopButton.setToolTipText("Stop current simulation");
                stopButton.addActionListener(new ActionListener() {
                        public void actionPerformed(ActionEvent e) {
				stop=true;
                        }
                });
		mb=new JMenuBar();
		mb.add(fileMenu);
		fileMenu.setMnemonic('F');
		mb.add(editMenu);
		mb.add(runMenu);
		mb.add(helpMenu);
                mb.add(runButton);
		mb.add(stopButton);
		mb.add(sLabel);
		mb.add(breakPointTextField);
		mb.add(inLabel);
                setJMenuBar(mb);

		Container contentPane=getContentPane();

		panelFlow=new FlowPanel(gossiper);
                panelVirus=new VirusPanel(gossiper);
		bin=new int[numbins];
		panelGout=new HistoPanel(bin,hpanelwd,hpanelht);
		retainCheckBox=new JCheckBox("Retain and Accumulate");
		panelGout.add(retainCheckBox);
                panelTout=new OutputPanel();
		JScrollPane tsp=new JScrollPane(panelTout);

                tp=new JTabbedPane();
		tp.addTab("Flow Parameters",new ImageIcon(
			jar.loadImage("flow.gif")),
			panelFlow,"flow parameters");
		tp.addTab("Virus Parameters",new ImageIcon(
			jar.loadImage("virus.gif")),
			panelVirus,"virus parameters");
                tp.addTab("Histogram",new ImageIcon(
                        jar.loadImage("histogram.gif")),
                        panelGout,"histogram");
		tp.addTab("Probability",new ImageIcon(
			jar.loadImage("tout.gif")),
	        	tsp,"text");
                getContentPane().add(tp,"Center");

		sd=panelFlow.getData();
		vd=panelVirus.getData();
		soilData=(Medium)(sd.clone());
		virusData=(Operandum)(vd.clone());
		Mlo=new HspMonteCarlo(soilData,virusData);
	}
	/** Run the model with the current parameters to be sent to the
	<b>Attenuator</b> object.
	*/
	private double getMfd() {
		runcount=0;
		hits=0;
               	panelTout.printOutput("This is sensitivity analysis!!");
		vd=panelVirus.getData();
		ccount++;
		Mlo=new HspMonteCarlo(soilData,virusData);
		runButton.setEnabled(false);
		while (!stop && runcount++<ccount*100000) {
			// Note, Mlo.getNext returns simply the log10(A), thus
			mf=-Mlo.getNext();
			if (mf<bp) hits++;
		}
		runButton.setEnabled(true);
		return ((double)hits)/((double)runcount);
	}
	private double mfd;
	private String Message, bpString;
	private boolean stop=true;
	private Medium soilData,sd;
	private MediumXMLWriter sdwriter;
	private Operandum virusData,vd;
	private OperandumXMLWriter vdwriter;
	private HspMonteCarlo Mlo;
	private int hpanelwd=400, hpanelht=460;
	private int ccount;
	private int[] bin;
	private AboutFrame aframe;
	private RandomAccessFile rof;
	private OutputStream out;
	private double mf;
	private int i,it,hits,nancount,runcount,numbins=75;
	private double bp=4.;
	private JarLoadable jar;
	private String outString="";
	private JFileChooser chooser;
	private JLabel sLabel, inLabel;
	private JMenuBar mb;
	private JMenu fileMenu;
	private JMenu editMenu;
	private JMenu runMenu;
	private JMenu helpMenu;
	private JMenuItem saveItem;
	private JMenuItem openItem;
	private JMenuItem exitItem;
	private JMenuItem copyItem;
	private JMenuItem selectItem;
	private JMenuItem goItem;
	private JMenuItem stopItem;
	private JMenuItem aboutItem;
	private JButton runButton;
	private JButton stopButton;
	private JCheckBox retainCheckBox;
	private JTextField breakPointTextField;
	private JTabbedPane tp;
	private Gossiper gossiper;
	private BufferedImage image;
	private FlowPanel panelFlow;
	private VirusPanel panelVirus;
	private OutputPanel panelTout;
	private HistoPanel panelGout;
}
