C UNITS:  all times are in days, but ages are in years.
C         Pb is in micrograms.
C    INMODE is intake mode.
C    INMODE=0 is injection (direct input) into diffusible plasma,
C     1 is inhalation, 2 is ingestion, 3 is any combination of 0, 1, and 2.
C    IACUTE=1 is acute intake & 2 is chronic intake.
C    The chronic intake rate may be varied with time in a stepwise fashion.
C    The chronic injection rate is the variable CHR, which is later converted to CRONIC.
C    The chronic inhalation rate is the variable BRETH, which is later converted
C     to BRTCRN.  The chronic ingestion rate is eat, later converted to EATCRN.
C    ICPR.for received from Rich Leggett 9/93
C    ICRPv001 (chelat.for) add line#53 for chelation 10/96; rwl
C    ICRPv002 convert to crtconbm & trbconbm bone mineral density; jgp
C    ICRPv003 convert output time from DAYS to YEARS; 6/97; jgp
C    ICRPv004 add UPTAKEGI, UPTAKERI, UPTAKE; correct trbconbm conversion;
C             add decimal to YEARS; 11/97 jgp & rwl
C    ICRPv005 add age-dependent scaling for RBCONC,RENCON,CRTCON,TRBCON,ASHCON,TORBC 
c             April 2014, JGP
C    ICRPv005a adjust Pb distribution to cort-trab bone; fraction trab-cort bone
      DIMENSION DELTA(10),ICYC(10),Q(50)
      DIMENSION CHAGE(14),ENDPT(1000),CHR(1000),BRETH(1000),EAT(1000),
     $ AGSCAL(14),ARCORT(14),ARTRAB(14),ATBONE(14),ATFRAC(14),
     $ AF1(14),ARCS2B(14),ARTS2B(14),ARCSDF(14),ARTSDF(14),
     $ ARBLAD(14),ARLVR2(14),ARKDN2(14),ARBRAN(14),ARRBC(14),
     $ ARD2CS(14),ARD2TS(14),ARD2DC(14),ARD2DT(14),ATBRAN(14),
     $ ATSOF0(14),ATSOF1(14),ATSOF2(14),AAMTBL(14),RDIFF(14),
     $ FLONG(14),AKIDWT(14),ATSKELWT(14),ATTRABWT(14),ATCORTWT(14),
     $ FRTTRAB(14),ARBCVOL(14),APLSVOL(14),ABLDHCT(14),ATORBC(14)
      REAL INTACT,LAMOUT
      OPEN(30,FILE='POUNDS.DAT')
      OPEN(50,FILE='TEMP.DAT')
      READ(30,*) EXPAGE
      READ(30,*) NDELT,DELT0,NCYCLE,ENDDAY
      READ(30,*) (DELTA(I),I=1,NDELT)
      READ(30,*) (ICYC(I),I=1,NDELT)
      READ(30,*) ISKIP
      READ(30,*) I1,I2,I3,I4,I5
      READ(30,*) INMODE,IACUTE,LINPUT
C READ # CHRONIC INTAKE STEPS UP TO 50 AND CONSECUTIVE
C  ENDPOINTS IN DAYS, STARTING WITH DAYS=0.0.
      READ(30,*) NCHRON
      IF (IACUTE .EQ. 2) READ(30,*) (ENDPT(I),I=1,NCHRON)
      IF (IACUTE .EQ. 2) READ(30,*) (CHR(I),I=1,NCHRON)
      IF (IACUTE .EQ. 2) READ(30,*) (BRETH(I),I=1,NCHRON)
      IF (IACUTE .EQ. 2) READ(30,*) (EAT(I),I=1,NCHRON)
      IF (IACUTE .NE. 2) READ(30,*) DUMMY
      IF (IACUTE .NE. 2) READ(30,*) DUMMY
      IF (IACUTE .NE. 2) READ(30,*) DUMMY
      IF (IACUTE .NE. 2) READ(30,*) DUMMY
      READ(30,*) NUMAGE,XMXAGE
      READ(30,*) (CHAGE(I),I=1,NUMAGE)
      READ(30,*) (AF1(I),I=1,NUMAGE)
      READ(30,*) RDECAY
      READ(30,*) IRBC,RBCNL,SATRAT,POWER
      READ(30,*) IFETAL,BLDMOT,BRATIO
      READ(30,*) SOFIN,RBCIN,BONIN,RENIN,HEPIN,BRANIN
      READ(30,*) R1,R2,R3,R4,CILIAR
      READ(30,*) BR1,BR2,BR3,BR4
      READ(30,*) RSTMC,RSIC,RULI,RLLI
      READ(30,*) (AGSCAL(I),I=1,NUMAGE)
      READ(30,*) (ARCORT(I),I=1,NUMAGE)
      READ(30,*) (ARTRAB(I),I=1,NUMAGE)
      READ(30,*) (ARCS2B(I),I=1,NUMAGE)
      READ(30,*) (ARTS2B(I),I=1,NUMAGE)
      READ(30,*) (ARCSDF(I),I=1,NUMAGE)
      READ(30,*) (ARTSDF(I),I=1,NUMAGE)
      READ(30,*) (RDIFF(I),I=1,NUMAGE)
      READ(30,*) (FLONG(I),I=1,NUMAGE)
      READ(30,*) RLVR1,RKDN1
      READ(30,*) (ARBLAD(I),I=1,NUMAGE)
      READ(30,*) (ARLVR2(I),I=1,NUMAGE)
      READ(30,*) (ARKDN2(I),I=1,NUMAGE)
      READ(30,*) RSOF0,RSOF1,RSOF2
      READ(30,*) (ARBRAN(I),I=1,NUMAGE)
      READ(30,*) TOURIN,TOFECE,TOSWET,S2HAIR
      READ(30,*) (ATBONE(I),I=1,NUMAGE)
      READ(30,*) (ATFRAC(I),I=1,NUMAGE)
      READ(30,*) TOLVR1,H1TOH2,H1TOSI,H1TOBL
      READ(30,*) TOKDN1,TOKDN2
      READ(30,*) (ATSOF0(I),I=1,NUMAGE)
      READ(30,*) (ATSOF1(I),I=1,NUMAGE)
      READ(30,*) (ATSOF2(I),I=1,NUMAGE)
      READ(30,*) (ATBRAN(I),I=1,NUMAGE)
      DO 6 I=1,NUMAGE
      ARD2CS(I)=(1.-FLONG(I))*RDIFF(I)
      ARD2TS(I)=(1.-FLONG(I))*RDIFF(I)
      ARD2DC(I)=FLONG(I)*RDIFF(I)
      ARD2DT(I)=FLONG(I)*RDIFF(I)
   6  CONTINUE
      READ(30,*) TORBC
      READ(30,*) TOEVF,SIZEVF
      READ(30,*) RPLAS,TOPROT,RPROT
      READ(30,*) (ARRBC(I),I=1,NUMAGE)
      READ(30,*) XRBCVOL,XPLSVOL
C      ADJRBC=RBCVOL/(RBCVOL+PLSVOL) moved to below
      READ(30,*) (AAMTBL(I),I=1,NUMAGE)
      READ(30,*) ICHEL,CHLEFF,CHEL1,CHEL2
      IF (IACUTE .EQ. 1 .AND. LINPUT .EQ. 1) WRITE(*,11)
      IF (IACUTE .EQ. 2 .AND. LINPUT .EQ. 1) WRITE(*,12)

C  Age-Dependent Kidney Mass from ICRP v89, p148 
C  WHERE AGES 0,0.27,1,5,10,15,18,24,30,40,45,55,65 and 75 yr
      AKIDWT (1) = 25.
      AKIDWT (2) = 36.
      AKIDWT (3) = 70.
      AKIDWT (4) = 110.
      AKIDWT (5) = 180.
      AKIDWT (6) = 250.
      AKIDWT (7) = 310.
      AKIDWT (8) = 310.
      AKIDWT (9) = 310.
      AKIDWT (10) = 310.
      AKIDWT (11) = 310.
      AKIDWT (12) = 310.
      AKIDWT (13) = 310.
      AKIDWT (14) = 310.

C 	AGE-DEPENDENT TOTAL SKELETAL MASS (g) from ICRP v89, page 170
C	WHERE AGES ARE 0,0.27,1,5,10,15,18,24,30,40,45,55,65 and 75 YEARS
      ATSKELWT (1) = 370.
      ATSKELWT (2) = 642.
      ATSKELWT (3) = 1170.
      ATSKELWT (4) = 2430.
      ATSKELWT (5) = 4500.
      ATSKELWT (6) = 7950.
      ATSKELWT (7) = 10500.
      ATSKELWT (8) = 10500.
      ATSKELWT (9) = 10500.
      ATSKELWT (10) = 10500.
      ATSKELWT (11) = 10500.
      ATSKELWT (12) = 10500.
      ATSKELWT (13) = 10500.
      ATSKELWT (14) = 10500.

C       AGE-DEPENDENT Fraction of total skeletal mass comprised of trabecular bone 
C	WHERE AGES ARE 0,0.27,1,5,10,15,18,24,30,40,45,55,65 and 75 YEARS 
C     (changed from 99,96,87,)
      FRTTRAB (1) = .95
      FRTTRAB (2) = .90
      FRTTRAB (3) = .85
      FRTTRAB (4) = .50
      FRTTRAB (5) = .34
      FRTTRAB (6) = .23
      FRTTRAB (7) = .20
      FRTTRAB (8) = .20
      FRTTRAB (9) = .20
      FRTTRAB (10) = .20
      FRTTRAB (11) = .20
      FRTTRAB (12) = .20
      FRTTRAB (13) = .20
      FRTTRAB (14) = .20

C     CALCULATE AGE-DEPENDENT MASS OF TRABECULAR AND SKELETAL BONE AT 14 AGES
      ATTRABWT=ATSKELWT*FRTTRAB
      ATCORTWT=ATSKELWT*(1-FRTTRAB)

C     Age-dependent ARBCVOL and APLSVOL calculated from age-dependent hematocrit and total blood (7) .48->.42
      ABLDHCT (1) = .575
      ABLDHCT (2) = .37
      ABLDHCT (3) = .35
      ABLDHCT (4) = .38
      ABLDHCT (5) = .38
      ABLDHCT (6) = .40
      ABLDHCT (7) = .42
      ABLDHCT (8) = .45
      ABLDHCT (9) = .45
      ABLDHCT (10) = .45
      ABLDHCT (11) = .45
      ABLDHCT (12) = .45
      ABLDHCT (13) = .45
      ABLDHCT (14) = .45

      ARBCVOL=AAMTBL*ABLDHCT
      APLSVOL=AAMTBL*(1-ABLDHCT)
C     ADJRBC=RBCVOL/(RBCVOL+PLSVOL) Calculation replaced by BLDHCT

C     Age-dependent depostion fraction to RBC
      ATORBC (1) = 0.20
      ATORBC (2) = 0.20
      ATORBC (3) = 0.20
      ATORBC (4) = 0.20
      ATORBC (5) = 0.21
      ATORBC (6) = 0.22
      ATORBC (7) = 0.22
      ATORBC (8) = 0.22
      ATORBC (9) = 0.22
      ATORBC (10) = 0.22
      ATORBC (11) = 0.22
      ATORBC (12) = 0.22
      ATORBC (13) = 0.22
      ATORBC (14) = 0.22

  11  FORMAT(' Enter acute input.')
  12  FORMAT(' Enter chronic input to blood.')
      IF (IACUTE .EQ. 1 .AND. LINPUT .EQ. 1) READ(*,*)ACPLAS
      IF (IACUTE .EQ. 2 .AND. LINPUT .EQ. 1) READ(*,*)CHR(1)
      IF (IACUTE .EQ. 1 .AND. LINPUT .NE. 1) AACUTE=1.0
      IF (IACUTE .EQ. 1 .AND. LINPUT .EQ. 1) AACUTE=ACPLAS
C
      IF (IFETAL .NE. 1 .OR. EXPAGE .GT. 0.01 .OR.
     $     IACUTE .NE. 2) GO TO 15
      YSOF2=SOFIN*(BLDMOT*BRATIO*3./RBCIN)
      YRBC=RBCIN*(BLDMOT*BRATIO*3./RBCIN)
      YCVOL=0.8*BONIN*(BLDMOT*BRATIO*3./RBCIN)
      YTVOL=0.2*BONIN*(BLDMOT*BRATIO*3./RBCIN)
      YKDN2=RENIN*(BLDMOT*BRATIO*3./RBCIN)
      YLVR2=HEPIN*(BLDMOT*BRATIO*3./RBCIN)
      YBRAN=BRANIN*(BLDMOT*BRATIO*3./RBCIN)
  15  CONTINUE
      HOWOLD=EXPAGE
      DAYS=0.0
      BTEMP=0.0
C  BEGIN CALCULATIONS.
      DO 1000 N=1,NCYCLE
C CHRONIC INTAKE SWITCH IS IACUTE.
      BRTCRN=0.0
      IF (IACUTE .NE. 2) GO TO 38
      DO 35 I=2,NCHRON+1
      IF (DAYS .GT. ENDPT(I-1)-1.0E-09) GO TO 35
      CRONIC=CHR(I-1)
      BRTCRN=BRETH(I-1)
      EATCRN=EAT(I-1)
      GO TO 38
  35  CONTINUE
  38  CONTINUE
         IF (DELT0 .GT. 0.0) THEN
            DELT = DELT0
         ELSE
            DO 52 ISTEP = 1, NDELT
               IF (N .LE. ICYC(ISTEP)) THEN
                  DELT = DELTA(ISTEP)
                  GO TO 53
               END IF
   52       CONTINUE
   53       CONTINUE
         END IF
      HOWOLD=HOWOLD+DELT/365.
      DAYS=DAYS+DELT
      TMINS=1440.*DAYS
      XMINS=1440.*DAYS
      HOURS=24.*DAYS
      YEARS=DAYS/365.
      IF (DAYS .GT. 1.0) TMINS=DAYS
C IN THE FOLLOWING THE AGE-DEPENDENT VARIABLES ARE INTERPOLATED
C TO GET VALUES FOR AGE HOWOLD.
C  SKIP THE FOLLOWING STEPS FOR PERSONS OLDER THAN XMXAGE YEARS.
      IF (HOWOLD .GE. XMXAGE) GO TO 500
C
        DO 200 JAGE=1,NUMAGE
        IF (HOWOLD .GE. CHAGE(JAGE)) GO TO 200
        K=JAGE-1
        GO TO 300
 200    CONTINUE
C
 300  CONTINUE
C
      L=K+1
      U=HOWOLD-CHAGE(K)
      V=CHAGE(L)-HOWOLD
      W=V/(U+V)
      Z=U/(U+V)
C
      GO TO 600
C
C  FOR THE CASE IN WHICH HOWOLD IS AT LEAST XMXAGE YEARS:
 500  K=NUMAGE
      L=NUMAGE
      W=1.0
      Z=0.0
C
 600  CONTINUE
C
C  DETERMINE BY INTERPOLATION THE RATES AND FRACTIONS AT AGE HOWOLD.
C
      F1=W*AF1(K)+Z*AF1(L)
      AMTBLD=W*AAMTBL(K)+Z*AAMTBL(L)
      RCORT=W*ARCORT(K)+Z*ARCORT(L)
      RTRAB=W*ARTRAB(K)+Z*ARTRAB(L)
      TFRAC=W*ATFRAC(K)+Z*ATFRAC(L)
      TBONE=W*ATBONE(K)+Z*ATBONE(L)
      TOSOF0=W*ATSOF0(K)+Z*ATSOF0(L)
      TOSOF1=W*ATSOF1(K)+Z*ATSOF1(L)
      TOSOF2=W*ATSOF2(K)+Z*ATSOF2(L)
      TOBRAN=W*ATBRAN(K)+Z*ATBRAN(L)
      RCS2B=W*ARCS2B(K)+Z*ARCS2B(L)
      RTS2B=W*ARTS2B(K)+Z*ARTS2B(L)
      RCS2DF=W*ARCSDF(K)+Z*ARCSDF(L)
      RTS2DF=W*ARTSDF(K)+Z*ARTSDF(L)
      RDF2CS=W*ARD2CS(K)+Z*ARD2CS(L)
      RDF2TS=W*ARD2TS(K)+Z*ARD2TS(L)
      RDF2DC=W*ARD2DC(K)+Z*ARD2DC(L)
      RDF2DT=W*ARD2DT(K)+Z*ARD2DT(L)
      RLVR2=W*ARLVR2(K)+Z*ARLVR2(L)
      RKDN2=W*ARKDN2(K)+Z*ARKDN2(L)
      RBLAD=W*ARBLAD(K)+Z*ARBLAD(L)
      RBRAN=W*ARBRAN(K)+Z*ARBRAN(L)
      RRBC=W*ARRBC(K)+Z*ARRBC(L)
      GSCALE=W*AGSCAL(K)+Z*AGSCAL(L)
      KIDWT=W*AKIDWT(K)+Z*AKIDWT(L)
      TSKELWT=W*ATSKELWT(K)+Z*ATSKELWT(L)
      TRABWT=W*ATTRABWT(K)+Z*ATTRABWT(L)
      CORTWT=W*ATCORTWT(K)+Z*ATCORTWT(L)
      RBCVOL=W*ARBCVOL(K)+Z*ARBCVOL(L)
      PLSVOL=W*APLSVOL(K)+Z*APLSVOL(L)
      BLDHCT=w*ABLDHCT(K)+Z*ABLDHCT(L)
      TORBC= w*ATORBC(K)+Z*ATORBC(L)

C        ADJRBC=W*AADJRBC(K)+Z*AADJRBC(L)

C
      TEVF=TOEVF
      AGESCL=(1.0-TEVF-TBONE)/(1.0-TEVF-ATBONE(NUMAGE))
      TURIN=AGESCL*TOURIN
      TFECE=AGESCL*TOFECE
      TSWET=AGESCL*TOSWET
      TSOF0=AGESCL*TOSOF0
      TSOF1=AGESCL*TOSOF1
      TSOF2=AGESCL*TOSOF2
      TBRAN=AGESCL*TOBRAN
      TLVR1=AGESCL*TOLVR1
      TKDN1=AGESCL*TOKDN1
      TKDN2=AGESCL*TOKDN2
      TRBC=AGESCL*TORBC
      TPROT=AGESCL*TOPROT
C
      DECRBC=YRBC/RBCVOL
      DECPLS=YPLAS/PLSVOL
      BLDVOL=RBCVOL+PLSVOL
      DECLTR=YBLUD/BLDVOL
      TOORBC=TRBC
      IF (IRBC .NE. 1 .OR. RBCONC .LE. RBCNL) GO TO 610
      TOORBC=TRBC*(1.-((RBCONC-RBCNL)/(SATRAT-RBCNL)))**POWER
      IF (TOORBC .LT. 0.0) TOORBC=0.0
 610  CONTINUE
      TSUM=TOORBC+TEVF+TPROT+TBONE+TURIN+TFECE+TSWET+TLVR1
     $ +TKDN1+TKDN2+TSOF0+TSOF1+TSOF2+TBRAN
      CF=(1.-TOORBC)/(1.-TRBC)
      RPLS=TSUM*RPLAS
      REVF=TEVF*RPLS/SIZEVF
      IF (ICHEL. EQ. 1 .AND. DAYS .GE. CHEL1 .AND. DAYS .LE. CHEL2)
     $  THEN
      TEVF=(1.-CHLEFF)*TEVF
      TFECE=(1.-CHLEFF)*TFECE
      TSWET=(1.-CHLEFF)*TSWET
      TSOF0=(1.-CHLEFF)*TSOF0
      TSOF1=(1.-CHLEFF)*TSOF1
      TSOF2=(1.-CHLEFF)*TSOF2
      TBRAN=(1.-CHLEFF)*TBRAN
      TLVR1=(1.-CHLEFF)*TLVR1
      TKDN1=(1.-CHLEFF)*TKDN1
      TKDN2=(1.-CHLEFF)*TKDN2
      TPROT=(1.-CHLEFF)*TPROT
      TBONE=(1.-CHLEFF)*TBONE
      TOORBC=(1.-CHLEFF)*TOORBC
      TURIN=1.0-TOORBC-TEVF-TPROT-TBONE-TFECE-TSWET-TLVR1
     $ -TKDN1-TKDN2-TSOF0-TSOF1-TSOF2-TBRAN
      END IF
C
      IF (INMODE .EQ. 0 .OR. INMODE .EQ. 2) GO TO 55
C____________________________________________
C  LUNG 1 COMPARTMENT
      Y0=YR1
      IF (IACUTE .EQ. 1 .AND. N .EQ. 1) Y0=R1*AACUTE
      P=0.0
      IF (IACUTE .EQ. 2) P=R1*BRTCRN
      LAMOUT=RDECAY+BR1
      YR1=ACTVTY(Y0,P,LAMOUT,DELT)
      YR1W=INTACT(Y0,P,LAMOUT,DELT)
C_______________________________________________
C  LUNG 2 COMPARTMENT
      Y0=YR2
      IF (IACUTE .EQ. 1 .AND. N .EQ. 1) Y0=R2*AACUTE
      P=0.0
      IF (IACUTE .EQ. 2) P=R2*BRTCRN
      LAMOUT=RDECAY+BR2
      YR2=ACTVTY(Y0,P,LAMOUT,DELT)
      YR2W=INTACT(Y0,P,LAMOUT,DELT)
C_______________________________________________
C  LUNG 3 COMPARTMENT
      Y0=YR3
      IF (IACUTE .EQ. 1 .AND. N .EQ. 1) Y0=R3*AACUTE
      P=0.0
      IF (IACUTE .EQ. 2) P=R3*BRTCRN
      LAMOUT=RDECAY+BR3
      YR3=ACTVTY(Y0,P,LAMOUT,DELT)
      YR3W=INTACT(Y0,P,LAMOUT,DELT)
C_______________________________________________
C  LUNG 4 COMPARTMENT
      Y0=YR4
      IF (IACUTE .EQ. 1 .AND. N .EQ. 1) Y0=R4*AACUTE
      P=0.0
      IF (IACUTE .EQ. 2) P=R4*BRTCRN
      LAMOUT=RDECAY+BR4
      YR4=ACTVTY(Y0,P,LAMOUT,DELT)
      YR4W=INTACT(Y0,P,LAMOUT,DELT)
      YLUNG=YR1+YR2+YR3+YR4
  55   CONTINUE
C____________________________________________
      IF (INMODE .EQ. 0) GO TO 65
C  STOMACH CONTENTS (STMC) COMPARTMENT
      Y0=YSTMC
      IF (INMODE .EQ. 2 .AND. IACUTE .EQ. 1 .AND. N .EQ. 1)
     $ Y0=AACUTE
      P=0.0
      IF (INMODE .GT. 1 .AND. IACUTE .EQ. 2) P=EATCRN
      IF (INMODE .EQ. 1 .OR. INMODE .EQ. 3) P=EATCRN+
     $   CILIAR*(BR1*YR1W+BR2*YR2W+BR3*YR3W+BR4*YR4W)/DELT
      LAMOUT=RDECAY+GSCALE*RSTMC
      YSTMC=ACTVTY(Y0,P,LAMOUT,DELT)
      YSTMCW=INTACT(Y0,P,LAMOUT,DELT)
  65  CONTINUE
      IF (INMODE .EQ. 0 .AND. N .EQ. 1) GO TO 66
C___________________________________________
C  SMALL INTESTINE CONTENTS (SIC) COMPARTMENT
      Y0=YSIC
      P=(GSCALE*RSTMC*YSTMCW+H1TOSI*RLVR1*YLVR1W+TFECE*CF*BTEMP)/DELT
      LAMOUT=RDECAY+GSCALE*RSIC
      YSIC=ACTVTY(Y0,P,LAMOUT,DELT)
      YSICW=INTACT(Y0,P,LAMOUT,DELT)
  66  CONTINUE
C---------------------------------------
C  PLASMA (PLS); THIS IS DIFFUSIBLE PLASMA PB;
C   DOES NOT INCLUDE RELATIVELY SLOWLY EXCHANGEABLE PLASMA-
C   PROTEIN-BOUND PB, WHEN THE LATTER COMPARTMENT IS USED.
      Y0=YPLS
      IF (INMODE .EQ. 0 .AND. N .EQ. 1 .AND. IACUTE .EQ. 1)
     $ Y0=AACUTE
      P1=(RPROT*YPROTW+RRBC*YRBCW+REVF*YEVFW+RSOF0*YSOF0W
     $ +(1.0-S2HAIR)*RSOF1*YSOF1W+RSOF2*YSOF2W
     $ +H1TOBL*RLVR1*YLVR1W+RLVR2*YLVR2W
     $ +RKDN2*YKDN2W+RCS2B*YCSURW+RTS2B*YTSURW
     $ +RCORT*YCVOLW+RTRAB*YTVOLW+RBRAN*YBRANW
     $ +F1*GSCALE*RSIC*YSICW)/DELT
      IF (IACUTE .EQ. 2) P1=P1+CRONIC
      IF (INMODE .EQ. 1 .OR. INMODE .EQ. 3) P1=P1+
     $  (1.0-CILIAR)*(BR1*YR1W+BR2*YR2W+BR3*YR3W+BR4*YR4W)/DELT
      LAMOUT=RPLS+RDECAY
      UPTAKEGI=(F1*GSCALE*RSIC*YSICW)/DELT
      UPTAKERI=(1.0-CILIAR)*(BR1*YR1W+BR2*YR2W+BR3*YR3W+BR4*YR4W)/DELT
      UPTAKE=UPTAKEGI+UPTAKERI
C  ACTIVITY AND INTEGRATED ACTIVITY
      YPLS=ACTVTY(Y0,P1,LAMOUT,DELT)
      YPLSW=INTACT(Y0,P1,LAMOUT,DELT)
      BTEMP=RPLS*YPLSW
C__________________________________
C  PLASMA-PROTEIN BOUND PB (PROT)
      Y0=YPROT
      P=TPROT*CF*BTEMP/DELT
      LAMOUT=RPROT+RDECAY
      YPROT=ACTVTY(Y0,P,LAMOUT,DELT)
      YPROTW=INTACT(Y0,P,LAMOUT,DELT)
      YPLAS=YPLS+YPROT
      YPLASW=YPLSW+YPROTW
C______________________________________
C
C  RED BLOOD CELLS (RBC)
      Y0=YRBC
C NOTE THAT CF HAS BEEN REMOVED FROM FOLLOWING:
      P=TOORBC*BTEMP/DELT
      LAMOUT=RRBC+RDECAY
      YRBC=ACTVTY(Y0,P,LAMOUT,DELT)
      YRBCW=INTACT(Y0,P,LAMOUT,DELT)
      YBLUD=YPLAS+YRBC
      SUMRBC=SUMRBC+YRBCW
C______________________________________
C  EVF
      Y0=YEVF
      P=TEVF*CF*BTEMP/DELT
      LAMOUT=REVF+RDECAY
      YEVF=ACTVTY(Y0,P,LAMOUT,DELT)
      YEVFW=INTACT(Y0,P,LAMOUT,DELT)
C_______________________________________________
C  FAST TURNOVER SOFT-TISSUE COMPARTMENT (SOF0)
      Y0=YSOF0
      P=TSOF0*CF*BTEMP/DELT
      LAMOUT=RSOF0+RDECAY
      YSOF0=ACTVTY(Y0,P,LAMOUT,DELT)
      YSOF0W=INTACT(Y0,P,LAMOUT,DELT)
C  _____________________________________
C  INTERMEDIATE TURNOVER SOFT-TISSUE COMPARTMENT (SOF1)
      Y0=YSOF1
      P=TSOF1*CF*BTEMP/DELT
      LAMOUT=RSOF1+RDECAY
      YSOF1=ACTVTY(Y0,P,LAMOUT,DELT)
      YSOF1W=INTACT(Y0,P,LAMOUT,DELT)
C  _____________________________________
C  SLOW TURNOVER SOFT-TISSUE COMPARTMENT (SOF2)
      Y0=YSOF2
      P=TSOF2*CF*BTEMP/DELT
      LAMOUT=RSOF2+RDECAY
      YSOF2=ACTVTY(Y0,P,LAMOUT,DELT)
      YSOF2W=INTACT(Y0,P,LAMOUT,DELT)
C  _____________________________________
C  BRAIN (BRAN)
      Y0=YBRAN
      P=TBRAN*CF*BTEMP/DELT
      LAMOUT=RBRAN+RDECAY
      YBRAN=ACTVTY(Y0,P,LAMOUT,DELT)
      YBRANW=INTACT(Y0,P,LAMOUT,DELT)
C__________________________________________
C  CORTICAL SURFACE (CSUR)
      Y0=YCSUR
      P=(TBONE*(1.0-TFRAC)*CF*BTEMP+RDF2CS*YCDIFW)/DELT
      LAMOUT=RCS2B+RCS2DF+RDECAY
      YCSUR=ACTVTY(Y0,P,LAMOUT,DELT)
      YCSURW=INTACT(Y0,P,LAMOUT,DELT)
C______________________________________
C  EXCHANGEABLE CORTICAL VOLUME (CDIF)
      Y0=YCDIF
      P=RCS2DF*YCSURW/DELT
      LAMOUT=RDF2CS+RDF2DC+RDECAY
      YCDIF=ACTVTY(Y0,P,LAMOUT,DELT)
      YCDIFW=INTACT(Y0,P,LAMOUT,DELT)
 620  CONTINUE
C--------------------------------------------------
C  NONEXCHANGEABLE CORTICAL VOLUME (CVOL)
      Y0=YCVOL
      P=RDF2DC*YCDIFW/DELT
      LAMOUT=RCORT+RDECAY
      YCVOL=ACTVTY(Y0,P,LAMOUT,DELT)
      YCVOLW=INTACT(Y0,P,LAMOUT,DELT)
C--------------------------------------------------
C  TRABECULAR SURFACE (TSUR)
      Y0=YTSUR
      P=(TBONE*TFRAC*CF*BTEMP+RDF2TS*YTDIFW)/DELT
      LAMOUT=RTS2B+RTS2DF+RDECAY
      YTSUR=ACTVTY(Y0,P,LAMOUT,DELT)
      YTSURW=INTACT(Y0,P,LAMOUT,DELT)
C--------------------------------------------------
C  EXCHANGEABLE TRABECULAR VOLUME (CDIF)
      Y0=YTDIF
      P=RTS2DF*YTSURW/DELT
      LAMOUT=RDF2TS+RDF2DT+RDECAY
      YTDIF=ACTVTY(Y0,P,LAMOUT,DELT)
      YTDIFW=INTACT(Y0,P,LAMOUT,DELT)
 630  CONTINUE
C--------------------------------------------------
C  NONEXCHANGEABLE TRABECULAR VOLUME (TVOL)
      Y0=YTVOL
      P=RDF2DT*YTDIFW/DELT
      LAMOUT=RTRAB+RDECAY
      YTVOL=ACTVTY(Y0,P,LAMOUT,DELT)
      YTVOLW=INTACT(Y0,P,LAMOUT,DELT)
C-------------------------------------------
C  LIVER 1 (LVR1)
      Y0=YLVR1
      P=TLVR1*CF*BTEMP/DELT
      LAMOUT=RLVR1+RDECAY
      YLVR1=ACTVTY(Y0,P,LAMOUT,DELT)
      YLVR1W=INTACT(Y0,P,LAMOUT,DELT)
C--------------------------------------------
C  LIVER 2 (LVR2)
      Y0=YLVR2
      P=H1TOH2*RLVR1*YLVR1W/DELT
      LAMOUT=RLVR2+RDECAY
      YLVR2=ACTVTY(Y0,P,LAMOUT,DELT)
      YLVR2W=INTACT(Y0,P,LAMOUT,DELT)
      YLIVR=YLVR1+YLVR2
C--------------------------------------------------
C KIDNEYS 1
      Y0=YKDN1
      P=TKDN1*CF*BTEMP/DELT
      LAMOUT=RKDN1+RDECAY
      YKDN1=ACTVTY(Y0,P,LAMOUT,DELT)
      YKDN1W=INTACT(Y0,P,LAMOUT,DELT)
C--------------------------------------------------
C KIDNEYS 2
      Y0=YKDN2
      P=TKDN2*CF*BTEMP/DELT
      LAMOUT=RKDN2+RDECAY
      YKDN2=ACTVTY(Y0,P,LAMOUT,DELT)
      YKDN2W=INTACT(Y0,P,LAMOUT,DELT)
C
      YKDNE=YKDN1+YKDN2
C--------------------------------------------------
C  BLADDER
      Y0=YBLAD
      P=(TURIN*CF*BTEMP+RKDN1*YKDN1W)/DELT
      LAMOUT=RBLAD+RDECAY
      YBLAD=ACTVTY(Y0,P,LAMOUT,DELT)
      YBLADW=INTACT(Y0,P,LAMOUT,DELT)
C-------------------------------------------------
C UPPER LARGE INTESTINE CONTENTS
      Y0=YULIC
      P=(1.0-F1)*GSCALE*RSIC*YSICW/DELT
      LAMOUT=GSCALE*RULI+RDECAY
      YULIC=ACTVTY(Y0,P,LAMOUT,DELT)
      YULICW=INTACT(Y0,P,LAMOUT,DELT)
C-------------------------------------------------
C LOWER LARGE INTESTINE CONTENTS
      Y0=YLLIC
      P=GSCALE*RULI*YULICW/DELT
      LAMOUT=GSCALE*RLLI+RDECAY
      YLLIC=ACTVTY(Y0,P,LAMOUT,DELT)
      YLLICW=INTACT(Y0,P,LAMOUT,DELT)
C--------------------------------------------------
C URINE
      U0=YURIN
      Y0=YURIN
      P=RBLAD*YBLADW/DELT
      YURIN=Y0+P*DELT
      UTEMP=P*DELT
      URIN=YURIN-U0
C--------------------------------------------------
C FECES
      Y0=YFECE
      P=GSCALE*RLLI*YLLICW/DELT
      YFECE=Y0+P*DELT
      FTEMP=P*DELT
C--------------------------------------------------
C SWEAT
      Y0=YSWET
      P=TSWET*CF*BTEMP/DELT
      YSWET=Y0+P*DELT
C--------------------------------------------------
C HAIR, NAILS, DESQUAMATED SKIN
      Y0=YHAIR
      P=S2HAIR*RSOF1*YSOF1W/DELT
      YHAIR=Y0+P*DELT
C--------------------------------------------------
C
      SIGMA=YPLAS+YRBC+YEVF+YSOF0+YSOF1+YSOF2+YBRAN
     $ +YCVOL+YTVOL+YCSUR+YTSUR+YCDIF+YTDIF+YKDNE+YBLAD+YLIVR
     $ +YR1+YR2+YR3+YR4+YSTMC+YSIC+YULIC+YLLIC
     $ +YURIN+YFECE+YSWET+YHAIR
      TBODY1=YPLAS+YRBC+YEVF+YSOF0+YSOF1+YSOF2+YBRAN
     $ +YCVOL+YTVOL+YCSUR+YTSUR+YCDIF+YTDIF+YKDNE+YLIVR
      TBODY2=TBODY1+YR1+YR2+YR3+YR4+YBLAD
     $ +YSTMC+YSIC+YULIC+YLLIC
      TOTEXC=YURIN+YFECE+YSWET+YHAIR
      YSKEL=YCVOL+YTVOL+YCSUR+YTSUR+YCDIF+YTDIF
      YTRAB=YTSUR+YTDIF+YTVOL
      YCORT=YCSUR+YCDIF+YCVOL
      YSOFT=YSOF0+YSOF1+YSOF2
      IF (TBODY1 .NE. 0.0) BONFRC=YSKEL/TBODY1
      IF (TBODY1 .NE. 0.0) BRNFRC=YBRAN/TBODY1
      IF (TBODY1 .NE. 0.0) HEPFRC=YLIVR/TBODY1
      IF (TBODY1 .NE. 0.0) BLDFRC=YBLUD/TBODY1
      IF (TBODY1 .NE. 0.0) RENFRC=YKDNE/TBODY1
      IF (TBODY1 .NE. 0.0) OTHFRC=YSOFT/TBODY1
      IF (YBLUD .NE. 0.0) PLSRBC=YPLAS/YBLUD
      IF (AMTBLD .NE. 0.0) BLCONC=YBLUD/AMTBLD
C      IF (RBCVOL .NE. 0.0) RBCONC=YRBC/(ADJRBC*AMTBLD) replaced by next line
      IF (RBCVOL .NE. 0.0) RBCONC=YRBC/(BLDHCT*AMTBLD)

      RENCON=YKDNE/KIDWT
      CRTCON=YCORT/CORTWT
      TRBCON=YTRAB/TRABWT
      ASHCON=YSKEL/TSKELWT
      CRTCONBM=CRTCON*1.8
      TRBCONBM=TRBCON*3.*1.8

      IF (N .GT. 1) CLEAR=(URIN/DELT)/YPLAS
      IF (N .GT. 1) BCLEAR=100.*(URIN/DELT)/YBLUD
      IF (YBLUD .NE. 0.0) PCENT=100.*YPLAS/YBLUD
      Q(1)=YPLAS
      Q(2)=YRBC
      Q(3)=YBLUD
      Q(4)=YSKEL
      Q(5)=YCORT
      Q(6)=YTRAB
      Q(7)=YLIVR
      Q(8)=YKDNE
      Q(9)=YSOFT
      Q(10)=YBRAN
      Q(11)=YURIN
      Q(12)=YFECE
      Q(13)=TBODY2
      Q(14)=TOTEXC
      Q(15)=BONFRC
      Q(16)=BRNFRC
      Q(17)=HEPFRC
      Q(18)=BLDFRC
      Q(19)=RENFRC
      Q(20)=OTHFRC
      Q(21)=BLCONC
      Q(22)=RBCONC
      Q(23)=RENCON
      Q(24)=CRTCON
      Q(25)=TRBCON
      Q(26)=ASHCON
      Q(27)=CLEAR
      Q(28)=BCLEAR
      Q(29)=PCENT
      Q(30)=YLUNG
      Q(31)=Q(28)*Q(3)/100.
      Q(32)=CRTCONBM
      Q(33)=TRBCONBM
      Q(34)=UPTAKEGI
      Q(35)=UPTAKERI
      Q(36)=UPTAKE
      IF (MOD(N,ISKIP) .NE. 0) GO TO 1000
C      WRITE(*,991)YEARS,SIGMA,Q(I1),Q(I2),Q(I3),Q(I4),Q(I5)
      WRITE(50,991)YEARS,SIGMA,Q(I1),Q(I2),Q(I3),Q(I4),Q(I5)
      IF (DAYS .GT. ENDDAY) GO TO 1001
  991 format(' ', 1p7e10.3)
 1000 CONTINUE
 1001 CONTINUE
      STOP
      END
C
      REAL FUNCTION INTACT(Y,P,X,D)
      DX=D*X
      IF (DX .GT. 50.0) GO TO 10
      INTACT=((1.0-DEXP(-DBLE(X*D)))/X)*(Y-(P/X))+P*D/X
      GO TO 20
 10   INTACT=(1.0/X)*(Y-P/X)+P*D/X
 20   CONTINUE
      RETURN
      END
C
      FUNCTION ACTVTY(Y,P,X,D)
      DX=D*X
      IF (DX .GT. 50.0) GO TO 10
      ACTVTY=(Y-(P/X))*DEXP(-DBLE(X*D))+P/X
      GO TO 20
 10   ACTVTY=P/X
 20   CONTINUE
      RETURN
      END
