

function getDocument(doc_short_name) {
	var full_url;
	if (doc_short_name == 'total_ownership') {
		full_url = 'https://acc.EPA.mil/simplify/ev.php?ID=1205_201&ID2=DO_TOPIC';
	}
	myPopm = window.open(full_url, "externalDoc","resizable=1,toolbar=1,location=1,screenX=0,screenY=0,directories=0,status=0,left=0,top=0,menubar=1,scrollbars=1,copyhistory=0,width=600,height=500");
	setTimeout('myPopm.focus();',250);
}

// hidden question popups
function activate (field_name) {
	helpwin = window.open("","Utopia2000_Help","resizable=1,toolbar=0,location=0,directories=0,status=1,menubar=0,scrollbars=1,copyhistory=0,width=450,height=300");
	helpwin.document.writeln(field_name);                   
	helpwin.document.close();
	helpwin.focus();
}
		
// Function called to determine navigation image shown
function RollOverGeneric (obj) {
	var bobj = "b" + obj;
    var temp = document.images[bobj];
	if (document.layers) {
		temp = document.layers[obj].document.images[bobj];
	} else if (document.all) {
		temp = document.images[bobj];
	}
	var imgpath = temp.src.split("/images_int/");
	if (temp.src.match('_rol') == '_rol') {
		if (temp.src.match('.gif') == '.gif') {
			temp.src = imgpath[0] + "/images_int/" + obj + "_en.gif";
		} else {
			temp.src = imgpath[0] + "/images_int/" + obj + "_en.jpg";
		}
	} else {
		if (temp.src.match('.gif') == '.gif') {
			temp.src = imgpath[0] + "/images_int/" + obj + "_rol.gif";
		} else {
			temp.src = imgpath[0] + "/images_int/" + obj + "_rol.jpg";
		}
	}
}

//--------------------------------------------------------------------
// Handle the next button on knowledge reviews (check on learning)
// only go forward if they have tried to answer the question
//
//	function kr_next() {
//		if outta tries, or they got it right (getting it right adds 100 onto curr_tries)
//  	if ( curr_tries >= num_tries ) {
//			if the next page is null (or .html) then we're likely at the end of the SCO
//			and we don't want to go to next, we wanna call getTOC and do what IT tells us to
//				if ( next == ".html" || next == "" ) {
//					getTOC( base_dir );
//				} else {
//					window.location = next;
//				}

function kr_next() {

      // if outta tries, or they got it right (getting it right adds 100 onto curr_tries)
      if (( curr_tries >= num_tries ) && (next)) {
            window.location = next;
      } else {
            alert( "You must first try to answer the question!" );
      }
}




//--------------------------------------------------------------------
// Submit DR
//
function idr() {
	TempWindow = window.open("",
	"CSC_TCE_iDR",
	"toolbar=0,location=0,directories=0,status=1,menubar=0,resizable=1,scrollbars=1,copyhistory=0,width=610,height=360");
	window.document.dr_form.target = "CSC_TCE_iDR";
	window.document.dr_form.page_url.value = document.location.href;
	//alert( document.location.href );
	window.document.dr_form.submit();
	TempWindow.focus();
}

//--------------------------------------------------------------------
// navigates to the remediation page (defined in the host html page)
// and closes the review window
//
function gotoRemediation( thisPage ) {

	window.opener.location = thisPage;
	window.self.close();
}

//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
//
function TE_check( distractor, base_dir ) {

	// initialize the default background color and text color
	// DO feel free to change these.
	var bgcolor 		= "#E0E7EF";	// light blue
	var txcolor 		= "#000000";	// black

	var content = "";	
	
	// increment now since it starts at zero
	// DO NOT change this.
	curr_tries++;	
	
	// if we're past the max number of tries do NOTHING
	if ( curr_tries > num_tries ) {
		// DO feel free to change this alert content.
		alert( "You have completed this question." );
		return false;
	}
	
	
	// Look for the right answer
	for ( var i=1; i<=te_MAX; i++ ) {
		
		//alert( "comparing " + distractor + " to " + possibility[i] );
		// Remove the .toLowerCase() if you want to make it case sensitive. 
		// Note that this will change sensitivity for ALL the questions in the course
		if ( possibility[i].toLowerCase() == distractor.toLowerCase() ) {
			
			//alert( "MATCH. Setting feedback to " + feedbkArray[i] + " and looking at answer " + answerArray[i] );
			content = feedbkArray[i];
			
			if ( answerArray[i] == 'true' ) {
				curr_tries += 100;
			} 
		} 
	}
	
	//  if no matches, then use the default miss value
	if ( content == "" ) {
	
		if ( curr_tries >= num_tries ) {
		//	alert( "outta tries. and still wrong" );
			content = final_feedback_incorrect;
		} else {
		//	alert( "Nomatch. Setting partial feedback\n" + partial_feedback );
			content = partial_feedback;
		}
	}

	// open the window
	// DO NOT change this.
	Question_Popup( distractor, content, bgcolor, txcolor, base_dir )
	
	return false;
}
//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
//
function MA_toggleChoice( number, id ) {
	
	var current = userArray[number];
	
	if ( current == 'true' ) {
		current = 'false';
	} else {
		current = 'true';
	}
	//alert( "Setting " + number + " to " + current );
	userArray[number] = current;
}

//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
//
function MA_check( base_dir ) {
	
	// initialize the default background color and text color
	// DO feel free to change these.
	var bgcolor 		= "#efefef";	// light blue
	var txcolor 		= "#000000";	// black
	
	// images are optional. Set them to empty strings if you don't want them
	// DO feel free to change the filename, width, height, alignment, border and alt tag.
	// DO NOT change the "base_dir" or "image_int" part of the src attribute. Thise are requried!
	var correct_image   = "<img src='" + base_dir + "/images_int/correct.gif'   width='32' height='32' align='left' border='0' alt='check-mark'>";
	var incorrect_image = "<img src='" + base_dir + "/images_int/incorrect.gif' width='32' height='32' align='left' border='0' alt='X mark'>";
	//  var review_image	= "<img src='" + base_dir + "/images_int/review.jpg' width='45' height='30' align='right' border='0' alt='Review'>";
	// uncomment this if you want no images
	// correct_image = "";
	// incorrect_iamge = "";	
	// review_image = "";
	// initialize content to null. Required.
	var content 		= "";
	
	// initialize review to null. Required.
	var review			= "";
	
	// The "remediation_page" variable created by Utopia2000 and stuck on the HTML page (if a remediation page was identified for the question)
	// DO NOT change the check
	// DO NOT change the JS call (should call 'gotoRemediation').
	// DO feel free to change the text in side the anchor tags. If you add an image, make sure it follows the image tag style for the correct/incorrect imges
	//    that means it uses base_dir and images_int.
	// DO feel free to change the leading <br> Tag with something else, like a <p> tag.
	if ( remediation_page ) {
		review = "<p><a href='javascript:gotoRemediation(\""+ remediation_page + "\")'>Review material for this question.</a></p>";
	}
	
	// increment now since it starts at zero
	// DO NOT change this.
	curr_tries++;	
	
	// if we're past the max number of tries do NOTHING
	// DO NOT change this.
	if ( curr_tries > num_tries ) {
		alert( "You have completed this question." );
		return;
	}
	
	// init the score to 0 (only for multiple answer)
	// DO NOT change this.
	var score = 0;
	for ( var i=1; i<num_questions+1; i++ ) {
	
		//alert ("[ " + i + "] Comparing answer " + answerArray[i] + " to " +  userArray[i] );
	
		if ( answerArray[i] == userArray[i] ) {
			score++;
		}
	}
	//alert( score + " out of " + num_questions );
	
	// they got it right!
	if ( score == num_questions ) {		
		// max out num tries to end question
		// but do it so we can figure out how many tries it took!
		// DO NOT change this.
		curr_tries += 100;
		
		// make the content equal to the image and the final correct feedback
		// DO NOT change this. (if you don't want an image, set the variable to null at the top of the function.
		content = correct_image + final_feedback_correct;		
	
	// they got it wrong :(	
	} else {	
		// change background color to red
		// DO feel free to change the colors here if want to
		//bgcolor = "#ff8888";	// light red
		//txcolor = "#000000";	// black
	
		// make the content equal to the image and the partial feedback
		// DO NOT change this. (if you don't want an image, set the variable to null at the top of the function.
		content = incorrect_image + partial_feedback;
	
		// if we're outta tries, they get the final feedback
		if ( curr_tries == num_tries ) {
			// make the content equal to the image and the final incorrect feedback
			// DO NOT change this. (if you don't want an image, set the variable to null at the top of the function.
			content = incorrect_image + final_feedback_incorrect + review;
		
		}
	}
	
	// DO feel free to change the distractor style. This sits at the top of the screen in a bolder font (usually)
		// with 4 out of 5 as the title
		// distractor = score + " out of " +  num_questions;
		
		// without any title
		distractor = "";
	
	// open the window
	Question_Popup( distractor, content, bgcolor, txcolor, base_dir );
}

//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
//
function MC_check( content, distractor, code, base_dir ) {
	
	// initialize the default background color and text color
	// DO feel free to change these.
	var bgcolor 		= "#E0E7EF";	// light blue
	var txcolor 		= "#000000";	// black
	
	// images are optional. Set them to empty strings if you don't want them
	// DO feel free to change the filename, width, height, alignment, border and alt tag.
	// DO NOT change the "base_dir" or "image_int" part of the src attribute. Thise are requried!
	var correct_image   = "<img src='" + base_dir + "/images_int/correct.gif'   width='32' height='32' align='left' border='0' alt='check-mark'>";
	var incorrect_image = "<img src='" + base_dir + "/images_int/incorrect.gif' width='32' height='32' align='left' border='0' alt='X mark'>";
	
	// uncomment this if you want no images
	// correct_image = "";
	// incorrect_iamge = "";	
	
	// initialize review to null. Required.
	var review			= "";
	
	// The "remediation_page" variable created by Utopia2000 and stuck on the HTML page (if a remediation page was identified for the question)
	// DO NOT change the check
	// DO NOT change the JS call (should call 'gotoRemediation').
	// DO feel free to change the text in side the anchor tags. If you add an image, make sure it follows the image tag style for the correct/incorrect imges
	//    that means it uses base_dir and images_int.
	// DO feel free to change the leading <br> Tag with something else, like a <p> tag.
	//if ( remediation_page ) {
		//review			= "<br><a href='javascript:gotoRemediation(\""+ remediation_page + "\")'>Review material for this question.</a>";
	//}
	
		if ( remediation_page ) {
		review = "<p><a href='javascript:gotoRemediation(\""+ remediation_page + "\")'> <img src='" + base_dir + "/images_int/review.jpg'width='91' height='35'  border='0' align='left' alt='Review'></a></p>";
	}
	
	// increment now since it starts at zero
	// DO NOT change this.
	curr_tries++;	
	
	// if we're past the max number of tries do NOTHING
	if ( curr_tries > num_tries ) {
		// DO feel free to change this alert content.
		alert( "You have completed this question." );
		return;
	}
	
	if ( code == 'true' || code == 't' ) {
	
		// max out num tries to end question
		// but do it so we can figure out how many tries it took!
		// DO NOT change this.
		curr_tries += 100;
		
		// make the content equal to the image and the original content (unique feedback for each question)
		// DO NOT change this. (if you don't want an image, set the variable to null at the top of the function.
		// DO feel free to change the <p> tag to null, or something else.
		content = "<p>" + correct_image + content;
	
		// without question answer echoed
		// DO feel free to hard code an additional, permanent distractor (title) here
		distractor = "";
				
	} else {
		// assume they got it wrong
		
		// change background color to red
		// DO feel free to change the background colors (here, only for incorrect responses)
		//bgcolor 		= "#ff8888";	// light red
		//txcolor 		= "#000000";	// black
		
		// with question answer echoed
		// DO feel free to hard code an additional, permanent distractor (title) here
		// distractor += " is incorrect.";
	
		// without question answer echoed
		// DO feel free to hard code an additional, permanent distractor (title) here
		distractor = "";
	
		if ( curr_tries == num_tries ) {
			// make the content equal to the image and the final incorrect feedback.
			// if review is active, it will be added here. otherwise it defaulted to null and will cause no problems.
			// DO NOT change this. (if you don't want an image, set the variable to null at the top of the function.)
			// DO feel free to change the <p> tag to null, or something else.
			content = "<p>" + incorrect_image + final_feedback_incorrect + review;
		}
		if ( curr_tries < num_tries ) {
			// make the content equal to the image and the partial feedback
			// DO NOT change this. (if you don't want an image, set the variable to null at the top of the function.)
			// DO feel free to change the <p> tag to null, or something else.
			// DO feel free to add additional hard coded messages ( like "try again") to the null string between incorrect_image and content
			content = "<p>" + incorrect_image + "" + content;
		} 
	}
	
	
	// open the window
	// DO NOT change this.
	Question_Popup( distractor, content, bgcolor, txcolor, base_dir )
}


//--------------------------------------------------------------------
// DO feel free to change the close text. You may also add an image if you wish. 
function get_print( this_base_dir ) {

	// if no value, snag the global base_dir variable on the page
	if ( this_base_dir == null || this_base_dir == "undefined" ) {
		this_base_dir = base_dir;
	}

	// text based close window
	//return "Close Window"
	
	
	// image based (comment out text based if you uncomment this one)
	// DO adjust the filename, width, height, alt, border and alignment for your needs.
	// DO NOT remove the base_dir or images_int part.
	return "<img src='" + this_base_dir + "/images_int/print_en.gif' width='36' height='20' align='right' border='0' alt='Print'>"; 
}

//--------------------------------------------------------------------
// DO feel free to change the close text. You may also add an image if you wish. 
function get_close( this_base_dir ) {

	// if no value, snag the global base_dir variable on the page
	if ( this_base_dir == null || this_base_dir == "undefined" ) {
		this_base_dir = base_dir;
	}

	// text based close window
	//return "Close Window"
	
	
	// image based (comment out text based if you uncomment this one)
	// DO adjust the filename, width, height, alt, border and alignment for your needs.
	// DO NOT remove the base_dir or images_int part.
	return "<img src='" + this_base_dir + "/images_int/close_en.gif' width='41' height='20' align='right' border='0' alt='Close'>"; 
 
}



//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
//
function Question_Popup( distractor, content, bgcolor, txcolor, base_dir ) {	
	
	var bgimage       = "images_int/popup_background.jpg";
	var my_width      = 375;
	var my_height     = 250;
	var my_scrollbars = 1;
	var CLOSE         = get_close( base_dir );

	w = window.open(	"", 
						"questionResponse", 
						"resizable=0,toolbar=0,location=0,directories=0,status=1,menubar=0,scrollbars=" + my_scrollbars + ",copyhistory=0,width=" + my_width + ",height=" + my_height);
	w.document.open();
	w.document.writeln("<html><head><title>Question Response</title>");
	w.document.writeln("<script type='text/javascript'>function gotoRemediation( thisPage ) { window.opener.location = thisPage; window.self.close(); }</script>");
	w.document.writeln("<link rel='stylesheet' type='text/css' href='" + base_dir + "/PopupQuestion.css'> ");
	w.document.writeln("</head><body>");
	w.document.writeln("<div class='word'>Knowledge Review Feedback</div>");
	w.document.writeln("<div class='def' ><p>" + content + "</p><p><a href='javascript:self.close()'>" + CLOSE + "</a></p></div></body></html>");//This line was changed
	w.document.close();
	w.focus();
}

//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
//
function glossaryPopUp( word, definition, base_dir ) {

	// set up some constants
	// how editable!
	var bgcolor 		= "#FFF";	
	var bgimage		= "images_int/glossary_popup.jpg";
	var my_width  		= 375;
	var my_height 		= 150;
	var my_scrollbars  	= 1;
	var CLOSE 		= get_close( base_dir );
	
	// open the window
	w = window.open(	"", 
						"glossaryWindow", 
						"resizable=1,toolbar=0,location=0,directories=0,status=1,menubar=0,scrollbars=" + my_scrollbars + ",copyhistory=0,width=" + my_width + ",height=" + my_height);
	
	// write to it
	w.document.open();
	w.document.writeln("<html><head><title>Definition: " + word + "</title>");
	
	// if there is a base_dir, try to use a background image ON TOP OF a solid color
	// this will cause no error if the image doesn't exist
	// if no base_dir, then just use a solid color.
	if ( base_dir ) {
		w.document.writeln("<style>body  {background-color: "+ bgcolor + "; background-image: url('" + base_dir + "/" +  bgimage + "'); background-repeat: repeat-x;}");
	} else {
		w.document.writeln("<style>body  {background-color: "+ bgcolor + ";}");		
	}
	w.document.writeln("       .word {font-family: Tahoma, Arial, Helvetica, sans-serif; font-size: 12pt; font-weight: bold;  padding-left:0.25em; background-color: 2e6ba2; color: #FFFFFF;}");
	w.document.writeln("       .def  {font-family: Arial, Helvetica, sans-serif; font-size: 10pt; font-weight: normal; color: #000000;}");
	w.document.writeln("</style></head><body>");
	w.document.writeln("<div class='word'>" + word       + "</div>");	
	w.document.writeln("<div class='def' ><p>" + definition + "</p><p><a href='javascript:self.close()'>" + CLOSE + "</a></p></div></body></html>");
	w.document.close();
	w.focus();
}

//w.document.writeln("<div class='word'><p>Glossary Term</p></div>");	


//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
//
function ImagePopUp( content, alt_tag, base_dir ) {

	genericPopUp( alt_tag, content, base_dir )
}

//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
//
function genericPopUp( word, definition, base_dir ) {

	var course_short_name	= (course_short_name);
	var my_width  		= 375;
	var my_height 		= 275;
	var my_scrollbars  	= 1;
	var CLOSE     = get_close( base_dir );
	var PRINT 		= get_print( base_dir );
	
	w = window.open(	"", 
						"genericWindow", 
						"resizable=1,toolbar=0,location=0,directories=0,status=1,menubar=0,scrollbars=" + my_scrollbars + ",copyhistory=0,width=" + my_width + ",height=" + my_height);
	w.document.open();
	w.document.writeln("<html><head><title>Term: " + word + "</title>");
	w.document.writeln("<link rel='stylesheet' type='text/css' href='" + base_dir + "/PopupGeneric.css'> ");
	w.document.writeln("</head><body>");
	w.document.writeln("<div class='word'>" + word       + "</div>");	
	w.document.writeln("<div class='def' ><p>" + definition + "</p><p><a href='javascript:self.close()'>" + CLOSE + "</a><a href='javascript:window.print()'>" + PRINT + "</a></p></div></body></html>");
	w.document.close();
	w.focus();
}

//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
//
function objectPopUp( object_uri, width, height, description, longdesc, base_dir ) {	
	
	var widthOffset  = 25;
	var heightOffset = 65;
	
	// set up some constants
	// how editable!
	var bgcolor 		= "#CCCCCC";	
	var my_width  		= parseInt(width)  + widthOffset;
	var my_height 		= parseInt(height) + heightOffset;
	var my_scrollbars  	= 1;
	var CLOSE 		= get_close( base_dir );
	
	if ( width > widthOffset && height > heightOffset ) {
		type = "image";
		size = ",width=" + my_width + ",height=" + my_height;
	} else {
		type = "file";
		size = "";
	}
	
	// open the window
	w = window.open(	"", 
						"graphicWindow", 
						"resizable=1,toolbar=0,location=0,directories=0,status=1,menubar=0,scrollbars=" + my_scrollbars + ",copyhistory=0" + size);
	
	if ( type =="image" ) {
	
		// write to it
		w.document.open();
		w.document.writeln("<html><head><title>Graphic Popup</title>");
		w.document.writeln("<style>body  {background-color: "+ bgcolor + ";}");		
		w.document.writeln("       .def  {font-family: Arial, Helvetica, sans-serif; font-size: 10pt; font-weight: normal; color: #000000;}");
		w.document.writeln("</style></head><body>");
		w.document.writeln("<div class='def' ><p><img src='" + object_uri + "' width='"+ width + "' height='"+ height + "' alt='"+ description + "' border='0'>");
	//	w.document.writeln("<a href='#' onClick=\"genericPopUp('long description for " + object_uri + "', '"+ longdesc + "')\">D</a>");
		w.document.writeln("</p><p><a href='javascript:self.close()'>" + CLOSE + "</a></p></div></body></html>");
		w.document.close();
	
	} else {
	
		// if no width/height, just navigate to the object
		w.location = object_uri;	
	}
	
	// bring it to the front
	w.focus();
}

//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
// DEPRECATED - use objectPopUp instead
//
function popupObject( my_filename, base_dir ) {

	var my_width  = 750;
	var my_height = 510;
	var my_scrollbars  	= 1;
	
	// open the window
	w = window.open(	my_filename, 
						"graphicWindow", 
						"resizable=1,toolbar=0,location=0,directories=0,status=1,menubar=0,scrollbars=" + my_scrollbars + ",copyhistory=0,width=" + my_width + ",height=" + my_height);
	
	// bring it to the front
	w.focus();
}


//------------------------------Revised open window for 52D10 11 29 rob m
function openmenu(){
 windowNavi = window.open("wla_map.html","popup","toolbar=no,width=260,height=465,menubar=no,status=no,scrollbars=yes,resizable=no");
 windowNavi.moveTo(((screen.width/2)-389),((screen.height/2)-265))
windowNavi.focus();

 //--------- 	  window.open('indexmap.html', 'popup')
		 
}
 
function prevWin(page){
				if(opener && !opener.closed){
					opener.document.location =  page;
				}
			}
 
//------------------------------Revised open window for 52D10 11 29 rob m
function openRefs(myurl){
   windowNavi = window.open(myurl,"EPArefs","toolbar=no,width=520,height=610,menubar=no,status=yes,scrollbars=yes,resizable=yes");
   windowNavi.moveTo(((screen.width/2)-389),((screen.height/2)-265))
   windowNavi.location = myurl;
   windowNavi.focus();
}

//------------------------------Revised open window 12 30 tom s
function open800(myurl){
   windowNavi = window.open(myurl,"EPA","toolbar=no,width=800,height=610,menubar=no,status=yes,scrollbars=yes,resizable=yes");
   windowNavi.moveTo(((screen.width/2)-389),((screen.height/2)-265))
   windowNavi.location = myurl;
   windowNavi.focus();
}

//------------------------------Revised open window for 52D10 11 29 rob m
function openCenter2(myurl){
   windowNavi = window.open(myurl,"EPA","toolbar=no,width=520,height=310,menubar=yes,status=yes,scrollbars=yes,resizable=yes");
   windowNavi.moveTo(((screen.width/2)-389),((screen.height/2)-265))
   windowNavi.location = myurl;
   windowNavi.focus();
}


//------------------------------Revised open window for 52D10 11 29 rob m
function newpopup(myurl){      
   windowNavi = window.open(myurl,"EPApop","toolbar=no,width=550,height=650,menubar=no,status=yes,scrollbars=auto,resizable=yes");
   windowNavi.moveTo(((screen.width/2)-389),((screen.height/2)-265))
   windowNavi.location = myurl;
   windowNavi.focus();
}


// Allnew here down 7-21


function openWindowCenter(filename, my_width, my_height) {
 myX=355-(my_width/2);
 myY=300-(my_height/2);
    myWin = window.open(filename, "displayWindow","resizable=1,toolbar=0,location=0,screenX=" + myX + " screenY=" + myY + " directories=0,status=0,left=" + myX + ",top=" + myY + ",menubar=0,scrollbars=1,copyhistory=0,width=" + my_width + ",height=" + my_height);
	
	setTimeout('myWin.focus();',250);
} 

function openWindowCustom(filename, my_width, my_height) {
    myWin = window.open(filename, "displayWindow","resizable=1,toolbar=0,location=0,screenX=0,screenY=0,directories=0,status=0,left=0,top=0,menubar=0,scrollbars=1,copyhistory=0,width=" + my_width + ",height=" + my_height);
	setTimeout('myWin.focus();',250);
} 

function openWindow(filename, my_width, my_height) {
    myWin = window.open(filename, "displayWindow","resizable=1,toolbar=0,location=0,screenX=0,screenY=0,directories=0,status=1,left=0,top=0,menubar=1,scrollbars=1,copyhistory=0,width=" + my_width + ",height=" + my_height);
	setTimeout('myWin.focus();',250);
} 

//function showText(path_depth,narr) {
// if narration on a page, create a showText pop-up window
	// set up some constants
	//if (!path_depth) {
	// path_depth = "";
	//}
	//var bgcolor = "#EFEFEF";
	//var narrate;
	//narrate = narrnotes;
	//w = window.open("", "showtextWin", "toolbar=0,location=0,left=0,top=0,screenX=0,screenY=0,directories=0,status=0,menubar=0,scrollbars=1,copyhistory=0,width=375,height=250, resizable=1" );

	//setTimeout('w.focus();',1000);
 	//w.document.open();
	//setTimeout('w.focus();',1000);
 	//w.document.writeln("<html><head><title>Narration Text </title>");
	//w.document.writeln("<script type=\"text/javascript\">");
	//w.document.writeln("function findParent( repeat ) {	if ( opener && repeat ) { opener.showText( '../../'); } }");
	//w.document.writeln("</script>");
	//w.document.writeln("<style>body  {background-color: " + bgcolor + "; background-image: url('" + path_depth + "images_int/showtext_popup.gif');  background-repeat: no-repeat;}");
	
	//w.document.writeln("       .word {font-family: Arial, Helvetica, sans-serif; font-size: 12pt; font-weight: bold;   color: #000000;}");
	//w.document.writeln("       .nar  {font-family: verdana, arial, serif; font-size: 10pt; font-weight: normal; color: #000000;}");
	//w.document.writeln("</style></head><body>");
	//w.document.writeln("<div class='word'><p>Narration</p></div>");	
    //w.document.writeln("<div id='narText' class='nar'>" + narrate + "<br /><br /></div>");
   // w.document.writeln("<div><a href='javascript: window.close()'><img src='" + path_depth + "images_int/close_en.gif' border='0' alt='Close' align='right'  width='41' height='20'></a><a href='javascript:window.print()'><img src='" + path_depth + "images_int/print_en.gif' border='0' alt='Print' align='right' width='70' height='25'></a><br /></div></body></html>");
   // w.document.close();
   // w.focus();
//}


//------------------------------Revised open window for print sco rob m
function openPrintSco(myurl){
      
	
   windowNavi = window.open(myurl,"EPA","toolbar=no,width=785,height=600,menubar=yes,status=yes,scrollbars=yes,resizable=yes");
   windowNavi.moveTo(((screen.width/2)-400),((screen.height/2)-300))
   windowNavi.location = myurl;
   windowNavi.focus();
}

function findParent( repeat ) {
	if ( opener && repeat ) {
		opener.showText( '../../' );
		window.focus()
		w = window;
	}	
}

function leaving() {
	//alert("Opener is changing: " + w);
	if ( w ) {
		w.setTimeout("findParent(1)", 1000 );
	}
}


//------------------------------Revised open window for 52D10 11 29 rob m
function openProcs(myurl){
      
   windowNavi = window.open(myurl,"EPA","toolbar=no,width=760,height=300,menubar=no,status=yes,scrollbars=yes,resizable=yes");
   windowNavi.moveTo(((screen.width/2)-389),((screen.height/2)-265))
   windowNavi.location = myurl;
   windowNavi.focus();
}


//-----------------------------------------------------------------------------------------------------------------------------------
//New Audio and 508 JS
//-----------------------------------------------------------------------------------------------------------------------------------


//--------------------------------------------------------------------
// captures a keyStroke and changes url location to the corresponding 
// location provided in an array on the template
//
function getKey(keyStroke) {

	if (document.getElementById) {
		eventChooser = event.keyCode;
	}
	if (document.layers&&!document.getElementById) {
		eventChooser =keyStroke.which;
	}
	if (document.all&&!document.getElementById) {
		eventChooser = event.keyCode;
	}
//	isNetscape=((document.layers)||(document.getElementById&&!document.all));
	// Cross-browser key capture routine
//	eventChooser = (isNetscape) ? keyStroke.which : event.keyCode;
	which = String.fromCharCode(eventChooser).toLowerCase();
	for (var i in key) {
		if (which == i) {
			if (key[i].match('javascript') == 'javascript') {
				window.location = key[i];
			} else if (key[i] != '') {
				window.location = key[i] + '.html';
			}
		}
	}
}

function scroll( column_id ) {
	var colUpPos = -50;
	var colDownPos = 0;
	if ( document.layers ) {
		var thisColumn = document.layers[column_id];
		var thisTop    = thisColumn.top;
	}
	if ( document.all ) {
		var thisColumn = document.all[column_id].style;
		var thisTop    = thisColumn.posTop;  // IE likes to read this value better than just TOP
	}
//	alert("a:"+thisTop+" b:"+thisColumn.top);
	if ((thisTop != colDownPos) || (thisColumn.top == '')) {
		thisColumn.top = colDownPos;
	} else {
		thisColumn.top = colUpPos;
	}
}

/*
//----------------------------------------------------
var moviename   = "theMovie";
var movie_ready = "false";
*/
//----------------------------------------------------
// Flash requires this to pass commands. Do not change the name!
// You can add additional "if/else" lines to expand
// the commands. You can make up commands and arguments
// but Flash must pass them using the FSCommand thingy.
function theMovie_DoFSCommand( command, args ) {
	if ( command == "trigger" ) {
		Show( args );
	} else if ( command == "reset" ) {
		Reset( args );
	}
}

//----------------------------------------------------
// Find the movie object.
function movieobject( moviename ) {
	if ( document.all ) {
		return document.all[moviename];
	} else if ( document.layers ) {
		if (movieDiv) {
			return document.layers[movieDiv].document.embeds[moviename];
		} else {
			return document.embeds[moviename];
		}
	} else if ( document.getElementById&&!document.all) {
		return (document.getElementsByName(moviename));
	}
}

//----------------------------------------------------
// Tell the Flash movie to play
function playmovie() {
	var this_object = movieobject( moviename );
	var myMovieName = "playMe('" + moviename + "')"; // added to use with timeout
	// make sure the movie is loaded until we try to play it.
	if ( movie_ready == "false" ) {
		// loop until the movie IS ready
		while ( movie_ready == "false" ) {
			if ( this_object.PercentLoaded() == 100 ) {
				setTimeout(myMovieName,50);  // added timout so audio would play
				//this_object.Play();
				movie_ready = "true";
			}
		}
	} else {
		setTimeout(myMovieName,50);  // added timout so audio would play
		//this_object.Play();
	}
}

//ADT added this function to use with a timeout -- sometimes the audio
// would not play -- the timeout seems to fix that problem
function playMe(moviename) {
	movieobject(moviename).Play();
}

//----------------------------------------------------
// Tell the Flash movie to stop
function stopmovie() {
	movieobject( moviename ).StopPlay();
}

//----------------------------------------------------
// Tell the Flash movie to rewind and play
function replaymovie() {
//	movieobject( moviename ).GotoFrame(1);
	movieobject( moviename ).Rewind();
	playmovie();
}



//-----------------------------------------------------------------------------------------------------------------------------------
//Custom Functions for this course
//-----------------------------------------------------------------------------------------------------------------------------------

function check_m2aq100(qform) {
            if((qform.ans1.value == "") || (qform.ans2.value == "") || (qform.ans3.value == ""))
            {
                  alert("A question has been left unanswered. All questions must be completed.");
                  return false;
            }

      parent.tryCtr++;
      if ( (qform.ans1.value.toLowerCase() == 'c' ) && (qform.ans2.value.toLowerCase() == 'b' ) && (qform.ans3.value.toLowerCase()== 'a' )  ) {
            MT_check(base_dir, 'correct');           // correct
      } else {
            if (curr_tries < num_tries) {
                  if ( (qform.ans1.value.toLowerCase() == 'c' ) || (qform.ans2.value.toLowerCase() == 'b' ) || (qform.ans3.value.toLowerCase()== 'a' )   ) {
                                     // partially correct
                        MT_check(base_dir, 'partial');
                  } else {
                        MT_check(base_dir, 'tryagain');
                  }
            } else {
                  MT_check(base_dir, 'incorrect'); // incorrect. here's correct info
            }
      }
}

function check_m2q25(qform) {
            if((qform.ans1.value == "") || (qform.ans2.value == "") || (qform.ans3.value == ""))
            {
                  alert("A question has been left unanswered. All questions must be completed.");
                  return false;
            }

      parent.tryCtr++;
      if ( (qform.ans1.value.toLowerCase() == 'b' ) && (qform.ans2.value.toLowerCase() == 'c' ) && (qform.ans3.value.toLowerCase() == 'a' )  ) {
            MT_check(base_dir, 'correct');           // correct
      } else {
            if (curr_tries < num_tries) {
                  if ( (qform.ans1.value.toLowerCase() == 'b' ) || (qform.ans2.value.toLowerCase() == 'c' ) || (qform.ans3.value.toLowerCase()== 'a' )   ) {
                                     // partially correct
                        MT_check(base_dir, 'partial');
                  } else {
                        MT_check(base_dir, 'tryagain');
                  }
            } else {
                  MT_check(base_dir, 'incorrect'); // incorrect. here's correct info
            }
      }
}

function check_m2q210(qform) {
            if((qform.ans1.value == "") || (qform.ans2.value == "") ||(qform.ans3.value == "") || (qform.ans4.value == ""))
            {
                  alert("A question has been left unanswered. All questions must be completed.");
                  return false;
            }

      parent.tryCtr++;
      if ( (qform.ans1.value.toLowerCase() == 'a' ) && (qform.ans2.value.toLowerCase() == 'b' ) && (qform.ans3.value.toLowerCase() == 'd' ) && (qform.ans4.value.toLowerCase()== 'c' ) ) {
            MT_check(base_dir, 'correct');           // correct
      } else {
            if (curr_tries < num_tries) {
                  if ( (qform.ans1.value.toLowerCase() == 'a' ) || (qform.ans2.value.toLowerCase() == 'b' ) || (qform.ans3.value.toLowerCase() == 'd' ) || (qform.ans3.value.toLowerCase()== 'c' )   ) {
                                     // partially correct
                        MT_check(base_dir, 'partial');
                  } else {
                        MT_check(base_dir, 'tryagain');
                  }
            } else {
                  MT_check(base_dir, 'incorrect'); // incorrect. here's correct info
            }
      }
}


function check_m4q133(qform) {
            if((qform.ans1.value == "") || (qform.ans2.value == "") || (qform.ans3.value == ""))
            {
                  alert("A question has been left unanswered. All questions must be completed.");
                  return false;
            }

      parent.tryCtr++;
      if ( (qform.ans1.value.toLowerCase() == 'b' ) &&
(qform.ans2.value.toLowerCase() == 'a' ) && (qform.ans3.value.toLowerCase() == 'c' )  ) {
            MT_check(base_dir, 'correct');           // correct
      } else {
            if (curr_tries < num_tries) {
                  if ( (qform.ans1.value.toLowerCase() == 'b' ) || (qform.ans2.value.toLowerCase() == 'a' ) || (qform.ans3.value.toLowerCase() == 'c' )   ) {
                                     // partially correct
                        MT_check(base_dir, 'partial');
                  } else {
                        MT_check(base_dir, 'tryagain');
                  }
            } else {
                  MT_check(base_dir, 'incorrect'); // incorrect. here's correct info
            }
      }
}

function check_m4q170(qform) {
            if((qform.ans1.value == "") || (qform.ans2.value == "") || (qform.ans3.value == "")|| (qform.ans4.value == ""))
            {
                  alert("A question has been left unanswered. All questions must be completed.");
                  return false;
            }

      parent.tryCtr++;
      if ( (qform.ans1.value.toLowerCase() == 'c' ) && (qform.ans2.value.toLowerCase()== 'a' ) && (qform.ans3.value.toLowerCase() == 'd' ) && (qform.ans4.value.toLowerCase() == 'b' ) ) {
	               MT_check(base_dir, 'correct');           // correct
      } else {
            if (curr_tries < num_tries) {
                  if ( (qform.ans1.value.toLowerCase() == 'c' ) ||
(qform.ans2.value.toLowerCase() == 'a' ) || (qform.ans3.value.toLowerCase()== 'd' ) || (qform.ans4.value.toLowerCase()== 'b' )) {
                                     // partially correct
                        MT_check(base_dir, 'partial');
                  } else {
                        MT_check(base_dir, 'tryagain');
                  }
            } else {
                  MT_check(base_dir, 'incorrect'); // incorrect. here's correct info
            }
      }
}


function check_m4q140 (qform) {
            if((qform.ans1.value == "") || (qform.ans2.value == "") ||(qform.ans3.value == ""))
            {
                  alert("A question has been left unanswered. All questions must be completed.");
                  return false;
            }

      parent.tryCtr++;
      if ( (qform.ans1.value.toLowerCase() == 'c' ) &&(qform.ans2.value.toLowerCase() == 'a' ) && (qform.ans3.value.toLowerCase()== 'b' )  ) {
            MT_check(base_dir, 'correct');           // correct
      } else {
            if (curr_tries < num_tries) {
                  if ( (qform.ans1.value.toLowerCase() == 'c' ) ||(qform.ans2.value.toLowerCase() == 'a' ) || (qform.ans3.value.toLowerCase()== 'b' )   ) {
                                     // partially correct
                        MT_check(base_dir, 'partial');
                  } else {
                        MT_check(base_dir, 'tryagain');
                  }
            } else {
                  MT_check(base_dir, 'incorrect'); // incorrect. here's correct info
            }
      }
}

// Edited 10/21/2004 by Sean Walsh.  Added various code within existing functions
// to handle the user hitting the submit button without actually choosing an answer.
// All added code is commented with this date.


//--------------------------------------------------------------------
var youcorrect		= "Correct! ";
var youwrong	 	= "Incorrect. ";
var tryagain		= "Try again. ";
var shouldhave		= "<p>The correct reponses are: <br />"; 
var goreview0		= "<p>If you wish to review this material, click <b>Review</b>.";
var goreview1		= "<p>Before continuing in the course, it is recommended that you review all relevant material in this lesson. ";
var goreview2		= "<p>Before continuing in the course, it is recommended that you review this material by clicking <b>Review</b>. ";
var choicewarn		= "You need to answer the question to continue."
var g_blnAttempted  = false;	//SW - 10/21/2004

//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
//
function MC_toggleChoice( number, base_dir) {


	 
	g_blnAttempted = true;	//SW--10/21/2004
	// set all the others to false.
	for (var i=1; i<userArray.length; i++ ) {
		userArray[i] = 'false';
		//alert( "Setting " + i + " to false" );
	}	
	
	//alert( "Setting " + number + " to true" );
	userArray[number] = 'true';
	
}


//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
//
function MC_toggleChoiceGraphic( number, imageId, base_dir) {

	var inlineImage = "inlineImage";
	var re = new RegExp(/^inlineImage/)

	var selectedImage = document.getElementById( inlineImage + imageId );
	
	var allImages = document.getElementsByTagName( "img" );

	// clear all the borders
	for (var i=0; i<allImages.length; i++ ) {
		//userArray[i] = 'false';
		//alert( "Setting " + i + " to false" );
		
		if ( allImages[i].id.match(re) ) {
			allImages[i].border = 0;		
		}
	}	
	
	selectedImage.border = 2;
	selectedImage.border.color = "black";
	
	// then call the regular toggle choice
	MC_toggleChoice( number, base_dir )
}

//--------------------------------------------------------------------
// open a new window with the text that was passed in as a parameter
//
function MC_check2( base_dir ) {
	
	// initialize the default background color and text color
	// DO feel free to change these.
	var bgcolor 		= "#EFEFEF";	// light gray
	var txcolor 		= "#000000";	// black
	var content 		= "";	
	
	// images are optional. Set them to empty strings if you don't want them
	// DO feel free to change the filename, width, height, alignment, border and alt tag.
	// DO NOT change the "base_dir" or "image_int" part of the src attribute. Thise are requried!
	var correct_image   = "<img src='" + base_dir + "/images_int/correct.gif'   width='32' height='32' align='left' border='0' alt='check-mark',>";
	var incorrect_image = "<img src='" + base_dir + "/images_int/incorrect.gif' width='32' height='32' align='left' border='0' alt='X-mark'>";
	
	// uncomment this if you want no images
	// correct_image = "";
	// incorrect_iamge = "";	
	
	// initialize review to null. Required.
	var review			= "";
	
	// The "remediation_page" variable created by Utopia2000 and stuck on the HTML page (if a remediation page was identified for the question)
	// DO NOT change the check
	// DO NOT change the JS call (should call 'gotoRemediation').
	// DO feel free to change the text in side the anchor tags. If you add an image, make sure it follows the image tag style for the correct/incorrect imges
	//    that means it uses base_dir and images_int.
	// DO feel free to change the leading <br> Tag with something else, like a <p> tag.
	if ( remediation_page ) {
		review			= "<br><a href='javascript:gotoRemediation(\""+ remediation_page + "\")'>Review material for this question.</a>";
	}
	

	// Edit: 10/21/2004 -- Sean Walsh
	// Add check to make sure the user attempts
	// the question before submitting.
	if ( !g_blnAttempted ){
		alert(choicewarn);
		return;
	}

	// increment now since it starts at zero
	// DO NOT change this.
	curr_tries++;	
	//alert( "user has tried this question " + curr_tries + " times." );
	
	// if we're past the max number of tries do NOTHING
	if ( curr_tries > num_tries ) {
		// DO feel free to change this alert content.
		alert( "You have completed this question." );
		return;
	}
	
	
	// init the number of the user choice
	var userSelection = "";
	
	// init the score to 0 (only for multiple answer)
	// DO NOT change this.
	var score     = 0;
	var score_max = 0;
	for ( var j=1; j<userArray.length; j++ ) {
		
		if ( userArray[j] == 'true' ) { userSelection = j; };	
		
		/* this method of matching TRUE = TRUE doesn't work in Multiple Choice
		   that have multiple correct answers, which is possible and allowed
		   so go back to ANY true marks it as true.
	
		score_max++;
	
			
		  
		// score gets incremented for every match (FALSE == FALSE, TRUE == TRUE)
		if ( answerArray[j] == userArray[j] ) {
			score++;
		}
		*/
		  
		// answer is true, then increment score (can be multiple trues)
		if ( userArray[j] == 'true' && answerArray[j] == userArray[j]) {
			score++;
		}
		
		//alert( j + " comparing " + answerArray[j] + " to " +  userArray[j] + "\n" + score );	
	}
	

	//alert( "score " + score + " of " + score_max + "\nthe user selected " + userSelection );
	
	// score gets incremented for every match (FALSE == FALSE, TRUE == TRUE)
	// so if the score == score_max then they got them all right
	//if ( score == score_max ) {
	
	// any score is a pass for multiple choice (can be multiple trues thsi way)		
	if ( score > 0 ) {
	
		// max out num tries to end question
		// but do it so we can figure out how many tries it took!
		// DO NOT change this.
		curr_tries += 100;
		
		// make the content equal to the image and the original content (unique feedback for each question)
		// DO NOT change this. (if you don't want an image, set the variable to null at the top of the function.
		// DO feel free to change the <p> tag to null, or something else.
		content = "<p>" + correct_image + feedbkArray[userSelection];
	
		// without question answer echoed
		// DO feel free to hard code an additional, permanent distractor (title) here
		distractor = "";
				
	} else {
		// assume they got it wrong
		
		// change background color to red
		// DO feel free to change the background colors (here, only for incorrect responses)
		//bgcolor 		= "#ff8888";	// light red
		//txcolor 		= "#000000";	// black
		
		// with question answer echoed
		// DO feel free to hard code an additional, permanent distractor (title) here
		// distractor += " is incorrect.";
	
		// without question answer echoed
		// DO feel free to hard code an additional, permanent distractor (title) here
		distractor = "";
	
		if ( curr_tries == num_tries ) {
			// make the content equal to the image and the final incorrect feedback.
			// if review is active, it will be added here. otherwise it defaulted to null and will cause no problems.
			// DO NOT change this. (if you don't want an image, set the variable to null at the top of the function.)
			// DO feel free to change the <p> tag to null, or something else.
			content = "<p>" + incorrect_image + youwrong + final_feedback_incorrect + review;
		}
		if ( curr_tries < num_tries ) {
			// make the content equal to the image and the partial feedback
			// DO NOT change this. (if you don't want an image, set the variable to null at the top of the function.)
			// DO feel free to change the <p> tag to null, or something else.
			// DO feel free to add additional hard coded messages ( like "try again") to the null string between incorrect_image and content
			content = "<p>" + incorrect_image + "" + feedbkArray[userSelection];
		} 
	}
	
	distractor = distractorArray[userSelection];
	
	
	// open the window
	// DO NOT change this.
	Question_Popup( distractor, content, bgcolor, txcolor, base_dir )
}



//none



function opentryit(tryit){
	
   windowNavi = window.open(tryit,"tutorial","toolbar=no,width=640,height=720,menubar=no,status=yes,scrollbars=yes,resizable=yes");
 //  windowNavi.moveTo(((screen.width/2)-389),((screen.height/2)-265))
   windowNavi.location = tryit;
   windowNavi.focus();
}

function ToggleDisplay(DisplayElement){
  if (DisplayElement.style.display == "none") { DisplayElement.style.display = ""; }
  else { DisplayElement.style.display = "none"; } 
}

function another_try(iscorrect){
	if(iscorrect == true)
		curr_tries=100;
	else curr_tries++;
}





function expandcontent(cid, aobject){
	if (document.getElementById){
		highlighttab(aobject)
		detectSourceindex(aobject)
		if (previoustab!="")
			document.getElementById(previoustab).style.display="none"
		document.getElementById(cid).style.display="block"
		previoustab=cid
		if (aobject.blur)
			aobject.blur()
		return false
	}
	else
	return true
}

<!-- Terms -->

var initialTerm=[1, "term1"]

function styleSheet(el, cssproperty, csspropertyNS){
	if (el.currentStyle)
		return el.currentStyle[cssproperty]
	else if (window.getComputedStyle){
		var elstyle=window.getComputedStyle(el, "")
		return elstyle.getPropertyValue(csspropertyNS)
	}
}

var previousTerm=""

function showContent(cid, aobject){
	if (document.getElementById){
		highlightLink(aobject)
		detectIndex(aobject)
		if (previousTerm!="")
			document.getElementById(previousTerm).style.display="none"
		document.getElementById(cid).style.display="block"
		previousTerm=cid
		if (aobject.blur)
			aobject.blur()
		return false
	}
	else
	return true
}

function highlightLink(aobject){
	if (typeof termObjectLinks=="undefined")
		gatherlinks()
	for (i=0; i<termObjectLinks.length; i++){
		termObjectLinks[i].style.color=initTermColor
		}
	aobject.style.color=initTermPostColor
}

function gatherlinks(){
		var termObject=document.getElementById("termslist")
		termObjectLinks=termObject.getElementsByTagName("A")
}

function detectIndex(aobject){
	for (i=0; i<termObjectLinks.length; i++){
		if (aobject==termObjectLinks[i]){
			termSourceIndex=i
			break
		}
	}
}



if (window.addEventListener)
	window.addEventListener("load", callOnLoad, false)
else if (window.attachEvent)
	window.attachEvent("onload", callOnLoad)
else if (document.getElementById)
	window.onload=callOnLoad

function display(div){
	document.getElementById(div).style.display="block";
}


function callOnLoad(){
	if (document.getElementById("termslist")!= null){
		var cookiename=(typeof persisttype!="undefined" && persisttype=="sitewide")? "termscontent" : window.location.pathname
		var cookiecheck=window.get_cookie && get_cookie(cookiename).indexOf("|")!=-1
		gatherlinks()
		initTermColor=styleSheet(termObjectLinks[0], "color", "color")
		initTermPostColor=styleSheet(termObjectLinks[termObjectLinks.length-1], "color", "color")
		if (typeof enablepersistence!="undefined" && enablepersistence && cookiecheck){
			var cookieparse=get_cookie(cookiename).split("|")
			var whichtab=cookieparse[0]
			var termscontentid=cookieparse[1]
			showContent(termscontentid, termObjectLinks[whichtab])
		}
	}



	var flashName = "../../images_int/knowrev_2.2.2.swf?xmlname=";
	var sPath = window.location.pathname;
	var sPage = sPath.substring(sPath.lastIndexOf('/') + 1, sPath.length-5);
	flashName += sPage;
if (document.getElementById("kr")!= null){

flashembed("kr", {
			src: flashName,
			id: 'knowrev_2_2',
			w3c: true
		}
	);
}
}