# This script is a component of the Ecosystem Rarity Toolbox for ArcGIS
# This script calculates the Ecoform Relative Rarity Metric
# Developed by Samantha D. Sifleet 2/28/2013 updated 7/22/2013

# Import system modules
import sys, string, os, arcpy

# Define variables
raster = sys.argv[1] ## Raster of ecosystems clipped to area of interest
geo_table = sys.argv[2] ## Master Table with Spatial Pattern

GAP_3 = "LEVEL3" ## GAP Level 3 codes 
Spatial = "Spatial_Pa" ## Spatial Pattern expressed as integer 
MGC = "MACRO_CD" ## Macrogroup Code 

# Read in data from raster attribute table and the GAP spatial pattern table
fields = [str(f.name) for f in arcpy.ListFields(raster)]
FIELDS = []
for f in fields:
    F = str.upper(f)
    FIELDS.append(F)
rows = arcpy.SearchCursor(raster, fields = "VALUE ; COUNT", sort_fields = "VALUE")
raster_table = [] 
for row in rows:
    ROW = [row.getValue("VALUE"), row.getValue("COUNT")]
    raster_table.append(ROW)
del row, rows

rows = arcpy.SearchCursor( geo_table, fields="Value;"+GAP_3+";"+Spatial+";"+MGC,
    sort_fields = "Value")
table = []
for row in rows:
    ROW = [ row.getValue("Value"), row.getValue(GAP_3), row.getValue(Spatial), row.getValue(MGC) ]
    table.append(ROW)
del row, rows

# Combine the spatial pattern data with the raster table
values = []
for row in raster_table:
    values.append(row[0])
    
for i in table:
    if i[0] in values:
        x = values.index(i[0])
        raster_table[x].extend(i[1:4])
        
# Sort ecosystems into spatial pattern categories
LP = []
LI = []
MA = []
SP = []
HU = []

for row in raster_table:
    if int(row[3]) == 1:
        LP.append(row)
    elif int(row[3]) == 2:
        LI.append(row)
    elif int(row[3]) == 3:
        MA.append(row)
    elif int(row[3]) == 4:
        SP.append(row)
    else:
        HU.append(row)
# Sort each spatial pattern list by Count
LP.sort(key = lambda a: int(a[1]), reverse = True)
LI.sort(key = lambda a: int(a[1]), reverse = True)
MA.sort(key = lambda a: int(a[1]), reverse = True)
SP.sort(key = lambda a: int(a[1]), reverse = True)
HU.sort(key = lambda a: int(a[1]), reverse = True)
LIST = [LP, LI, MA, SP]
# Assign Ranks
for i in LIST:
    rank = 1 
    for row in i:
        # If count = 0: rank = 0
        if int(row[1]) == 0:
            row.append(0)
        else:
            row.append(rank)
            rank += 1
# Calculate Ecoform Relative Rarity Metric
for i in LIST:
    a = 1
    max = i[-a]
    while max[1] == 0:
        a+=1
        max = i[-a]
    for row in i:
        row.append(int((float(row[5])/float(max[5]))*100))

for i in HU:
    i.append(0)
    i.append(0)
# Reaggregate table
LP.extend(LI)
LP.extend(MA)
LP.extend(SP)
LP.extend(HU)

# Create dictionary relating GAP Level 3 code to Ecoform Relative Rarity value
LP.sort(key = lambda a: int(a[0]))
keys = []
values = []
for row in LP:
    keys.append(row[0])
    values.append(row[6])
ESRR = dict(zip(keys, values))

# Create new field with Ecoform Relative Rarity values in the raster attribute table
arcpy.AddField_management(raster, "Ecoform_RR", "SHORT", 9, "", "", "", "NULLABLE")
rows = arcpy.UpdateCursor(raster, sort_fields = "VALUE")
for row in rows:
    if row.getValue("VALUE") == 0:
        row.setValue("Ecoform_RR", None)
    elif row.getValue("VALUE") in ESRR:
        k = row.getValue("VALUE")
        row.setValue("Ecoform_RR", ESRR[k])
    else:
        row.setValue("Ecoform_RR", None)
    rows.updateRow(row)
del row, rows
