# This script is a component of the Ecosystem Rarity Toolbox for ArcGIS
# This script calculates the Ecosystem Relative Rarity Metric
# Developed by Samantha D. Sifleet 28/2/2013 updated 4/9/2013

# Import system modules
import sys, string, os, arcpy

# Define variables
raster = sys.argv[1] ## Raster of ecosystems clipped to area of interest
geo_table = sys.argv[2] ## ## Master Table with Spatial Pattern

GAP_3 = "LEVEL3" ## GAP Level 3 codes -  must be field in raster attribute table
Spatial = "Spatial_Pa" ## Spatial Pattern expressed as integer - must be field in raster attribute table
MGC = "MACRO_CD" ## Macrogroup Code - must be field in raster attribute table

# Read in data from raster attribute table
fields = [str(f.name) for f in arcpy.ListFields(raster)]
FIELDS = []
for f in fields:
    F = str.upper(f)
    FIELDS.append(F)
rows = arcpy.SearchCursor(raster, fields = "VALUE ; COUNT", sort_fields = "VALUE")
raster_table = [] 
for row in rows:
    ROW = [row.getValue("VALUE"), row.getValue("COUNT")]
    raster_table.append(ROW)
del row, rows

rows = arcpy.SearchCursor( geo_table, fields="Value ;"+GAP_3+";"+Spatial+";"+MGC,
    sort_fields = "Value")
table = []
for row in rows:
    ROW = [ row.getValue("Value"), row.getValue(GAP_3), row.getValue(Spatial), row.getValue(MGC) ]
    table.append(ROW)
del row, rows

# Combine the spatial pattern data with the raster table
values = []
for row in raster_table:
    values.append(row[0])
    
for i in table:
    if i[0] in values:
        x = values.index(i[0])
        raster_table[x].extend(i[1:4])

# Sort Ecosystems from Human Use landcover
HU = []
ES = []
for row in raster_table:
    if int(row[3]) == 0:
        HU.append(row)
    else:
        ES.append(row)

# Sort and Rank Ecosystems by Area
ES.sort(key = lambda a: int(a[1]), reverse = True) 
HU.sort(key = lambda a: int(a[1]), reverse = True)
rank = 1 
for row in ES:
    # If count = 0 or Level 3 = 0 or Spatial pattern = 0
    if int(row[1]) == 0 or int(row[0]) == 0 or int(row[2]) == 0 :
        row.append(0)
    else:
        row.append(rank)
        rank += 1

# Calculate Ecoform Relative Rarity Metric
a = 1
max = ES[-a]
# Do not rank systems with 0 pixel count
while max[1] == 0:
    a+=1
    max = ES[-a]
for row in ES:
    row.append(int((float(row[5])/float(max[5]))*100))

for i in HU:
    i.append(0)
    i.append(0)
    
# Reaggregate table
ES.extend(HU)

# Create dictionary relating GAP Level 3 code to Ecosystems Relative Rarity Metric value
ES.sort(key = lambda a: int(a[0]))
keys = []
values = []
for row in ES:
    keys.append(int(row[0]))
    values.append(row[6])
EFRR = dict(zip(keys, values))

# Create new field with Ecosystem Relative Rarity Metric values in the raster attribute table
arcpy.AddField_management(raster, "Ecosys_RR", "SHORT", 9, "", "", "", "NULLABLE")
rows = arcpy.UpdateCursor(raster, sort_fields = "VALUE")
for row in rows:
    if row.getValue("VALUE") == 0:
        row.setValue("Ecosys_RR", None)
    elif row.getValue("VALUE") in EFRR:
        k = row.getValue("VALUE")
        row.setValue("Ecosys_RR", EFRR[k])
    else:
        row.setValue("Ecosys_RR", None)
    rows.updateRow(row)

del row, rows
