# This script is a component of the Ecosystem Rarity Toolbox for ArcGIS
# This script calculates the Macrogroup Relative Rarity Metric
# Developed by Samantha D. Sifleet 28/2/2013 updated 4/9/2013

# Import system modules
import sys, string, os, arcpy

# Define variables
raster = sys.argv[1] ## Raster of ecosystems clipped to area of interest
geo_table = sys.argv[2] ## ## Master Table with Spatial Pattern

GAP_3 = "LEVEL3" ## GAP Level 3 codes -  must be field in raster attribute table
Spatial = "Spatial_Pa" ## Spatial Pattern expressed as integer - must be field in raster attribute table
MGC = "MACRO_CD" ## Macrogroup Code - must be field in raster attribute table

# Read in data from raster attribute table
fields = [str(f.name) for f in arcpy.ListFields(raster)]
FIELDS = []
for f in fields:
    F = str.upper(f)
    FIELDS.append(F)
rows = arcpy.SearchCursor(raster, fields = "VALUE ; COUNT", sort_fields = "VALUE")
raster_table = [] 
for row in rows:
    ROW = [row.getValue("VALUE"), row.getValue("COUNT")]
    raster_table.append(ROW)
del row, rows

rows = arcpy.SearchCursor( geo_table, fields="Value ;"+GAP_3+";"+Spatial+";"+MGC,
    sort_fields = "Value")
table = []
for row in rows:
    ROW = [ row.getValue("Value"), row.getValue(GAP_3), row.getValue(Spatial), row.getValue(MGC) ]
    table.append(ROW)
del row, rows

# Combine the spatial pattern data with the raster table
values = []
for row in raster_table:
    values.append(row[0])
    
for i in table:
    if i[0] in values:
        x = values.index(i[0])
        raster_table[x].extend(i[1:4])

# Sort Ecosystems from Human Use landcover
HU = []
ES = []
for row in raster_table:
    if int(row[3]) == 0:
        HU.append(row)
    else:
        ES.append(row)

ES.sort(key = lambda a: a[4])

# Sum area for macrogroups - create a dictionary directing MGC to summed area
MG = []
MGD = {}
for row in ES:
    if row[4] not in MG:
        area = int(row[1])
        MGD[row[4]] = area
        MG.append(row[4])
    else:
        area = int(area) + int(row[1])
        MGD[row[4]] = area
for row in ES:
    row.append(MGD[row[4]])
# Sort macrogroups by area and then rank
MGD_list = list(MGD.items())
MGD_list.sort(key = lambda a: int(a[1]), reverse = True)
print MGD_list
rank = 1
for x in MGD_list:
    if x[1] == 0:
        MGD[x[0]] = 0
    else:
        MGD[x[0]] = rank
        rank+=1
for row in ES:
    row.append(MGD[row[4]])
# Calculate Macrogroup Relative Rarity
MGD_list2 = list(MGD.items())
for x in MGD_list2:
    rarity = int((float(x[1])/float(rank-1))*100)
    MGD[x[0]] = rarity
for row in ES:
    row.append(MGD[row[4]])
for i in HU:
    i.append(0)
    i.append(0)
    i.append(0)

# Reaggregate table
ES.extend(HU)
print ES
# Create dictionary relating GAP Level 3 code to Macrogroup Relative Rarity value
ES.sort(key = lambda a: int(a[0]))
keys = []
values = []
for row in ES:
    keys.append(int(row[0]))
    values.append(row[7])
MGRR = dict(zip(keys, values))

# Create new field with Macrogroup Relative Rarity values in the raster attribute table
arcpy.AddField_management(raster, "Macrogp_RR", "SHORT", 9, "", "", "", "NULLABLE")
rows = arcpy.UpdateCursor(raster, sort_fields = "VALUE")
for row in rows:
    if row.getValue("VALUE") == 0:
        row.setValue("Macrogp_RR", None)
    elif row.getValue("VALUE") in MGRR:
        k = row.getValue("VALUE")
        row.setValue("Macrogp_RR", MGRR[k])
    else:
        row.setValue("Macrogp_RR", None)
    rows.updateRow(row)

del row, rows
