classdef class_REVS_AT_transmission 
	%class_REVS_AT_transmission
	%   Definition of class_REVS_AT_transmission class
	
	properties ( Constant = true )
		type = enum_transmission_type.automatic;		
	end
	
	properties
		% Base Properties
        matrix_vintage = enum_matrix_vintage.present;

        name                = '';                           % Description of transmission
        
        rated_torque_Nm     = 0;                            % transmission rated input torque in Newton-meters
        
		gear                = class_REVS_gearbox;			% Gearbox Definition
		torque_converter    = class_REVS_torque_converter;	% Torque Converter Definition
		control             = class_REVS_AT_control;        % AT Control Parameters
		thermal;                                            % Thermal Definintion
		pump_loss_Nm;                                       % Transmission Pump Loss - Dynamic Lookup
		
		gear_strategy;                                      % Gear selection strategy structure / class
		tcc_strategy;                                       % TCC lockup strategy structure / class
        
	end
	
	methods ( Static = true )		
		% Constructor
		function obj = class_REVS_AT_transmission()
			
			obj.gear.type = enum_transmission_type.automatic;
			obj.gear.shift_duration_secs = 0.5;
	
        end
    end
end

