classdef class_REVS_alternator
	%UNTITLED2 Summary of this class goes here
	%   Detailed explanation goes here
	
	properties
		target_voltage_V                    = 14;       % default target voltage
		inertia_kgm2                        = 0;        % alternator inertia, kg-m^2
		efficiency_norm                     = 0.65;     % alternator efficiency [0..1]
		max_current_A                       = 80;       % maximum alternator output current, Amps
        
        regen_enable                        = false;    % enables alternator regen during upshifts and braking if true
        regen_max_soc_drop_norm             = 0.01;     % SoC change below initial SoC that activates/reactivates alternator regen SoC control
        regen_min_soc_rise_norm             = 0.05;     % SoC change above initial SoC that deactivates alternator regen SoC control
        regen_boost_max_battery_soc_norm    = 0.9;      % maximum battery SoC allowed for alternator voltage boost during upshift or braking
        regen_upshift_boost_volts           = 2.0;      % boost voltage during upshifts
        regen_brake_boost_gain              = 0;        % DEPRECATED converts brake norm to boost volts
        regen_max_boost_volts               = 2.5;      % maximum boost voltage during alternator regen
        regen_idle_speed_offset_radps       = 5;        % minimum speed above idle required for alternator regen
        
        nominal_Kp                          = 10;       % alternator proportional gain when regen disabled
        nominal_Ki                          = 1;        % alternator integral gain when regen disabled
        regen_Kp_multiplier                 = 5;        % with regen enabled, proportional gain = nominal_Kp * (1 + regen_Kp_multiplier)
        regen_Ki_multiplier                 = 20;       % with regen enabled, integral gain = nominal_Ki * (1 + regen_Ki_multiplier)
        
        activation_time_secs                = 1.0;      % length of time it takes alternator to achieve full activation
   		activate_speed_radps                = 50;       % minimum engine speed to activate alternator charging
		deactivate_speed_radps              = 25;       % speed below which alternator charging is disabled
	end
	
	methods
		function obj = class_REVS_alternator( engine ) 
			if nargin > 0 
				obj.activate_speed_radps = min(engine.idle_speed_radps.table(:));
				obj.deactivate_speed_radps = min(engine.idle_speed_radps.table(:)) / 2;
			end			
        end
	end
	
end
