classdef class_REVS_ambient 
	%class_REVS_ambient
	%
	
	
	properties
		
		% Define Ambient Defaults
		temperature_degC    = 20;          % [C]
		pressure_Pa         = 98210;      % [Pa]
		
	end
	
	
	properties ( Dependent = true, Transient = true)

		air_density_kgpm3% [kg/m^3]

	end
	
	
 

	properties( Constant = true )
		% Air gas constant
		Rgas_JpkgK			= 286.9; %    J/kg-k
		gravity_mps2        = 9.81;     % [m/s^2]
	end
	
	methods
		
		function val = get.air_density_kgpm3(obj) 
			val = obj.pressure_Pa/obj.Rgas_JpkgK/(obj.temperature_degC+273.15);      % [kg/m^3] 
		end
		
		function obj = set.air_density_kgpm3(obj, val) 
			% Change Pressure if Air Density is specified
			obj.pressure_Pa = val * obj.Rgas_JpkgK *(obj.temperature_degC+273.15);	
		end
		
	end
	
end

